//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmysql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// LocationBasedRecommendedActionSessionsResultClient contains the methods for the LocationBasedRecommendedActionSessionsResult group.
// Don't use this type directly, use NewLocationBasedRecommendedActionSessionsResultClient() instead.
type LocationBasedRecommendedActionSessionsResultClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewLocationBasedRecommendedActionSessionsResultClient creates a new instance of LocationBasedRecommendedActionSessionsResultClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewLocationBasedRecommendedActionSessionsResultClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*LocationBasedRecommendedActionSessionsResultClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &LocationBasedRecommendedActionSessionsResultClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListPager - Recommendation action session operation result.
//
// Generated from API version 2018-06-01
//   - locationName - The name of the location.
//   - operationID - The operation identifier.
//   - options - LocationBasedRecommendedActionSessionsResultClientListOptions contains the optional parameters for the LocationBasedRecommendedActionSessionsResultClient.NewListPager
//     method.
func (client *LocationBasedRecommendedActionSessionsResultClient) NewListPager(locationName string, operationID string, options *LocationBasedRecommendedActionSessionsResultClientListOptions) *runtime.Pager[LocationBasedRecommendedActionSessionsResultClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[LocationBasedRecommendedActionSessionsResultClientListResponse]{
		More: func(page LocationBasedRecommendedActionSessionsResultClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LocationBasedRecommendedActionSessionsResultClientListResponse) (LocationBasedRecommendedActionSessionsResultClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "LocationBasedRecommendedActionSessionsResultClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, locationName, operationID, options)
			}, nil)
			if err != nil {
				return LocationBasedRecommendedActionSessionsResultClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *LocationBasedRecommendedActionSessionsResultClient) listCreateRequest(ctx context.Context, locationName string, operationID string, options *LocationBasedRecommendedActionSessionsResultClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/locations/{locationName}/recommendedActionSessionsOperationResults/{operationId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if locationName == "" {
		return nil, errors.New("parameter locationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{locationName}", url.PathEscape(locationName))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *LocationBasedRecommendedActionSessionsResultClient) listHandleResponse(resp *http.Response) (LocationBasedRecommendedActionSessionsResultClientListResponse, error) {
	result := LocationBasedRecommendedActionSessionsResultClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RecommendationActionsResultList); err != nil {
		return LocationBasedRecommendedActionSessionsResultClientListResponse{}, err
	}
	return result, nil
}
