//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysqlflexibleservers/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ServersMigrationServer is a fake server for instances of the armmysqlflexibleservers.ServersMigrationClient type.
type ServersMigrationServer struct {
	// BeginCutoverMigration is the fake for method ServersMigrationClient.BeginCutoverMigration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCutoverMigration func(ctx context.Context, resourceGroupName string, serverName string, options *armmysqlflexibleservers.ServersMigrationClientBeginCutoverMigrationOptions) (resp azfake.PollerResponder[armmysqlflexibleservers.ServersMigrationClientCutoverMigrationResponse], errResp azfake.ErrorResponder)
}

// NewServersMigrationServerTransport creates a new instance of ServersMigrationServerTransport with the provided implementation.
// The returned ServersMigrationServerTransport instance is connected to an instance of armmysqlflexibleservers.ServersMigrationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServersMigrationServerTransport(srv *ServersMigrationServer) *ServersMigrationServerTransport {
	return &ServersMigrationServerTransport{
		srv:                   srv,
		beginCutoverMigration: newTracker[azfake.PollerResponder[armmysqlflexibleservers.ServersMigrationClientCutoverMigrationResponse]](),
	}
}

// ServersMigrationServerTransport connects instances of armmysqlflexibleservers.ServersMigrationClient to instances of ServersMigrationServer.
// Don't use this type directly, use NewServersMigrationServerTransport instead.
type ServersMigrationServerTransport struct {
	srv                   *ServersMigrationServer
	beginCutoverMigration *tracker[azfake.PollerResponder[armmysqlflexibleservers.ServersMigrationClientCutoverMigrationResponse]]
}

// Do implements the policy.Transporter interface for ServersMigrationServerTransport.
func (s *ServersMigrationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServersMigrationClient.BeginCutoverMigration":
		resp, err = s.dispatchBeginCutoverMigration(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServersMigrationServerTransport) dispatchBeginCutoverMigration(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCutoverMigration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCutoverMigration not implemented")}
	}
	beginCutoverMigration := s.beginCutoverMigration.get(req)
	if beginCutoverMigration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cutoverMigration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCutoverMigration(req.Context(), resourceGroupNameParam, serverNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCutoverMigration = &respr
		s.beginCutoverMigration.add(req, beginCutoverMigration)
	}

	resp, err := server.PollerResponderNext(beginCutoverMigration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCutoverMigration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCutoverMigration) {
		s.beginCutoverMigration.remove(req)
	}

	return resp, nil
}
