//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
	"net/http"
	"net/url"
	"regexp"
)

// WatchersServer is a fake server for instances of the armnetwork.WatchersClient type.
type WatchersServer struct {
	// BeginCheckConnectivity is the fake for method WatchersClient.BeginCheckConnectivity
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCheckConnectivity func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.ConnectivityParameters, options *armnetwork.WatchersClientBeginCheckConnectivityOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientCheckConnectivityResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdate is the fake for method WatchersClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.Watcher, options *armnetwork.WatchersClientCreateOrUpdateOptions) (resp azfake.Responder[armnetwork.WatchersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method WatchersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, networkWatcherName string, options *armnetwork.WatchersClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method WatchersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, networkWatcherName string, options *armnetwork.WatchersClientGetOptions) (resp azfake.Responder[armnetwork.WatchersClientGetResponse], errResp azfake.ErrorResponder)

	// BeginGetAzureReachabilityReport is the fake for method WatchersClient.BeginGetAzureReachabilityReport
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetAzureReachabilityReport func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.AzureReachabilityReportParameters, options *armnetwork.WatchersClientBeginGetAzureReachabilityReportOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientGetAzureReachabilityReportResponse], errResp azfake.ErrorResponder)

	// BeginGetFlowLogStatus is the fake for method WatchersClient.BeginGetFlowLogStatus
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetFlowLogStatus func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.FlowLogStatusParameters, options *armnetwork.WatchersClientBeginGetFlowLogStatusOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientGetFlowLogStatusResponse], errResp azfake.ErrorResponder)

	// BeginGetNetworkConfigurationDiagnostic is the fake for method WatchersClient.BeginGetNetworkConfigurationDiagnostic
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetNetworkConfigurationDiagnostic func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.ConfigurationDiagnosticParameters, options *armnetwork.WatchersClientBeginGetNetworkConfigurationDiagnosticOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientGetNetworkConfigurationDiagnosticResponse], errResp azfake.ErrorResponder)

	// BeginGetNextHop is the fake for method WatchersClient.BeginGetNextHop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetNextHop func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.NextHopParameters, options *armnetwork.WatchersClientBeginGetNextHopOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientGetNextHopResponse], errResp azfake.ErrorResponder)

	// GetTopology is the fake for method WatchersClient.GetTopology
	// HTTP status codes to indicate success: http.StatusOK
	GetTopology func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.TopologyParameters, options *armnetwork.WatchersClientGetTopologyOptions) (resp azfake.Responder[armnetwork.WatchersClientGetTopologyResponse], errResp azfake.ErrorResponder)

	// BeginGetTroubleshooting is the fake for method WatchersClient.BeginGetTroubleshooting
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetTroubleshooting func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.TroubleshootingParameters, options *armnetwork.WatchersClientBeginGetTroubleshootingOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientGetTroubleshootingResponse], errResp azfake.ErrorResponder)

	// BeginGetTroubleshootingResult is the fake for method WatchersClient.BeginGetTroubleshootingResult
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetTroubleshootingResult func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.QueryTroubleshootingParameters, options *armnetwork.WatchersClientBeginGetTroubleshootingResultOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientGetTroubleshootingResultResponse], errResp azfake.ErrorResponder)

	// BeginGetVMSecurityRules is the fake for method WatchersClient.BeginGetVMSecurityRules
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetVMSecurityRules func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.SecurityGroupViewParameters, options *armnetwork.WatchersClientBeginGetVMSecurityRulesOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientGetVMSecurityRulesResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method WatchersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armnetwork.WatchersClientListOptions) (resp azfake.PagerResponder[armnetwork.WatchersClientListResponse])

	// NewListAllPager is the fake for method WatchersClient.NewListAllPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllPager func(options *armnetwork.WatchersClientListAllOptions) (resp azfake.PagerResponder[armnetwork.WatchersClientListAllResponse])

	// BeginListAvailableProviders is the fake for method WatchersClient.BeginListAvailableProviders
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListAvailableProviders func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.AvailableProvidersListParameters, options *armnetwork.WatchersClientBeginListAvailableProvidersOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientListAvailableProvidersResponse], errResp azfake.ErrorResponder)

	// BeginSetFlowLogConfiguration is the fake for method WatchersClient.BeginSetFlowLogConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSetFlowLogConfiguration func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.FlowLogInformation, options *armnetwork.WatchersClientBeginSetFlowLogConfigurationOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientSetFlowLogConfigurationResponse], errResp azfake.ErrorResponder)

	// UpdateTags is the fake for method WatchersClient.UpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	UpdateTags func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.TagsObject, options *armnetwork.WatchersClientUpdateTagsOptions) (resp azfake.Responder[armnetwork.WatchersClientUpdateTagsResponse], errResp azfake.ErrorResponder)

	// BeginVerifyIPFlow is the fake for method WatchersClient.BeginVerifyIPFlow
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginVerifyIPFlow func(ctx context.Context, resourceGroupName string, networkWatcherName string, parameters armnetwork.VerificationIPFlowParameters, options *armnetwork.WatchersClientBeginVerifyIPFlowOptions) (resp azfake.PollerResponder[armnetwork.WatchersClientVerifyIPFlowResponse], errResp azfake.ErrorResponder)
}

// NewWatchersServerTransport creates a new instance of WatchersServerTransport with the provided implementation.
// The returned WatchersServerTransport instance is connected to an instance of armnetwork.WatchersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWatchersServerTransport(srv *WatchersServer) *WatchersServerTransport {
	return &WatchersServerTransport{
		srv:                                    srv,
		beginCheckConnectivity:                 newTracker[azfake.PollerResponder[armnetwork.WatchersClientCheckConnectivityResponse]](),
		beginDelete:                            newTracker[azfake.PollerResponder[armnetwork.WatchersClientDeleteResponse]](),
		beginGetAzureReachabilityReport:        newTracker[azfake.PollerResponder[armnetwork.WatchersClientGetAzureReachabilityReportResponse]](),
		beginGetFlowLogStatus:                  newTracker[azfake.PollerResponder[armnetwork.WatchersClientGetFlowLogStatusResponse]](),
		beginGetNetworkConfigurationDiagnostic: newTracker[azfake.PollerResponder[armnetwork.WatchersClientGetNetworkConfigurationDiagnosticResponse]](),
		beginGetNextHop:                        newTracker[azfake.PollerResponder[armnetwork.WatchersClientGetNextHopResponse]](),
		beginGetTroubleshooting:                newTracker[azfake.PollerResponder[armnetwork.WatchersClientGetTroubleshootingResponse]](),
		beginGetTroubleshootingResult:          newTracker[azfake.PollerResponder[armnetwork.WatchersClientGetTroubleshootingResultResponse]](),
		beginGetVMSecurityRules:                newTracker[azfake.PollerResponder[armnetwork.WatchersClientGetVMSecurityRulesResponse]](),
		newListPager:                           newTracker[azfake.PagerResponder[armnetwork.WatchersClientListResponse]](),
		newListAllPager:                        newTracker[azfake.PagerResponder[armnetwork.WatchersClientListAllResponse]](),
		beginListAvailableProviders:            newTracker[azfake.PollerResponder[armnetwork.WatchersClientListAvailableProvidersResponse]](),
		beginSetFlowLogConfiguration:           newTracker[azfake.PollerResponder[armnetwork.WatchersClientSetFlowLogConfigurationResponse]](),
		beginVerifyIPFlow:                      newTracker[azfake.PollerResponder[armnetwork.WatchersClientVerifyIPFlowResponse]](),
	}
}

// WatchersServerTransport connects instances of armnetwork.WatchersClient to instances of WatchersServer.
// Don't use this type directly, use NewWatchersServerTransport instead.
type WatchersServerTransport struct {
	srv                                    *WatchersServer
	beginCheckConnectivity                 *tracker[azfake.PollerResponder[armnetwork.WatchersClientCheckConnectivityResponse]]
	beginDelete                            *tracker[azfake.PollerResponder[armnetwork.WatchersClientDeleteResponse]]
	beginGetAzureReachabilityReport        *tracker[azfake.PollerResponder[armnetwork.WatchersClientGetAzureReachabilityReportResponse]]
	beginGetFlowLogStatus                  *tracker[azfake.PollerResponder[armnetwork.WatchersClientGetFlowLogStatusResponse]]
	beginGetNetworkConfigurationDiagnostic *tracker[azfake.PollerResponder[armnetwork.WatchersClientGetNetworkConfigurationDiagnosticResponse]]
	beginGetNextHop                        *tracker[azfake.PollerResponder[armnetwork.WatchersClientGetNextHopResponse]]
	beginGetTroubleshooting                *tracker[azfake.PollerResponder[armnetwork.WatchersClientGetTroubleshootingResponse]]
	beginGetTroubleshootingResult          *tracker[azfake.PollerResponder[armnetwork.WatchersClientGetTroubleshootingResultResponse]]
	beginGetVMSecurityRules                *tracker[azfake.PollerResponder[armnetwork.WatchersClientGetVMSecurityRulesResponse]]
	newListPager                           *tracker[azfake.PagerResponder[armnetwork.WatchersClientListResponse]]
	newListAllPager                        *tracker[azfake.PagerResponder[armnetwork.WatchersClientListAllResponse]]
	beginListAvailableProviders            *tracker[azfake.PollerResponder[armnetwork.WatchersClientListAvailableProvidersResponse]]
	beginSetFlowLogConfiguration           *tracker[azfake.PollerResponder[armnetwork.WatchersClientSetFlowLogConfigurationResponse]]
	beginVerifyIPFlow                      *tracker[azfake.PollerResponder[armnetwork.WatchersClientVerifyIPFlowResponse]]
}

// Do implements the policy.Transporter interface for WatchersServerTransport.
func (w *WatchersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WatchersClient.BeginCheckConnectivity":
		resp, err = w.dispatchBeginCheckConnectivity(req)
	case "WatchersClient.CreateOrUpdate":
		resp, err = w.dispatchCreateOrUpdate(req)
	case "WatchersClient.BeginDelete":
		resp, err = w.dispatchBeginDelete(req)
	case "WatchersClient.Get":
		resp, err = w.dispatchGet(req)
	case "WatchersClient.BeginGetAzureReachabilityReport":
		resp, err = w.dispatchBeginGetAzureReachabilityReport(req)
	case "WatchersClient.BeginGetFlowLogStatus":
		resp, err = w.dispatchBeginGetFlowLogStatus(req)
	case "WatchersClient.BeginGetNetworkConfigurationDiagnostic":
		resp, err = w.dispatchBeginGetNetworkConfigurationDiagnostic(req)
	case "WatchersClient.BeginGetNextHop":
		resp, err = w.dispatchBeginGetNextHop(req)
	case "WatchersClient.GetTopology":
		resp, err = w.dispatchGetTopology(req)
	case "WatchersClient.BeginGetTroubleshooting":
		resp, err = w.dispatchBeginGetTroubleshooting(req)
	case "WatchersClient.BeginGetTroubleshootingResult":
		resp, err = w.dispatchBeginGetTroubleshootingResult(req)
	case "WatchersClient.BeginGetVMSecurityRules":
		resp, err = w.dispatchBeginGetVMSecurityRules(req)
	case "WatchersClient.NewListPager":
		resp, err = w.dispatchNewListPager(req)
	case "WatchersClient.NewListAllPager":
		resp, err = w.dispatchNewListAllPager(req)
	case "WatchersClient.BeginListAvailableProviders":
		resp, err = w.dispatchBeginListAvailableProviders(req)
	case "WatchersClient.BeginSetFlowLogConfiguration":
		resp, err = w.dispatchBeginSetFlowLogConfiguration(req)
	case "WatchersClient.UpdateTags":
		resp, err = w.dispatchUpdateTags(req)
	case "WatchersClient.BeginVerifyIPFlow":
		resp, err = w.dispatchBeginVerifyIPFlow(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginCheckConnectivity(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCheckConnectivity == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCheckConnectivity not implemented")}
	}
	beginCheckConnectivity := w.beginCheckConnectivity.get(req)
	if beginCheckConnectivity == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectivityCheck`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.ConnectivityParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCheckConnectivity(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCheckConnectivity = &respr
		w.beginCheckConnectivity.add(req, beginCheckConnectivity)
	}

	resp, err := server.PollerResponderNext(beginCheckConnectivity, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginCheckConnectivity.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCheckConnectivity) {
		w.beginCheckConnectivity.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.Watcher](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Watcher, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := w.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDelete(req.Context(), resourceGroupNameParam, networkWatcherNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		w.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		w.beginDelete.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), resourceGroupNameParam, networkWatcherNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Watcher, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginGetAzureReachabilityReport(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetAzureReachabilityReport == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetAzureReachabilityReport not implemented")}
	}
	beginGetAzureReachabilityReport := w.beginGetAzureReachabilityReport.get(req)
	if beginGetAzureReachabilityReport == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/azureReachabilityReport`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.AzureReachabilityReportParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetAzureReachabilityReport(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetAzureReachabilityReport = &respr
		w.beginGetAzureReachabilityReport.add(req, beginGetAzureReachabilityReport)
	}

	resp, err := server.PollerResponderNext(beginGetAzureReachabilityReport, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetAzureReachabilityReport.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetAzureReachabilityReport) {
		w.beginGetAzureReachabilityReport.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginGetFlowLogStatus(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetFlowLogStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetFlowLogStatus not implemented")}
	}
	beginGetFlowLogStatus := w.beginGetFlowLogStatus.get(req)
	if beginGetFlowLogStatus == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryFlowLogStatus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.FlowLogStatusParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetFlowLogStatus(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetFlowLogStatus = &respr
		w.beginGetFlowLogStatus.add(req, beginGetFlowLogStatus)
	}

	resp, err := server.PollerResponderNext(beginGetFlowLogStatus, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetFlowLogStatus.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetFlowLogStatus) {
		w.beginGetFlowLogStatus.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginGetNetworkConfigurationDiagnostic(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetNetworkConfigurationDiagnostic == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetNetworkConfigurationDiagnostic not implemented")}
	}
	beginGetNetworkConfigurationDiagnostic := w.beginGetNetworkConfigurationDiagnostic.get(req)
	if beginGetNetworkConfigurationDiagnostic == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkConfigurationDiagnostic`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.ConfigurationDiagnosticParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetNetworkConfigurationDiagnostic(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetNetworkConfigurationDiagnostic = &respr
		w.beginGetNetworkConfigurationDiagnostic.add(req, beginGetNetworkConfigurationDiagnostic)
	}

	resp, err := server.PollerResponderNext(beginGetNetworkConfigurationDiagnostic, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetNetworkConfigurationDiagnostic.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetNetworkConfigurationDiagnostic) {
		w.beginGetNetworkConfigurationDiagnostic.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginGetNextHop(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetNextHop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetNextHop not implemented")}
	}
	beginGetNextHop := w.beginGetNextHop.get(req)
	if beginGetNextHop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/nextHop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.NextHopParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetNextHop(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetNextHop = &respr
		w.beginGetNextHop.add(req, beginGetNextHop)
	}

	resp, err := server.PollerResponderNext(beginGetNextHop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetNextHop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetNextHop) {
		w.beginGetNextHop.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchGetTopology(req *http.Request) (*http.Response, error) {
	if w.srv.GetTopology == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTopology not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/topology`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.TopologyParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetTopology(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Topology, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginGetTroubleshooting(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetTroubleshooting == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetTroubleshooting not implemented")}
	}
	beginGetTroubleshooting := w.beginGetTroubleshooting.get(req)
	if beginGetTroubleshooting == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/troubleshoot`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.TroubleshootingParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetTroubleshooting(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetTroubleshooting = &respr
		w.beginGetTroubleshooting.add(req, beginGetTroubleshooting)
	}

	resp, err := server.PollerResponderNext(beginGetTroubleshooting, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetTroubleshooting.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetTroubleshooting) {
		w.beginGetTroubleshooting.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginGetTroubleshootingResult(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetTroubleshootingResult == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetTroubleshootingResult not implemented")}
	}
	beginGetTroubleshootingResult := w.beginGetTroubleshootingResult.get(req)
	if beginGetTroubleshootingResult == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryTroubleshootResult`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.QueryTroubleshootingParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetTroubleshootingResult(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetTroubleshootingResult = &respr
		w.beginGetTroubleshootingResult.add(req, beginGetTroubleshootingResult)
	}

	resp, err := server.PollerResponderNext(beginGetTroubleshootingResult, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetTroubleshootingResult.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetTroubleshootingResult) {
		w.beginGetTroubleshootingResult.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginGetVMSecurityRules(req *http.Request) (*http.Response, error) {
	if w.srv.BeginGetVMSecurityRules == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetVMSecurityRules not implemented")}
	}
	beginGetVMSecurityRules := w.beginGetVMSecurityRules.get(req)
	if beginGetVMSecurityRules == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/securityGroupView`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.SecurityGroupViewParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginGetVMSecurityRules(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetVMSecurityRules = &respr
		w.beginGetVMSecurityRules.add(req, beginGetVMSecurityRules)
	}

	resp, err := server.PollerResponderNext(beginGetVMSecurityRules, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginGetVMSecurityRules.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetVMSecurityRules) {
		w.beginGetVMSecurityRules.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := w.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		w.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		w.newListPager.remove(req)
	}
	return resp, nil
}

func (w *WatchersServerTransport) dispatchNewListAllPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListAllPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllPager not implemented")}
	}
	newListAllPager := w.newListAllPager.get(req)
	if newListAllPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := w.srv.NewListAllPager(nil)
		newListAllPager = &resp
		w.newListAllPager.add(req, newListAllPager)
	}
	resp, err := server.PagerResponderNext(newListAllPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListAllPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllPager) {
		w.newListAllPager.remove(req)
	}
	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginListAvailableProviders(req *http.Request) (*http.Response, error) {
	if w.srv.BeginListAvailableProviders == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListAvailableProviders not implemented")}
	}
	beginListAvailableProviders := w.beginListAvailableProviders.get(req)
	if beginListAvailableProviders == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/availableProvidersList`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.AvailableProvidersListParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginListAvailableProviders(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListAvailableProviders = &respr
		w.beginListAvailableProviders.add(req, beginListAvailableProviders)
	}

	resp, err := server.PollerResponderNext(beginListAvailableProviders, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginListAvailableProviders.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListAvailableProviders) {
		w.beginListAvailableProviders.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginSetFlowLogConfiguration(req *http.Request) (*http.Response, error) {
	if w.srv.BeginSetFlowLogConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSetFlowLogConfiguration not implemented")}
	}
	beginSetFlowLogConfiguration := w.beginSetFlowLogConfiguration.get(req)
	if beginSetFlowLogConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/configureFlowLog`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.FlowLogInformation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginSetFlowLogConfiguration(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSetFlowLogConfiguration = &respr
		w.beginSetFlowLogConfiguration.add(req, beginSetFlowLogConfiguration)
	}

	resp, err := server.PollerResponderNext(beginSetFlowLogConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginSetFlowLogConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSetFlowLogConfiguration) {
		w.beginSetFlowLogConfiguration.remove(req)
	}

	return resp, nil
}

func (w *WatchersServerTransport) dispatchUpdateTags(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateTags not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.TagsObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateTags(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Watcher, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WatchersServerTransport) dispatchBeginVerifyIPFlow(req *http.Request) (*http.Response, error) {
	if w.srv.BeginVerifyIPFlow == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginVerifyIPFlow not implemented")}
	}
	beginVerifyIPFlow := w.beginVerifyIPFlow.get(req)
	if beginVerifyIPFlow == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/networkWatchers/(?P<networkWatcherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ipFlowVerify`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.VerificationIPFlowParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkWatcherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkWatcherName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginVerifyIPFlow(req.Context(), resourceGroupNameParam, networkWatcherNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginVerifyIPFlow = &respr
		w.beginVerifyIPFlow.add(req, beginVerifyIPFlow)
	}

	resp, err := server.PollerResponderNext(beginVerifyIPFlow, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginVerifyIPFlow.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginVerifyIPFlow) {
		w.beginVerifyIPFlow.remove(req)
	}

	return resp, nil
}
