//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherCreate.json
func ExampleWatchersClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWatchersClient().CreateOrUpdate(ctx, "rg1", "nw1", armnetwork.Watcher{
		Location:   to.Ptr("eastus"),
		Properties: &armnetwork.WatcherPropertiesFormat{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Watcher = armnetwork.Watcher{
	// 	Name: to.Ptr("nw1"),
	// 	Type: to.Ptr("Microsoft.Network/networkWatchers"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkWatchers/nw1"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 	Properties: &armnetwork.WatcherPropertiesFormat{
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherGet.json
func ExampleWatchersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWatchersClient().Get(ctx, "rg1", "nw1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Watcher = armnetwork.Watcher{
	// 	Name: to.Ptr("nw1"),
	// 	Type: to.Ptr("Microsoft.Network/networkWatchers"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkWatchers/nw1"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 	Properties: &armnetwork.WatcherPropertiesFormat{
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherDelete.json
func ExampleWatchersClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginDelete(ctx, "rg1", "nw1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherUpdateTags.json
func ExampleWatchersClient_UpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWatchersClient().UpdateTags(ctx, "rg1", "nw1", armnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Watcher = armnetwork.Watcher{
	// 	Name: to.Ptr("nw1"),
	// 	Type: to.Ptr("Microsoft.Network/networkWatchers"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkWatchers/nw1"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 	Properties: &armnetwork.WatcherPropertiesFormat{
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherList.json
func ExampleWatchersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWatchersClient().NewListPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WatcherListResult = armnetwork.WatcherListResult{
		// 	Value: []*armnetwork.Watcher{
		// 		{
		// 			Name: to.Ptr("nw1"),
		// 			Type: to.Ptr("Microsoft.Network/networkWatchers"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkWatchers/nw1"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
		// 			Properties: &armnetwork.WatcherPropertiesFormat{
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("nw2"),
		// 			Type: to.Ptr("Microsoft.Network/networkWatchers"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkWatchers/nw2"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
		// 			Properties: &armnetwork.WatcherPropertiesFormat{
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherListAll.json
func ExampleWatchersClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWatchersClient().NewListAllPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WatcherListResult = armnetwork.WatcherListResult{
		// 	Value: []*armnetwork.Watcher{
		// 		{
		// 			Name: to.Ptr("nw1"),
		// 			Type: to.Ptr("Microsoft.Network/networkWatchers"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkWatchers/nw1"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
		// 			Properties: &armnetwork.WatcherPropertiesFormat{
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("nw2"),
		// 			Type: to.Ptr("Microsoft.Network/networkWatchers"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkWatchers/nw2"),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
		// 			Properties: &armnetwork.WatcherPropertiesFormat{
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherTopologyGet.json
func ExampleWatchersClient_GetTopology() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWatchersClient().GetTopology(ctx, "rg1", "nw1", armnetwork.TopologyParameters{
		TargetResourceGroupName: to.Ptr("rg2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Topology = armnetwork.Topology{
	// 	CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-02T19:31:55.946Z"); return t}()),
	// 	ID: to.Ptr("ce592f46-8164-4bf2-ad36-b8e4acf6fb68"),
	// 	LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-27T00:00:13.200Z"); return t}()),
	// 	Resources: []*armnetwork.TopologyResource{
	// 		{
	// 			Name: to.Ptr("MultiTierApp0"),
	// 			Associations: []*armnetwork.TopologyAssociation{
	// 				{
	// 					Name: to.Ptr("appNic0"),
	// 					AssociationType: to.Ptr(armnetwork.AssociationTypeContains),
	// 					ResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkInterfaces/appNic0"),
	// 				},
	// 				{
	// 					Name: to.Ptr("appNic10"),
	// 					AssociationType: to.Ptr(armnetwork.AssociationTypeContains),
	// 					ResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkInterfaces/appNic10"),
	// 			}},
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/MultiTierApp0"),
	// 			Location: to.Ptr("westus"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherIpFlowVerify.json
func ExampleWatchersClient_BeginVerifyIPFlow() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginVerifyIPFlow(ctx, "rg1", "nw1", armnetwork.VerificationIPFlowParameters{
		Direction:        to.Ptr(armnetwork.DirectionOutbound),
		LocalIPAddress:   to.Ptr("10.2.0.4"),
		LocalPort:        to.Ptr("80"),
		RemoteIPAddress:  to.Ptr("121.10.1.1"),
		RemotePort:       to.Ptr("80"),
		TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
		Protocol:         to.Ptr(armnetwork.IPFlowProtocolTCP),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VerificationIPFlowResult = armnetwork.VerificationIPFlowResult{
	// 	Access: to.Ptr(armnetwork.AccessAllow),
	// 	RuleName: to.Ptr("Rule1"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherNextHopGet.json
func ExampleWatchersClient_BeginGetNextHop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginGetNextHop(ctx, "rg1", "nw1", armnetwork.NextHopParameters{
		DestinationIPAddress: to.Ptr("10.0.0.10"),
		SourceIPAddress:      to.Ptr("10.0.0.5"),
		TargetNicResourceID:  to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkInterfaces/nic1"),
		TargetResourceID:     to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NextHopResult = armnetwork.NextHopResult{
	// 	NextHopIPAddress: to.Ptr("10.0.0.1"),
	// 	NextHopType: to.Ptr(armnetwork.NextHopTypeVnetLocal),
	// 	RouteTableID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/routeTables/rt1"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherSecurityGroupViewGet.json
func ExampleWatchersClient_BeginGetVMSecurityRules() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginGetVMSecurityRules(ctx, "rg1", "nw1", armnetwork.SecurityGroupViewParameters{
		TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SecurityGroupViewResult = armnetwork.SecurityGroupViewResult{
	// 	NetworkInterfaces: []*armnetwork.SecurityGroupNetworkInterface{
	// 		{
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkInterfaces/nic1"),
	// 			SecurityRuleAssociations: &armnetwork.SecurityRuleAssociations{
	// 				DefaultSecurityRules: []*armnetwork.SecurityRule{
	// 					{
	// 						ID: to.Ptr("/subscriptions//resourceGroups//providers/Microsoft.Network/networkSecurityGroups//defaultSecurityRules/"),
	// 						Name: to.Ptr("AllowVnetInBound"),
	// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 							Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
	// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 							DestinationPortRange: to.Ptr("*"),
	// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 							Priority: to.Ptr[int32](65000),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 							SourcePortRange: to.Ptr("*"),
	// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 						},
	// 				}},
	// 				EffectiveSecurityRules: []*armnetwork.EffectiveNetworkSecurityRule{
	// 					{
	// 						Name: to.Ptr("DefaultOutboundDenyAll"),
	// 						Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 						DestinationAddressPrefix: to.Ptr("*"),
	// 						DestinationPortRange: to.Ptr("0-65535"),
	// 						Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 						Priority: to.Ptr[int32](65500),
	// 						SourceAddressPrefix: to.Ptr("*"),
	// 						SourcePortRange: to.Ptr("0-65535"),
	// 						Protocol: to.Ptr(armnetwork.EffectiveSecurityRuleProtocolAll),
	// 				}},
	// 				SubnetAssociation: &armnetwork.SubnetAssociation{
	// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 					SecurityRules: []*armnetwork.SecurityRule{
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/AppNSG/securityRules/fe_rule"),
	// 							Name: to.Ptr("fe_rule"),
	// 							Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 							Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 								Description: to.Ptr("Allow Frontend"),
	// 								Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 								DestinationAddressPrefix: to.Ptr("*"),
	// 								DestinationPortRange: to.Ptr("*"),
	// 								Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 								Priority: to.Ptr[int32](100),
	// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 								SourceAddressPrefix: to.Ptr("10.1.0.0/24"),
	// 								SourcePortRange: to.Ptr("*"),
	// 								Protocol: to.Ptr(armnetwork.SecurityRuleProtocolTCP),
	// 							},
	// 					}},
	// 				},
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherTroubleshootGet.json
func ExampleWatchersClient_BeginGetTroubleshooting() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginGetTroubleshooting(ctx, "rg1", "nw1", armnetwork.TroubleshootingParameters{
		Properties: &armnetwork.TroubleshootingProperties{
			StorageID:   to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/st1"),
			StoragePath: to.Ptr("https://st1.blob.core.windows.net/cn1"),
		},
		TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TroubleshootingResult = armnetwork.TroubleshootingResult{
	// 	Code: to.Ptr("UnHealthy"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-01-12T00:20:09.914Z"); return t}()),
	// 	Results: []*armnetwork.TroubleshootingDetails{
	// 		{
	// 			Detail: to.Ptr("During this time S2S VPN tunnels to on premises sites or other Azure virtual networks will be disconnected"),
	// 			ID: to.Ptr("000000"),
	// 			ReasonType: to.Ptr("VipUnResponsive"),
	// 			RecommendedActions: []*armnetwork.TroubleshootingRecommendedActions{
	// 				{
	// 					ActionText: to.Ptr("Verify if there is a network security group (NSG) applied to the GatewaySubnet"),
	// 					ActionURI: to.Ptr("https://docs.microsoft.com/en-us/azure/virtual-network/virtual-networks-create-nsg-arm-pportal"),
	// 					ActionURIText: to.Ptr("Verify"),
	// 				},
	// 				{
	// 					ActionText: to.Ptr("If your VPN gateway isn't up and running by the expected resolution time, contact support"),
	// 					ActionURI: to.Ptr("http://azure.microsoft.com/support"),
	// 					ActionURIText: to.Ptr("contact support"),
	// 			}},
	// 			Summary: to.Ptr("We are sorry, your VPN gateway is unreachable from the Internet"),
	// 	}},
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-01-12T00:19:47.044Z"); return t}()),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherTroubleshootResultQuery.json
func ExampleWatchersClient_BeginGetTroubleshootingResult() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginGetTroubleshootingResult(ctx, "rg1", "nw1", armnetwork.QueryTroubleshootingParameters{
		TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TroubleshootingResult = armnetwork.TroubleshootingResult{
	// 	Code: to.Ptr("UnHealthy"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-01-12T00:20:09.914Z"); return t}()),
	// 	Results: []*armnetwork.TroubleshootingDetails{
	// 		{
	// 			Detail: to.Ptr("During this time S2S VPN tunnels to on premises sites or other Azure virtual networks will be disconnected"),
	// 			ID: to.Ptr("000000"),
	// 			ReasonType: to.Ptr("VipUnResponsive"),
	// 			RecommendedActions: []*armnetwork.TroubleshootingRecommendedActions{
	// 				{
	// 					ActionText: to.Ptr("Verify if there is a network security group (NSG) applied to the GatewaySubnet"),
	// 					ActionURI: to.Ptr("https://docs.microsoft.com/en-us/azure/virtual-network/virtual-networks-create-nsg-arm-pportal"),
	// 					ActionURIText: to.Ptr("Verify"),
	// 				},
	// 				{
	// 					ActionText: to.Ptr("If your VPN gateway isn't up and running by the expected resolution time, contact support"),
	// 					ActionURI: to.Ptr("http://azure.microsoft.com/support"),
	// 					ActionURIText: to.Ptr("contact support"),
	// 			}},
	// 			Summary: to.Ptr("We are sorry, your VPN gateway is unreachable from the Internet"),
	// 	}},
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-01-12T00:19:47.044Z"); return t}()),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherFlowLogConfigure.json
func ExampleWatchersClient_BeginSetFlowLogConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginSetFlowLogConfiguration(ctx, "rg1", "nw1", armnetwork.FlowLogInformation{
		Properties: &armnetwork.FlowLogProperties{
			Enabled:   to.Ptr(true),
			StorageID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/st1"),
		},
		TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FlowLogInformation = armnetwork.FlowLogInformation{
	// 	Properties: &armnetwork.FlowLogProperties{
	// 		Enabled: to.Ptr(true),
	// 		StorageID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/st1"),
	// 	},
	// 	TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherFlowLogStatusQuery.json
func ExampleWatchersClient_BeginGetFlowLogStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginGetFlowLogStatus(ctx, "rg1", "nw1", armnetwork.FlowLogStatusParameters{
		TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FlowLogInformation = armnetwork.FlowLogInformation{
	// 	Properties: &armnetwork.FlowLogProperties{
	// 		Enabled: to.Ptr(true),
	// 		StorageID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/st1"),
	// 	},
	// 	TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherConnectivityCheck.json
func ExampleWatchersClient_BeginCheckConnectivity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginCheckConnectivity(ctx, "rg1", "nw1", armnetwork.ConnectivityParameters{
		Destination: &armnetwork.ConnectivityDestination{
			Address: to.Ptr("192.168.100.4"),
			Port:    to.Ptr[int32](3389),
		},
		PreferredIPVersion: to.Ptr(armnetwork.IPVersionIPv4),
		Source: &armnetwork.ConnectivitySource{
			ResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectivityInformation = armnetwork.ConnectivityInformation{
	// 	AvgLatencyInMs: to.Ptr[int32](1),
	// 	ConnectionStatus: to.Ptr(armnetwork.ConnectionStatusConnected),
	// 	Hops: []*armnetwork.ConnectivityHop{
	// 		{
	// 			Type: to.Ptr("Source"),
	// 			Address: to.Ptr("10.1.1.4"),
	// 			ID: to.Ptr("7dbbe7aa-60ba-4650-831e-63d775d38e9e"),
	// 			Issues: []*armnetwork.ConnectivityIssue{
	// 			},
	// 			NextHopIDs: []*string{
	// 				to.Ptr("75c8d819-b208-4584-a311-1aa45ce753f9")},
	// 				ResourceID: to.Ptr("subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkInterfaces/nic0/ipConfigurations/ipconfig1"),
	// 			},
	// 			{
	// 				Type: to.Ptr("VirtualNetwork"),
	// 				Address: to.Ptr("192.168.100.4"),
	// 				ID: to.Ptr("75c8d819-b208-4584-a311-1aa45ce753f9"),
	// 				Issues: []*armnetwork.ConnectivityIssue{
	// 				},
	// 				NextHopIDs: []*string{
	// 				},
	// 				ResourceID: to.Ptr("subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkInterfaces/nic1/ipConfigurations/ipconfig1"),
	// 		}},
	// 		MaxLatencyInMs: to.Ptr[int32](4),
	// 		MinLatencyInMs: to.Ptr[int32](1),
	// 		ProbesFailed: to.Ptr[int32](0),
	// 		ProbesSent: to.Ptr[int32](100),
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherAzureReachabilityReportGet.json
func ExampleWatchersClient_BeginGetAzureReachabilityReport() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginGetAzureReachabilityReport(ctx, "rg1", "nw1", armnetwork.AzureReachabilityReportParameters{
		AzureLocations: []*string{
			to.Ptr("West US")},
		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-10T00:00:00.000Z"); return t }()),
		ProviderLocation: &armnetwork.AzureReachabilityReportLocation{
			Country: to.Ptr("United States"),
			State:   to.Ptr("washington"),
		},
		Providers: []*string{
			to.Ptr("Frontier Communications of America, Inc. - ASN 5650")},
		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-07T00:00:00.000Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureReachabilityReport = armnetwork.AzureReachabilityReport{
	// 	AggregationLevel: to.Ptr("State"),
	// 	ProviderLocation: &armnetwork.AzureReachabilityReportLocation{
	// 		Country: to.Ptr("United States"),
	// 		State: to.Ptr("washington"),
	// 	},
	// 	ReachabilityReport: []*armnetwork.AzureReachabilityReportItem{
	// 		{
	// 			AzureLocation: to.Ptr("West US"),
	// 			Latencies: []*armnetwork.AzureReachabilityReportLatencyInfo{
	// 				{
	// 					Score: to.Ptr[int32](94),
	// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-07T00:00:00.000Z"); return t}()),
	// 				},
	// 				{
	// 					Score: to.Ptr[int32](94),
	// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-08T00:00:00.000Z"); return t}()),
	// 				},
	// 				{
	// 					Score: to.Ptr[int32](94),
	// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-09T00:00:00.000Z"); return t}()),
	// 			}},
	// 			Provider: to.Ptr("Frontier Communications of America, Inc. - ASN 5650"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherAvailableProvidersListGet.json
func ExampleWatchersClient_BeginListAvailableProviders() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginListAvailableProviders(ctx, "rg1", "nw1", armnetwork.AvailableProvidersListParameters{
		AzureLocations: []*string{
			to.Ptr("West US")},
		City:    to.Ptr("seattle"),
		Country: to.Ptr("United States"),
		State:   to.Ptr("washington"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AvailableProvidersList = armnetwork.AvailableProvidersList{
	// 	Countries: []*armnetwork.AvailableProvidersListCountry{
	// 		{
	// 			CountryName: to.Ptr("United States"),
	// 			States: []*armnetwork.AvailableProvidersListState{
	// 				{
	// 					Cities: []*armnetwork.AvailableProvidersListCity{
	// 						{
	// 							CityName: to.Ptr("seattle"),
	// 							Providers: []*string{
	// 								to.Ptr("Comcast Cable Communications, Inc. - ASN 7922"),
	// 								to.Ptr("Comcast Cable Communications, LLC - ASN 7922"),
	// 								to.Ptr("Level 3 Communications, Inc. (GBLX) - ASN 3549"),
	// 								to.Ptr("Qwest Communications Company, LLC - ASN 209")},
	// 						}},
	// 						StateName: to.Ptr("washington"),
	// 				}},
	// 		}},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkWatcherNetworkConfigurationDiagnostic.json
func ExampleWatchersClient_BeginGetNetworkConfigurationDiagnostic() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWatchersClient().BeginGetNetworkConfigurationDiagnostic(ctx, "rg1", "nw1", armnetwork.ConfigurationDiagnosticParameters{
		Profiles: []*armnetwork.ConfigurationDiagnosticProfile{
			{
				Destination:     to.Ptr("12.11.12.14"),
				DestinationPort: to.Ptr("12100"),
				Direction:       to.Ptr(armnetwork.DirectionInbound),
				Source:          to.Ptr("10.1.0.4"),
				Protocol:        to.Ptr("TCP"),
			}},
		TargetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConfigurationDiagnosticResponse = armnetwork.ConfigurationDiagnosticResponse{
	// 	Results: []*armnetwork.ConfigurationDiagnosticResult{
	// 		{
	// 			NetworkSecurityGroupResult: &armnetwork.SecurityGroupResult{
	// 				EvaluatedNetworkSecurityGroups: []*armnetwork.EvaluatedNetworkSecurityGroup{
	// 					{
	// 						AppliedTo: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/vnet/subnets/AppSubnet"),
	// 						MatchedRule: &armnetwork.MatchedRule{
	// 							Action: to.Ptr("Allow"),
	// 							RuleName: to.Ptr("UserRule_fe_rule"),
	// 						},
	// 						NetworkSecurityGroupID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg1"),
	// 						RulesEvaluationResult: []*armnetwork.SecurityRulesEvaluationResult{
	// 							{
	// 								Name: to.Ptr("UserRule_Cleanuptool-Allow-100"),
	// 								DestinationMatched: to.Ptr(true),
	// 								DestinationPortMatched: to.Ptr(false),
	// 								ProtocolMatched: to.Ptr(true),
	// 								SourceMatched: to.Ptr(false),
	// 								SourcePortMatched: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("UserRule_Cleanuptool-Allow-101"),
	// 								DestinationMatched: to.Ptr(true),
	// 								DestinationPortMatched: to.Ptr(false),
	// 								ProtocolMatched: to.Ptr(true),
	// 								SourceMatched: to.Ptr(true),
	// 								SourcePortMatched: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("UserRule_Cleanuptool-Allow-102"),
	// 								DestinationMatched: to.Ptr(true),
	// 								DestinationPortMatched: to.Ptr(false),
	// 								ProtocolMatched: to.Ptr(true),
	// 								SourceMatched: to.Ptr(false),
	// 								SourcePortMatched: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("UserRule_Cleanuptool-Deny-103"),
	// 								DestinationMatched: to.Ptr(true),
	// 								DestinationPortMatched: to.Ptr(false),
	// 								ProtocolMatched: to.Ptr(true),
	// 								SourceMatched: to.Ptr(true),
	// 								SourcePortMatched: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("UserRule_fe_rule"),
	// 								DestinationMatched: to.Ptr(true),
	// 								DestinationPortMatched: to.Ptr(true),
	// 								ProtocolMatched: to.Ptr(true),
	// 								SourceMatched: to.Ptr(true),
	// 								SourcePortMatched: to.Ptr(true),
	// 						}},
	// 					},
	// 					{
	// 						AppliedTo: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/vnet/networkInterfaces/nic"),
	// 						MatchedRule: &armnetwork.MatchedRule{
	// 							Action: to.Ptr("Allow"),
	// 							RuleName: to.Ptr("UserRule_fe_rule"),
	// 						},
	// 						NetworkSecurityGroupID: to.Ptr("/subscriptions/61cc8a98-a8be-4bfe-a04e-0b461f93fe35/resourceGroups/NwRgCentralUSEUAP_copy/providers/Microsoft.Network/networkSecurityGroups/AppNSG"),
	// 						RulesEvaluationResult: []*armnetwork.SecurityRulesEvaluationResult{
	// 							{
	// 								Name: to.Ptr("UserRule_fe_rule"),
	// 								DestinationMatched: to.Ptr(true),
	// 								DestinationPortMatched: to.Ptr(true),
	// 								ProtocolMatched: to.Ptr(true),
	// 								SourceMatched: to.Ptr(true),
	// 								SourcePortMatched: to.Ptr(true),
	// 						}},
	// 				}},
	// 				SecurityRuleAccessResult: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 			},
	// 			Profile: &armnetwork.ConfigurationDiagnosticProfile{
	// 				Destination: to.Ptr("12.11.12.14"),
	// 				DestinationPort: to.Ptr("12100"),
	// 				Direction: to.Ptr(armnetwork.DirectionInbound),
	// 				Source: to.Ptr("10.1.0.4"),
	// 				Protocol: to.Ptr("TCP"),
	// 			},
	// 	}},
	// }
}
