//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkanalytics

import "time"

// AccountSas - The details for storage account sas creation.
type AccountSas struct {
	// REQUIRED; Sas token expiry timestamp.
	ExpiryTimeStamp *time.Time

	// REQUIRED; Ip Address
	IPAddress *string

	// REQUIRED; Sas token start timestamp.
	StartTimeStamp *time.Time
}

// AccountSasToken - Details of storage account sas token .
type AccountSasToken struct {
	// REQUIRED; Field to specify storage account sas token.
	StorageAccountSasToken *string
}

// ConsumptionEndpointsProperties - Details of Consumption Properties
type ConsumptionEndpointsProperties struct {
	// READ-ONLY; Resource Id of file access endpoint.
	FileAccessResourceID *string

	// READ-ONLY; Url to consume file type.
	FileAccessURL *string

	// READ-ONLY; Resource Id of ingestion endpoint.
	IngestionResourceID *string

	// READ-ONLY; Ingestion url to upload the data.
	IngestionURL *string

	// READ-ONLY; Resource Id of query endpoint.
	QueryResourceID *string

	// READ-ONLY; Url to consume the processed data.
	QueryURL *string
}

// ContainerSaS - The details for container sas creation.
type ContainerSaS struct {
	// REQUIRED; Sas token expiry timestamp.
	ExpiryTimeStamp *time.Time

	// REQUIRED; Ip Address
	IPAddress *string

	// REQUIRED; Sas token start timestamp.
	StartTimeStamp *time.Time
}

// ContainerSasToken - Details of storage container account sas token .
type ContainerSasToken struct {
	// REQUIRED; Field to specify storage container sas token.
	StorageContainerSasToken *string
}

// DataProduct - The data product resource.
type DataProduct struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The managed service identities assigned to this resource.
	Identity *ManagedServiceIdentity

	// The resource-specific properties for this resource.
	Properties *DataProductProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataProductInformation - Data Product Information
type DataProductInformation struct {
	// REQUIRED; Name of data product.
	DataProductName *string

	// REQUIRED; Version information of data product.
	DataProductVersions []*DataProductVersion

	// REQUIRED; Description about data product.
	Description *string
}

// DataProductListResult - The response of a DataProduct list operation.
type DataProductListResult struct {
	// REQUIRED; The DataProduct items on this page
	Value []*DataProduct

	// The link to the next page of items
	NextLink *string
}

// DataProductNetworkACLs - Data Product Network rule set
type DataProductNetworkACLs struct {
	// REQUIRED; The list of query ips in the format of CIDR allowed to connect to query/visualization endpoint.
	AllowedQueryIPRangeList []*string

	// REQUIRED; Default Action
	DefaultAction *DefaultAction

	// REQUIRED; IP rule with specific IP or IP range in CIDR format.
	IPRules []*IPRules

	// REQUIRED; Virtual Network Rule
	VirtualNetworkRule []*VirtualNetworkRule
}

// DataProductProperties - The data product properties.
type DataProductProperties struct {
	// REQUIRED; Major version of data product.
	MajorVersion *string

	// REQUIRED; Product name of data product.
	Product *string

	// REQUIRED; Data product publisher name.
	Publisher *string

	// Current configured minor version of the data product resource.
	CurrentMinorVersion *string

	// Customer managed encryption key details for data product.
	CustomerEncryptionKey *EncryptionKeyDetails

	// Flag to enable customer managed key encryption for data product.
	CustomerManagedKeyEncryptionEnabled *ControlState

	// Managed resource group configuration.
	ManagedResourceGroupConfiguration *ManagedResourceGroupConfiguration

	// Network rule set for data product.
	Networkacls *DataProductNetworkACLs

	// List of name or email associated with data product resource deployment.
	Owners []*string

	// Flag to enable or disable private link for data product resource.
	PrivateLinksEnabled *ControlState

	// Flag to enable or disable public access of data product resource.
	PublicNetworkAccess *ControlState

	// Purview account url for data product to connect to.
	PurviewAccount *string

	// Purview collection url for data product to connect to.
	PurviewCollection *string

	// Flag to enable or disable redundancy for data product.
	Redundancy *ControlState

	// READ-ONLY; List of available minor versions of the data product resource.
	AvailableMinorVersions []*string

	// READ-ONLY; Resource links which exposed to the customer to query the data.
	ConsumptionEndpoints *ConsumptionEndpointsProperties

	// READ-ONLY; Documentation link for the data product based on definition file.
	Documentation *string

	// READ-ONLY; Key vault url.
	KeyVaultURL *string

	// READ-ONLY; Latest provisioning state of data product.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the data product resource.
	ResourceGUID *string
}

// DataProductUpdate - The type used for update operations of the DataProduct.
type DataProductUpdate struct {
	// The managed service identities assigned to this resource.
	Identity *ManagedServiceIdentity

	// The updatable properties of the DataProduct.
	Properties *DataProductUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// DataProductUpdateProperties - The updatable properties of the DataProduct.
type DataProductUpdateProperties struct {
	// Current configured minor version of the data product resource.
	CurrentMinorVersion *string

	// List of name or email associated with data product resource deployment.
	Owners []*string

	// Flag to enable or disable private link for data product resource.
	PrivateLinksEnabled *ControlState

	// Purview account url for data product to connect to.
	PurviewAccount *string

	// Purview collection url for data product to connect to.
	PurviewCollection *string
}

// DataProductVersion - Data Product Version.
type DataProductVersion struct {
	// REQUIRED; Version of data product
	Version *string
}

// DataProductsCatalog - The data catalog resource.
type DataProductsCatalog struct {
	// The resource-specific properties for this resource.
	Properties *DataProductsCatalogProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataProductsCatalogListResult - The response of a DataProductsCatalog list operation.
type DataProductsCatalogListResult struct {
	// REQUIRED; The DataProductsCatalog items on this page
	Value []*DataProductsCatalog

	// The link to the next page of items
	NextLink *string
}

// DataProductsCatalogProperties - Details for data catalog properties.
type DataProductsCatalogProperties struct {
	// REQUIRED; The data product publisher information.
	Publishers []*PublisherInformation

	// READ-ONLY; The data catalog provisioning state.
	ProvisioningState *ProvisioningState
}

// DataType - The data type resource.
type DataType struct {
	// The resource-specific properties for this resource.
	Properties *DataTypeProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataTypeListResult - The response of a DataType list operation.
type DataTypeListResult struct {
	// REQUIRED; The DataType items on this page
	Value []*DataType

	// The link to the next page of items
	NextLink *string
}

// DataTypeProperties - The data type properties
type DataTypeProperties struct {
	// Field for database cache retention in days.
	DatabaseCacheRetention *int32

	// Field for database data retention in days.
	DatabaseRetention *int32

	// State of data type.
	State *DataTypeState

	// Field for storage output retention in days.
	StorageOutputRetention *int32

	// READ-ONLY; Latest provisioning state of data product.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Reason for the state of data type.
	StateReason *string

	// READ-ONLY; Url for data visualization.
	VisualizationURL *string
}

// DataTypeUpdate - The type used for update operations of the DataType.
type DataTypeUpdate struct {
	// The updatable properties of the DataType.
	Properties *DataTypeUpdateProperties
}

// DataTypeUpdateProperties - The updatable properties of the DataType.
type DataTypeUpdateProperties struct {
	// Field for database cache retention in days.
	DatabaseCacheRetention *int32

	// Field for database data retention in days.
	DatabaseRetention *int32

	// State of data type.
	State *DataTypeState

	// Field for storage output retention in days.
	StorageOutputRetention *int32
}

// EncryptionKeyDetails - Encryption key details.
type EncryptionKeyDetails struct {
	// REQUIRED; The name of the key vault key.
	KeyName *string

	// REQUIRED; The Uri of the key vault.
	KeyVaultURI *string

	// REQUIRED; The version of the key vault key.
	KeyVersion *string
}

// IPRules - IP rule with specific IP or IP range in CIDR format.
type IPRules struct {
	// REQUIRED; The action of virtual network rule.
	Action *string

	// IP Rules Value
	Value *string
}

// KeyVaultInfo - Details for KeyVault.
type KeyVaultInfo struct {
	// REQUIRED; key vault url.
	KeyVaultURL *string
}

// ListRoleAssignments - list role assignments.
type ListRoleAssignments struct {
	// REQUIRED; Count of role assignments.
	Count *int32

	// REQUIRED; list of role assignments
	RoleAssignmentResponse []*RoleAssignmentDetail
}

// ManagedResourceGroupConfiguration - ManagedResourceGroup related properties
type ManagedResourceGroupConfiguration struct {
	// REQUIRED; Managed Resource Group location
	Location *string

	// REQUIRED; Name of managed resource group
	Name *string
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// PublisherInformation - Details for Publisher Information.
type PublisherInformation struct {
	// REQUIRED; Data product information.
	DataProducts []*DataProductInformation

	// REQUIRED; Name of the publisher.
	PublisherName *string
}

// RoleAssignmentCommonProperties - The details for role assignment common properties.
type RoleAssignmentCommonProperties struct {
	// REQUIRED; Data Type Scope at which the role assignment is created.
	DataTypeScope []*string

	// REQUIRED; Object ID of the AAD principal or security-group.
	PrincipalID *string

	// REQUIRED; Type of the principal Id: User, Group or ServicePrincipal
	PrincipalType *string

	// REQUIRED; Data Product role to be assigned to a user.
	Role *DataProductUserRole

	// REQUIRED; Role Id of the Built-In Role
	RoleID *string

	// REQUIRED; User name.
	UserName *string
}

// RoleAssignmentDetail - The details for role assignment response.
type RoleAssignmentDetail struct {
	// REQUIRED; Data Type Scope at which the role assignment is created.
	DataTypeScope []*string

	// REQUIRED; Object ID of the AAD principal or security-group.
	PrincipalID *string

	// REQUIRED; Type of the principal Id: User, Group or ServicePrincipal
	PrincipalType *string

	// REQUIRED; Data Product role to be assigned to a user.
	Role *DataProductUserRole

	// REQUIRED; Id of role assignment request
	RoleAssignmentID *string

	// REQUIRED; Role Id of the Built-In Role
	RoleID *string

	// REQUIRED; User name.
	UserName *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// VirtualNetworkRule - Virtual Network Rule
type VirtualNetworkRule struct {
	// REQUIRED; Resource ID of a subnet
	ID *string

	// The action of virtual network rule.
	Action *string

	// Gets the state of virtual network rule.
	State *string
}
