//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkcloud

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AADConfiguration.
func (a AADConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminGroupObjectIds", a.AdminGroupObjectIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADConfiguration.
func (a *AADConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminGroupObjectIds":
			err = unpopulate(val, "AdminGroupObjectIDs", &a.AdminGroupObjectIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdministrativeCredentials.
func (a AdministrativeCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "username", a.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdministrativeCredentials.
func (a *AdministrativeCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &a.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdministratorConfiguration.
func (a AdministratorConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminUsername", a.AdminUsername)
	populate(objectMap, "sshPublicKeys", a.SSHPublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdministratorConfiguration.
func (a *AdministratorConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &a.AdminUsername)
			delete(rawMsg, key)
		case "sshPublicKeys":
			err = unpopulate(val, "SSHPublicKeys", &a.SSHPublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentOptions.
func (a AgentOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hugepagesCount", a.HugepagesCount)
	populate(objectMap, "hugepagesSize", a.HugepagesSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentOptions.
func (a *AgentOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hugepagesCount":
			err = unpopulate(val, "HugepagesCount", &a.HugepagesCount)
			delete(rawMsg, key)
		case "hugepagesSize":
			err = unpopulate(val, "HugepagesSize", &a.HugepagesSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPool.
func (a AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", a.ExtendedLocation)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPool.
func (a *AgentPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &a.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolList.
func (a AgentPoolList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolList.
func (a *AgentPoolList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolPatchParameters.
func (a AgentPoolPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolPatchParameters.
func (a *AgentPoolPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolPatchProperties.
func (a AgentPoolPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "upgradeSettings", a.UpgradeSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolPatchProperties.
func (a *AgentPoolPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &a.UpgradeSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProperties.
func (a AgentPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorConfiguration", a.AdministratorConfiguration)
	populate(objectMap, "agentOptions", a.AgentOptions)
	populate(objectMap, "attachedNetworkConfiguration", a.AttachedNetworkConfiguration)
	populate(objectMap, "availabilityZones", a.AvailabilityZones)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "detailedStatus", a.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", a.DetailedStatusMessage)
	populate(objectMap, "kubernetesVersion", a.KubernetesVersion)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "mode", a.Mode)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "taints", a.Taints)
	populate(objectMap, "upgradeSettings", a.UpgradeSettings)
	populate(objectMap, "vmSkuName", a.VMSKUName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProperties.
func (a *AgentPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorConfiguration":
			err = unpopulate(val, "AdministratorConfiguration", &a.AdministratorConfiguration)
			delete(rawMsg, key)
		case "agentOptions":
			err = unpopulate(val, "AgentOptions", &a.AgentOptions)
			delete(rawMsg, key)
		case "attachedNetworkConfiguration":
			err = unpopulate(val, "AttachedNetworkConfiguration", &a.AttachedNetworkConfiguration)
			delete(rawMsg, key)
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &a.AvailabilityZones)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &a.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &a.DetailedStatusMessage)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &a.KubernetesVersion)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "taints":
			err = unpopulate(val, "Taints", &a.Taints)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &a.UpgradeSettings)
			delete(rawMsg, key)
		case "vmSkuName":
			err = unpopulate(val, "VMSKUName", &a.VMSKUName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeSettings.
func (a AgentPoolUpgradeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxSurge", a.MaxSurge)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeSettings.
func (a *AgentPoolUpgradeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxSurge":
			err = unpopulate(val, "MaxSurge", &a.MaxSurge)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachedNetworkConfiguration.
func (a AttachedNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "l2Networks", a.L2Networks)
	populate(objectMap, "l3Networks", a.L3Networks)
	populate(objectMap, "trunkedNetworks", a.TrunkedNetworks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachedNetworkConfiguration.
func (a *AttachedNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "l2Networks":
			err = unpopulate(val, "L2Networks", &a.L2Networks)
			delete(rawMsg, key)
		case "l3Networks":
			err = unpopulate(val, "L3Networks", &a.L3Networks)
			delete(rawMsg, key)
		case "trunkedNetworks":
			err = unpopulate(val, "TrunkedNetworks", &a.TrunkedNetworks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableUpgrade.
func (a AvailableUpgrade) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityLifecycle", a.AvailabilityLifecycle)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableUpgrade.
func (a *AvailableUpgrade) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityLifecycle":
			err = unpopulate(val, "AvailabilityLifecycle", &a.AvailabilityLifecycle)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachine.
func (b BareMetalMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", b.ExtendedLocation)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachine.
func (b *BareMetalMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &b.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineCommandSpecification.
func (b BareMetalMachineCommandSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", b.Arguments)
	populate(objectMap, "command", b.Command)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineCommandSpecification.
func (b *BareMetalMachineCommandSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &b.Arguments)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &b.Command)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineConfigurationData.
func (b BareMetalMachineConfigurationData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bmcConnectionString", b.BmcConnectionString)
	populate(objectMap, "bmcCredentials", b.BmcCredentials)
	populate(objectMap, "bmcMacAddress", b.BmcMacAddress)
	populate(objectMap, "bootMacAddress", b.BootMacAddress)
	populate(objectMap, "machineDetails", b.MachineDetails)
	populate(objectMap, "machineName", b.MachineName)
	populate(objectMap, "rackSlot", b.RackSlot)
	populate(objectMap, "serialNumber", b.SerialNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineConfigurationData.
func (b *BareMetalMachineConfigurationData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bmcConnectionString":
			err = unpopulate(val, "BmcConnectionString", &b.BmcConnectionString)
			delete(rawMsg, key)
		case "bmcCredentials":
			err = unpopulate(val, "BmcCredentials", &b.BmcCredentials)
			delete(rawMsg, key)
		case "bmcMacAddress":
			err = unpopulate(val, "BmcMacAddress", &b.BmcMacAddress)
			delete(rawMsg, key)
		case "bootMacAddress":
			err = unpopulate(val, "BootMacAddress", &b.BootMacAddress)
			delete(rawMsg, key)
		case "machineDetails":
			err = unpopulate(val, "MachineDetails", &b.MachineDetails)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &b.MachineName)
			delete(rawMsg, key)
		case "rackSlot":
			err = unpopulate(val, "RackSlot", &b.RackSlot)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &b.SerialNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineCordonParameters.
func (b BareMetalMachineCordonParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "evacuate", b.Evacuate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineCordonParameters.
func (b *BareMetalMachineCordonParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "evacuate":
			err = unpopulate(val, "Evacuate", &b.Evacuate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineKeySet.
func (b BareMetalMachineKeySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", b.ExtendedLocation)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineKeySet.
func (b *BareMetalMachineKeySet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &b.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineKeySetList.
func (b BareMetalMachineKeySetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineKeySetList.
func (b *BareMetalMachineKeySetList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineKeySetPatchParameters.
func (b BareMetalMachineKeySetPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineKeySetPatchParameters.
func (b *BareMetalMachineKeySetPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineKeySetPatchProperties.
func (b BareMetalMachineKeySetPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiration", b.Expiration)
	populate(objectMap, "jumpHostsAllowed", b.JumpHostsAllowed)
	populate(objectMap, "userList", b.UserList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineKeySetPatchProperties.
func (b *BareMetalMachineKeySetPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiration":
			err = unpopulateDateTimeRFC3339(val, "Expiration", &b.Expiration)
			delete(rawMsg, key)
		case "jumpHostsAllowed":
			err = unpopulate(val, "JumpHostsAllowed", &b.JumpHostsAllowed)
			delete(rawMsg, key)
		case "userList":
			err = unpopulate(val, "UserList", &b.UserList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineKeySetProperties.
func (b BareMetalMachineKeySetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureGroupId", b.AzureGroupID)
	populate(objectMap, "detailedStatus", b.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", b.DetailedStatusMessage)
	populateDateTimeRFC3339(objectMap, "expiration", b.Expiration)
	populate(objectMap, "jumpHostsAllowed", b.JumpHostsAllowed)
	populateDateTimeRFC3339(objectMap, "lastValidation", b.LastValidation)
	populate(objectMap, "osGroupName", b.OSGroupName)
	populate(objectMap, "privilegeLevel", b.PrivilegeLevel)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "userList", b.UserList)
	populate(objectMap, "userListStatus", b.UserListStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineKeySetProperties.
func (b *BareMetalMachineKeySetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureGroupId":
			err = unpopulate(val, "AzureGroupID", &b.AzureGroupID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &b.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &b.DetailedStatusMessage)
			delete(rawMsg, key)
		case "expiration":
			err = unpopulateDateTimeRFC3339(val, "Expiration", &b.Expiration)
			delete(rawMsg, key)
		case "jumpHostsAllowed":
			err = unpopulate(val, "JumpHostsAllowed", &b.JumpHostsAllowed)
			delete(rawMsg, key)
		case "lastValidation":
			err = unpopulateDateTimeRFC3339(val, "LastValidation", &b.LastValidation)
			delete(rawMsg, key)
		case "osGroupName":
			err = unpopulate(val, "OSGroupName", &b.OSGroupName)
			delete(rawMsg, key)
		case "privilegeLevel":
			err = unpopulate(val, "PrivilegeLevel", &b.PrivilegeLevel)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "userList":
			err = unpopulate(val, "UserList", &b.UserList)
			delete(rawMsg, key)
		case "userListStatus":
			err = unpopulate(val, "UserListStatus", &b.UserListStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineList.
func (b BareMetalMachineList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineList.
func (b *BareMetalMachineList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachinePatchParameters.
func (b BareMetalMachinePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachinePatchParameters.
func (b *BareMetalMachinePatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachinePatchProperties.
func (b BareMetalMachinePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "machineDetails", b.MachineDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachinePatchProperties.
func (b *BareMetalMachinePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "machineDetails":
			err = unpopulate(val, "MachineDetails", &b.MachineDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachinePowerOffParameters.
func (b BareMetalMachinePowerOffParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipShutdown", b.SkipShutdown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachinePowerOffParameters.
func (b *BareMetalMachinePowerOffParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipShutdown":
			err = unpopulate(val, "SkipShutdown", &b.SkipShutdown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineProperties.
func (b BareMetalMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedResourceIds", b.AssociatedResourceIDs)
	populate(objectMap, "bmcConnectionString", b.BmcConnectionString)
	populate(objectMap, "bmcCredentials", b.BmcCredentials)
	populate(objectMap, "bmcMacAddress", b.BmcMacAddress)
	populate(objectMap, "bootMacAddress", b.BootMacAddress)
	populate(objectMap, "clusterId", b.ClusterID)
	populate(objectMap, "cordonStatus", b.CordonStatus)
	populate(objectMap, "detailedStatus", b.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", b.DetailedStatusMessage)
	populate(objectMap, "hardwareInventory", b.HardwareInventory)
	populate(objectMap, "hardwareValidationStatus", b.HardwareValidationStatus)
	populate(objectMap, "hybridAksClustersAssociatedIds", b.HybridAksClustersAssociatedIDs)
	populate(objectMap, "kubernetesNodeName", b.KubernetesNodeName)
	populate(objectMap, "kubernetesVersion", b.KubernetesVersion)
	populate(objectMap, "machineDetails", b.MachineDetails)
	populate(objectMap, "machineName", b.MachineName)
	populate(objectMap, "machineSkuId", b.MachineSKUID)
	populate(objectMap, "osImage", b.OSImage)
	populate(objectMap, "oamIpv4Address", b.OamIPv4Address)
	populate(objectMap, "oamIpv6Address", b.OamIPv6Address)
	populate(objectMap, "powerState", b.PowerState)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "rackId", b.RackID)
	populate(objectMap, "rackSlot", b.RackSlot)
	populate(objectMap, "readyState", b.ReadyState)
	populate(objectMap, "serialNumber", b.SerialNumber)
	populate(objectMap, "serviceTag", b.ServiceTag)
	populate(objectMap, "virtualMachinesAssociatedIds", b.VirtualMachinesAssociatedIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineProperties.
func (b *BareMetalMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedResourceIds":
			err = unpopulate(val, "AssociatedResourceIDs", &b.AssociatedResourceIDs)
			delete(rawMsg, key)
		case "bmcConnectionString":
			err = unpopulate(val, "BmcConnectionString", &b.BmcConnectionString)
			delete(rawMsg, key)
		case "bmcCredentials":
			err = unpopulate(val, "BmcCredentials", &b.BmcCredentials)
			delete(rawMsg, key)
		case "bmcMacAddress":
			err = unpopulate(val, "BmcMacAddress", &b.BmcMacAddress)
			delete(rawMsg, key)
		case "bootMacAddress":
			err = unpopulate(val, "BootMacAddress", &b.BootMacAddress)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &b.ClusterID)
			delete(rawMsg, key)
		case "cordonStatus":
			err = unpopulate(val, "CordonStatus", &b.CordonStatus)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &b.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &b.DetailedStatusMessage)
			delete(rawMsg, key)
		case "hardwareInventory":
			err = unpopulate(val, "HardwareInventory", &b.HardwareInventory)
			delete(rawMsg, key)
		case "hardwareValidationStatus":
			err = unpopulate(val, "HardwareValidationStatus", &b.HardwareValidationStatus)
			delete(rawMsg, key)
		case "hybridAksClustersAssociatedIds":
			err = unpopulate(val, "HybridAksClustersAssociatedIDs", &b.HybridAksClustersAssociatedIDs)
			delete(rawMsg, key)
		case "kubernetesNodeName":
			err = unpopulate(val, "KubernetesNodeName", &b.KubernetesNodeName)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &b.KubernetesVersion)
			delete(rawMsg, key)
		case "machineDetails":
			err = unpopulate(val, "MachineDetails", &b.MachineDetails)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &b.MachineName)
			delete(rawMsg, key)
		case "machineSkuId":
			err = unpopulate(val, "MachineSKUID", &b.MachineSKUID)
			delete(rawMsg, key)
		case "osImage":
			err = unpopulate(val, "OSImage", &b.OSImage)
			delete(rawMsg, key)
		case "oamIpv4Address":
			err = unpopulate(val, "OamIPv4Address", &b.OamIPv4Address)
			delete(rawMsg, key)
		case "oamIpv6Address":
			err = unpopulate(val, "OamIPv6Address", &b.OamIPv6Address)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &b.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "rackId":
			err = unpopulate(val, "RackID", &b.RackID)
			delete(rawMsg, key)
		case "rackSlot":
			err = unpopulate(val, "RackSlot", &b.RackSlot)
			delete(rawMsg, key)
		case "readyState":
			err = unpopulate(val, "ReadyState", &b.ReadyState)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &b.SerialNumber)
			delete(rawMsg, key)
		case "serviceTag":
			err = unpopulate(val, "ServiceTag", &b.ServiceTag)
			delete(rawMsg, key)
		case "virtualMachinesAssociatedIds":
			err = unpopulate(val, "VirtualMachinesAssociatedIDs", &b.VirtualMachinesAssociatedIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineReplaceParameters.
func (b BareMetalMachineReplaceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bmcCredentials", b.BmcCredentials)
	populate(objectMap, "bmcMacAddress", b.BmcMacAddress)
	populate(objectMap, "bootMacAddress", b.BootMacAddress)
	populate(objectMap, "machineName", b.MachineName)
	populate(objectMap, "serialNumber", b.SerialNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineReplaceParameters.
func (b *BareMetalMachineReplaceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bmcCredentials":
			err = unpopulate(val, "BmcCredentials", &b.BmcCredentials)
			delete(rawMsg, key)
		case "bmcMacAddress":
			err = unpopulate(val, "BmcMacAddress", &b.BmcMacAddress)
			delete(rawMsg, key)
		case "bootMacAddress":
			err = unpopulate(val, "BootMacAddress", &b.BootMacAddress)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &b.MachineName)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &b.SerialNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineRunCommandParameters.
func (b BareMetalMachineRunCommandParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", b.Arguments)
	populate(objectMap, "limitTimeSeconds", b.LimitTimeSeconds)
	populate(objectMap, "script", b.Script)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineRunCommandParameters.
func (b *BareMetalMachineRunCommandParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &b.Arguments)
			delete(rawMsg, key)
		case "limitTimeSeconds":
			err = unpopulate(val, "LimitTimeSeconds", &b.LimitTimeSeconds)
			delete(rawMsg, key)
		case "script":
			err = unpopulate(val, "Script", &b.Script)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineRunDataExtractsParameters.
func (b BareMetalMachineRunDataExtractsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commands", b.Commands)
	populate(objectMap, "limitTimeSeconds", b.LimitTimeSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineRunDataExtractsParameters.
func (b *BareMetalMachineRunDataExtractsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commands":
			err = unpopulate(val, "Commands", &b.Commands)
			delete(rawMsg, key)
		case "limitTimeSeconds":
			err = unpopulate(val, "LimitTimeSeconds", &b.LimitTimeSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BareMetalMachineRunReadCommandsParameters.
func (b BareMetalMachineRunReadCommandsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commands", b.Commands)
	populate(objectMap, "limitTimeSeconds", b.LimitTimeSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BareMetalMachineRunReadCommandsParameters.
func (b *BareMetalMachineRunReadCommandsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commands":
			err = unpopulate(val, "Commands", &b.Commands)
			delete(rawMsg, key)
		case "limitTimeSeconds":
			err = unpopulate(val, "LimitTimeSeconds", &b.LimitTimeSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpAdvertisement.
func (b BgpAdvertisement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "advertiseToFabric", b.AdvertiseToFabric)
	populate(objectMap, "communities", b.Communities)
	populate(objectMap, "ipAddressPools", b.IPAddressPools)
	populate(objectMap, "peers", b.Peers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpAdvertisement.
func (b *BgpAdvertisement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advertiseToFabric":
			err = unpopulate(val, "AdvertiseToFabric", &b.AdvertiseToFabric)
			delete(rawMsg, key)
		case "communities":
			err = unpopulate(val, "Communities", &b.Communities)
			delete(rawMsg, key)
		case "ipAddressPools":
			err = unpopulate(val, "IPAddressPools", &b.IPAddressPools)
			delete(rawMsg, key)
		case "peers":
			err = unpopulate(val, "Peers", &b.Peers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpServiceLoadBalancerConfiguration.
func (b BgpServiceLoadBalancerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bgpAdvertisements", b.BgpAdvertisements)
	populate(objectMap, "bgpPeers", b.BgpPeers)
	populate(objectMap, "fabricPeeringEnabled", b.FabricPeeringEnabled)
	populate(objectMap, "ipAddressPools", b.IPAddressPools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpServiceLoadBalancerConfiguration.
func (b *BgpServiceLoadBalancerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bgpAdvertisements":
			err = unpopulate(val, "BgpAdvertisements", &b.BgpAdvertisements)
			delete(rawMsg, key)
		case "bgpPeers":
			err = unpopulate(val, "BgpPeers", &b.BgpPeers)
			delete(rawMsg, key)
		case "fabricPeeringEnabled":
			err = unpopulate(val, "FabricPeeringEnabled", &b.FabricPeeringEnabled)
			delete(rawMsg, key)
		case "ipAddressPools":
			err = unpopulate(val, "IPAddressPools", &b.IPAddressPools)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BmcKeySet.
func (b BmcKeySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", b.ExtendedLocation)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BmcKeySet.
func (b *BmcKeySet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &b.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BmcKeySetList.
func (b BmcKeySetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BmcKeySetList.
func (b *BmcKeySetList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BmcKeySetPatchParameters.
func (b BmcKeySetPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BmcKeySetPatchParameters.
func (b *BmcKeySetPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BmcKeySetPatchProperties.
func (b BmcKeySetPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expiration", b.Expiration)
	populate(objectMap, "userList", b.UserList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BmcKeySetPatchProperties.
func (b *BmcKeySetPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiration":
			err = unpopulateDateTimeRFC3339(val, "Expiration", &b.Expiration)
			delete(rawMsg, key)
		case "userList":
			err = unpopulate(val, "UserList", &b.UserList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BmcKeySetProperties.
func (b BmcKeySetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureGroupId", b.AzureGroupID)
	populate(objectMap, "detailedStatus", b.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", b.DetailedStatusMessage)
	populateDateTimeRFC3339(objectMap, "expiration", b.Expiration)
	populateDateTimeRFC3339(objectMap, "lastValidation", b.LastValidation)
	populate(objectMap, "privilegeLevel", b.PrivilegeLevel)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "userList", b.UserList)
	populate(objectMap, "userListStatus", b.UserListStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BmcKeySetProperties.
func (b *BmcKeySetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureGroupId":
			err = unpopulate(val, "AzureGroupID", &b.AzureGroupID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &b.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &b.DetailedStatusMessage)
			delete(rawMsg, key)
		case "expiration":
			err = unpopulateDateTimeRFC3339(val, "Expiration", &b.Expiration)
			delete(rawMsg, key)
		case "lastValidation":
			err = unpopulateDateTimeRFC3339(val, "LastValidation", &b.LastValidation)
			delete(rawMsg, key)
		case "privilegeLevel":
			err = unpopulate(val, "PrivilegeLevel", &b.PrivilegeLevel)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "userList":
			err = unpopulate(val, "UserList", &b.UserList)
			delete(rawMsg, key)
		case "userListStatus":
			err = unpopulate(val, "UserListStatus", &b.UserListStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServicesNetwork.
func (c CloudServicesNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServicesNetwork.
func (c *CloudServicesNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServicesNetworkList.
func (c CloudServicesNetworkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServicesNetworkList.
func (c *CloudServicesNetworkList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServicesNetworkPatchParameters.
func (c CloudServicesNetworkPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServicesNetworkPatchParameters.
func (c *CloudServicesNetworkPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServicesNetworkPatchProperties.
func (c CloudServicesNetworkPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalEgressEndpoints", c.AdditionalEgressEndpoints)
	populate(objectMap, "enableDefaultEgressEndpoints", c.EnableDefaultEgressEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServicesNetworkPatchProperties.
func (c *CloudServicesNetworkPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalEgressEndpoints":
			err = unpopulate(val, "AdditionalEgressEndpoints", &c.AdditionalEgressEndpoints)
			delete(rawMsg, key)
		case "enableDefaultEgressEndpoints":
			err = unpopulate(val, "EnableDefaultEgressEndpoints", &c.EnableDefaultEgressEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudServicesNetworkProperties.
func (c CloudServicesNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalEgressEndpoints", c.AdditionalEgressEndpoints)
	populate(objectMap, "associatedResourceIds", c.AssociatedResourceIDs)
	populate(objectMap, "clusterId", c.ClusterID)
	populate(objectMap, "detailedStatus", c.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", c.DetailedStatusMessage)
	populate(objectMap, "enableDefaultEgressEndpoints", c.EnableDefaultEgressEndpoints)
	populate(objectMap, "enabledEgressEndpoints", c.EnabledEgressEndpoints)
	populate(objectMap, "hybridAksClustersAssociatedIds", c.HybridAksClustersAssociatedIDs)
	populate(objectMap, "interfaceName", c.InterfaceName)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "virtualMachinesAssociatedIds", c.VirtualMachinesAssociatedIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudServicesNetworkProperties.
func (c *CloudServicesNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalEgressEndpoints":
			err = unpopulate(val, "AdditionalEgressEndpoints", &c.AdditionalEgressEndpoints)
			delete(rawMsg, key)
		case "associatedResourceIds":
			err = unpopulate(val, "AssociatedResourceIDs", &c.AssociatedResourceIDs)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &c.ClusterID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &c.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &c.DetailedStatusMessage)
			delete(rawMsg, key)
		case "enableDefaultEgressEndpoints":
			err = unpopulate(val, "EnableDefaultEgressEndpoints", &c.EnableDefaultEgressEndpoints)
			delete(rawMsg, key)
		case "enabledEgressEndpoints":
			err = unpopulate(val, "EnabledEgressEndpoints", &c.EnabledEgressEndpoints)
			delete(rawMsg, key)
		case "hybridAksClustersAssociatedIds":
			err = unpopulate(val, "HybridAksClustersAssociatedIDs", &c.HybridAksClustersAssociatedIDs)
			delete(rawMsg, key)
		case "interfaceName":
			err = unpopulate(val, "InterfaceName", &c.InterfaceName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "virtualMachinesAssociatedIds":
			err = unpopulate(val, "VirtualMachinesAssociatedIDs", &c.VirtualMachinesAssociatedIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Cluster.
func (c *Cluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterAvailableUpgradeVersion.
func (c ClusterAvailableUpgradeVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "controlImpact", c.ControlImpact)
	populate(objectMap, "expectedDuration", c.ExpectedDuration)
	populate(objectMap, "impactDescription", c.ImpactDescription)
	populate(objectMap, "supportExpiryDate", c.SupportExpiryDate)
	populate(objectMap, "targetClusterVersion", c.TargetClusterVersion)
	populate(objectMap, "workloadImpact", c.WorkloadImpact)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterAvailableUpgradeVersion.
func (c *ClusterAvailableUpgradeVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controlImpact":
			err = unpopulate(val, "ControlImpact", &c.ControlImpact)
			delete(rawMsg, key)
		case "expectedDuration":
			err = unpopulate(val, "ExpectedDuration", &c.ExpectedDuration)
			delete(rawMsg, key)
		case "impactDescription":
			err = unpopulate(val, "ImpactDescription", &c.ImpactDescription)
			delete(rawMsg, key)
		case "supportExpiryDate":
			err = unpopulate(val, "SupportExpiryDate", &c.SupportExpiryDate)
			delete(rawMsg, key)
		case "targetClusterVersion":
			err = unpopulate(val, "TargetClusterVersion", &c.TargetClusterVersion)
			delete(rawMsg, key)
		case "workloadImpact":
			err = unpopulate(val, "WorkloadImpact", &c.WorkloadImpact)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterAvailableVersion.
func (c ClusterAvailableVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportExpiryDate", c.SupportExpiryDate)
	populate(objectMap, "targetClusterVersion", c.TargetClusterVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterAvailableVersion.
func (c *ClusterAvailableVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportExpiryDate":
			err = unpopulate(val, "SupportExpiryDate", &c.SupportExpiryDate)
			delete(rawMsg, key)
		case "targetClusterVersion":
			err = unpopulate(val, "TargetClusterVersion", &c.TargetClusterVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterCapacity.
func (c ClusterCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableApplianceStorageGB", c.AvailableApplianceStorageGB)
	populate(objectMap, "availableCoreCount", c.AvailableCoreCount)
	populate(objectMap, "availableHostStorageGB", c.AvailableHostStorageGB)
	populate(objectMap, "availableMemoryGB", c.AvailableMemoryGB)
	populate(objectMap, "totalApplianceStorageGB", c.TotalApplianceStorageGB)
	populate(objectMap, "totalCoreCount", c.TotalCoreCount)
	populate(objectMap, "totalHostStorageGB", c.TotalHostStorageGB)
	populate(objectMap, "totalMemoryGB", c.TotalMemoryGB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterCapacity.
func (c *ClusterCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableApplianceStorageGB":
			err = unpopulate(val, "AvailableApplianceStorageGB", &c.AvailableApplianceStorageGB)
			delete(rawMsg, key)
		case "availableCoreCount":
			err = unpopulate(val, "AvailableCoreCount", &c.AvailableCoreCount)
			delete(rawMsg, key)
		case "availableHostStorageGB":
			err = unpopulate(val, "AvailableHostStorageGB", &c.AvailableHostStorageGB)
			delete(rawMsg, key)
		case "availableMemoryGB":
			err = unpopulate(val, "AvailableMemoryGB", &c.AvailableMemoryGB)
			delete(rawMsg, key)
		case "totalApplianceStorageGB":
			err = unpopulate(val, "TotalApplianceStorageGB", &c.TotalApplianceStorageGB)
			delete(rawMsg, key)
		case "totalCoreCount":
			err = unpopulate(val, "TotalCoreCount", &c.TotalCoreCount)
			delete(rawMsg, key)
		case "totalHostStorageGB":
			err = unpopulate(val, "TotalHostStorageGB", &c.TotalHostStorageGB)
			delete(rawMsg, key)
		case "totalMemoryGB":
			err = unpopulate(val, "TotalMemoryGB", &c.TotalMemoryGB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterDeployParameters.
func (c ClusterDeployParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipValidationsForMachines", c.SkipValidationsForMachines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterDeployParameters.
func (c *ClusterDeployParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipValidationsForMachines":
			err = unpopulate(val, "SkipValidationsForMachines", &c.SkipValidationsForMachines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterList.
func (c ClusterList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterList.
func (c *ClusterList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterManager.
func (c ClusterManager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterManager.
func (c *ClusterManager) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterManagerList.
func (c ClusterManagerList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterManagerList.
func (c *ClusterManagerList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterManagerPatchParameters.
func (c ClusterManagerPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterManagerPatchParameters.
func (c *ClusterManagerPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterManagerProperties.
func (c ClusterManagerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "analyticsWorkspaceId", c.AnalyticsWorkspaceID)
	populate(objectMap, "availabilityZones", c.AvailabilityZones)
	populate(objectMap, "clusterVersions", c.ClusterVersions)
	populate(objectMap, "detailedStatus", c.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", c.DetailedStatusMessage)
	populate(objectMap, "fabricControllerId", c.FabricControllerID)
	populate(objectMap, "managedResourceGroupConfiguration", c.ManagedResourceGroupConfiguration)
	populate(objectMap, "managerExtendedLocation", c.ManagerExtendedLocation)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "vmSize", c.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterManagerProperties.
func (c *ClusterManagerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analyticsWorkspaceId":
			err = unpopulate(val, "AnalyticsWorkspaceID", &c.AnalyticsWorkspaceID)
			delete(rawMsg, key)
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &c.AvailabilityZones)
			delete(rawMsg, key)
		case "clusterVersions":
			err = unpopulate(val, "ClusterVersions", &c.ClusterVersions)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &c.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &c.DetailedStatusMessage)
			delete(rawMsg, key)
		case "fabricControllerId":
			err = unpopulate(val, "FabricControllerID", &c.FabricControllerID)
			delete(rawMsg, key)
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &c.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "managerExtendedLocation":
			err = unpopulate(val, "ManagerExtendedLocation", &c.ManagerExtendedLocation)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &c.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterMetricsConfiguration.
func (c ClusterMetricsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterMetricsConfiguration.
func (c *ClusterMetricsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterMetricsConfigurationList.
func (c ClusterMetricsConfigurationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterMetricsConfigurationList.
func (c *ClusterMetricsConfigurationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterMetricsConfigurationPatchParameters.
func (c ClusterMetricsConfigurationPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterMetricsConfigurationPatchParameters.
func (c *ClusterMetricsConfigurationPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterMetricsConfigurationPatchProperties.
func (c ClusterMetricsConfigurationPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "collectionInterval", c.CollectionInterval)
	populate(objectMap, "enabledMetrics", c.EnabledMetrics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterMetricsConfigurationPatchProperties.
func (c *ClusterMetricsConfigurationPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collectionInterval":
			err = unpopulate(val, "CollectionInterval", &c.CollectionInterval)
			delete(rawMsg, key)
		case "enabledMetrics":
			err = unpopulate(val, "EnabledMetrics", &c.EnabledMetrics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterMetricsConfigurationProperties.
func (c ClusterMetricsConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "collectionInterval", c.CollectionInterval)
	populate(objectMap, "detailedStatus", c.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", c.DetailedStatusMessage)
	populate(objectMap, "disabledMetrics", c.DisabledMetrics)
	populate(objectMap, "enabledMetrics", c.EnabledMetrics)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterMetricsConfigurationProperties.
func (c *ClusterMetricsConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collectionInterval":
			err = unpopulate(val, "CollectionInterval", &c.CollectionInterval)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &c.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &c.DetailedStatusMessage)
			delete(rawMsg, key)
		case "disabledMetrics":
			err = unpopulate(val, "DisabledMetrics", &c.DisabledMetrics)
			delete(rawMsg, key)
		case "enabledMetrics":
			err = unpopulate(val, "EnabledMetrics", &c.EnabledMetrics)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPatchParameters.
func (c ClusterPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPatchParameters.
func (c *ClusterPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPatchProperties.
func (c ClusterPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregatorOrSingleRackDefinition", c.AggregatorOrSingleRackDefinition)
	populate(objectMap, "clusterLocation", c.ClusterLocation)
	populate(objectMap, "clusterServicePrincipal", c.ClusterServicePrincipal)
	populate(objectMap, "computeDeploymentThreshold", c.ComputeDeploymentThreshold)
	populate(objectMap, "computeRackDefinitions", c.ComputeRackDefinitions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPatchProperties.
func (c *ClusterPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregatorOrSingleRackDefinition":
			err = unpopulate(val, "AggregatorOrSingleRackDefinition", &c.AggregatorOrSingleRackDefinition)
			delete(rawMsg, key)
		case "clusterLocation":
			err = unpopulate(val, "ClusterLocation", &c.ClusterLocation)
			delete(rawMsg, key)
		case "clusterServicePrincipal":
			err = unpopulate(val, "ClusterServicePrincipal", &c.ClusterServicePrincipal)
			delete(rawMsg, key)
		case "computeDeploymentThreshold":
			err = unpopulate(val, "ComputeDeploymentThreshold", &c.ComputeDeploymentThreshold)
			delete(rawMsg, key)
		case "computeRackDefinitions":
			err = unpopulate(val, "ComputeRackDefinitions", &c.ComputeRackDefinitions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterProperties.
func (c ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregatorOrSingleRackDefinition", c.AggregatorOrSingleRackDefinition)
	populate(objectMap, "analyticsWorkspaceId", c.AnalyticsWorkspaceID)
	populate(objectMap, "availableUpgradeVersions", c.AvailableUpgradeVersions)
	populate(objectMap, "clusterCapacity", c.ClusterCapacity)
	populate(objectMap, "clusterConnectionStatus", c.ClusterConnectionStatus)
	populate(objectMap, "clusterExtendedLocation", c.ClusterExtendedLocation)
	populate(objectMap, "clusterLocation", c.ClusterLocation)
	populate(objectMap, "clusterManagerConnectionStatus", c.ClusterManagerConnectionStatus)
	populate(objectMap, "clusterManagerId", c.ClusterManagerID)
	populate(objectMap, "clusterServicePrincipal", c.ClusterServicePrincipal)
	populate(objectMap, "clusterType", c.ClusterType)
	populate(objectMap, "clusterVersion", c.ClusterVersion)
	populate(objectMap, "computeDeploymentThreshold", c.ComputeDeploymentThreshold)
	populate(objectMap, "computeRackDefinitions", c.ComputeRackDefinitions)
	populate(objectMap, "detailedStatus", c.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", c.DetailedStatusMessage)
	populate(objectMap, "hybridAksExtendedLocation", c.HybridAksExtendedLocation)
	populate(objectMap, "managedResourceGroupConfiguration", c.ManagedResourceGroupConfiguration)
	populate(objectMap, "manualActionCount", c.ManualActionCount)
	populate(objectMap, "networkFabricId", c.NetworkFabricID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "supportExpiryDate", c.SupportExpiryDate)
	populate(objectMap, "workloadResourceIds", c.WorkloadResourceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterProperties.
func (c *ClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregatorOrSingleRackDefinition":
			err = unpopulate(val, "AggregatorOrSingleRackDefinition", &c.AggregatorOrSingleRackDefinition)
			delete(rawMsg, key)
		case "analyticsWorkspaceId":
			err = unpopulate(val, "AnalyticsWorkspaceID", &c.AnalyticsWorkspaceID)
			delete(rawMsg, key)
		case "availableUpgradeVersions":
			err = unpopulate(val, "AvailableUpgradeVersions", &c.AvailableUpgradeVersions)
			delete(rawMsg, key)
		case "clusterCapacity":
			err = unpopulate(val, "ClusterCapacity", &c.ClusterCapacity)
			delete(rawMsg, key)
		case "clusterConnectionStatus":
			err = unpopulate(val, "ClusterConnectionStatus", &c.ClusterConnectionStatus)
			delete(rawMsg, key)
		case "clusterExtendedLocation":
			err = unpopulate(val, "ClusterExtendedLocation", &c.ClusterExtendedLocation)
			delete(rawMsg, key)
		case "clusterLocation":
			err = unpopulate(val, "ClusterLocation", &c.ClusterLocation)
			delete(rawMsg, key)
		case "clusterManagerConnectionStatus":
			err = unpopulate(val, "ClusterManagerConnectionStatus", &c.ClusterManagerConnectionStatus)
			delete(rawMsg, key)
		case "clusterManagerId":
			err = unpopulate(val, "ClusterManagerID", &c.ClusterManagerID)
			delete(rawMsg, key)
		case "clusterServicePrincipal":
			err = unpopulate(val, "ClusterServicePrincipal", &c.ClusterServicePrincipal)
			delete(rawMsg, key)
		case "clusterType":
			err = unpopulate(val, "ClusterType", &c.ClusterType)
			delete(rawMsg, key)
		case "clusterVersion":
			err = unpopulate(val, "ClusterVersion", &c.ClusterVersion)
			delete(rawMsg, key)
		case "computeDeploymentThreshold":
			err = unpopulate(val, "ComputeDeploymentThreshold", &c.ComputeDeploymentThreshold)
			delete(rawMsg, key)
		case "computeRackDefinitions":
			err = unpopulate(val, "ComputeRackDefinitions", &c.ComputeRackDefinitions)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &c.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &c.DetailedStatusMessage)
			delete(rawMsg, key)
		case "hybridAksExtendedLocation":
			err = unpopulate(val, "HybridAksExtendedLocation", &c.HybridAksExtendedLocation)
			delete(rawMsg, key)
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &c.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "manualActionCount":
			err = unpopulate(val, "ManualActionCount", &c.ManualActionCount)
			delete(rawMsg, key)
		case "networkFabricId":
			err = unpopulate(val, "NetworkFabricID", &c.NetworkFabricID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "supportExpiryDate":
			err = unpopulate(val, "SupportExpiryDate", &c.SupportExpiryDate)
			delete(rawMsg, key)
		case "workloadResourceIds":
			err = unpopulate(val, "WorkloadResourceIDs", &c.WorkloadResourceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpdateVersionParameters.
func (c ClusterUpdateVersionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetClusterVersion", c.TargetClusterVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterUpdateVersionParameters.
func (c *ClusterUpdateVersionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetClusterVersion":
			err = unpopulate(val, "TargetClusterVersion", &c.TargetClusterVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Console.
func (c Console) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Console.
func (c *Console) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConsoleList.
func (c ConsoleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConsoleList.
func (c *ConsoleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConsolePatchParameters.
func (c ConsolePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConsolePatchParameters.
func (c *ConsolePatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConsolePatchProperties.
func (c ConsolePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", c.Enabled)
	populateDateTimeRFC3339(objectMap, "expiration", c.Expiration)
	populate(objectMap, "sshPublicKey", c.SSHPublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConsolePatchProperties.
func (c *ConsolePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "expiration":
			err = unpopulateDateTimeRFC3339(val, "Expiration", &c.Expiration)
			delete(rawMsg, key)
		case "sshPublicKey":
			err = unpopulate(val, "SSHPublicKey", &c.SSHPublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConsoleProperties.
func (c ConsoleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detailedStatus", c.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", c.DetailedStatusMessage)
	populate(objectMap, "enabled", c.Enabled)
	populateDateTimeRFC3339(objectMap, "expiration", c.Expiration)
	populate(objectMap, "privateLinkServiceId", c.PrivateLinkServiceID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "sshPublicKey", c.SSHPublicKey)
	populate(objectMap, "virtualMachineAccessId", c.VirtualMachineAccessID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConsoleProperties.
func (c *ConsoleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &c.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &c.DetailedStatusMessage)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "expiration":
			err = unpopulateDateTimeRFC3339(val, "Expiration", &c.Expiration)
			delete(rawMsg, key)
		case "privateLinkServiceId":
			err = unpopulate(val, "PrivateLinkServiceID", &c.PrivateLinkServiceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "sshPublicKey":
			err = unpopulate(val, "SSHPublicKey", &c.SSHPublicKey)
			delete(rawMsg, key)
		case "virtualMachineAccessId":
			err = unpopulate(val, "VirtualMachineAccessID", &c.VirtualMachineAccessID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControlPlaneNodeConfiguration.
func (c ControlPlaneNodeConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorConfiguration", c.AdministratorConfiguration)
	populate(objectMap, "availabilityZones", c.AvailabilityZones)
	populate(objectMap, "count", c.Count)
	populate(objectMap, "vmSkuName", c.VMSKUName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControlPlaneNodeConfiguration.
func (c *ControlPlaneNodeConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorConfiguration":
			err = unpopulate(val, "AdministratorConfiguration", &c.AdministratorConfiguration)
			delete(rawMsg, key)
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &c.AvailabilityZones)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		case "vmSkuName":
			err = unpopulate(val, "VMSKUName", &c.VMSKUName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControlPlaneNodePatchConfiguration.
func (c ControlPlaneNodePatchConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", c.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControlPlaneNodePatchConfiguration.
func (c *ControlPlaneNodePatchConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EgressEndpoint.
func (e EgressEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", e.Category)
	populate(objectMap, "endpoints", e.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EgressEndpoint.
func (e *EgressEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &e.Category)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &e.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDependency.
func (e EndpointDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainName", e.DomainName)
	populate(objectMap, "port", e.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointDependency.
func (e *EndpointDependency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &e.DomainName)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &e.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeatureStatus.
func (f FeatureStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detailedStatus", f.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", f.DetailedStatusMessage)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "version", f.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureStatus.
func (f *FeatureStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &f.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &f.DetailedStatusMessage)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &f.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareInventory.
func (h HardwareInventory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalHostInformation", h.AdditionalHostInformation)
	populate(objectMap, "interfaces", h.Interfaces)
	populate(objectMap, "nics", h.Nics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareInventory.
func (h *HardwareInventory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalHostInformation":
			err = unpopulate(val, "AdditionalHostInformation", &h.AdditionalHostInformation)
			delete(rawMsg, key)
		case "interfaces":
			err = unpopulate(val, "Interfaces", &h.Interfaces)
			delete(rawMsg, key)
		case "nics":
			err = unpopulate(val, "Nics", &h.Nics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareInventoryNetworkInterface.
func (h HardwareInventoryNetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkStatus", h.LinkStatus)
	populate(objectMap, "macAddress", h.MacAddress)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "networkInterfaceId", h.NetworkInterfaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareInventoryNetworkInterface.
func (h *HardwareInventoryNetworkInterface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkStatus":
			err = unpopulate(val, "LinkStatus", &h.LinkStatus)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &h.MacAddress)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "networkInterfaceId":
			err = unpopulate(val, "NetworkInterfaceID", &h.NetworkInterfaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareValidationStatus.
func (h HardwareValidationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "lastValidationTime", h.LastValidationTime)
	populate(objectMap, "result", h.Result)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareValidationStatus.
func (h *HardwareValidationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastValidationTime":
			err = unpopulateDateTimeRFC3339(val, "LastValidationTime", &h.LastValidationTime)
			delete(rawMsg, key)
		case "result":
			err = unpopulate(val, "Result", &h.Result)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddressPool.
func (i IPAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addresses", i.Addresses)
	populate(objectMap, "autoAssign", i.AutoAssign)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "onlyUseHostIps", i.OnlyUseHostIPs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddressPool.
func (i *IPAddressPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addresses":
			err = unpopulate(val, "Addresses", &i.Addresses)
			delete(rawMsg, key)
		case "autoAssign":
			err = unpopulate(val, "AutoAssign", &i.AutoAssign)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "onlyUseHostIps":
			err = unpopulate(val, "OnlyUseHostIPs", &i.OnlyUseHostIPs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageRepositoryCredentials.
func (i ImageRepositoryCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", i.Password)
	populate(objectMap, "registryUrl", i.RegistryURL)
	populate(objectMap, "username", i.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageRepositoryCredentials.
func (i *ImageRepositoryCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &i.Password)
			delete(rawMsg, key)
		case "registryUrl":
			err = unpopulate(val, "RegistryURL", &i.RegistryURL)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &i.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InitialAgentPoolConfiguration.
func (i InitialAgentPoolConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorConfiguration", i.AdministratorConfiguration)
	populate(objectMap, "agentOptions", i.AgentOptions)
	populate(objectMap, "attachedNetworkConfiguration", i.AttachedNetworkConfiguration)
	populate(objectMap, "availabilityZones", i.AvailabilityZones)
	populate(objectMap, "count", i.Count)
	populate(objectMap, "labels", i.Labels)
	populate(objectMap, "mode", i.Mode)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "taints", i.Taints)
	populate(objectMap, "upgradeSettings", i.UpgradeSettings)
	populate(objectMap, "vmSkuName", i.VMSKUName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InitialAgentPoolConfiguration.
func (i *InitialAgentPoolConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorConfiguration":
			err = unpopulate(val, "AdministratorConfiguration", &i.AdministratorConfiguration)
			delete(rawMsg, key)
		case "agentOptions":
			err = unpopulate(val, "AgentOptions", &i.AgentOptions)
			delete(rawMsg, key)
		case "attachedNetworkConfiguration":
			err = unpopulate(val, "AttachedNetworkConfiguration", &i.AttachedNetworkConfiguration)
			delete(rawMsg, key)
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &i.AvailabilityZones)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &i.Count)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &i.Labels)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &i.Mode)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "taints":
			err = unpopulate(val, "Taints", &i.Taints)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &i.UpgradeSettings)
			delete(rawMsg, key)
		case "vmSkuName":
			err = unpopulate(val, "VMSKUName", &i.VMSKUName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeySetUser.
func (k KeySetUser) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureUserName", k.AzureUserName)
	populate(objectMap, "description", k.Description)
	populate(objectMap, "sshPublicKey", k.SSHPublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeySetUser.
func (k *KeySetUser) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureUserName":
			err = unpopulate(val, "AzureUserName", &k.AzureUserName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &k.Description)
			delete(rawMsg, key)
		case "sshPublicKey":
			err = unpopulate(val, "SSHPublicKey", &k.SSHPublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeySetUserStatus.
func (k KeySetUserStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureUserName", k.AzureUserName)
	populate(objectMap, "status", k.Status)
	populate(objectMap, "statusMessage", k.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeySetUserStatus.
func (k *KeySetUserStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureUserName":
			err = unpopulate(val, "AzureUserName", &k.AzureUserName)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &k.Status)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &k.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesCluster.
func (k KubernetesCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", k.ExtendedLocation)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "location", k.Location)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "systemData", k.SystemData)
	populate(objectMap, "tags", k.Tags)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesCluster.
func (k *KubernetesCluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &k.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &k.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &k.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &k.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterList.
func (k KubernetesClusterList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", k.NextLink)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterList.
func (k *KubernetesClusterList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &k.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterNode.
func (k KubernetesClusterNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentPoolId", k.AgentPoolID)
	populate(objectMap, "availabilityZone", k.AvailabilityZone)
	populate(objectMap, "bareMetalMachineId", k.BareMetalMachineID)
	populate(objectMap, "cpuCores", k.CPUCores)
	populate(objectMap, "detailedStatus", k.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", k.DetailedStatusMessage)
	populate(objectMap, "diskSizeGB", k.DiskSizeGB)
	populate(objectMap, "image", k.Image)
	populate(objectMap, "kubernetesVersion", k.KubernetesVersion)
	populate(objectMap, "labels", k.Labels)
	populate(objectMap, "memorySizeGB", k.MemorySizeGB)
	populate(objectMap, "mode", k.Mode)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "networkAttachments", k.NetworkAttachments)
	populate(objectMap, "powerState", k.PowerState)
	populate(objectMap, "role", k.Role)
	populate(objectMap, "taints", k.Taints)
	populate(objectMap, "vmSkuName", k.VMSKUName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterNode.
func (k *KubernetesClusterNode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolId":
			err = unpopulate(val, "AgentPoolID", &k.AgentPoolID)
			delete(rawMsg, key)
		case "availabilityZone":
			err = unpopulate(val, "AvailabilityZone", &k.AvailabilityZone)
			delete(rawMsg, key)
		case "bareMetalMachineId":
			err = unpopulate(val, "BareMetalMachineID", &k.BareMetalMachineID)
			delete(rawMsg, key)
		case "cpuCores":
			err = unpopulate(val, "CPUCores", &k.CPUCores)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &k.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &k.DetailedStatusMessage)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &k.DiskSizeGB)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &k.Image)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &k.KubernetesVersion)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &k.Labels)
			delete(rawMsg, key)
		case "memorySizeGB":
			err = unpopulate(val, "MemorySizeGB", &k.MemorySizeGB)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &k.Mode)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "networkAttachments":
			err = unpopulate(val, "NetworkAttachments", &k.NetworkAttachments)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &k.PowerState)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &k.Role)
			delete(rawMsg, key)
		case "taints":
			err = unpopulate(val, "Taints", &k.Taints)
			delete(rawMsg, key)
		case "vmSkuName":
			err = unpopulate(val, "VMSKUName", &k.VMSKUName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterPatchParameters.
func (k KubernetesClusterPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "tags", k.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterPatchParameters.
func (k *KubernetesClusterPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &k.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterPatchProperties.
func (k KubernetesClusterPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "controlPlaneNodeConfiguration", k.ControlPlaneNodeConfiguration)
	populate(objectMap, "kubernetesVersion", k.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterPatchProperties.
func (k *KubernetesClusterPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controlPlaneNodeConfiguration":
			err = unpopulate(val, "ControlPlaneNodeConfiguration", &k.ControlPlaneNodeConfiguration)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &k.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterProperties.
func (k KubernetesClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadConfiguration", k.AADConfiguration)
	populate(objectMap, "administratorConfiguration", k.AdministratorConfiguration)
	populate(objectMap, "attachedNetworkIds", k.AttachedNetworkIDs)
	populate(objectMap, "availableUpgrades", k.AvailableUpgrades)
	populate(objectMap, "clusterId", k.ClusterID)
	populate(objectMap, "connectedClusterId", k.ConnectedClusterID)
	populate(objectMap, "controlPlaneKubernetesVersion", k.ControlPlaneKubernetesVersion)
	populate(objectMap, "controlPlaneNodeConfiguration", k.ControlPlaneNodeConfiguration)
	populate(objectMap, "detailedStatus", k.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", k.DetailedStatusMessage)
	populate(objectMap, "featureStatuses", k.FeatureStatuses)
	populate(objectMap, "initialAgentPoolConfigurations", k.InitialAgentPoolConfigurations)
	populate(objectMap, "kubernetesVersion", k.KubernetesVersion)
	populate(objectMap, "managedResourceGroupConfiguration", k.ManagedResourceGroupConfiguration)
	populate(objectMap, "networkConfiguration", k.NetworkConfiguration)
	populate(objectMap, "nodes", k.Nodes)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterProperties.
func (k *KubernetesClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadConfiguration":
			err = unpopulate(val, "AADConfiguration", &k.AADConfiguration)
			delete(rawMsg, key)
		case "administratorConfiguration":
			err = unpopulate(val, "AdministratorConfiguration", &k.AdministratorConfiguration)
			delete(rawMsg, key)
		case "attachedNetworkIds":
			err = unpopulate(val, "AttachedNetworkIDs", &k.AttachedNetworkIDs)
			delete(rawMsg, key)
		case "availableUpgrades":
			err = unpopulate(val, "AvailableUpgrades", &k.AvailableUpgrades)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &k.ClusterID)
			delete(rawMsg, key)
		case "connectedClusterId":
			err = unpopulate(val, "ConnectedClusterID", &k.ConnectedClusterID)
			delete(rawMsg, key)
		case "controlPlaneKubernetesVersion":
			err = unpopulate(val, "ControlPlaneKubernetesVersion", &k.ControlPlaneKubernetesVersion)
			delete(rawMsg, key)
		case "controlPlaneNodeConfiguration":
			err = unpopulate(val, "ControlPlaneNodeConfiguration", &k.ControlPlaneNodeConfiguration)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &k.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &k.DetailedStatusMessage)
			delete(rawMsg, key)
		case "featureStatuses":
			err = unpopulate(val, "FeatureStatuses", &k.FeatureStatuses)
			delete(rawMsg, key)
		case "initialAgentPoolConfigurations":
			err = unpopulate(val, "InitialAgentPoolConfigurations", &k.InitialAgentPoolConfigurations)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &k.KubernetesVersion)
			delete(rawMsg, key)
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &k.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "networkConfiguration":
			err = unpopulate(val, "NetworkConfiguration", &k.NetworkConfiguration)
			delete(rawMsg, key)
		case "nodes":
			err = unpopulate(val, "Nodes", &k.Nodes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesClusterRestartNodeParameters.
func (k KubernetesClusterRestartNodeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodeName", k.NodeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesClusterRestartNodeParameters.
func (k *KubernetesClusterRestartNodeParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodeName":
			err = unpopulate(val, "NodeName", &k.NodeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesLabel.
func (k KubernetesLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", k.Key)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesLabel.
func (k *KubernetesLabel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &k.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2Network.
func (l L2Network) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", l.ExtendedLocation)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2Network.
func (l *L2Network) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &l.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2NetworkAttachmentConfiguration.
func (l L2NetworkAttachmentConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkId", l.NetworkID)
	populate(objectMap, "pluginType", l.PluginType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2NetworkAttachmentConfiguration.
func (l *L2NetworkAttachmentConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkId":
			err = unpopulate(val, "NetworkID", &l.NetworkID)
			delete(rawMsg, key)
		case "pluginType":
			err = unpopulate(val, "PluginType", &l.PluginType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2NetworkList.
func (l L2NetworkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2NetworkList.
func (l *L2NetworkList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2NetworkPatchParameters.
func (l L2NetworkPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2NetworkPatchParameters.
func (l *L2NetworkPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L2NetworkProperties.
func (l L2NetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedResourceIds", l.AssociatedResourceIDs)
	populate(objectMap, "clusterId", l.ClusterID)
	populate(objectMap, "detailedStatus", l.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", l.DetailedStatusMessage)
	populate(objectMap, "hybridAksClustersAssociatedIds", l.HybridAksClustersAssociatedIDs)
	populate(objectMap, "hybridAksPluginType", l.HybridAksPluginType)
	populate(objectMap, "interfaceName", l.InterfaceName)
	populate(objectMap, "l2IsolationDomainId", l.L2IsolationDomainID)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "virtualMachinesAssociatedIds", l.VirtualMachinesAssociatedIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L2NetworkProperties.
func (l *L2NetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedResourceIds":
			err = unpopulate(val, "AssociatedResourceIDs", &l.AssociatedResourceIDs)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &l.ClusterID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &l.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &l.DetailedStatusMessage)
			delete(rawMsg, key)
		case "hybridAksClustersAssociatedIds":
			err = unpopulate(val, "HybridAksClustersAssociatedIDs", &l.HybridAksClustersAssociatedIDs)
			delete(rawMsg, key)
		case "hybridAksPluginType":
			err = unpopulate(val, "HybridAksPluginType", &l.HybridAksPluginType)
			delete(rawMsg, key)
		case "interfaceName":
			err = unpopulate(val, "InterfaceName", &l.InterfaceName)
			delete(rawMsg, key)
		case "l2IsolationDomainId":
			err = unpopulate(val, "L2IsolationDomainID", &l.L2IsolationDomainID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "virtualMachinesAssociatedIds":
			err = unpopulate(val, "VirtualMachinesAssociatedIDs", &l.VirtualMachinesAssociatedIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3Network.
func (l L3Network) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", l.ExtendedLocation)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3Network.
func (l *L3Network) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &l.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3NetworkAttachmentConfiguration.
func (l L3NetworkAttachmentConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipamEnabled", l.IpamEnabled)
	populate(objectMap, "networkId", l.NetworkID)
	populate(objectMap, "pluginType", l.PluginType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3NetworkAttachmentConfiguration.
func (l *L3NetworkAttachmentConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipamEnabled":
			err = unpopulate(val, "IpamEnabled", &l.IpamEnabled)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &l.NetworkID)
			delete(rawMsg, key)
		case "pluginType":
			err = unpopulate(val, "PluginType", &l.PluginType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3NetworkList.
func (l L3NetworkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3NetworkList.
func (l *L3NetworkList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3NetworkPatchParameters.
func (l L3NetworkPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3NetworkPatchParameters.
func (l *L3NetworkPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type L3NetworkProperties.
func (l L3NetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedResourceIds", l.AssociatedResourceIDs)
	populate(objectMap, "clusterId", l.ClusterID)
	populate(objectMap, "detailedStatus", l.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", l.DetailedStatusMessage)
	populate(objectMap, "hybridAksClustersAssociatedIds", l.HybridAksClustersAssociatedIDs)
	populate(objectMap, "hybridAksIpamEnabled", l.HybridAksIpamEnabled)
	populate(objectMap, "hybridAksPluginType", l.HybridAksPluginType)
	populate(objectMap, "ipAllocationType", l.IPAllocationType)
	populate(objectMap, "ipv4ConnectedPrefix", l.IPv4ConnectedPrefix)
	populate(objectMap, "ipv6ConnectedPrefix", l.IPv6ConnectedPrefix)
	populate(objectMap, "interfaceName", l.InterfaceName)
	populate(objectMap, "l3IsolationDomainId", l.L3IsolationDomainID)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "virtualMachinesAssociatedIds", l.VirtualMachinesAssociatedIDs)
	populate(objectMap, "vlan", l.Vlan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type L3NetworkProperties.
func (l *L3NetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedResourceIds":
			err = unpopulate(val, "AssociatedResourceIDs", &l.AssociatedResourceIDs)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &l.ClusterID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &l.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &l.DetailedStatusMessage)
			delete(rawMsg, key)
		case "hybridAksClustersAssociatedIds":
			err = unpopulate(val, "HybridAksClustersAssociatedIDs", &l.HybridAksClustersAssociatedIDs)
			delete(rawMsg, key)
		case "hybridAksIpamEnabled":
			err = unpopulate(val, "HybridAksIpamEnabled", &l.HybridAksIpamEnabled)
			delete(rawMsg, key)
		case "hybridAksPluginType":
			err = unpopulate(val, "HybridAksPluginType", &l.HybridAksPluginType)
			delete(rawMsg, key)
		case "ipAllocationType":
			err = unpopulate(val, "IPAllocationType", &l.IPAllocationType)
			delete(rawMsg, key)
		case "ipv4ConnectedPrefix":
			err = unpopulate(val, "IPv4ConnectedPrefix", &l.IPv4ConnectedPrefix)
			delete(rawMsg, key)
		case "ipv6ConnectedPrefix":
			err = unpopulate(val, "IPv6ConnectedPrefix", &l.IPv6ConnectedPrefix)
			delete(rawMsg, key)
		case "interfaceName":
			err = unpopulate(val, "InterfaceName", &l.InterfaceName)
			delete(rawMsg, key)
		case "l3IsolationDomainId":
			err = unpopulate(val, "L3IsolationDomainID", &l.L3IsolationDomainID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "virtualMachinesAssociatedIds":
			err = unpopulate(val, "VirtualMachinesAssociatedIDs", &l.VirtualMachinesAssociatedIDs)
			delete(rawMsg, key)
		case "vlan":
			err = unpopulate(val, "Vlan", &l.Vlan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LldpNeighbor.
func (l LldpNeighbor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "portDescription", l.PortDescription)
	populate(objectMap, "portName", l.PortName)
	populate(objectMap, "systemDescription", l.SystemDescription)
	populate(objectMap, "systemName", l.SystemName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LldpNeighbor.
func (l *LldpNeighbor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "portDescription":
			err = unpopulate(val, "PortDescription", &l.PortDescription)
			delete(rawMsg, key)
		case "portName":
			err = unpopulate(val, "PortName", &l.PortName)
			delete(rawMsg, key)
		case "systemDescription":
			err = unpopulate(val, "SystemDescription", &l.SystemDescription)
			delete(rawMsg, key)
		case "systemName":
			err = unpopulate(val, "SystemName", &l.SystemName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineDisk.
func (m MachineDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityGB", m.CapacityGB)
	populate(objectMap, "connection", m.Connection)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineDisk.
func (m *MachineDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityGB":
			err = unpopulate(val, "CapacityGB", &m.CapacityGB)
			delete(rawMsg, key)
		case "connection":
			err = unpopulate(val, "Connection", &m.Connection)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineSKUProperties.
func (m MachineSKUProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bootstrapProtocol", m.BootstrapProtocol)
	populate(objectMap, "cpuCores", m.CPUCores)
	populate(objectMap, "cpuSockets", m.CPUSockets)
	populate(objectMap, "disks", m.Disks)
	populate(objectMap, "generation", m.Generation)
	populate(objectMap, "hardwareVersion", m.HardwareVersion)
	populate(objectMap, "memoryCapacityGB", m.MemoryCapacityGB)
	populate(objectMap, "model", m.Model)
	populate(objectMap, "networkInterfaces", m.NetworkInterfaces)
	populate(objectMap, "totalThreads", m.TotalThreads)
	populate(objectMap, "vendor", m.Vendor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineSKUProperties.
func (m *MachineSKUProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bootstrapProtocol":
			err = unpopulate(val, "BootstrapProtocol", &m.BootstrapProtocol)
			delete(rawMsg, key)
		case "cpuCores":
			err = unpopulate(val, "CPUCores", &m.CPUCores)
			delete(rawMsg, key)
		case "cpuSockets":
			err = unpopulate(val, "CPUSockets", &m.CPUSockets)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &m.Disks)
			delete(rawMsg, key)
		case "generation":
			err = unpopulate(val, "Generation", &m.Generation)
			delete(rawMsg, key)
		case "hardwareVersion":
			err = unpopulate(val, "HardwareVersion", &m.HardwareVersion)
			delete(rawMsg, key)
		case "memoryCapacityGB":
			err = unpopulate(val, "MemoryCapacityGB", &m.MemoryCapacityGB)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &m.Model)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &m.NetworkInterfaces)
			delete(rawMsg, key)
		case "totalThreads":
			err = unpopulate(val, "TotalThreads", &m.TotalThreads)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &m.Vendor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineSKUSlot.
func (m MachineSKUSlot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "rackSlot", m.RackSlot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineSKUSlot.
func (m *MachineSKUSlot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "rackSlot":
			err = unpopulate(val, "RackSlot", &m.RackSlot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedResourceGroupConfiguration.
func (m ManagedResourceGroupConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedResourceGroupConfiguration.
func (m *ManagedResourceGroupConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkAttachment.
func (n NetworkAttachment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedNetworkId", n.AttachedNetworkID)
	populate(objectMap, "defaultGateway", n.DefaultGateway)
	populate(objectMap, "ipAllocationMethod", n.IPAllocationMethod)
	populate(objectMap, "ipv4Address", n.IPv4Address)
	populate(objectMap, "ipv6Address", n.IPv6Address)
	populate(objectMap, "macAddress", n.MacAddress)
	populate(objectMap, "networkAttachmentName", n.NetworkAttachmentName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkAttachment.
func (n *NetworkAttachment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedNetworkId":
			err = unpopulate(val, "AttachedNetworkID", &n.AttachedNetworkID)
			delete(rawMsg, key)
		case "defaultGateway":
			err = unpopulate(val, "DefaultGateway", &n.DefaultGateway)
			delete(rawMsg, key)
		case "ipAllocationMethod":
			err = unpopulate(val, "IPAllocationMethod", &n.IPAllocationMethod)
			delete(rawMsg, key)
		case "ipv4Address":
			err = unpopulate(val, "IPv4Address", &n.IPv4Address)
			delete(rawMsg, key)
		case "ipv6Address":
			err = unpopulate(val, "IPv6Address", &n.IPv6Address)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &n.MacAddress)
			delete(rawMsg, key)
		case "networkAttachmentName":
			err = unpopulate(val, "NetworkAttachmentName", &n.NetworkAttachmentName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkConfiguration.
func (n NetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedNetworkConfiguration", n.AttachedNetworkConfiguration)
	populate(objectMap, "bgpServiceLoadBalancerConfiguration", n.BgpServiceLoadBalancerConfiguration)
	populate(objectMap, "cloudServicesNetworkId", n.CloudServicesNetworkID)
	populate(objectMap, "cniNetworkId", n.CniNetworkID)
	populate(objectMap, "dnsServiceIp", n.DNSServiceIP)
	populate(objectMap, "podCidrs", n.PodCidrs)
	populate(objectMap, "serviceCidrs", n.ServiceCidrs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkConfiguration.
func (n *NetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedNetworkConfiguration":
			err = unpopulate(val, "AttachedNetworkConfiguration", &n.AttachedNetworkConfiguration)
			delete(rawMsg, key)
		case "bgpServiceLoadBalancerConfiguration":
			err = unpopulate(val, "BgpServiceLoadBalancerConfiguration", &n.BgpServiceLoadBalancerConfiguration)
			delete(rawMsg, key)
		case "cloudServicesNetworkId":
			err = unpopulate(val, "CloudServicesNetworkID", &n.CloudServicesNetworkID)
			delete(rawMsg, key)
		case "cniNetworkId":
			err = unpopulate(val, "CniNetworkID", &n.CniNetworkID)
			delete(rawMsg, key)
		case "dnsServiceIp":
			err = unpopulate(val, "DNSServiceIP", &n.DNSServiceIP)
			delete(rawMsg, key)
		case "podCidrs":
			err = unpopulate(val, "PodCidrs", &n.PodCidrs)
			delete(rawMsg, key)
		case "serviceCidrs":
			err = unpopulate(val, "ServiceCidrs", &n.ServiceCidrs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterface.
func (n NetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", n.Address)
	populate(objectMap, "deviceConnectionType", n.DeviceConnectionType)
	populate(objectMap, "model", n.Model)
	populate(objectMap, "physicalSlot", n.PhysicalSlot)
	populate(objectMap, "portCount", n.PortCount)
	populate(objectMap, "portSpeed", n.PortSpeed)
	populate(objectMap, "vendor", n.Vendor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterface.
func (n *NetworkInterface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &n.Address)
			delete(rawMsg, key)
		case "deviceConnectionType":
			err = unpopulate(val, "DeviceConnectionType", &n.DeviceConnectionType)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &n.Model)
			delete(rawMsg, key)
		case "physicalSlot":
			err = unpopulate(val, "PhysicalSlot", &n.PhysicalSlot)
			delete(rawMsg, key)
		case "portCount":
			err = unpopulate(val, "PortCount", &n.PortCount)
			delete(rawMsg, key)
		case "portSpeed":
			err = unpopulate(val, "PortSpeed", &n.PortSpeed)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &n.Vendor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Nic.
func (n Nic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lldpNeighbor", n.LldpNeighbor)
	populate(objectMap, "macAddress", n.MacAddress)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Nic.
func (n *Nic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lldpNeighbor":
			err = unpopulate(val, "LldpNeighbor", &n.LldpNeighbor)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &n.MacAddress)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatusResult.
func (o OperationStatusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "operations", o.Operations)
	populate(objectMap, "percentComplete", o.PercentComplete)
	populate(objectMap, "resourceId", o.ResourceID)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusResult.
func (o *OperationStatusResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "operations":
			err = unpopulate(val, "Operations", &o.Operations)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &o.PercentComplete)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &o.ResourceID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsDisk.
func (o OsDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createOption", o.CreateOption)
	populate(objectMap, "deleteOption", o.DeleteOption)
	populate(objectMap, "diskSizeGB", o.DiskSizeGB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsDisk.
func (o *OsDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createOption":
			err = unpopulate(val, "CreateOption", &o.CreateOption)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &o.DeleteOption)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &o.DiskSizeGB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Rack.
func (r Rack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", r.ExtendedLocation)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Rack.
func (r *Rack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &r.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RackDefinition.
func (r RackDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZone", r.AvailabilityZone)
	populate(objectMap, "bareMetalMachineConfigurationData", r.BareMetalMachineConfigurationData)
	populate(objectMap, "networkRackId", r.NetworkRackID)
	populate(objectMap, "rackLocation", r.RackLocation)
	populate(objectMap, "rackSkuId", r.RackSKUID)
	populate(objectMap, "rackSerialNumber", r.RackSerialNumber)
	populate(objectMap, "storageApplianceConfigurationData", r.StorageApplianceConfigurationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RackDefinition.
func (r *RackDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZone":
			err = unpopulate(val, "AvailabilityZone", &r.AvailabilityZone)
			delete(rawMsg, key)
		case "bareMetalMachineConfigurationData":
			err = unpopulate(val, "BareMetalMachineConfigurationData", &r.BareMetalMachineConfigurationData)
			delete(rawMsg, key)
		case "networkRackId":
			err = unpopulate(val, "NetworkRackID", &r.NetworkRackID)
			delete(rawMsg, key)
		case "rackLocation":
			err = unpopulate(val, "RackLocation", &r.RackLocation)
			delete(rawMsg, key)
		case "rackSkuId":
			err = unpopulate(val, "RackSKUID", &r.RackSKUID)
			delete(rawMsg, key)
		case "rackSerialNumber":
			err = unpopulate(val, "RackSerialNumber", &r.RackSerialNumber)
			delete(rawMsg, key)
		case "storageApplianceConfigurationData":
			err = unpopulate(val, "StorageApplianceConfigurationData", &r.StorageApplianceConfigurationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RackList.
func (r RackList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RackList.
func (r *RackList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RackPatchParameters.
func (r RackPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RackPatchParameters.
func (r *RackPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RackProperties.
func (r RackProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZone", r.AvailabilityZone)
	populate(objectMap, "clusterId", r.ClusterID)
	populate(objectMap, "detailedStatus", r.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", r.DetailedStatusMessage)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "rackLocation", r.RackLocation)
	populate(objectMap, "rackSkuId", r.RackSKUID)
	populate(objectMap, "rackSerialNumber", r.RackSerialNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RackProperties.
func (r *RackProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZone":
			err = unpopulate(val, "AvailabilityZone", &r.AvailabilityZone)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &r.ClusterID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &r.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &r.DetailedStatusMessage)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "rackLocation":
			err = unpopulate(val, "RackLocation", &r.RackLocation)
			delete(rawMsg, key)
		case "rackSkuId":
			err = unpopulate(val, "RackSKUID", &r.RackSKUID)
			delete(rawMsg, key)
		case "rackSerialNumber":
			err = unpopulate(val, "RackSerialNumber", &r.RackSerialNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RackSKU.
func (r RackSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RackSKU.
func (r *RackSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RackSKUList.
func (r RackSKUList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RackSKUList.
func (r *RackSKUList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RackSKUProperties.
func (r RackSKUProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeMachines", r.ComputeMachines)
	populate(objectMap, "controllerMachines", r.ControllerMachines)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "maxClusterSlots", r.MaxClusterSlots)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "rackType", r.RackType)
	populate(objectMap, "storageAppliances", r.StorageAppliances)
	populate(objectMap, "supportedRackSkuIds", r.SupportedRackSKUIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RackSKUProperties.
func (r *RackSKUProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeMachines":
			err = unpopulate(val, "ComputeMachines", &r.ComputeMachines)
			delete(rawMsg, key)
		case "controllerMachines":
			err = unpopulate(val, "ControllerMachines", &r.ControllerMachines)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "maxClusterSlots":
			err = unpopulate(val, "MaxClusterSlots", &r.MaxClusterSlots)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "rackType":
			err = unpopulate(val, "RackType", &r.RackType)
			delete(rawMsg, key)
		case "storageAppliances":
			err = unpopulate(val, "StorageAppliances", &r.StorageAppliances)
			delete(rawMsg, key)
		case "supportedRackSkuIds":
			err = unpopulate(val, "SupportedRackSKUIDs", &r.SupportedRackSKUIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RacksPatchProperties.
func (r RacksPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rackLocation", r.RackLocation)
	populate(objectMap, "rackSerialNumber", r.RackSerialNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RacksPatchProperties.
func (r *RacksPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rackLocation":
			err = unpopulate(val, "RackLocation", &r.RackLocation)
			delete(rawMsg, key)
		case "rackSerialNumber":
			err = unpopulate(val, "RackSerialNumber", &r.RackSerialNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKey.
func (s SSHPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyData", s.KeyData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKey.
func (s *SSHPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyData":
			err = unpopulate(val, "KeyData", &s.KeyData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceLoadBalancerBgpPeer.
func (s ServiceLoadBalancerBgpPeer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bfdEnabled", s.BfdEnabled)
	populate(objectMap, "bgpMultiHop", s.BgpMultiHop)
	populate(objectMap, "holdTime", s.HoldTime)
	populate(objectMap, "keepAliveTime", s.KeepAliveTime)
	populate(objectMap, "myAsn", s.MyAsn)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "password", s.Password)
	populate(objectMap, "peerAddress", s.PeerAddress)
	populate(objectMap, "peerAsn", s.PeerAsn)
	populate(objectMap, "peerPort", s.PeerPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceLoadBalancerBgpPeer.
func (s *ServiceLoadBalancerBgpPeer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bfdEnabled":
			err = unpopulate(val, "BfdEnabled", &s.BfdEnabled)
			delete(rawMsg, key)
		case "bgpMultiHop":
			err = unpopulate(val, "BgpMultiHop", &s.BgpMultiHop)
			delete(rawMsg, key)
		case "holdTime":
			err = unpopulate(val, "HoldTime", &s.HoldTime)
			delete(rawMsg, key)
		case "keepAliveTime":
			err = unpopulate(val, "KeepAliveTime", &s.KeepAliveTime)
			delete(rawMsg, key)
		case "myAsn":
			err = unpopulate(val, "MyAsn", &s.MyAsn)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &s.Password)
			delete(rawMsg, key)
		case "peerAddress":
			err = unpopulate(val, "PeerAddress", &s.PeerAddress)
			delete(rawMsg, key)
		case "peerAsn":
			err = unpopulate(val, "PeerAsn", &s.PeerAsn)
			delete(rawMsg, key)
		case "peerPort":
			err = unpopulate(val, "PeerPort", &s.PeerPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePrincipalInformation.
func (s ServicePrincipalInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationId", s.ApplicationID)
	populate(objectMap, "password", s.Password)
	populate(objectMap, "principalId", s.PrincipalID)
	populate(objectMap, "tenantId", s.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePrincipalInformation.
func (s *ServicePrincipalInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &s.ApplicationID)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &s.Password)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &s.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &s.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAppliance.
func (s StorageAppliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", s.ExtendedLocation)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAppliance.
func (s *StorageAppliance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &s.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageApplianceConfigurationData.
func (s StorageApplianceConfigurationData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminCredentials", s.AdminCredentials)
	populate(objectMap, "rackSlot", s.RackSlot)
	populate(objectMap, "serialNumber", s.SerialNumber)
	populate(objectMap, "storageApplianceName", s.StorageApplianceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageApplianceConfigurationData.
func (s *StorageApplianceConfigurationData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminCredentials":
			err = unpopulate(val, "AdminCredentials", &s.AdminCredentials)
			delete(rawMsg, key)
		case "rackSlot":
			err = unpopulate(val, "RackSlot", &s.RackSlot)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &s.SerialNumber)
			delete(rawMsg, key)
		case "storageApplianceName":
			err = unpopulate(val, "StorageApplianceName", &s.StorageApplianceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageApplianceEnableRemoteVendorManagementParameters.
func (s StorageApplianceEnableRemoteVendorManagementParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportEndpoints", s.SupportEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageApplianceEnableRemoteVendorManagementParameters.
func (s *StorageApplianceEnableRemoteVendorManagementParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportEndpoints":
			err = unpopulate(val, "SupportEndpoints", &s.SupportEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageApplianceList.
func (s StorageApplianceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageApplianceList.
func (s *StorageApplianceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAppliancePatchParameters.
func (s StorageAppliancePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAppliancePatchParameters.
func (s *StorageAppliancePatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAppliancePatchProperties.
func (s StorageAppliancePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serialNumber", s.SerialNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAppliancePatchProperties.
func (s *StorageAppliancePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &s.SerialNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageApplianceProperties.
func (s StorageApplianceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorCredentials", s.AdministratorCredentials)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "capacityUsed", s.CapacityUsed)
	populate(objectMap, "clusterId", s.ClusterID)
	populate(objectMap, "detailedStatus", s.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", s.DetailedStatusMessage)
	populate(objectMap, "managementIpv4Address", s.ManagementIPv4Address)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "rackId", s.RackID)
	populate(objectMap, "rackSlot", s.RackSlot)
	populate(objectMap, "remoteVendorManagementFeature", s.RemoteVendorManagementFeature)
	populate(objectMap, "remoteVendorManagementStatus", s.RemoteVendorManagementStatus)
	populate(objectMap, "serialNumber", s.SerialNumber)
	populate(objectMap, "storageApplianceSkuId", s.StorageApplianceSKUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageApplianceProperties.
func (s *StorageApplianceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorCredentials":
			err = unpopulate(val, "AdministratorCredentials", &s.AdministratorCredentials)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "capacityUsed":
			err = unpopulate(val, "CapacityUsed", &s.CapacityUsed)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &s.ClusterID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &s.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &s.DetailedStatusMessage)
			delete(rawMsg, key)
		case "managementIpv4Address":
			err = unpopulate(val, "ManagementIPv4Address", &s.ManagementIPv4Address)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "rackId":
			err = unpopulate(val, "RackID", &s.RackID)
			delete(rawMsg, key)
		case "rackSlot":
			err = unpopulate(val, "RackSlot", &s.RackSlot)
			delete(rawMsg, key)
		case "remoteVendorManagementFeature":
			err = unpopulate(val, "RemoteVendorManagementFeature", &s.RemoteVendorManagementFeature)
			delete(rawMsg, key)
		case "remoteVendorManagementStatus":
			err = unpopulate(val, "RemoteVendorManagementStatus", &s.RemoteVendorManagementStatus)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &s.SerialNumber)
			delete(rawMsg, key)
		case "storageApplianceSkuId":
			err = unpopulate(val, "StorageApplianceSKUID", &s.StorageApplianceSKUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageApplianceSKUProperties.
func (s StorageApplianceSKUProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityGB", s.CapacityGB)
	populate(objectMap, "model", s.Model)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageApplianceSKUProperties.
func (s *StorageApplianceSKUProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityGB":
			err = unpopulate(val, "CapacityGB", &s.CapacityGB)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &s.Model)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageApplianceSKUSlot.
func (s StorageApplianceSKUSlot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "rackSlot", s.RackSlot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageApplianceSKUSlot.
func (s *StorageApplianceSKUSlot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "rackSlot":
			err = unpopulate(val, "RackSlot", &s.RackSlot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfile.
func (s StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osDisk", s.OSDisk)
	populate(objectMap, "volumeAttachments", s.VolumeAttachments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageProfile.
func (s *StorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osDisk":
			err = unpopulate(val, "OSDisk", &s.OSDisk)
			delete(rawMsg, key)
		case "volumeAttachments":
			err = unpopulate(val, "VolumeAttachments", &s.VolumeAttachments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrunkedNetwork.
func (t TrunkedNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", t.ExtendedLocation)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrunkedNetwork.
func (t *TrunkedNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &t.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrunkedNetworkAttachmentConfiguration.
func (t TrunkedNetworkAttachmentConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkId", t.NetworkID)
	populate(objectMap, "pluginType", t.PluginType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrunkedNetworkAttachmentConfiguration.
func (t *TrunkedNetworkAttachmentConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkId":
			err = unpopulate(val, "NetworkID", &t.NetworkID)
			delete(rawMsg, key)
		case "pluginType":
			err = unpopulate(val, "PluginType", &t.PluginType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrunkedNetworkList.
func (t TrunkedNetworkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrunkedNetworkList.
func (t *TrunkedNetworkList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrunkedNetworkPatchParameters.
func (t TrunkedNetworkPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrunkedNetworkPatchParameters.
func (t *TrunkedNetworkPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrunkedNetworkProperties.
func (t TrunkedNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedResourceIds", t.AssociatedResourceIDs)
	populate(objectMap, "clusterId", t.ClusterID)
	populate(objectMap, "detailedStatus", t.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", t.DetailedStatusMessage)
	populate(objectMap, "hybridAksClustersAssociatedIds", t.HybridAksClustersAssociatedIDs)
	populate(objectMap, "hybridAksPluginType", t.HybridAksPluginType)
	populate(objectMap, "interfaceName", t.InterfaceName)
	populate(objectMap, "isolationDomainIds", t.IsolationDomainIDs)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "virtualMachinesAssociatedIds", t.VirtualMachinesAssociatedIDs)
	populate(objectMap, "vlans", t.Vlans)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrunkedNetworkProperties.
func (t *TrunkedNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedResourceIds":
			err = unpopulate(val, "AssociatedResourceIDs", &t.AssociatedResourceIDs)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &t.ClusterID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &t.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &t.DetailedStatusMessage)
			delete(rawMsg, key)
		case "hybridAksClustersAssociatedIds":
			err = unpopulate(val, "HybridAksClustersAssociatedIDs", &t.HybridAksClustersAssociatedIDs)
			delete(rawMsg, key)
		case "hybridAksPluginType":
			err = unpopulate(val, "HybridAksPluginType", &t.HybridAksPluginType)
			delete(rawMsg, key)
		case "interfaceName":
			err = unpopulate(val, "InterfaceName", &t.InterfaceName)
			delete(rawMsg, key)
		case "isolationDomainIds":
			err = unpopulate(val, "IsolationDomainIDs", &t.IsolationDomainIDs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		case "virtualMachinesAssociatedIds":
			err = unpopulate(val, "VirtualMachinesAssociatedIDs", &t.VirtualMachinesAssociatedIDs)
			delete(rawMsg, key)
		case "vlans":
			err = unpopulate(val, "Vlans", &t.Vlans)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationThreshold.
func (v ValidationThreshold) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grouping", v.Grouping)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationThreshold.
func (v *ValidationThreshold) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grouping":
			err = unpopulate(val, "Grouping", &v.Grouping)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachine.
func (v VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachine.
func (v *VirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineList.
func (v VirtualMachineList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineList.
func (v *VirtualMachineList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePatchParameters.
func (v VirtualMachinePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePatchParameters.
func (v *VirtualMachinePatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePatchProperties.
func (v VirtualMachinePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmImageRepositoryCredentials", v.VMImageRepositoryCredentials)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePatchProperties.
func (v *VirtualMachinePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmImageRepositoryCredentials":
			err = unpopulate(val, "VMImageRepositoryCredentials", &v.VMImageRepositoryCredentials)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePlacementHint.
func (v VirtualMachinePlacementHint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hintType", v.HintType)
	populate(objectMap, "resourceId", v.ResourceID)
	populate(objectMap, "schedulingExecution", v.SchedulingExecution)
	populate(objectMap, "scope", v.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePlacementHint.
func (v *VirtualMachinePlacementHint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hintType":
			err = unpopulate(val, "HintType", &v.HintType)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &v.ResourceID)
			delete(rawMsg, key)
		case "schedulingExecution":
			err = unpopulate(val, "SchedulingExecution", &v.SchedulingExecution)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &v.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinePowerOffParameters.
func (v VirtualMachinePowerOffParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipShutdown", v.SkipShutdown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinePowerOffParameters.
func (v *VirtualMachinePowerOffParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipShutdown":
			err = unpopulate(val, "SkipShutdown", &v.SkipShutdown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineProperties.
func (v VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminUsername", v.AdminUsername)
	populate(objectMap, "availabilityZone", v.AvailabilityZone)
	populate(objectMap, "bareMetalMachineId", v.BareMetalMachineID)
	populate(objectMap, "bootMethod", v.BootMethod)
	populate(objectMap, "cpuCores", v.CPUCores)
	populate(objectMap, "cloudServicesNetworkAttachment", v.CloudServicesNetworkAttachment)
	populate(objectMap, "clusterId", v.ClusterID)
	populate(objectMap, "detailedStatus", v.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", v.DetailedStatusMessage)
	populate(objectMap, "isolateEmulatorThread", v.IsolateEmulatorThread)
	populate(objectMap, "memorySizeGB", v.MemorySizeGB)
	populate(objectMap, "networkAttachments", v.NetworkAttachments)
	populate(objectMap, "networkData", v.NetworkData)
	populate(objectMap, "placementHints", v.PlacementHints)
	populate(objectMap, "powerState", v.PowerState)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "sshPublicKeys", v.SSHPublicKeys)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populate(objectMap, "userData", v.UserData)
	populate(objectMap, "vmDeviceModel", v.VMDeviceModel)
	populate(objectMap, "vmImage", v.VMImage)
	populate(objectMap, "vmImageRepositoryCredentials", v.VMImageRepositoryCredentials)
	populate(objectMap, "virtioInterface", v.VirtioInterface)
	populate(objectMap, "volumes", v.Volumes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineProperties.
func (v *VirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &v.AdminUsername)
			delete(rawMsg, key)
		case "availabilityZone":
			err = unpopulate(val, "AvailabilityZone", &v.AvailabilityZone)
			delete(rawMsg, key)
		case "bareMetalMachineId":
			err = unpopulate(val, "BareMetalMachineID", &v.BareMetalMachineID)
			delete(rawMsg, key)
		case "bootMethod":
			err = unpopulate(val, "BootMethod", &v.BootMethod)
			delete(rawMsg, key)
		case "cpuCores":
			err = unpopulate(val, "CPUCores", &v.CPUCores)
			delete(rawMsg, key)
		case "cloudServicesNetworkAttachment":
			err = unpopulate(val, "CloudServicesNetworkAttachment", &v.CloudServicesNetworkAttachment)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &v.ClusterID)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &v.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &v.DetailedStatusMessage)
			delete(rawMsg, key)
		case "isolateEmulatorThread":
			err = unpopulate(val, "IsolateEmulatorThread", &v.IsolateEmulatorThread)
			delete(rawMsg, key)
		case "memorySizeGB":
			err = unpopulate(val, "MemorySizeGB", &v.MemorySizeGB)
			delete(rawMsg, key)
		case "networkAttachments":
			err = unpopulate(val, "NetworkAttachments", &v.NetworkAttachments)
			delete(rawMsg, key)
		case "networkData":
			err = unpopulate(val, "NetworkData", &v.NetworkData)
			delete(rawMsg, key)
		case "placementHints":
			err = unpopulate(val, "PlacementHints", &v.PlacementHints)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &v.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "sshPublicKeys":
			err = unpopulate(val, "SSHPublicKeys", &v.SSHPublicKeys)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "userData":
			err = unpopulate(val, "UserData", &v.UserData)
			delete(rawMsg, key)
		case "vmDeviceModel":
			err = unpopulate(val, "VMDeviceModel", &v.VMDeviceModel)
			delete(rawMsg, key)
		case "vmImage":
			err = unpopulate(val, "VMImage", &v.VMImage)
			delete(rawMsg, key)
		case "vmImageRepositoryCredentials":
			err = unpopulate(val, "VMImageRepositoryCredentials", &v.VMImageRepositoryCredentials)
			delete(rawMsg, key)
		case "virtioInterface":
			err = unpopulate(val, "VirtioInterface", &v.VirtioInterface)
			delete(rawMsg, key)
		case "volumes":
			err = unpopulate(val, "Volumes", &v.Volumes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Volume.
func (v Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Volume.
func (v *Volume) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeList.
func (v VolumeList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeList.
func (v *VolumeList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumePatchParameters.
func (v VolumePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumePatchParameters.
func (v *VolumePatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeProperties.
func (v VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedTo", v.AttachedTo)
	populate(objectMap, "detailedStatus", v.DetailedStatus)
	populate(objectMap, "detailedStatusMessage", v.DetailedStatusMessage)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "serialNumber", v.SerialNumber)
	populate(objectMap, "sizeMiB", v.SizeMiB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeProperties.
func (v *VolumeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedTo":
			err = unpopulate(val, "AttachedTo", &v.AttachedTo)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &v.DetailedStatus)
			delete(rawMsg, key)
		case "detailedStatusMessage":
			err = unpopulate(val, "DetailedStatusMessage", &v.DetailedStatusMessage)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &v.SerialNumber)
			delete(rawMsg, key)
		case "sizeMiB":
			err = unpopulate(val, "SizeMiB", &v.SizeMiB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
