//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkfunction

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Azure Subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAzureTrafficCollectorsByResourceGroupClient creates a new instance of AzureTrafficCollectorsByResourceGroupClient.
func (c *ClientFactory) NewAzureTrafficCollectorsByResourceGroupClient() *AzureTrafficCollectorsByResourceGroupClient {
	subClient, _ := NewAzureTrafficCollectorsByResourceGroupClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAzureTrafficCollectorsBySubscriptionClient creates a new instance of AzureTrafficCollectorsBySubscriptionClient.
func (c *ClientFactory) NewAzureTrafficCollectorsBySubscriptionClient() *AzureTrafficCollectorsBySubscriptionClient {
	subClient, _ := NewAzureTrafficCollectorsBySubscriptionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAzureTrafficCollectorsClient creates a new instance of AzureTrafficCollectorsClient.
func (c *ClientFactory) NewAzureTrafficCollectorsClient() *AzureTrafficCollectorsClient {
	subClient, _ := NewAzureTrafficCollectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClient creates a new instance of Client.
func (c *ClientFactory) NewClient() *Client {
	subClient, _ := NewClient(c.credential, c.options)
	return subClient
}

// NewCollectorPoliciesClient creates a new instance of CollectorPoliciesClient.
func (c *ClientFactory) NewCollectorPoliciesClient() *CollectorPoliciesClient {
	subClient, _ := NewCollectorPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
