//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkfunction/armnetworkfunction/v2"
	"net/http"
	"net/url"
	"regexp"
)

// CollectorPoliciesServer is a fake server for instances of the armnetworkfunction.CollectorPoliciesClient type.
type CollectorPoliciesServer struct {
	// BeginCreateOrUpdate is the fake for method CollectorPoliciesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, parameters armnetworkfunction.CollectorPolicy, options *armnetworkfunction.CollectorPoliciesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetworkfunction.CollectorPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CollectorPoliciesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, options *armnetworkfunction.CollectorPoliciesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetworkfunction.CollectorPoliciesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CollectorPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, options *armnetworkfunction.CollectorPoliciesClientGetOptions) (resp azfake.Responder[armnetworkfunction.CollectorPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CollectorPoliciesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, azureTrafficCollectorName string, options *armnetworkfunction.CollectorPoliciesClientListOptions) (resp azfake.PagerResponder[armnetworkfunction.CollectorPoliciesClientListResponse])

	// UpdateTags is the fake for method CollectorPoliciesClient.UpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	UpdateTags func(ctx context.Context, resourceGroupName string, azureTrafficCollectorName string, collectorPolicyName string, parameters armnetworkfunction.TagsObject, options *armnetworkfunction.CollectorPoliciesClientUpdateTagsOptions) (resp azfake.Responder[armnetworkfunction.CollectorPoliciesClientUpdateTagsResponse], errResp azfake.ErrorResponder)
}

// NewCollectorPoliciesServerTransport creates a new instance of CollectorPoliciesServerTransport with the provided implementation.
// The returned CollectorPoliciesServerTransport instance is connected to an instance of armnetworkfunction.CollectorPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCollectorPoliciesServerTransport(srv *CollectorPoliciesServer) *CollectorPoliciesServerTransport {
	return &CollectorPoliciesServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armnetworkfunction.CollectorPoliciesClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armnetworkfunction.CollectorPoliciesClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armnetworkfunction.CollectorPoliciesClientListResponse]](),
	}
}

// CollectorPoliciesServerTransport connects instances of armnetworkfunction.CollectorPoliciesClient to instances of CollectorPoliciesServer.
// Don't use this type directly, use NewCollectorPoliciesServerTransport instead.
type CollectorPoliciesServerTransport struct {
	srv                 *CollectorPoliciesServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armnetworkfunction.CollectorPoliciesClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armnetworkfunction.CollectorPoliciesClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armnetworkfunction.CollectorPoliciesClientListResponse]]
}

// Do implements the policy.Transporter interface for CollectorPoliciesServerTransport.
func (c *CollectorPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CollectorPoliciesClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "CollectorPoliciesClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CollectorPoliciesClient.Get":
		resp, err = c.dispatchGet(req)
	case "CollectorPoliciesClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "CollectorPoliciesClient.UpdateTags":
		resp, err = c.dispatchUpdateTags(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CollectorPoliciesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkFunction/azureTrafficCollectors/(?P<azureTrafficCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collectorPolicies/(?P<collectorPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkfunction.CollectorPolicy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		azureTrafficCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureTrafficCollectorName")])
		if err != nil {
			return nil, err
		}
		collectorPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectorPolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, azureTrafficCollectorNameParam, collectorPolicyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *CollectorPoliciesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkFunction/azureTrafficCollectors/(?P<azureTrafficCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collectorPolicies/(?P<collectorPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		azureTrafficCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureTrafficCollectorName")])
		if err != nil {
			return nil, err
		}
		collectorPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectorPolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, azureTrafficCollectorNameParam, collectorPolicyNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CollectorPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkFunction/azureTrafficCollectors/(?P<azureTrafficCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collectorPolicies/(?P<collectorPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureTrafficCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureTrafficCollectorName")])
	if err != nil {
		return nil, err
	}
	collectorPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectorPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, azureTrafficCollectorNameParam, collectorPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CollectorPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CollectorPoliciesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkFunction/azureTrafficCollectors/(?P<azureTrafficCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collectorPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		azureTrafficCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureTrafficCollectorName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, azureTrafficCollectorNameParam, nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetworkfunction.CollectorPoliciesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *CollectorPoliciesServerTransport) dispatchUpdateTags(req *http.Request) (*http.Response, error) {
	if c.srv.UpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateTags not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkFunction/azureTrafficCollectors/(?P<azureTrafficCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collectorPolicies/(?P<collectorPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetworkfunction.TagsObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureTrafficCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureTrafficCollectorName")])
	if err != nil {
		return nil, err
	}
	collectorPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectorPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.UpdateTags(req.Context(), resourceGroupNameParam, azureTrafficCollectorNameParam, collectorPolicyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CollectorPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
