//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
	"net/http"
	"net/url"
	"regexp"
)

// LinkedStorageAccountsServer is a fake server for instances of the armoperationalinsights.LinkedStorageAccountsClient type.
type LinkedStorageAccountsServer struct {
	// CreateOrUpdate is the fake for method LinkedStorageAccountsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, dataSourceType armoperationalinsights.DataSourceType, parameters armoperationalinsights.LinkedStorageAccountsResource, options *armoperationalinsights.LinkedStorageAccountsClientCreateOrUpdateOptions) (resp azfake.Responder[armoperationalinsights.LinkedStorageAccountsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method LinkedStorageAccountsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, resourceGroupName string, workspaceName string, dataSourceType armoperationalinsights.DataSourceType, options *armoperationalinsights.LinkedStorageAccountsClientDeleteOptions) (resp azfake.Responder[armoperationalinsights.LinkedStorageAccountsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LinkedStorageAccountsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, dataSourceType armoperationalinsights.DataSourceType, options *armoperationalinsights.LinkedStorageAccountsClientGetOptions) (resp azfake.Responder[armoperationalinsights.LinkedStorageAccountsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByWorkspacePager is the fake for method LinkedStorageAccountsClient.NewListByWorkspacePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByWorkspacePager func(resourceGroupName string, workspaceName string, options *armoperationalinsights.LinkedStorageAccountsClientListByWorkspaceOptions) (resp azfake.PagerResponder[armoperationalinsights.LinkedStorageAccountsClientListByWorkspaceResponse])
}

// NewLinkedStorageAccountsServerTransport creates a new instance of LinkedStorageAccountsServerTransport with the provided implementation.
// The returned LinkedStorageAccountsServerTransport instance is connected to an instance of armoperationalinsights.LinkedStorageAccountsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLinkedStorageAccountsServerTransport(srv *LinkedStorageAccountsServer) *LinkedStorageAccountsServerTransport {
	return &LinkedStorageAccountsServerTransport{
		srv:                     srv,
		newListByWorkspacePager: newTracker[azfake.PagerResponder[armoperationalinsights.LinkedStorageAccountsClientListByWorkspaceResponse]](),
	}
}

// LinkedStorageAccountsServerTransport connects instances of armoperationalinsights.LinkedStorageAccountsClient to instances of LinkedStorageAccountsServer.
// Don't use this type directly, use NewLinkedStorageAccountsServerTransport instead.
type LinkedStorageAccountsServerTransport struct {
	srv                     *LinkedStorageAccountsServer
	newListByWorkspacePager *tracker[azfake.PagerResponder[armoperationalinsights.LinkedStorageAccountsClientListByWorkspaceResponse]]
}

// Do implements the policy.Transporter interface for LinkedStorageAccountsServerTransport.
func (l *LinkedStorageAccountsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LinkedStorageAccountsClient.CreateOrUpdate":
		resp, err = l.dispatchCreateOrUpdate(req)
	case "LinkedStorageAccountsClient.Delete":
		resp, err = l.dispatchDelete(req)
	case "LinkedStorageAccountsClient.Get":
		resp, err = l.dispatchGet(req)
	case "LinkedStorageAccountsClient.NewListByWorkspacePager":
		resp, err = l.dispatchNewListByWorkspacePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LinkedStorageAccountsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedStorageAccounts/(?P<dataSourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armoperationalinsights.LinkedStorageAccountsResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	dataSourceTypeParam, err := parseWithCast(matches[regex.SubexpIndex("dataSourceType")], func(v string) (armoperationalinsights.DataSourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armoperationalinsights.DataSourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, dataSourceTypeParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LinkedStorageAccountsResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LinkedStorageAccountsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if l.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedStorageAccounts/(?P<dataSourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	dataSourceTypeParam, err := parseWithCast(matches[regex.SubexpIndex("dataSourceType")], func(v string) (armoperationalinsights.DataSourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armoperationalinsights.DataSourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Delete(req.Context(), resourceGroupNameParam, workspaceNameParam, dataSourceTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LinkedStorageAccountsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedStorageAccounts/(?P<dataSourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	dataSourceTypeParam, err := parseWithCast(matches[regex.SubexpIndex("dataSourceType")], func(v string) (armoperationalinsights.DataSourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armoperationalinsights.DataSourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, dataSourceTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LinkedStorageAccountsResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LinkedStorageAccountsServerTransport) dispatchNewListByWorkspacePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByWorkspacePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByWorkspacePager not implemented")}
	}
	newListByWorkspacePager := l.newListByWorkspacePager.get(req)
	if newListByWorkspacePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/linkedStorageAccounts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListByWorkspacePager(resourceGroupNameParam, workspaceNameParam, nil)
		newListByWorkspacePager = &resp
		l.newListByWorkspacePager.add(req, newListByWorkspacePager)
	}
	resp, err := server.PagerResponderNext(newListByWorkspacePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByWorkspacePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByWorkspacePager) {
		l.newListByWorkspacePager.remove(req)
	}
	return resp, nil
}
