//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoperationalinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/StorageInsightsCreateOrUpdate.json
func ExampleStorageInsightConfigsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStorageInsightConfigsClient().CreateOrUpdate(ctx, "OIAutoRest5123", "aztest5048", "AzTestSI1110", armoperationalinsights.StorageInsight{
		Properties: &armoperationalinsights.StorageInsightProperties{
			Containers: []*string{
				to.Ptr("wad-iis-logfiles")},
			StorageAccount: &armoperationalinsights.StorageAccount{
				ID:  to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945"),
				Key: to.Ptr("1234"),
			},
			Tables: []*string{
				to.Ptr("WADWindowsEventLogsTable"),
				to.Ptr("LinuxSyslogVer2v0")},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StorageInsight = armoperationalinsights.StorageInsight{
	// 	Name: to.Ptr("AzTestSI1110"),
	// 	Type: to.Ptr("Microsoft.OperationalInsights/workspaces/storageinsightconfigs"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/oiautorest6987/providers/microsoft.operationalinsights/workspaces/aztest5048/storageinsightconfigs/AzTestSI1110"),
	// 	Properties: &armoperationalinsights.StorageInsightProperties{
	// 		Containers: []*string{
	// 			to.Ptr("wad-iis-logfiles")},
	// 			Status: &armoperationalinsights.StorageInsightStatus{
	// 				State: to.Ptr(armoperationalinsights.StorageInsightStateOK),
	// 			},
	// 			StorageAccount: &armoperationalinsights.StorageAccount{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945"),
	// 				Key: to.Ptr("Storage Key"),
	// 			},
	// 			Tables: []*string{
	// 				to.Ptr("WADWindowsEventLogsTable"),
	// 				to.Ptr("LinuxSyslogVer2v0")},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/StorageInsightsGet.json
func ExampleStorageInsightConfigsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStorageInsightConfigsClient().Get(ctx, "OIAutoRest5123", "aztest5048", "AzTestSI1110", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StorageInsight = armoperationalinsights.StorageInsight{
	// 	Name: to.Ptr("AzTestSI1110"),
	// 	Type: to.Ptr("Microsoft.OperationalInsights/workspaces/storageinsightconfigs"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/oiautorest6987/providers/microsoft.operationalinsights/workspaces/aztest5048/storageinsightconfigs/AzTestSI1110"),
	// 	Properties: &armoperationalinsights.StorageInsightProperties{
	// 		Containers: []*string{
	// 			to.Ptr("wad-iis-logfiles")},
	// 			Status: &armoperationalinsights.StorageInsightStatus{
	// 				State: to.Ptr(armoperationalinsights.StorageInsightStateOK),
	// 			},
	// 			StorageAccount: &armoperationalinsights.StorageAccount{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945"),
	// 				Key: to.Ptr("Storage Account Key"),
	// 			},
	// 			Tables: []*string{
	// 				to.Ptr("WADWindowsEventLogsTable"),
	// 				to.Ptr("LinuxSyslogVer2v0")},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/StorageInsightsDelete.json
func ExampleStorageInsightConfigsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewStorageInsightConfigsClient().Delete(ctx, "OIAutoRest5123", "aztest5048", "AzTestSI1110", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/StorageInsightsListByWorkspace.json
func ExampleStorageInsightConfigsClient_NewListByWorkspacePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStorageInsightConfigsClient().NewListByWorkspacePager("OIAutoRest5123", "aztest5048", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StorageInsightListResult = armoperationalinsights.StorageInsightListResult{
		// }
	}
}
