//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/orbital/armorbital/v2"
	"net/http"
	"net/url"
	"regexp"
)

// OperationsResultsServer is a fake server for instances of the armorbital.OperationsResultsClient type.
type OperationsResultsServer struct {
	// BeginGet is the fake for method OperationsResultsClient.BeginGet
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGet func(ctx context.Context, location string, operationID string, options *armorbital.OperationsResultsClientBeginGetOptions) (resp azfake.PollerResponder[armorbital.OperationsResultsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewOperationsResultsServerTransport creates a new instance of OperationsResultsServerTransport with the provided implementation.
// The returned OperationsResultsServerTransport instance is connected to an instance of armorbital.OperationsResultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOperationsResultsServerTransport(srv *OperationsResultsServer) *OperationsResultsServerTransport {
	return &OperationsResultsServerTransport{
		srv:      srv,
		beginGet: newTracker[azfake.PollerResponder[armorbital.OperationsResultsClientGetResponse]](),
	}
}

// OperationsResultsServerTransport connects instances of armorbital.OperationsResultsClient to instances of OperationsResultsServer.
// Don't use this type directly, use NewOperationsResultsServerTransport instead.
type OperationsResultsServerTransport struct {
	srv      *OperationsResultsServer
	beginGet *tracker[azfake.PollerResponder[armorbital.OperationsResultsClientGetResponse]]
}

// Do implements the policy.Transporter interface for OperationsResultsServerTransport.
func (o *OperationsResultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OperationsResultsClient.BeginGet":
		resp, err = o.dispatchBeginGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OperationsResultsServerTransport) dispatchBeginGet(req *http.Request) (*http.Response, error) {
	if o.srv.BeginGet == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGet not implemented")}
	}
	beginGet := o.beginGet.get(req)
	if beginGet == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Orbital/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationResults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := o.srv.BeginGet(req.Context(), locationParam, operationIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGet = &respr
		o.beginGet.add(req, beginGet)
	}

	resp, err := server.PollerResponderNext(beginGet, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		o.beginGet.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGet) {
		o.beginGet.remove(req)
	}

	return resp, nil
}
