//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpeering

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// LegacyPeeringsClient contains the methods for the LegacyPeerings group.
// Don't use this type directly, use NewLegacyPeeringsClient() instead.
type LegacyPeeringsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewLegacyPeeringsClient creates a new instance of LegacyPeeringsClient with the specified values.
//   - subscriptionID - The Azure subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewLegacyPeeringsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*LegacyPeeringsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &LegacyPeeringsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListPager - Lists all of the legacy peerings under the given subscription matching the specified kind and location.
//
// Generated from API version 2022-01-01
//   - peeringLocation - The location of the peering.
//   - kind - The kind of the peering.
//   - options - LegacyPeeringsClientListOptions contains the optional parameters for the LegacyPeeringsClient.NewListPager method.
func (client *LegacyPeeringsClient) NewListPager(peeringLocation string, kind LegacyPeeringsKind, options *LegacyPeeringsClientListOptions) *runtime.Pager[LegacyPeeringsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[LegacyPeeringsClientListResponse]{
		More: func(page LegacyPeeringsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LegacyPeeringsClientListResponse) (LegacyPeeringsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "LegacyPeeringsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, peeringLocation, kind, options)
			}, nil)
			if err != nil {
				return LegacyPeeringsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *LegacyPeeringsClient) listCreateRequest(ctx context.Context, peeringLocation string, kind LegacyPeeringsKind, options *LegacyPeeringsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/legacyPeerings"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("peeringLocation", peeringLocation)
	reqQP.Set("kind", string(kind))
	if options != nil && options.Asn != nil {
		reqQP.Set("asn", strconv.FormatInt(int64(*options.Asn), 10))
	}
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *LegacyPeeringsClient) listHandleResponse(resp *http.Response) (LegacyPeeringsClientListResponse, error) {
	result := LegacyPeeringsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListResult); err != nil {
		return LegacyPeeringsClientListResponse{}, err
	}
	return result, nil
}
