//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
	"time"
)

// PolicyStatesServer is a fake server for instances of the armpolicyinsights.PolicyStatesClient type.
type PolicyStatesServer struct {
	// NewListQueryResultsForManagementGroupPager is the fake for method PolicyStatesClient.NewListQueryResultsForManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForManagementGroupPager func(policyStatesResource armpolicyinsights.PolicyStatesResource, managementGroupName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientListQueryResultsForManagementGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForManagementGroupResponse])

	// NewListQueryResultsForPolicyDefinitionPager is the fake for method PolicyStatesClient.NewListQueryResultsForPolicyDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForPolicyDefinitionPager func(policyStatesResource armpolicyinsights.PolicyStatesResource, subscriptionID string, policyDefinitionName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientListQueryResultsForPolicyDefinitionOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForPolicyDefinitionResponse])

	// NewListQueryResultsForPolicySetDefinitionPager is the fake for method PolicyStatesClient.NewListQueryResultsForPolicySetDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForPolicySetDefinitionPager func(policyStatesResource armpolicyinsights.PolicyStatesResource, subscriptionID string, policySetDefinitionName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientListQueryResultsForPolicySetDefinitionOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse])

	// NewListQueryResultsForResourcePager is the fake for method PolicyStatesClient.NewListQueryResultsForResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForResourcePager func(policyStatesResource armpolicyinsights.PolicyStatesResource, resourceID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientListQueryResultsForResourceOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceResponse])

	// NewListQueryResultsForResourceGroupPager is the fake for method PolicyStatesClient.NewListQueryResultsForResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForResourceGroupPager func(policyStatesResource armpolicyinsights.PolicyStatesResource, subscriptionID string, resourceGroupName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupResponse])

	// NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager is the fake for method PolicyStatesClient.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager func(policyStatesResource armpolicyinsights.PolicyStatesResource, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse])

	// NewListQueryResultsForSubscriptionPager is the fake for method PolicyStatesClient.NewListQueryResultsForSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForSubscriptionPager func(policyStatesResource armpolicyinsights.PolicyStatesResource, subscriptionID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionResponse])

	// NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager is the fake for method PolicyStatesClient.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager func(policyStatesResource armpolicyinsights.PolicyStatesResource, subscriptionID string, policyAssignmentName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse])

	// SummarizeForManagementGroup is the fake for method PolicyStatesClient.SummarizeForManagementGroup
	// HTTP status codes to indicate success: http.StatusOK
	SummarizeForManagementGroup func(ctx context.Context, policyStatesSummaryResource armpolicyinsights.PolicyStatesSummaryResourceType, managementGroupName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientSummarizeForManagementGroupOptions) (resp azfake.Responder[armpolicyinsights.PolicyStatesClientSummarizeForManagementGroupResponse], errResp azfake.ErrorResponder)

	// SummarizeForPolicyDefinition is the fake for method PolicyStatesClient.SummarizeForPolicyDefinition
	// HTTP status codes to indicate success: http.StatusOK
	SummarizeForPolicyDefinition func(ctx context.Context, policyStatesSummaryResource armpolicyinsights.PolicyStatesSummaryResourceType, subscriptionID string, policyDefinitionName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientSummarizeForPolicyDefinitionOptions) (resp azfake.Responder[armpolicyinsights.PolicyStatesClientSummarizeForPolicyDefinitionResponse], errResp azfake.ErrorResponder)

	// SummarizeForPolicySetDefinition is the fake for method PolicyStatesClient.SummarizeForPolicySetDefinition
	// HTTP status codes to indicate success: http.StatusOK
	SummarizeForPolicySetDefinition func(ctx context.Context, policyStatesSummaryResource armpolicyinsights.PolicyStatesSummaryResourceType, subscriptionID string, policySetDefinitionName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientSummarizeForPolicySetDefinitionOptions) (resp azfake.Responder[armpolicyinsights.PolicyStatesClientSummarizeForPolicySetDefinitionResponse], errResp azfake.ErrorResponder)

	// SummarizeForResource is the fake for method PolicyStatesClient.SummarizeForResource
	// HTTP status codes to indicate success: http.StatusOK
	SummarizeForResource func(ctx context.Context, policyStatesSummaryResource armpolicyinsights.PolicyStatesSummaryResourceType, resourceID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientSummarizeForResourceOptions) (resp azfake.Responder[armpolicyinsights.PolicyStatesClientSummarizeForResourceResponse], errResp azfake.ErrorResponder)

	// SummarizeForResourceGroup is the fake for method PolicyStatesClient.SummarizeForResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	SummarizeForResourceGroup func(ctx context.Context, policyStatesSummaryResource armpolicyinsights.PolicyStatesSummaryResourceType, subscriptionID string, resourceGroupName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientSummarizeForResourceGroupOptions) (resp azfake.Responder[armpolicyinsights.PolicyStatesClientSummarizeForResourceGroupResponse], errResp azfake.ErrorResponder)

	// SummarizeForResourceGroupLevelPolicyAssignment is the fake for method PolicyStatesClient.SummarizeForResourceGroupLevelPolicyAssignment
	// HTTP status codes to indicate success: http.StatusOK
	SummarizeForResourceGroupLevelPolicyAssignment func(ctx context.Context, policyStatesSummaryResource armpolicyinsights.PolicyStatesSummaryResourceType, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentOptions) (resp azfake.Responder[armpolicyinsights.PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentResponse], errResp azfake.ErrorResponder)

	// SummarizeForSubscription is the fake for method PolicyStatesClient.SummarizeForSubscription
	// HTTP status codes to indicate success: http.StatusOK
	SummarizeForSubscription func(ctx context.Context, policyStatesSummaryResource armpolicyinsights.PolicyStatesSummaryResourceType, subscriptionID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientSummarizeForSubscriptionOptions) (resp azfake.Responder[armpolicyinsights.PolicyStatesClientSummarizeForSubscriptionResponse], errResp azfake.ErrorResponder)

	// SummarizeForSubscriptionLevelPolicyAssignment is the fake for method PolicyStatesClient.SummarizeForSubscriptionLevelPolicyAssignment
	// HTTP status codes to indicate success: http.StatusOK
	SummarizeForSubscriptionLevelPolicyAssignment func(ctx context.Context, policyStatesSummaryResource armpolicyinsights.PolicyStatesSummaryResourceType, subscriptionID string, policyAssignmentName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentOptions) (resp azfake.Responder[armpolicyinsights.PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentResponse], errResp azfake.ErrorResponder)

	// BeginTriggerResourceGroupEvaluation is the fake for method PolicyStatesClient.BeginTriggerResourceGroupEvaluation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTriggerResourceGroupEvaluation func(ctx context.Context, subscriptionID string, resourceGroupName string, options *armpolicyinsights.PolicyStatesClientBeginTriggerResourceGroupEvaluationOptions) (resp azfake.PollerResponder[armpolicyinsights.PolicyStatesClientTriggerResourceGroupEvaluationResponse], errResp azfake.ErrorResponder)

	// BeginTriggerSubscriptionEvaluation is the fake for method PolicyStatesClient.BeginTriggerSubscriptionEvaluation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTriggerSubscriptionEvaluation func(ctx context.Context, subscriptionID string, options *armpolicyinsights.PolicyStatesClientBeginTriggerSubscriptionEvaluationOptions) (resp azfake.PollerResponder[armpolicyinsights.PolicyStatesClientTriggerSubscriptionEvaluationResponse], errResp azfake.ErrorResponder)
}

// NewPolicyStatesServerTransport creates a new instance of PolicyStatesServerTransport with the provided implementation.
// The returned PolicyStatesServerTransport instance is connected to an instance of armpolicyinsights.PolicyStatesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPolicyStatesServerTransport(srv *PolicyStatesServer) *PolicyStatesServerTransport {
	return &PolicyStatesServerTransport{
		srv: srv,
		newListQueryResultsForManagementGroupPager:                    newTracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForManagementGroupResponse]](),
		newListQueryResultsForPolicyDefinitionPager:                   newTracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForPolicyDefinitionResponse]](),
		newListQueryResultsForPolicySetDefinitionPager:                newTracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse]](),
		newListQueryResultsForResourcePager:                           newTracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceResponse]](),
		newListQueryResultsForResourceGroupPager:                      newTracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupResponse]](),
		newListQueryResultsForResourceGroupLevelPolicyAssignmentPager: newTracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse]](),
		newListQueryResultsForSubscriptionPager:                       newTracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionResponse]](),
		newListQueryResultsForSubscriptionLevelPolicyAssignmentPager:  newTracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse]](),
		beginTriggerResourceGroupEvaluation:                           newTracker[azfake.PollerResponder[armpolicyinsights.PolicyStatesClientTriggerResourceGroupEvaluationResponse]](),
		beginTriggerSubscriptionEvaluation:                            newTracker[azfake.PollerResponder[armpolicyinsights.PolicyStatesClientTriggerSubscriptionEvaluationResponse]](),
	}
}

// PolicyStatesServerTransport connects instances of armpolicyinsights.PolicyStatesClient to instances of PolicyStatesServer.
// Don't use this type directly, use NewPolicyStatesServerTransport instead.
type PolicyStatesServerTransport struct {
	srv                                                           *PolicyStatesServer
	newListQueryResultsForManagementGroupPager                    *tracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForManagementGroupResponse]]
	newListQueryResultsForPolicyDefinitionPager                   *tracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForPolicyDefinitionResponse]]
	newListQueryResultsForPolicySetDefinitionPager                *tracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse]]
	newListQueryResultsForResourcePager                           *tracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceResponse]]
	newListQueryResultsForResourceGroupPager                      *tracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupResponse]]
	newListQueryResultsForResourceGroupLevelPolicyAssignmentPager *tracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse]]
	newListQueryResultsForSubscriptionPager                       *tracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionResponse]]
	newListQueryResultsForSubscriptionLevelPolicyAssignmentPager  *tracker[azfake.PagerResponder[armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse]]
	beginTriggerResourceGroupEvaluation                           *tracker[azfake.PollerResponder[armpolicyinsights.PolicyStatesClientTriggerResourceGroupEvaluationResponse]]
	beginTriggerSubscriptionEvaluation                            *tracker[azfake.PollerResponder[armpolicyinsights.PolicyStatesClientTriggerSubscriptionEvaluationResponse]]
}

// Do implements the policy.Transporter interface for PolicyStatesServerTransport.
func (p *PolicyStatesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PolicyStatesClient.NewListQueryResultsForManagementGroupPager":
		resp, err = p.dispatchNewListQueryResultsForManagementGroupPager(req)
	case "PolicyStatesClient.NewListQueryResultsForPolicyDefinitionPager":
		resp, err = p.dispatchNewListQueryResultsForPolicyDefinitionPager(req)
	case "PolicyStatesClient.NewListQueryResultsForPolicySetDefinitionPager":
		resp, err = p.dispatchNewListQueryResultsForPolicySetDefinitionPager(req)
	case "PolicyStatesClient.NewListQueryResultsForResourcePager":
		resp, err = p.dispatchNewListQueryResultsForResourcePager(req)
	case "PolicyStatesClient.NewListQueryResultsForResourceGroupPager":
		resp, err = p.dispatchNewListQueryResultsForResourceGroupPager(req)
	case "PolicyStatesClient.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager":
		resp, err = p.dispatchNewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(req)
	case "PolicyStatesClient.NewListQueryResultsForSubscriptionPager":
		resp, err = p.dispatchNewListQueryResultsForSubscriptionPager(req)
	case "PolicyStatesClient.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager":
		resp, err = p.dispatchNewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(req)
	case "PolicyStatesClient.SummarizeForManagementGroup":
		resp, err = p.dispatchSummarizeForManagementGroup(req)
	case "PolicyStatesClient.SummarizeForPolicyDefinition":
		resp, err = p.dispatchSummarizeForPolicyDefinition(req)
	case "PolicyStatesClient.SummarizeForPolicySetDefinition":
		resp, err = p.dispatchSummarizeForPolicySetDefinition(req)
	case "PolicyStatesClient.SummarizeForResource":
		resp, err = p.dispatchSummarizeForResource(req)
	case "PolicyStatesClient.SummarizeForResourceGroup":
		resp, err = p.dispatchSummarizeForResourceGroup(req)
	case "PolicyStatesClient.SummarizeForResourceGroupLevelPolicyAssignment":
		resp, err = p.dispatchSummarizeForResourceGroupLevelPolicyAssignment(req)
	case "PolicyStatesClient.SummarizeForSubscription":
		resp, err = p.dispatchSummarizeForSubscription(req)
	case "PolicyStatesClient.SummarizeForSubscriptionLevelPolicyAssignment":
		resp, err = p.dispatchSummarizeForSubscriptionLevelPolicyAssignment(req)
	case "PolicyStatesClient.BeginTriggerResourceGroupEvaluation":
		resp, err = p.dispatchBeginTriggerResourceGroupEvaluation(req)
	case "PolicyStatesClient.BeginTriggerSubscriptionEvaluation":
		resp, err = p.dispatchBeginTriggerSubscriptionEvaluation(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchNewListQueryResultsForManagementGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForManagementGroupPager not implemented")}
	}
	newListQueryResultsForManagementGroupPager := p.newListQueryResultsForManagementGroupPager.get(req)
	if newListQueryResultsForManagementGroupPager == nil {
		const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyStatesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesResource")], func(v string) (armpolicyinsights.PolicyStatesResource, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyStatesResource(p), nil
		})
		if err != nil {
			return nil, err
		}
		managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForManagementGroupPager(policyStatesResourceParam, managementGroupNameParam, queryOptions, nil)
		newListQueryResultsForManagementGroupPager = &resp
		p.newListQueryResultsForManagementGroupPager.add(req, newListQueryResultsForManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForManagementGroupPager, req, func(page *armpolicyinsights.PolicyStatesClientListQueryResultsForManagementGroupResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForManagementGroupPager) {
		p.newListQueryResultsForManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchNewListQueryResultsForPolicyDefinitionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForPolicyDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForPolicyDefinitionPager not implemented")}
	}
	newListQueryResultsForPolicyDefinitionPager := p.newListQueryResultsForPolicyDefinitionPager.get(req)
	if newListQueryResultsForPolicyDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyDefinitions/(?P<policyDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyStatesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesResource")], func(v string) (armpolicyinsights.PolicyStatesResource, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyStatesResource(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		policyDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyDefinitionName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForPolicyDefinitionPager(policyStatesResourceParam, subscriptionIDParam, policyDefinitionNameParam, queryOptions, nil)
		newListQueryResultsForPolicyDefinitionPager = &resp
		p.newListQueryResultsForPolicyDefinitionPager.add(req, newListQueryResultsForPolicyDefinitionPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForPolicyDefinitionPager, req, func(page *armpolicyinsights.PolicyStatesClientListQueryResultsForPolicyDefinitionResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForPolicyDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForPolicyDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForPolicyDefinitionPager) {
		p.newListQueryResultsForPolicyDefinitionPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchNewListQueryResultsForPolicySetDefinitionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForPolicySetDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForPolicySetDefinitionPager not implemented")}
	}
	newListQueryResultsForPolicySetDefinitionPager := p.newListQueryResultsForPolicySetDefinitionPager.get(req)
	if newListQueryResultsForPolicySetDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policySetDefinitions/(?P<policySetDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyStatesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesResource")], func(v string) (armpolicyinsights.PolicyStatesResource, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyStatesResource(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		policySetDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policySetDefinitionName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForPolicySetDefinitionPager(policyStatesResourceParam, subscriptionIDParam, policySetDefinitionNameParam, queryOptions, nil)
		newListQueryResultsForPolicySetDefinitionPager = &resp
		p.newListQueryResultsForPolicySetDefinitionPager.add(req, newListQueryResultsForPolicySetDefinitionPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForPolicySetDefinitionPager, req, func(page *armpolicyinsights.PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForPolicySetDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForPolicySetDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForPolicySetDefinitionPager) {
		p.newListQueryResultsForPolicySetDefinitionPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchNewListQueryResultsForResourcePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForResourcePager not implemented")}
	}
	newListQueryResultsForResourcePager := p.newListQueryResultsForResourcePager.get(req)
	if newListQueryResultsForResourcePager == nil {
		const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyStatesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesResource")], func(v string) (armpolicyinsights.PolicyStatesResource, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyStatesResource(p), nil
		})
		if err != nil {
			return nil, err
		}
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || expandParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				Expand:    expandParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForResourcePager(policyStatesResourceParam, resourceIDParam, queryOptions, nil)
		newListQueryResultsForResourcePager = &resp
		p.newListQueryResultsForResourcePager.add(req, newListQueryResultsForResourcePager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForResourcePager, req, func(page *armpolicyinsights.PolicyStatesClientListQueryResultsForResourceResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForResourcePager) {
		p.newListQueryResultsForResourcePager.remove(req)
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchNewListQueryResultsForResourceGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForResourceGroupPager not implemented")}
	}
	newListQueryResultsForResourceGroupPager := p.newListQueryResultsForResourceGroupPager.get(req)
	if newListQueryResultsForResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyStatesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesResource")], func(v string) (armpolicyinsights.PolicyStatesResource, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyStatesResource(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForResourceGroupPager(policyStatesResourceParam, subscriptionIDParam, resourceGroupNameParam, queryOptions, nil)
		newListQueryResultsForResourceGroupPager = &resp
		p.newListQueryResultsForResourceGroupPager.add(req, newListQueryResultsForResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForResourceGroupPager, req, func(page *armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForResourceGroupPager) {
		p.newListQueryResultsForResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchNewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager not implemented")}
	}
	newListQueryResultsForResourceGroupLevelPolicyAssignmentPager := p.newListQueryResultsForResourceGroupLevelPolicyAssignmentPager.get(req)
	if newListQueryResultsForResourceGroupLevelPolicyAssignmentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyStatesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesResource")], func(v string) (armpolicyinsights.PolicyStatesResource, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyStatesResource(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(policyStatesResourceParam, subscriptionIDParam, resourceGroupNameParam, policyAssignmentNameParam, queryOptions, nil)
		newListQueryResultsForResourceGroupLevelPolicyAssignmentPager = &resp
		p.newListQueryResultsForResourceGroupLevelPolicyAssignmentPager.add(req, newListQueryResultsForResourceGroupLevelPolicyAssignmentPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForResourceGroupLevelPolicyAssignmentPager, req, func(page *armpolicyinsights.PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForResourceGroupLevelPolicyAssignmentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForResourceGroupLevelPolicyAssignmentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForResourceGroupLevelPolicyAssignmentPager) {
		p.newListQueryResultsForResourceGroupLevelPolicyAssignmentPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchNewListQueryResultsForSubscriptionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForSubscriptionPager not implemented")}
	}
	newListQueryResultsForSubscriptionPager := p.newListQueryResultsForSubscriptionPager.get(req)
	if newListQueryResultsForSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyStatesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesResource")], func(v string) (armpolicyinsights.PolicyStatesResource, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyStatesResource(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForSubscriptionPager(policyStatesResourceParam, subscriptionIDParam, queryOptions, nil)
		newListQueryResultsForSubscriptionPager = &resp
		p.newListQueryResultsForSubscriptionPager.add(req, newListQueryResultsForSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForSubscriptionPager, req, func(page *armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForSubscriptionPager) {
		p.newListQueryResultsForSubscriptionPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchNewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager not implemented")}
	}
	newListQueryResultsForSubscriptionLevelPolicyAssignmentPager := p.newListQueryResultsForSubscriptionLevelPolicyAssignmentPager.get(req)
	if newListQueryResultsForSubscriptionLevelPolicyAssignmentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyStatesResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesResource")], func(v string) (armpolicyinsights.PolicyStatesResource, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyStatesResource(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(policyStatesResourceParam, subscriptionIDParam, policyAssignmentNameParam, queryOptions, nil)
		newListQueryResultsForSubscriptionLevelPolicyAssignmentPager = &resp
		p.newListQueryResultsForSubscriptionLevelPolicyAssignmentPager.add(req, newListQueryResultsForSubscriptionLevelPolicyAssignmentPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForSubscriptionLevelPolicyAssignmentPager, req, func(page *armpolicyinsights.PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForSubscriptionLevelPolicyAssignmentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForSubscriptionLevelPolicyAssignmentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForSubscriptionLevelPolicyAssignmentPager) {
		p.newListQueryResultsForSubscriptionLevelPolicyAssignmentPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchSummarizeForManagementGroup(req *http.Request) (*http.Response, error) {
	if p.srv.SummarizeForManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method SummarizeForManagementGroup not implemented")}
	}
	const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesSummaryResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/summarize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	policyStatesSummaryResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesSummaryResource")], func(v string) (armpolicyinsights.PolicyStatesSummaryResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpolicyinsights.PolicyStatesSummaryResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
	if err != nil {
		return nil, err
	}
	fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
	if err != nil {
		return nil, err
	}
	toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var queryOptions *armpolicyinsights.QueryOptions
	if topParam != nil || fromParam != nil || toParam != nil || filterParam != nil {
		queryOptions = &armpolicyinsights.QueryOptions{
			Top:    topParam,
			From:   fromParam,
			To:     toParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := p.srv.SummarizeForManagementGroup(req.Context(), policyStatesSummaryResourceParam, managementGroupNameParam, queryOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SummarizeResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchSummarizeForPolicyDefinition(req *http.Request) (*http.Response, error) {
	if p.srv.SummarizeForPolicyDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method SummarizeForPolicyDefinition not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyDefinitions/(?P<policyDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesSummaryResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/summarize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	policyStatesSummaryResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesSummaryResource")], func(v string) (armpolicyinsights.PolicyStatesSummaryResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpolicyinsights.PolicyStatesSummaryResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	policyDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyDefinitionName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
	if err != nil {
		return nil, err
	}
	fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
	if err != nil {
		return nil, err
	}
	toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var queryOptions *armpolicyinsights.QueryOptions
	if topParam != nil || fromParam != nil || toParam != nil || filterParam != nil {
		queryOptions = &armpolicyinsights.QueryOptions{
			Top:    topParam,
			From:   fromParam,
			To:     toParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := p.srv.SummarizeForPolicyDefinition(req.Context(), policyStatesSummaryResourceParam, subscriptionIDParam, policyDefinitionNameParam, queryOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SummarizeResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchSummarizeForPolicySetDefinition(req *http.Request) (*http.Response, error) {
	if p.srv.SummarizeForPolicySetDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method SummarizeForPolicySetDefinition not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policySetDefinitions/(?P<policySetDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesSummaryResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/summarize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	policyStatesSummaryResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesSummaryResource")], func(v string) (armpolicyinsights.PolicyStatesSummaryResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpolicyinsights.PolicyStatesSummaryResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	policySetDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policySetDefinitionName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
	if err != nil {
		return nil, err
	}
	fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
	if err != nil {
		return nil, err
	}
	toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var queryOptions *armpolicyinsights.QueryOptions
	if topParam != nil || fromParam != nil || toParam != nil || filterParam != nil {
		queryOptions = &armpolicyinsights.QueryOptions{
			Top:    topParam,
			From:   fromParam,
			To:     toParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := p.srv.SummarizeForPolicySetDefinition(req.Context(), policyStatesSummaryResourceParam, subscriptionIDParam, policySetDefinitionNameParam, queryOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SummarizeResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchSummarizeForResource(req *http.Request) (*http.Response, error) {
	if p.srv.SummarizeForResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method SummarizeForResource not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesSummaryResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/summarize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	policyStatesSummaryResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesSummaryResource")], func(v string) (armpolicyinsights.PolicyStatesSummaryResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpolicyinsights.PolicyStatesSummaryResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
	if err != nil {
		return nil, err
	}
	fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
	if err != nil {
		return nil, err
	}
	toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var queryOptions *armpolicyinsights.QueryOptions
	if topParam != nil || fromParam != nil || toParam != nil || filterParam != nil {
		queryOptions = &armpolicyinsights.QueryOptions{
			Top:    topParam,
			From:   fromParam,
			To:     toParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := p.srv.SummarizeForResource(req.Context(), policyStatesSummaryResourceParam, resourceIDParam, queryOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SummarizeResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchSummarizeForResourceGroup(req *http.Request) (*http.Response, error) {
	if p.srv.SummarizeForResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method SummarizeForResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesSummaryResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/summarize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	policyStatesSummaryResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesSummaryResource")], func(v string) (armpolicyinsights.PolicyStatesSummaryResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpolicyinsights.PolicyStatesSummaryResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
	if err != nil {
		return nil, err
	}
	fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
	if err != nil {
		return nil, err
	}
	toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var queryOptions *armpolicyinsights.QueryOptions
	if topParam != nil || fromParam != nil || toParam != nil || filterParam != nil {
		queryOptions = &armpolicyinsights.QueryOptions{
			Top:    topParam,
			From:   fromParam,
			To:     toParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := p.srv.SummarizeForResourceGroup(req.Context(), policyStatesSummaryResourceParam, subscriptionIDParam, resourceGroupNameParam, queryOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SummarizeResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchSummarizeForResourceGroupLevelPolicyAssignment(req *http.Request) (*http.Response, error) {
	if p.srv.SummarizeForResourceGroupLevelPolicyAssignment == nil {
		return nil, &nonRetriableError{errors.New("fake for method SummarizeForResourceGroupLevelPolicyAssignment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesSummaryResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/summarize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	policyStatesSummaryResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesSummaryResource")], func(v string) (armpolicyinsights.PolicyStatesSummaryResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpolicyinsights.PolicyStatesSummaryResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
	if err != nil {
		return nil, err
	}
	fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
	if err != nil {
		return nil, err
	}
	toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var queryOptions *armpolicyinsights.QueryOptions
	if topParam != nil || fromParam != nil || toParam != nil || filterParam != nil {
		queryOptions = &armpolicyinsights.QueryOptions{
			Top:    topParam,
			From:   fromParam,
			To:     toParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := p.srv.SummarizeForResourceGroupLevelPolicyAssignment(req.Context(), policyStatesSummaryResourceParam, subscriptionIDParam, resourceGroupNameParam, policyAssignmentNameParam, queryOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SummarizeResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchSummarizeForSubscription(req *http.Request) (*http.Response, error) {
	if p.srv.SummarizeForSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method SummarizeForSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesSummaryResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/summarize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	policyStatesSummaryResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesSummaryResource")], func(v string) (armpolicyinsights.PolicyStatesSummaryResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpolicyinsights.PolicyStatesSummaryResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
	if err != nil {
		return nil, err
	}
	fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
	if err != nil {
		return nil, err
	}
	toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var queryOptions *armpolicyinsights.QueryOptions
	if topParam != nil || fromParam != nil || toParam != nil || filterParam != nil {
		queryOptions = &armpolicyinsights.QueryOptions{
			Top:    topParam,
			From:   fromParam,
			To:     toParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := p.srv.SummarizeForSubscription(req.Context(), policyStatesSummaryResourceParam, subscriptionIDParam, queryOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SummarizeResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchSummarizeForSubscriptionLevelPolicyAssignment(req *http.Request) (*http.Response, error) {
	if p.srv.SummarizeForSubscriptionLevelPolicyAssignment == nil {
		return nil, &nonRetriableError{errors.New("fake for method SummarizeForSubscriptionLevelPolicyAssignment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/(?P<policyStatesSummaryResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/summarize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	policyStatesSummaryResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyStatesSummaryResource")], func(v string) (armpolicyinsights.PolicyStatesSummaryResourceType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpolicyinsights.PolicyStatesSummaryResourceType(p), nil
	})
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
	if err != nil {
		return nil, err
	}
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
	if err != nil {
		return nil, err
	}
	fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
	if err != nil {
		return nil, err
	}
	toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var queryOptions *armpolicyinsights.QueryOptions
	if topParam != nil || fromParam != nil || toParam != nil || filterParam != nil {
		queryOptions = &armpolicyinsights.QueryOptions{
			Top:    topParam,
			From:   fromParam,
			To:     toParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := p.srv.SummarizeForSubscriptionLevelPolicyAssignment(req.Context(), policyStatesSummaryResourceParam, subscriptionIDParam, policyAssignmentNameParam, queryOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SummarizeResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchBeginTriggerResourceGroupEvaluation(req *http.Request) (*http.Response, error) {
	if p.srv.BeginTriggerResourceGroupEvaluation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTriggerResourceGroupEvaluation not implemented")}
	}
	beginTriggerResourceGroupEvaluation := p.beginTriggerResourceGroupEvaluation.get(req)
	if beginTriggerResourceGroupEvaluation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/latest/triggerEvaluation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginTriggerResourceGroupEvaluation(req.Context(), subscriptionIDParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTriggerResourceGroupEvaluation = &respr
		p.beginTriggerResourceGroupEvaluation.add(req, beginTriggerResourceGroupEvaluation)
	}

	resp, err := server.PollerResponderNext(beginTriggerResourceGroupEvaluation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginTriggerResourceGroupEvaluation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTriggerResourceGroupEvaluation) {
		p.beginTriggerResourceGroupEvaluation.remove(req)
	}

	return resp, nil
}

func (p *PolicyStatesServerTransport) dispatchBeginTriggerSubscriptionEvaluation(req *http.Request) (*http.Response, error) {
	if p.srv.BeginTriggerSubscriptionEvaluation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTriggerSubscriptionEvaluation not implemented")}
	}
	beginTriggerSubscriptionEvaluation := p.beginTriggerSubscriptionEvaluation.get(req)
	if beginTriggerSubscriptionEvaluation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyStates/latest/triggerEvaluation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginTriggerSubscriptionEvaluation(req.Context(), subscriptionIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTriggerSubscriptionEvaluation = &respr
		p.beginTriggerSubscriptionEvaluation.add(req, beginTriggerSubscriptionEvaluation)
	}

	resp, err := server.PollerResponderNext(beginTriggerSubscriptionEvaluation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginTriggerSubscriptionEvaluation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTriggerSubscriptionEvaluation) {
		p.beginTriggerSubscriptionEvaluation.remove(req)
	}

	return resp, nil
}
