//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/postgresql/armpostgresql"
	"net/http"
	"net/url"
	"regexp"
)

// ServerBasedPerformanceTierServer is a fake server for instances of the armpostgresql.ServerBasedPerformanceTierClient type.
type ServerBasedPerformanceTierServer struct {
	// NewListPager is the fake for method ServerBasedPerformanceTierClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, serverName string, options *armpostgresql.ServerBasedPerformanceTierClientListOptions) (resp azfake.PagerResponder[armpostgresql.ServerBasedPerformanceTierClientListResponse])
}

// NewServerBasedPerformanceTierServerTransport creates a new instance of ServerBasedPerformanceTierServerTransport with the provided implementation.
// The returned ServerBasedPerformanceTierServerTransport instance is connected to an instance of armpostgresql.ServerBasedPerformanceTierClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerBasedPerformanceTierServerTransport(srv *ServerBasedPerformanceTierServer) *ServerBasedPerformanceTierServerTransport {
	return &ServerBasedPerformanceTierServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armpostgresql.ServerBasedPerformanceTierClientListResponse]](),
	}
}

// ServerBasedPerformanceTierServerTransport connects instances of armpostgresql.ServerBasedPerformanceTierClient to instances of ServerBasedPerformanceTierServer.
// Don't use this type directly, use NewServerBasedPerformanceTierServerTransport instead.
type ServerBasedPerformanceTierServerTransport struct {
	srv          *ServerBasedPerformanceTierServer
	newListPager *tracker[azfake.PagerResponder[armpostgresql.ServerBasedPerformanceTierClientListResponse]]
}

// Do implements the policy.Transporter interface for ServerBasedPerformanceTierServerTransport.
func (s *ServerBasedPerformanceTierServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServerBasedPerformanceTierClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerBasedPerformanceTierServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforPostgreSQL/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/performanceTiers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, serverNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
