//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresqlflexibleservers

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ActiveDirectoryAdministrator.
func (a ActiveDirectoryAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveDirectoryAdministrator.
func (a *ActiveDirectoryAdministrator) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveDirectoryAdministratorAdd.
func (a ActiveDirectoryAdministratorAdd) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveDirectoryAdministratorAdd.
func (a *ActiveDirectoryAdministratorAdd) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminCredentials.
func (a AdminCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceServerPassword", a.SourceServerPassword)
	populate(objectMap, "targetServerPassword", a.TargetServerPassword)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminCredentials.
func (a *AdminCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceServerPassword":
			err = unpopulate(val, "SourceServerPassword", &a.SourceServerPassword)
			delete(rawMsg, key)
		case "targetServerPassword":
			err = unpopulate(val, "TargetServerPassword", &a.TargetServerPassword)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdministratorListResult.
func (a AdministratorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdministratorListResult.
func (a *AdministratorListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdministratorProperties.
func (a AdministratorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "objectId", a.ObjectID)
	populate(objectMap, "principalName", a.PrincipalName)
	populate(objectMap, "principalType", a.PrincipalType)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdministratorProperties.
func (a *AdministratorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectId":
			err = unpopulate(val, "ObjectID", &a.ObjectID)
			delete(rawMsg, key)
		case "principalName":
			err = unpopulate(val, "PrincipalName", &a.PrincipalName)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &a.PrincipalType)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdministratorPropertiesForAdd.
func (a AdministratorPropertiesForAdd) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalName", a.PrincipalName)
	populate(objectMap, "principalType", a.PrincipalType)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdministratorPropertiesForAdd.
func (a *AdministratorPropertiesForAdd) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalName":
			err = unpopulate(val, "PrincipalName", &a.PrincipalName)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &a.PrincipalType)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthConfig.
func (a AuthConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeDirectoryAuth", a.ActiveDirectoryAuth)
	populate(objectMap, "passwordAuth", a.PasswordAuth)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthConfig.
func (a *AuthConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeDirectoryAuth":
			err = unpopulate(val, "ActiveDirectoryAuth", &a.ActiveDirectoryAuth)
			delete(rawMsg, key)
		case "passwordAuth":
			err = unpopulate(val, "PasswordAuth", &a.PasswordAuth)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Backup.
func (b Backup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupRetentionDays", b.BackupRetentionDays)
	populateDateTimeRFC3339(objectMap, "earliestRestoreDate", b.EarliestRestoreDate)
	populate(objectMap, "geoRedundantBackup", b.GeoRedundantBackup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Backup.
func (b *Backup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupRetentionDays":
			err = unpopulate(val, "BackupRetentionDays", &b.BackupRetentionDays)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateDateTimeRFC3339(val, "EarliestRestoreDate", &b.EarliestRestoreDate)
			delete(rawMsg, key)
		case "geoRedundantBackup":
			err = unpopulate(val, "GeoRedundantBackup", &b.GeoRedundantBackup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupSettings.
func (b BackupSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupName", b.BackupName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupSettings.
func (b *BackupSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupName":
			err = unpopulate(val, "BackupName", &b.BackupName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupStoreDetails.
func (b BackupStoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sasUriList", b.SasURIList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupStoreDetails.
func (b *BackupStoreDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sasUriList":
			err = unpopulate(val, "SasURIList", &b.SasURIList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapabilitiesListResult.
func (c CapabilitiesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapabilitiesListResult.
func (c *CapabilitiesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityRequest.
func (c CheckNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityRequest.
func (c *CheckNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Configuration.
func (c *Configuration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationForUpdate.
func (c ConfigurationForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationForUpdate.
func (c *ConfigurationForUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationListResult.
func (c ConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationListResult.
func (c *ConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationProperties.
func (c ConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedValues", c.AllowedValues)
	populate(objectMap, "dataType", c.DataType)
	populate(objectMap, "defaultValue", c.DefaultValue)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "documentationLink", c.DocumentationLink)
	populate(objectMap, "isConfigPendingRestart", c.IsConfigPendingRestart)
	populate(objectMap, "isDynamicConfig", c.IsDynamicConfig)
	populate(objectMap, "isReadOnly", c.IsReadOnly)
	populate(objectMap, "source", c.Source)
	populate(objectMap, "unit", c.Unit)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationProperties.
func (c *ConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedValues":
			err = unpopulate(val, "AllowedValues", &c.AllowedValues)
			delete(rawMsg, key)
		case "dataType":
			err = unpopulate(val, "DataType", &c.DataType)
			delete(rawMsg, key)
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &c.DefaultValue)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "documentationLink":
			err = unpopulate(val, "DocumentationLink", &c.DocumentationLink)
			delete(rawMsg, key)
		case "isConfigPendingRestart":
			err = unpopulate(val, "IsConfigPendingRestart", &c.IsConfigPendingRestart)
			delete(rawMsg, key)
		case "isDynamicConfig":
			err = unpopulate(val, "IsDynamicConfig", &c.IsDynamicConfig)
			delete(rawMsg, key)
		case "isReadOnly":
			err = unpopulate(val, "IsReadOnly", &c.IsReadOnly)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &c.Unit)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataEncryption.
func (d DataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "geoBackupEncryptionKeyStatus", d.GeoBackupEncryptionKeyStatus)
	populate(objectMap, "geoBackupKeyURI", d.GeoBackupKeyURI)
	populate(objectMap, "geoBackupUserAssignedIdentityId", d.GeoBackupUserAssignedIdentityID)
	populate(objectMap, "primaryEncryptionKeyStatus", d.PrimaryEncryptionKeyStatus)
	populate(objectMap, "primaryKeyURI", d.PrimaryKeyURI)
	populate(objectMap, "primaryUserAssignedIdentityId", d.PrimaryUserAssignedIdentityID)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataEncryption.
func (d *DataEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "geoBackupEncryptionKeyStatus":
			err = unpopulate(val, "GeoBackupEncryptionKeyStatus", &d.GeoBackupEncryptionKeyStatus)
			delete(rawMsg, key)
		case "geoBackupKeyURI":
			err = unpopulate(val, "GeoBackupKeyURI", &d.GeoBackupKeyURI)
			delete(rawMsg, key)
		case "geoBackupUserAssignedIdentityId":
			err = unpopulate(val, "GeoBackupUserAssignedIdentityID", &d.GeoBackupUserAssignedIdentityID)
			delete(rawMsg, key)
		case "primaryEncryptionKeyStatus":
			err = unpopulate(val, "PrimaryEncryptionKeyStatus", &d.PrimaryEncryptionKeyStatus)
			delete(rawMsg, key)
		case "primaryKeyURI":
			err = unpopulate(val, "PrimaryKeyURI", &d.PrimaryKeyURI)
			delete(rawMsg, key)
		case "primaryUserAssignedIdentityId":
			err = unpopulate(val, "PrimaryUserAssignedIdentityID", &d.PrimaryUserAssignedIdentityID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Database.
func (d *Database) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseListResult.
func (d DatabaseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseListResult.
func (d *DatabaseListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseProperties.
func (d DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "charset", d.Charset)
	populate(objectMap, "collation", d.Collation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseProperties.
func (d *DatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "charset":
			err = unpopulate(val, "Charset", &d.Charset)
			delete(rawMsg, key)
		case "collation":
			err = unpopulate(val, "Collation", &d.Collation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DbLevelValidationStatus.
func (d DbLevelValidationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "databaseName", d.DatabaseName)
	populateDateTimeRFC3339(objectMap, "endedOn", d.EndedOn)
	populateDateTimeRFC3339(objectMap, "startedOn", d.StartedOn)
	populate(objectMap, "summary", d.Summary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DbLevelValidationStatus.
func (d *DbLevelValidationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &d.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateDateTimeRFC3339(val, "EndedOn", &d.EndedOn)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateDateTimeRFC3339(val, "StartedOn", &d.StartedOn)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &d.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DbMigrationStatus.
func (d DbMigrationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedChanges", d.AppliedChanges)
	populate(objectMap, "cdcDeleteCounter", d.CdcDeleteCounter)
	populate(objectMap, "cdcInsertCounter", d.CdcInsertCounter)
	populate(objectMap, "cdcUpdateCounter", d.CdcUpdateCounter)
	populate(objectMap, "databaseName", d.DatabaseName)
	populateDateTimeRFC3339(objectMap, "endedOn", d.EndedOn)
	populate(objectMap, "fullLoadCompletedTables", d.FullLoadCompletedTables)
	populate(objectMap, "fullLoadErroredTables", d.FullLoadErroredTables)
	populate(objectMap, "fullLoadLoadingTables", d.FullLoadLoadingTables)
	populate(objectMap, "fullLoadQueuedTables", d.FullLoadQueuedTables)
	populate(objectMap, "incomingChanges", d.IncomingChanges)
	populate(objectMap, "latency", d.Latency)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "migrationOperation", d.MigrationOperation)
	populate(objectMap, "migrationState", d.MigrationState)
	populateDateTimeRFC3339(objectMap, "startedOn", d.StartedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DbMigrationStatus.
func (d *DbMigrationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedChanges":
			err = unpopulate(val, "AppliedChanges", &d.AppliedChanges)
			delete(rawMsg, key)
		case "cdcDeleteCounter":
			err = unpopulate(val, "CdcDeleteCounter", &d.CdcDeleteCounter)
			delete(rawMsg, key)
		case "cdcInsertCounter":
			err = unpopulate(val, "CdcInsertCounter", &d.CdcInsertCounter)
			delete(rawMsg, key)
		case "cdcUpdateCounter":
			err = unpopulate(val, "CdcUpdateCounter", &d.CdcUpdateCounter)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &d.DatabaseName)
			delete(rawMsg, key)
		case "endedOn":
			err = unpopulateDateTimeRFC3339(val, "EndedOn", &d.EndedOn)
			delete(rawMsg, key)
		case "fullLoadCompletedTables":
			err = unpopulate(val, "FullLoadCompletedTables", &d.FullLoadCompletedTables)
			delete(rawMsg, key)
		case "fullLoadErroredTables":
			err = unpopulate(val, "FullLoadErroredTables", &d.FullLoadErroredTables)
			delete(rawMsg, key)
		case "fullLoadLoadingTables":
			err = unpopulate(val, "FullLoadLoadingTables", &d.FullLoadLoadingTables)
			delete(rawMsg, key)
		case "fullLoadQueuedTables":
			err = unpopulate(val, "FullLoadQueuedTables", &d.FullLoadQueuedTables)
			delete(rawMsg, key)
		case "incomingChanges":
			err = unpopulate(val, "IncomingChanges", &d.IncomingChanges)
			delete(rawMsg, key)
		case "latency":
			err = unpopulate(val, "Latency", &d.Latency)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "migrationOperation":
			err = unpopulate(val, "MigrationOperation", &d.MigrationOperation)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &d.MigrationState)
			delete(rawMsg, key)
		case "startedOn":
			err = unpopulateDateTimeRFC3339(val, "StartedOn", &d.StartedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DbServerMetadata.
func (d DbServerMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "storageMb", d.StorageMb)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DbServerMetadata.
func (d *DbServerMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "storageMb":
			err = unpopulate(val, "StorageMb", &d.StorageMb)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelegatedSubnetUsage.
func (d DelegatedSubnetUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subnetName", d.SubnetName)
	populate(objectMap, "usage", d.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelegatedSubnetUsage.
func (d *DelegatedSubnetUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subnetName":
			err = unpopulate(val, "SubnetName", &d.SubnetName)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &d.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FastProvisioningEditionCapability.
func (f FastProvisioningEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reason", f.Reason)
	populate(objectMap, "serverCount", f.ServerCount)
	populate(objectMap, "status", f.Status)
	populate(objectMap, "supportedSku", f.SupportedSKU)
	populate(objectMap, "supportedServerVersions", f.SupportedServerVersions)
	populate(objectMap, "supportedStorageGb", f.SupportedStorageGb)
	populate(objectMap, "supportedTier", f.SupportedTier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FastProvisioningEditionCapability.
func (f *FastProvisioningEditionCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reason":
			err = unpopulate(val, "Reason", &f.Reason)
			delete(rawMsg, key)
		case "serverCount":
			err = unpopulate(val, "ServerCount", &f.ServerCount)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &f.Status)
			delete(rawMsg, key)
		case "supportedSku":
			err = unpopulate(val, "SupportedSKU", &f.SupportedSKU)
			delete(rawMsg, key)
		case "supportedServerVersions":
			err = unpopulate(val, "SupportedServerVersions", &f.SupportedServerVersions)
			delete(rawMsg, key)
		case "supportedStorageGb":
			err = unpopulate(val, "SupportedStorageGb", &f.SupportedStorageGb)
			delete(rawMsg, key)
		case "supportedTier":
			err = unpopulate(val, "SupportedTier", &f.SupportedTier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallRule.
func (f FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallRule.
func (f *FirewallRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallRuleListResult.
func (f FirewallRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallRuleListResult.
func (f *FirewallRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallRuleProperties.
func (f FirewallRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endIpAddress", f.EndIPAddress)
	populate(objectMap, "startIpAddress", f.StartIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallRuleProperties.
func (f *FirewallRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endIpAddress":
			err = unpopulate(val, "EndIPAddress", &f.EndIPAddress)
			delete(rawMsg, key)
		case "startIpAddress":
			err = unpopulate(val, "StartIPAddress", &f.StartIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlexibleServerCapability.
func (f FlexibleServerCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fastProvisioningSupported", f.FastProvisioningSupported)
	populate(objectMap, "geoBackupSupported", f.GeoBackupSupported)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "onlineResizeSupported", f.OnlineResizeSupported)
	populate(objectMap, "reason", f.Reason)
	populate(objectMap, "restricted", f.Restricted)
	populate(objectMap, "status", f.Status)
	populate(objectMap, "storageAutoGrowthSupported", f.StorageAutoGrowthSupported)
	populate(objectMap, "supportedFastProvisioningEditions", f.SupportedFastProvisioningEditions)
	populate(objectMap, "supportedServerEditions", f.SupportedServerEditions)
	populate(objectMap, "supportedServerVersions", f.SupportedServerVersions)
	populate(objectMap, "zoneRedundantHaAndGeoBackupSupported", f.ZoneRedundantHaAndGeoBackupSupported)
	populate(objectMap, "zoneRedundantHaSupported", f.ZoneRedundantHaSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlexibleServerCapability.
func (f *FlexibleServerCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fastProvisioningSupported":
			err = unpopulate(val, "FastProvisioningSupported", &f.FastProvisioningSupported)
			delete(rawMsg, key)
		case "geoBackupSupported":
			err = unpopulate(val, "GeoBackupSupported", &f.GeoBackupSupported)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "onlineResizeSupported":
			err = unpopulate(val, "OnlineResizeSupported", &f.OnlineResizeSupported)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &f.Reason)
			delete(rawMsg, key)
		case "restricted":
			err = unpopulate(val, "Restricted", &f.Restricted)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &f.Status)
			delete(rawMsg, key)
		case "storageAutoGrowthSupported":
			err = unpopulate(val, "StorageAutoGrowthSupported", &f.StorageAutoGrowthSupported)
			delete(rawMsg, key)
		case "supportedFastProvisioningEditions":
			err = unpopulate(val, "SupportedFastProvisioningEditions", &f.SupportedFastProvisioningEditions)
			delete(rawMsg, key)
		case "supportedServerEditions":
			err = unpopulate(val, "SupportedServerEditions", &f.SupportedServerEditions)
			delete(rawMsg, key)
		case "supportedServerVersions":
			err = unpopulate(val, "SupportedServerVersions", &f.SupportedServerVersions)
			delete(rawMsg, key)
		case "zoneRedundantHaAndGeoBackupSupported":
			err = unpopulate(val, "ZoneRedundantHaAndGeoBackupSupported", &f.ZoneRedundantHaAndGeoBackupSupported)
			delete(rawMsg, key)
		case "zoneRedundantHaSupported":
			err = unpopulate(val, "ZoneRedundantHaSupported", &f.ZoneRedundantHaSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlexibleServerEditionCapability.
func (f FlexibleServerEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultSkuName", f.DefaultSKUName)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "reason", f.Reason)
	populate(objectMap, "status", f.Status)
	populate(objectMap, "supportedServerSkus", f.SupportedServerSKUs)
	populate(objectMap, "supportedStorageEditions", f.SupportedStorageEditions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlexibleServerEditionCapability.
func (f *FlexibleServerEditionCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultSkuName":
			err = unpopulate(val, "DefaultSKUName", &f.DefaultSKUName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &f.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &f.Status)
			delete(rawMsg, key)
		case "supportedServerSkus":
			err = unpopulate(val, "SupportedServerSKUs", &f.SupportedServerSKUs)
			delete(rawMsg, key)
		case "supportedStorageEditions":
			err = unpopulate(val, "SupportedStorageEditions", &f.SupportedStorageEditions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HighAvailability.
func (h HighAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mode", h.Mode)
	populate(objectMap, "standbyAvailabilityZone", h.StandbyAvailabilityZone)
	populate(objectMap, "state", h.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HighAvailability.
func (h *HighAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &h.Mode)
			delete(rawMsg, key)
		case "standbyAvailabilityZone":
			err = unpopulate(val, "StandbyAvailabilityZone", &h.StandbyAvailabilityZone)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &h.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogFile.
func (l LogFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogFile.
func (l *LogFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogFileListResult.
func (l LogFileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogFileListResult.
func (l *LogFileListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogFileProperties.
func (l LogFileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdTime", l.CreatedTime)
	populateDateTimeRFC3339(objectMap, "lastModifiedTime", l.LastModifiedTime)
	populate(objectMap, "sizeInKb", l.SizeInKb)
	populate(objectMap, "type", l.Type)
	populate(objectMap, "url", l.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogFileProperties.
func (l *LogFileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &l.CreatedTime)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTime", &l.LastModifiedTime)
			delete(rawMsg, key)
		case "sizeInKb":
			err = unpopulate(val, "SizeInKb", &l.SizeInKb)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &l.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LtrBackupOperationResponseProperties.
func (l LtrBackupOperationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupMetadata", l.BackupMetadata)
	populate(objectMap, "backupName", l.BackupName)
	populate(objectMap, "dataTransferredInBytes", l.DataTransferredInBytes)
	populate(objectMap, "datasourceSizeInBytes", l.DatasourceSizeInBytes)
	populateDateTimeRFC3339(objectMap, "endTime", l.EndTime)
	populate(objectMap, "errorCode", l.ErrorCode)
	populate(objectMap, "errorMessage", l.ErrorMessage)
	populate(objectMap, "percentComplete", l.PercentComplete)
	populateDateTimeRFC3339(objectMap, "startTime", l.StartTime)
	populate(objectMap, "status", l.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LtrBackupOperationResponseProperties.
func (l *LtrBackupOperationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupMetadata":
			err = unpopulate(val, "BackupMetadata", &l.BackupMetadata)
			delete(rawMsg, key)
		case "backupName":
			err = unpopulate(val, "BackupName", &l.BackupName)
			delete(rawMsg, key)
		case "dataTransferredInBytes":
			err = unpopulate(val, "DataTransferredInBytes", &l.DataTransferredInBytes)
			delete(rawMsg, key)
		case "datasourceSizeInBytes":
			err = unpopulate(val, "DatasourceSizeInBytes", &l.DatasourceSizeInBytes)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &l.EndTime)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &l.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &l.ErrorMessage)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &l.PercentComplete)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &l.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LtrBackupRequest.
func (l LtrBackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupSettings", l.BackupSettings)
	populate(objectMap, "targetDetails", l.TargetDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LtrBackupRequest.
func (l *LtrBackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupSettings":
			err = unpopulate(val, "BackupSettings", &l.BackupSettings)
			delete(rawMsg, key)
		case "targetDetails":
			err = unpopulate(val, "TargetDetails", &l.TargetDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LtrBackupResponse.
func (l LtrBackupResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LtrBackupResponse.
func (l *LtrBackupResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LtrPreBackupRequest.
func (l LtrPreBackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupSettings", l.BackupSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LtrPreBackupRequest.
func (l *LtrPreBackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupSettings":
			err = unpopulate(val, "BackupSettings", &l.BackupSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LtrPreBackupResponse.
func (l LtrPreBackupResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LtrPreBackupResponse.
func (l *LtrPreBackupResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LtrPreBackupResponseProperties.
func (l LtrPreBackupResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "numberOfContainers", l.NumberOfContainers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LtrPreBackupResponseProperties.
func (l *LtrPreBackupResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "numberOfContainers":
			err = unpopulate(val, "NumberOfContainers", &l.NumberOfContainers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LtrServerBackupOperation.
func (l LtrServerBackupOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LtrServerBackupOperation.
func (l *LtrServerBackupOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LtrServerBackupOperationList.
func (l LtrServerBackupOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LtrServerBackupOperationList.
func (l *LtrServerBackupOperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindow.
func (m MaintenanceWindow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customWindow", m.CustomWindow)
	populate(objectMap, "dayOfWeek", m.DayOfWeek)
	populate(objectMap, "startHour", m.StartHour)
	populate(objectMap, "startMinute", m.StartMinute)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindow.
func (m *MaintenanceWindow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customWindow":
			err = unpopulate(val, "CustomWindow", &m.CustomWindow)
			delete(rawMsg, key)
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &m.DayOfWeek)
			delete(rawMsg, key)
		case "startHour":
			err = unpopulate(val, "StartHour", &m.StartHour)
			delete(rawMsg, key)
		case "startMinute":
			err = unpopulate(val, "StartMinute", &m.StartMinute)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationNameAvailabilityResource.
func (m MigrationNameAvailabilityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "nameAvailable", m.NameAvailable)
	populate(objectMap, "reason", m.Reason)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationNameAvailabilityResource.
func (m *MigrationNameAvailabilityResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &m.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &m.Reason)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationResource.
func (m MigrationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationResource.
func (m *MigrationResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationResourceForPatch.
func (m MigrationResourceForPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationResourceForPatch.
func (m *MigrationResourceForPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationResourceListResult.
func (m MigrationResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationResourceListResult.
func (m *MigrationResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationResourceProperties.
func (m MigrationResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cancel", m.Cancel)
	populate(objectMap, "currentStatus", m.CurrentStatus)
	populate(objectMap, "dbsToCancelMigrationOn", m.DbsToCancelMigrationOn)
	populate(objectMap, "dbsToMigrate", m.DbsToMigrate)
	populate(objectMap, "dbsToTriggerCutoverOn", m.DbsToTriggerCutoverOn)
	populate(objectMap, "migrateRoles", m.MigrateRoles)
	populate(objectMap, "migrationId", m.MigrationID)
	populate(objectMap, "migrationInstanceResourceId", m.MigrationInstanceResourceID)
	populate(objectMap, "migrationMode", m.MigrationMode)
	populate(objectMap, "migrationOption", m.MigrationOption)
	populateDateTimeRFC3339(objectMap, "migrationWindowEndTimeInUtc", m.MigrationWindowEndTimeInUTC)
	populateDateTimeRFC3339(objectMap, "migrationWindowStartTimeInUtc", m.MigrationWindowStartTimeInUTC)
	populate(objectMap, "overwriteDbsInTarget", m.OverwriteDbsInTarget)
	populate(objectMap, "sslMode", m.SSLMode)
	populate(objectMap, "secretParameters", m.SecretParameters)
	populate(objectMap, "setupLogicalReplicationOnSourceDbIfNeeded", m.SetupLogicalReplicationOnSourceDbIfNeeded)
	populate(objectMap, "sourceDbServerFullyQualifiedDomainName", m.SourceDbServerFullyQualifiedDomainName)
	populate(objectMap, "sourceDbServerMetadata", m.SourceDbServerMetadata)
	populate(objectMap, "sourceDbServerResourceId", m.SourceDbServerResourceID)
	populate(objectMap, "sourceType", m.SourceType)
	populate(objectMap, "startDataMigration", m.StartDataMigration)
	populate(objectMap, "targetDbServerFullyQualifiedDomainName", m.TargetDbServerFullyQualifiedDomainName)
	populate(objectMap, "targetDbServerMetadata", m.TargetDbServerMetadata)
	populate(objectMap, "targetDbServerResourceId", m.TargetDbServerResourceID)
	populate(objectMap, "triggerCutover", m.TriggerCutover)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationResourceProperties.
func (m *MigrationResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancel":
			err = unpopulate(val, "Cancel", &m.Cancel)
			delete(rawMsg, key)
		case "currentStatus":
			err = unpopulate(val, "CurrentStatus", &m.CurrentStatus)
			delete(rawMsg, key)
		case "dbsToCancelMigrationOn":
			err = unpopulate(val, "DbsToCancelMigrationOn", &m.DbsToCancelMigrationOn)
			delete(rawMsg, key)
		case "dbsToMigrate":
			err = unpopulate(val, "DbsToMigrate", &m.DbsToMigrate)
			delete(rawMsg, key)
		case "dbsToTriggerCutoverOn":
			err = unpopulate(val, "DbsToTriggerCutoverOn", &m.DbsToTriggerCutoverOn)
			delete(rawMsg, key)
		case "migrateRoles":
			err = unpopulate(val, "MigrateRoles", &m.MigrateRoles)
			delete(rawMsg, key)
		case "migrationId":
			err = unpopulate(val, "MigrationID", &m.MigrationID)
			delete(rawMsg, key)
		case "migrationInstanceResourceId":
			err = unpopulate(val, "MigrationInstanceResourceID", &m.MigrationInstanceResourceID)
			delete(rawMsg, key)
		case "migrationMode":
			err = unpopulate(val, "MigrationMode", &m.MigrationMode)
			delete(rawMsg, key)
		case "migrationOption":
			err = unpopulate(val, "MigrationOption", &m.MigrationOption)
			delete(rawMsg, key)
		case "migrationWindowEndTimeInUtc":
			err = unpopulateDateTimeRFC3339(val, "MigrationWindowEndTimeInUTC", &m.MigrationWindowEndTimeInUTC)
			delete(rawMsg, key)
		case "migrationWindowStartTimeInUtc":
			err = unpopulateDateTimeRFC3339(val, "MigrationWindowStartTimeInUTC", &m.MigrationWindowStartTimeInUTC)
			delete(rawMsg, key)
		case "overwriteDbsInTarget":
			err = unpopulate(val, "OverwriteDbsInTarget", &m.OverwriteDbsInTarget)
			delete(rawMsg, key)
		case "sslMode":
			err = unpopulate(val, "SSLMode", &m.SSLMode)
			delete(rawMsg, key)
		case "secretParameters":
			err = unpopulate(val, "SecretParameters", &m.SecretParameters)
			delete(rawMsg, key)
		case "setupLogicalReplicationOnSourceDbIfNeeded":
			err = unpopulate(val, "SetupLogicalReplicationOnSourceDbIfNeeded", &m.SetupLogicalReplicationOnSourceDbIfNeeded)
			delete(rawMsg, key)
		case "sourceDbServerFullyQualifiedDomainName":
			err = unpopulate(val, "SourceDbServerFullyQualifiedDomainName", &m.SourceDbServerFullyQualifiedDomainName)
			delete(rawMsg, key)
		case "sourceDbServerMetadata":
			err = unpopulate(val, "SourceDbServerMetadata", &m.SourceDbServerMetadata)
			delete(rawMsg, key)
		case "sourceDbServerResourceId":
			err = unpopulate(val, "SourceDbServerResourceID", &m.SourceDbServerResourceID)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &m.SourceType)
			delete(rawMsg, key)
		case "startDataMigration":
			err = unpopulate(val, "StartDataMigration", &m.StartDataMigration)
			delete(rawMsg, key)
		case "targetDbServerFullyQualifiedDomainName":
			err = unpopulate(val, "TargetDbServerFullyQualifiedDomainName", &m.TargetDbServerFullyQualifiedDomainName)
			delete(rawMsg, key)
		case "targetDbServerMetadata":
			err = unpopulate(val, "TargetDbServerMetadata", &m.TargetDbServerMetadata)
			delete(rawMsg, key)
		case "targetDbServerResourceId":
			err = unpopulate(val, "TargetDbServerResourceID", &m.TargetDbServerResourceID)
			delete(rawMsg, key)
		case "triggerCutover":
			err = unpopulate(val, "TriggerCutover", &m.TriggerCutover)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationResourcePropertiesForPatch.
func (m MigrationResourcePropertiesForPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cancel", m.Cancel)
	populate(objectMap, "dbsToCancelMigrationOn", m.DbsToCancelMigrationOn)
	populate(objectMap, "dbsToMigrate", m.DbsToMigrate)
	populate(objectMap, "dbsToTriggerCutoverOn", m.DbsToTriggerCutoverOn)
	populate(objectMap, "migrateRoles", m.MigrateRoles)
	populate(objectMap, "migrationMode", m.MigrationMode)
	populateDateTimeRFC3339(objectMap, "migrationWindowStartTimeInUtc", m.MigrationWindowStartTimeInUTC)
	populate(objectMap, "overwriteDbsInTarget", m.OverwriteDbsInTarget)
	populate(objectMap, "secretParameters", m.SecretParameters)
	populate(objectMap, "setupLogicalReplicationOnSourceDbIfNeeded", m.SetupLogicalReplicationOnSourceDbIfNeeded)
	populate(objectMap, "sourceDbServerFullyQualifiedDomainName", m.SourceDbServerFullyQualifiedDomainName)
	populate(objectMap, "sourceDbServerResourceId", m.SourceDbServerResourceID)
	populate(objectMap, "startDataMigration", m.StartDataMigration)
	populate(objectMap, "targetDbServerFullyQualifiedDomainName", m.TargetDbServerFullyQualifiedDomainName)
	populate(objectMap, "triggerCutover", m.TriggerCutover)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationResourcePropertiesForPatch.
func (m *MigrationResourcePropertiesForPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancel":
			err = unpopulate(val, "Cancel", &m.Cancel)
			delete(rawMsg, key)
		case "dbsToCancelMigrationOn":
			err = unpopulate(val, "DbsToCancelMigrationOn", &m.DbsToCancelMigrationOn)
			delete(rawMsg, key)
		case "dbsToMigrate":
			err = unpopulate(val, "DbsToMigrate", &m.DbsToMigrate)
			delete(rawMsg, key)
		case "dbsToTriggerCutoverOn":
			err = unpopulate(val, "DbsToTriggerCutoverOn", &m.DbsToTriggerCutoverOn)
			delete(rawMsg, key)
		case "migrateRoles":
			err = unpopulate(val, "MigrateRoles", &m.MigrateRoles)
			delete(rawMsg, key)
		case "migrationMode":
			err = unpopulate(val, "MigrationMode", &m.MigrationMode)
			delete(rawMsg, key)
		case "migrationWindowStartTimeInUtc":
			err = unpopulateDateTimeRFC3339(val, "MigrationWindowStartTimeInUTC", &m.MigrationWindowStartTimeInUTC)
			delete(rawMsg, key)
		case "overwriteDbsInTarget":
			err = unpopulate(val, "OverwriteDbsInTarget", &m.OverwriteDbsInTarget)
			delete(rawMsg, key)
		case "secretParameters":
			err = unpopulate(val, "SecretParameters", &m.SecretParameters)
			delete(rawMsg, key)
		case "setupLogicalReplicationOnSourceDbIfNeeded":
			err = unpopulate(val, "SetupLogicalReplicationOnSourceDbIfNeeded", &m.SetupLogicalReplicationOnSourceDbIfNeeded)
			delete(rawMsg, key)
		case "sourceDbServerFullyQualifiedDomainName":
			err = unpopulate(val, "SourceDbServerFullyQualifiedDomainName", &m.SourceDbServerFullyQualifiedDomainName)
			delete(rawMsg, key)
		case "sourceDbServerResourceId":
			err = unpopulate(val, "SourceDbServerResourceID", &m.SourceDbServerResourceID)
			delete(rawMsg, key)
		case "startDataMigration":
			err = unpopulate(val, "StartDataMigration", &m.StartDataMigration)
			delete(rawMsg, key)
		case "targetDbServerFullyQualifiedDomainName":
			err = unpopulate(val, "TargetDbServerFullyQualifiedDomainName", &m.TargetDbServerFullyQualifiedDomainName)
			delete(rawMsg, key)
		case "triggerCutover":
			err = unpopulate(val, "TriggerCutover", &m.TriggerCutover)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationSecretParameters.
func (m MigrationSecretParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminCredentials", m.AdminCredentials)
	populate(objectMap, "sourceServerUsername", m.SourceServerUsername)
	populate(objectMap, "targetServerUsername", m.TargetServerUsername)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationSecretParameters.
func (m *MigrationSecretParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminCredentials":
			err = unpopulate(val, "AdminCredentials", &m.AdminCredentials)
			delete(rawMsg, key)
		case "sourceServerUsername":
			err = unpopulate(val, "SourceServerUsername", &m.SourceServerUsername)
			delete(rawMsg, key)
		case "targetServerUsername":
			err = unpopulate(val, "TargetServerUsername", &m.TargetServerUsername)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationStatus.
func (m MigrationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentSubStateDetails", m.CurrentSubStateDetails)
	populate(objectMap, "error", m.Error)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationStatus.
func (m *MigrationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentSubStateDetails":
			err = unpopulate(val, "CurrentSubStateDetails", &m.CurrentSubStateDetails)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationSubStateDetails.
func (m MigrationSubStateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentSubState", m.CurrentSubState)
	populate(objectMap, "dbDetails", m.DbDetails)
	populate(objectMap, "validationDetails", m.ValidationDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationSubStateDetails.
func (m *MigrationSubStateDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentSubState":
			err = unpopulate(val, "CurrentSubState", &m.CurrentSubState)
			delete(rawMsg, key)
		case "dbDetails":
			err = unpopulate(val, "DbDetails", &m.DbDetails)
			delete(rawMsg, key)
		case "validationDetails":
			err = unpopulate(val, "ValidationDetails", &m.ValidationDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameAvailability.
func (n NameAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", n.Message)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "nameAvailable", n.NameAvailable)
	populate(objectMap, "reason", n.Reason)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameAvailability.
func (n *NameAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &n.Message)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &n.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &n.Reason)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameProperty.
func (n NameProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", n.LocalizedValue)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameProperty.
func (n *NameProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &n.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Network.
func (n Network) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delegatedSubnetResourceId", n.DelegatedSubnetResourceID)
	populate(objectMap, "privateDnsZoneArmResourceId", n.PrivateDNSZoneArmResourceID)
	populate(objectMap, "publicNetworkAccess", n.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Network.
func (n *Network) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delegatedSubnetResourceId":
			err = unpopulate(val, "DelegatedSubnetResourceID", &n.DelegatedSubnetResourceID)
			delete(rawMsg, key)
		case "privateDnsZoneArmResourceId":
			err = unpopulate(val, "PrivateDNSZoneArmResourceID", &n.PrivateDNSZoneArmResourceID)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &n.PublicNetworkAccess)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupIds":
			err = unpopulate(val, "GroupIDs", &p.GroupIDs)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaUsage.
func (q QuotaUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", q.CurrentValue)
	populate(objectMap, "id", q.ID)
	populate(objectMap, "limit", q.Limit)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "unit", q.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaUsage.
func (q *QuotaUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &q.CurrentValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &q.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &q.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaUsagesListResult.
func (q QuotaUsagesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", q.NextLink)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaUsagesListResult.
func (q *QuotaUsagesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &q.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Replica.
func (r Replica) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", r.Capacity)
	populate(objectMap, "promoteMode", r.PromoteMode)
	populate(objectMap, "promoteOption", r.PromoteOption)
	populate(objectMap, "replicationState", r.ReplicationState)
	populate(objectMap, "role", r.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Replica.
func (r *Replica) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &r.Capacity)
			delete(rawMsg, key)
		case "promoteMode":
			err = unpopulate(val, "PromoteMode", &r.PromoteMode)
			delete(rawMsg, key)
		case "promoteOption":
			err = unpopulate(val, "PromoteOption", &r.PromoteOption)
			delete(rawMsg, key)
		case "replicationState":
			err = unpopulate(val, "ReplicationState", &r.ReplicationState)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &r.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestartParameter.
func (r RestartParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failoverMode", r.FailoverMode)
	populate(objectMap, "restartWithFailover", r.RestartWithFailover)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestartParameter.
func (r *RestartParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverMode":
			err = unpopulate(val, "FailoverMode", &r.FailoverMode)
			delete(rawMsg, key)
		case "restartWithFailover":
			err = unpopulate(val, "RestartWithFailover", &r.RestartWithFailover)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Server.
func (s *Server) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerBackup.
func (s ServerBackup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerBackup.
func (s *ServerBackup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerBackupListResult.
func (s ServerBackupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerBackupListResult.
func (s *ServerBackupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerBackupProperties.
func (s ServerBackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupType", s.BackupType)
	populateDateTimeRFC3339(objectMap, "completedTime", s.CompletedTime)
	populate(objectMap, "source", s.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerBackupProperties.
func (s *ServerBackupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupType":
			err = unpopulate(val, "BackupType", &s.BackupType)
			delete(rawMsg, key)
		case "completedTime":
			err = unpopulateDateTimeRFC3339(val, "CompletedTime", &s.CompletedTime)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &s.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerForUpdate.
func (s ServerForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerForUpdate.
func (s *ServerForUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerListResult.
func (s ServerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerListResult.
func (s *ServerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerProperties.
func (s ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorLogin", s.AdministratorLogin)
	populate(objectMap, "administratorLoginPassword", s.AdministratorLoginPassword)
	populate(objectMap, "authConfig", s.AuthConfig)
	populate(objectMap, "availabilityZone", s.AvailabilityZone)
	populate(objectMap, "backup", s.Backup)
	populate(objectMap, "createMode", s.CreateMode)
	populate(objectMap, "dataEncryption", s.DataEncryption)
	populate(objectMap, "fullyQualifiedDomainName", s.FullyQualifiedDomainName)
	populate(objectMap, "highAvailability", s.HighAvailability)
	populate(objectMap, "maintenanceWindow", s.MaintenanceWindow)
	populate(objectMap, "minorVersion", s.MinorVersion)
	populate(objectMap, "network", s.Network)
	populateDateTimeRFC3339(objectMap, "pointInTimeUTC", s.PointInTimeUTC)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "replica", s.Replica)
	populate(objectMap, "replicaCapacity", s.ReplicaCapacity)
	populate(objectMap, "replicationRole", s.ReplicationRole)
	populate(objectMap, "sourceServerResourceId", s.SourceServerResourceID)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storage", s.Storage)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerProperties.
func (s *ServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorLogin":
			err = unpopulate(val, "AdministratorLogin", &s.AdministratorLogin)
			delete(rawMsg, key)
		case "administratorLoginPassword":
			err = unpopulate(val, "AdministratorLoginPassword", &s.AdministratorLoginPassword)
			delete(rawMsg, key)
		case "authConfig":
			err = unpopulate(val, "AuthConfig", &s.AuthConfig)
			delete(rawMsg, key)
		case "availabilityZone":
			err = unpopulate(val, "AvailabilityZone", &s.AvailabilityZone)
			delete(rawMsg, key)
		case "backup":
			err = unpopulate(val, "Backup", &s.Backup)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "dataEncryption":
			err = unpopulate(val, "DataEncryption", &s.DataEncryption)
			delete(rawMsg, key)
		case "fullyQualifiedDomainName":
			err = unpopulate(val, "FullyQualifiedDomainName", &s.FullyQualifiedDomainName)
			delete(rawMsg, key)
		case "highAvailability":
			err = unpopulate(val, "HighAvailability", &s.HighAvailability)
			delete(rawMsg, key)
		case "maintenanceWindow":
			err = unpopulate(val, "MaintenanceWindow", &s.MaintenanceWindow)
			delete(rawMsg, key)
		case "minorVersion":
			err = unpopulate(val, "MinorVersion", &s.MinorVersion)
			delete(rawMsg, key)
		case "network":
			err = unpopulate(val, "Network", &s.Network)
			delete(rawMsg, key)
		case "pointInTimeUTC":
			err = unpopulateDateTimeRFC3339(val, "PointInTimeUTC", &s.PointInTimeUTC)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "replica":
			err = unpopulate(val, "Replica", &s.Replica)
			delete(rawMsg, key)
		case "replicaCapacity":
			err = unpopulate(val, "ReplicaCapacity", &s.ReplicaCapacity)
			delete(rawMsg, key)
		case "replicationRole":
			err = unpopulate(val, "ReplicationRole", &s.ReplicationRole)
			delete(rawMsg, key)
		case "sourceServerResourceId":
			err = unpopulate(val, "SourceServerResourceID", &s.SourceServerResourceID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storage":
			err = unpopulate(val, "Storage", &s.Storage)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerPropertiesForUpdate.
func (s ServerPropertiesForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorLoginPassword", s.AdministratorLoginPassword)
	populate(objectMap, "authConfig", s.AuthConfig)
	populate(objectMap, "backup", s.Backup)
	populate(objectMap, "createMode", s.CreateMode)
	populate(objectMap, "dataEncryption", s.DataEncryption)
	populate(objectMap, "highAvailability", s.HighAvailability)
	populate(objectMap, "maintenanceWindow", s.MaintenanceWindow)
	populate(objectMap, "network", s.Network)
	populate(objectMap, "replica", s.Replica)
	populate(objectMap, "replicationRole", s.ReplicationRole)
	populate(objectMap, "storage", s.Storage)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerPropertiesForUpdate.
func (s *ServerPropertiesForUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorLoginPassword":
			err = unpopulate(val, "AdministratorLoginPassword", &s.AdministratorLoginPassword)
			delete(rawMsg, key)
		case "authConfig":
			err = unpopulate(val, "AuthConfig", &s.AuthConfig)
			delete(rawMsg, key)
		case "backup":
			err = unpopulate(val, "Backup", &s.Backup)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "dataEncryption":
			err = unpopulate(val, "DataEncryption", &s.DataEncryption)
			delete(rawMsg, key)
		case "highAvailability":
			err = unpopulate(val, "HighAvailability", &s.HighAvailability)
			delete(rawMsg, key)
		case "maintenanceWindow":
			err = unpopulate(val, "MaintenanceWindow", &s.MaintenanceWindow)
			delete(rawMsg, key)
		case "network":
			err = unpopulate(val, "Network", &s.Network)
			delete(rawMsg, key)
		case "replica":
			err = unpopulate(val, "Replica", &s.Replica)
			delete(rawMsg, key)
		case "replicationRole":
			err = unpopulate(val, "ReplicationRole", &s.ReplicationRole)
			delete(rawMsg, key)
		case "storage":
			err = unpopulate(val, "Storage", &s.Storage)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerSKU.
func (s ServerSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerSKU.
func (s *ServerSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerSKUCapability.
func (s ServerSKUCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "reason", s.Reason)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "supportedHaMode", s.SupportedHaMode)
	populate(objectMap, "supportedIops", s.SupportedIops)
	populate(objectMap, "supportedMemoryPerVcoreMb", s.SupportedMemoryPerVcoreMb)
	populate(objectMap, "supportedZones", s.SupportedZones)
	populate(objectMap, "vCores", s.VCores)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerSKUCapability.
func (s *ServerSKUCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &s.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "supportedHaMode":
			err = unpopulate(val, "SupportedHaMode", &s.SupportedHaMode)
			delete(rawMsg, key)
		case "supportedIops":
			err = unpopulate(val, "SupportedIops", &s.SupportedIops)
			delete(rawMsg, key)
		case "supportedMemoryPerVcoreMb":
			err = unpopulate(val, "SupportedMemoryPerVcoreMb", &s.SupportedMemoryPerVcoreMb)
			delete(rawMsg, key)
		case "supportedZones":
			err = unpopulate(val, "SupportedZones", &s.SupportedZones)
			delete(rawMsg, key)
		case "vCores":
			err = unpopulate(val, "VCores", &s.VCores)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerThreatProtectionListResult.
func (s ServerThreatProtectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerThreatProtectionListResult.
func (s *ServerThreatProtectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerThreatProtectionProperties.
func (s ServerThreatProtectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerThreatProtectionProperties.
func (s *ServerThreatProtectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerThreatProtectionSettingsModel.
func (s ServerThreatProtectionSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerThreatProtectionSettingsModel.
func (s *ServerThreatProtectionSettingsModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerVersionCapability.
func (s ServerVersionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "reason", s.Reason)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "supportedVersionsToUpgrade", s.SupportedVersionsToUpgrade)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVersionCapability.
func (s *ServerVersionCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &s.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "supportedVersionsToUpgrade":
			err = unpopulate(val, "SupportedVersionsToUpgrade", &s.SupportedVersionsToUpgrade)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Storage.
func (s Storage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoGrow", s.AutoGrow)
	populate(objectMap, "iops", s.Iops)
	populate(objectMap, "storageSizeGB", s.StorageSizeGB)
	populate(objectMap, "throughput", s.Throughput)
	populate(objectMap, "tier", s.Tier)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Storage.
func (s *Storage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoGrow":
			err = unpopulate(val, "AutoGrow", &s.AutoGrow)
			delete(rawMsg, key)
		case "iops":
			err = unpopulate(val, "Iops", &s.Iops)
			delete(rawMsg, key)
		case "storageSizeGB":
			err = unpopulate(val, "StorageSizeGB", &s.StorageSizeGB)
			delete(rawMsg, key)
		case "throughput":
			err = unpopulate(val, "Throughput", &s.Throughput)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageEditionCapability.
func (s StorageEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultStorageSizeMb", s.DefaultStorageSizeMb)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "reason", s.Reason)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "supportedStorageMb", s.SupportedStorageMb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageEditionCapability.
func (s *StorageEditionCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultStorageSizeMb":
			err = unpopulate(val, "DefaultStorageSizeMb", &s.DefaultStorageSizeMb)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &s.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "supportedStorageMb":
			err = unpopulate(val, "SupportedStorageMb", &s.SupportedStorageMb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMbCapability.
func (s StorageMbCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultIopsTier", s.DefaultIopsTier)
	populate(objectMap, "maximumStorageSizeMb", s.MaximumStorageSizeMb)
	populate(objectMap, "reason", s.Reason)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "storageSizeMb", s.StorageSizeMb)
	populate(objectMap, "supportedIops", s.SupportedIops)
	populate(objectMap, "supportedIopsTiers", s.SupportedIopsTiers)
	populate(objectMap, "supportedMaximumIops", s.SupportedMaximumIops)
	populate(objectMap, "supportedMaximumThroughput", s.SupportedMaximumThroughput)
	populate(objectMap, "supportedThroughput", s.SupportedThroughput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMbCapability.
func (s *StorageMbCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultIopsTier":
			err = unpopulate(val, "DefaultIopsTier", &s.DefaultIopsTier)
			delete(rawMsg, key)
		case "maximumStorageSizeMb":
			err = unpopulate(val, "MaximumStorageSizeMb", &s.MaximumStorageSizeMb)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &s.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "storageSizeMb":
			err = unpopulate(val, "StorageSizeMb", &s.StorageSizeMb)
			delete(rawMsg, key)
		case "supportedIops":
			err = unpopulate(val, "SupportedIops", &s.SupportedIops)
			delete(rawMsg, key)
		case "supportedIopsTiers":
			err = unpopulate(val, "SupportedIopsTiers", &s.SupportedIopsTiers)
			delete(rawMsg, key)
		case "supportedMaximumIops":
			err = unpopulate(val, "SupportedMaximumIops", &s.SupportedMaximumIops)
			delete(rawMsg, key)
		case "supportedMaximumThroughput":
			err = unpopulate(val, "SupportedMaximumThroughput", &s.SupportedMaximumThroughput)
			delete(rawMsg, key)
		case "supportedThroughput":
			err = unpopulate(val, "SupportedThroughput", &s.SupportedThroughput)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTierCapability.
func (s StorageTierCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "iops", s.Iops)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "reason", s.Reason)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTierCapability.
func (s *StorageTierCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "iops":
			err = unpopulate(val, "Iops", &s.Iops)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &s.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tenantId", u.TenantID)
	populate(objectMap, "type", u.Type)
	populate(objectMap, "userAssignedIdentities", u.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tenantId":
			err = unpopulate(val, "TenantID", &u.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &u.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserIdentity.
func (u UserIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserIdentity.
func (u *UserIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationDetails.
func (v ValidationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dbLevelValidationDetails", v.DbLevelValidationDetails)
	populate(objectMap, "serverLevelValidationDetails", v.ServerLevelValidationDetails)
	populate(objectMap, "status", v.Status)
	populateDateTimeRFC3339(objectMap, "validationEndTimeInUtc", v.ValidationEndTimeInUTC)
	populateDateTimeRFC3339(objectMap, "validationStartTimeInUtc", v.ValidationStartTimeInUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationDetails.
func (v *ValidationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dbLevelValidationDetails":
			err = unpopulate(val, "DbLevelValidationDetails", &v.DbLevelValidationDetails)
			delete(rawMsg, key)
		case "serverLevelValidationDetails":
			err = unpopulate(val, "ServerLevelValidationDetails", &v.ServerLevelValidationDetails)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "validationEndTimeInUtc":
			err = unpopulateDateTimeRFC3339(val, "ValidationEndTimeInUTC", &v.ValidationEndTimeInUTC)
			delete(rawMsg, key)
		case "validationStartTimeInUtc":
			err = unpopulateDateTimeRFC3339(val, "ValidationStartTimeInUTC", &v.ValidationStartTimeInUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationMessage.
func (v ValidationMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", v.Message)
	populate(objectMap, "state", v.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationMessage.
func (v *ValidationMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationSummaryItem.
func (v ValidationSummaryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messages", v.Messages)
	populate(objectMap, "state", v.State)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationSummaryItem.
func (v *ValidationSummaryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messages":
			err = unpopulate(val, "Messages", &v.Messages)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualEndpointResource.
func (v VirtualEndpointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualEndpointResource.
func (v *VirtualEndpointResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualEndpointResourceForPatch.
func (v VirtualEndpointResourceForPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualEndpointResourceForPatch.
func (v *VirtualEndpointResourceForPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualEndpointResourceProperties.
func (v VirtualEndpointResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointType", v.EndpointType)
	populate(objectMap, "members", v.Members)
	populate(objectMap, "virtualEndpoints", v.VirtualEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualEndpointResourceProperties.
func (v *VirtualEndpointResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &v.EndpointType)
			delete(rawMsg, key)
		case "members":
			err = unpopulate(val, "Members", &v.Members)
			delete(rawMsg, key)
		case "virtualEndpoints":
			err = unpopulate(val, "VirtualEndpoints", &v.VirtualEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualEndpointsListResult.
func (v VirtualEndpointsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualEndpointsListResult.
func (v *VirtualEndpointsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkSubnetUsageParameter.
func (v VirtualNetworkSubnetUsageParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "virtualNetworkArmResourceId", v.VirtualNetworkArmResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkSubnetUsageParameter.
func (v *VirtualNetworkSubnetUsageParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "virtualNetworkArmResourceId":
			err = unpopulate(val, "VirtualNetworkArmResourceID", &v.VirtualNetworkArmResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkSubnetUsageResult.
func (v VirtualNetworkSubnetUsageResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delegatedSubnetsUsage", v.DelegatedSubnetsUsage)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "subscriptionId", v.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkSubnetUsageResult.
func (v *VirtualNetworkSubnetUsageResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delegatedSubnetsUsage":
			err = unpopulate(val, "DelegatedSubnetsUsage", &v.DelegatedSubnetsUsage)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &v.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
