//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/powerbiprivatelinks/armpowerbiprivatelinks/v2"
	"net/http"
	"net/url"
	"regexp"
)

// PowerBIResourcesServer is a fake server for instances of the armpowerbiprivatelinks.PowerBIResourcesClient type.
type PowerBIResourcesServer struct {
	// Create is the fake for method PowerBIResourcesClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, azureResourceName string, body armpowerbiprivatelinks.TenantResource, options *armpowerbiprivatelinks.PowerBIResourcesClientCreateOptions) (resp azfake.Responder[armpowerbiprivatelinks.PowerBIResourcesClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method PowerBIResourcesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, azureResourceName string, options *armpowerbiprivatelinks.PowerBIResourcesClientDeleteOptions) (resp azfake.Responder[armpowerbiprivatelinks.PowerBIResourcesClientDeleteResponse], errResp azfake.ErrorResponder)

	// ListByResourceName is the fake for method PowerBIResourcesClient.ListByResourceName
	// HTTP status codes to indicate success: http.StatusOK
	ListByResourceName func(ctx context.Context, resourceGroupName string, azureResourceName string, options *armpowerbiprivatelinks.PowerBIResourcesClientListByResourceNameOptions) (resp azfake.Responder[armpowerbiprivatelinks.PowerBIResourcesClientListByResourceNameResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method PowerBIResourcesClient.Update
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Update func(ctx context.Context, resourceGroupName string, azureResourceName string, body armpowerbiprivatelinks.TenantResource, options *armpowerbiprivatelinks.PowerBIResourcesClientUpdateOptions) (resp azfake.Responder[armpowerbiprivatelinks.PowerBIResourcesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewPowerBIResourcesServerTransport creates a new instance of PowerBIResourcesServerTransport with the provided implementation.
// The returned PowerBIResourcesServerTransport instance is connected to an instance of armpowerbiprivatelinks.PowerBIResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPowerBIResourcesServerTransport(srv *PowerBIResourcesServer) *PowerBIResourcesServerTransport {
	return &PowerBIResourcesServerTransport{srv: srv}
}

// PowerBIResourcesServerTransport connects instances of armpowerbiprivatelinks.PowerBIResourcesClient to instances of PowerBIResourcesServer.
// Don't use this type directly, use NewPowerBIResourcesServerTransport instead.
type PowerBIResourcesServerTransport struct {
	srv *PowerBIResourcesServer
}

// Do implements the policy.Transporter interface for PowerBIResourcesServerTransport.
func (p *PowerBIResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PowerBIResourcesClient.Create":
		resp, err = p.dispatchCreate(req)
	case "PowerBIResourcesClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "PowerBIResourcesClient.ListByResourceName":
		resp, err = p.dispatchListByResourceName(req)
	case "PowerBIResourcesClient.Update":
		resp, err = p.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PowerBIResourcesServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if p.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/privateLinkServicesForPowerBI/(?P<azureResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpowerbiprivatelinks.TenantResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureResourceName")])
	if err != nil {
		return nil, err
	}
	clientTenantIDParam := getOptional(getHeaderValue(req.Header, "x-ms-client-tenant-id"))
	var options *armpowerbiprivatelinks.PowerBIResourcesClientCreateOptions
	if clientTenantIDParam != nil {
		options = &armpowerbiprivatelinks.PowerBIResourcesClientCreateOptions{
			ClientTenantID: clientTenantIDParam,
		}
	}
	respr, errRespr := p.srv.Create(req.Context(), resourceGroupNameParam, azureResourceNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PowerBIResourcesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/privateLinkServicesForPowerBI/(?P<azureResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), resourceGroupNameParam, azureResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PowerBIResourcesServerTransport) dispatchListByResourceName(req *http.Request) (*http.Response, error) {
	if p.srv.ListByResourceName == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByResourceName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/privateLinkServicesForPowerBI/(?P<azureResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListByResourceName(req.Context(), resourceGroupNameParam, azureResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantResourceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PowerBIResourcesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/privateLinkServicesForPowerBI/(?P<azureResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpowerbiprivatelinks.TenantResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureResourceName")])
	if err != nil {
		return nil, err
	}
	clientTenantIDParam := getOptional(getHeaderValue(req.Header, "x-ms-client-tenant-id"))
	var options *armpowerbiprivatelinks.PowerBIResourcesClientUpdateOptions
	if clientTenantIDParam != nil {
		options = &armpowerbiprivatelinks.PowerBIResourcesClientUpdateOptions{
			ClientTenantID: clientTenantIDParam,
		}
	}
	respr, errRespr := p.srv.Update(req.Context(), resourceGroupNameParam, azureResourceNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
