//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/providerhub/armproviderhub"
	"net/http"
	"net/url"
	"regexp"
)

// SKUsServer is a fake server for instances of the armproviderhub.SKUsClient type.
type SKUsServer struct {
	// CreateOrUpdate is the fake for method SKUsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, providerNamespace string, resourceType string, sku string, properties armproviderhub.SKUResource, options *armproviderhub.SKUsClientCreateOrUpdateOptions) (resp azfake.Responder[armproviderhub.SKUsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateNestedResourceTypeFirst is the fake for method SKUsClient.CreateOrUpdateNestedResourceTypeFirst
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateNestedResourceTypeFirst func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, properties armproviderhub.SKUResource, options *armproviderhub.SKUsClientCreateOrUpdateNestedResourceTypeFirstOptions) (resp azfake.Responder[armproviderhub.SKUsClientCreateOrUpdateNestedResourceTypeFirstResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateNestedResourceTypeSecond is the fake for method SKUsClient.CreateOrUpdateNestedResourceTypeSecond
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateNestedResourceTypeSecond func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, properties armproviderhub.SKUResource, options *armproviderhub.SKUsClientCreateOrUpdateNestedResourceTypeSecondOptions) (resp azfake.Responder[armproviderhub.SKUsClientCreateOrUpdateNestedResourceTypeSecondResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateNestedResourceTypeThird is the fake for method SKUsClient.CreateOrUpdateNestedResourceTypeThird
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdateNestedResourceTypeThird func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, properties armproviderhub.SKUResource, options *armproviderhub.SKUsClientCreateOrUpdateNestedResourceTypeThirdOptions) (resp azfake.Responder[armproviderhub.SKUsClientCreateOrUpdateNestedResourceTypeThirdResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SKUsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, providerNamespace string, resourceType string, sku string, options *armproviderhub.SKUsClientDeleteOptions) (resp azfake.Responder[armproviderhub.SKUsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteNestedResourceTypeFirst is the fake for method SKUsClient.DeleteNestedResourceTypeFirst
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteNestedResourceTypeFirst func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, options *armproviderhub.SKUsClientDeleteNestedResourceTypeFirstOptions) (resp azfake.Responder[armproviderhub.SKUsClientDeleteNestedResourceTypeFirstResponse], errResp azfake.ErrorResponder)

	// DeleteNestedResourceTypeSecond is the fake for method SKUsClient.DeleteNestedResourceTypeSecond
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteNestedResourceTypeSecond func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, options *armproviderhub.SKUsClientDeleteNestedResourceTypeSecondOptions) (resp azfake.Responder[armproviderhub.SKUsClientDeleteNestedResourceTypeSecondResponse], errResp azfake.ErrorResponder)

	// DeleteNestedResourceTypeThird is the fake for method SKUsClient.DeleteNestedResourceTypeThird
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteNestedResourceTypeThird func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, options *armproviderhub.SKUsClientDeleteNestedResourceTypeThirdOptions) (resp azfake.Responder[armproviderhub.SKUsClientDeleteNestedResourceTypeThirdResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SKUsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, providerNamespace string, resourceType string, sku string, options *armproviderhub.SKUsClientGetOptions) (resp azfake.Responder[armproviderhub.SKUsClientGetResponse], errResp azfake.ErrorResponder)

	// GetNestedResourceTypeFirst is the fake for method SKUsClient.GetNestedResourceTypeFirst
	// HTTP status codes to indicate success: http.StatusOK
	GetNestedResourceTypeFirst func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, options *armproviderhub.SKUsClientGetNestedResourceTypeFirstOptions) (resp azfake.Responder[armproviderhub.SKUsClientGetNestedResourceTypeFirstResponse], errResp azfake.ErrorResponder)

	// GetNestedResourceTypeSecond is the fake for method SKUsClient.GetNestedResourceTypeSecond
	// HTTP status codes to indicate success: http.StatusOK
	GetNestedResourceTypeSecond func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, options *armproviderhub.SKUsClientGetNestedResourceTypeSecondOptions) (resp azfake.Responder[armproviderhub.SKUsClientGetNestedResourceTypeSecondResponse], errResp azfake.ErrorResponder)

	// GetNestedResourceTypeThird is the fake for method SKUsClient.GetNestedResourceTypeThird
	// HTTP status codes to indicate success: http.StatusOK
	GetNestedResourceTypeThird func(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, options *armproviderhub.SKUsClientGetNestedResourceTypeThirdOptions) (resp azfake.Responder[armproviderhub.SKUsClientGetNestedResourceTypeThirdResponse], errResp azfake.ErrorResponder)

	// NewListByResourceTypeRegistrationsPager is the fake for method SKUsClient.NewListByResourceTypeRegistrationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceTypeRegistrationsPager func(providerNamespace string, resourceType string, options *armproviderhub.SKUsClientListByResourceTypeRegistrationsOptions) (resp azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsResponse])

	// NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager is the fake for method SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager func(providerNamespace string, resourceType string, nestedResourceTypeFirst string, options *armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstOptions) (resp azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse])

	// NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager is the fake for method SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager func(providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, options *armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondOptions) (resp azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse])

	// NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager is the fake for method SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager func(providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, options *armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdOptions) (resp azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse])
}

// NewSKUsServerTransport creates a new instance of SKUsServerTransport with the provided implementation.
// The returned SKUsServerTransport instance is connected to an instance of armproviderhub.SKUsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSKUsServerTransport(srv *SKUsServer) *SKUsServerTransport {
	return &SKUsServerTransport{
		srv:                                     srv,
		newListByResourceTypeRegistrationsPager: newTracker[azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsResponse]](),
		newListByResourceTypeRegistrationsNestedResourceTypeFirstPager:  newTracker[azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse]](),
		newListByResourceTypeRegistrationsNestedResourceTypeSecondPager: newTracker[azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse]](),
		newListByResourceTypeRegistrationsNestedResourceTypeThirdPager:  newTracker[azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse]](),
	}
}

// SKUsServerTransport connects instances of armproviderhub.SKUsClient to instances of SKUsServer.
// Don't use this type directly, use NewSKUsServerTransport instead.
type SKUsServerTransport struct {
	srv                                                             *SKUsServer
	newListByResourceTypeRegistrationsPager                         *tracker[azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsResponse]]
	newListByResourceTypeRegistrationsNestedResourceTypeFirstPager  *tracker[azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse]]
	newListByResourceTypeRegistrationsNestedResourceTypeSecondPager *tracker[azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse]]
	newListByResourceTypeRegistrationsNestedResourceTypeThirdPager  *tracker[azfake.PagerResponder[armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse]]
}

// Do implements the policy.Transporter interface for SKUsServerTransport.
func (s *SKUsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SKUsClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SKUsClient.CreateOrUpdateNestedResourceTypeFirst":
		resp, err = s.dispatchCreateOrUpdateNestedResourceTypeFirst(req)
	case "SKUsClient.CreateOrUpdateNestedResourceTypeSecond":
		resp, err = s.dispatchCreateOrUpdateNestedResourceTypeSecond(req)
	case "SKUsClient.CreateOrUpdateNestedResourceTypeThird":
		resp, err = s.dispatchCreateOrUpdateNestedResourceTypeThird(req)
	case "SKUsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SKUsClient.DeleteNestedResourceTypeFirst":
		resp, err = s.dispatchDeleteNestedResourceTypeFirst(req)
	case "SKUsClient.DeleteNestedResourceTypeSecond":
		resp, err = s.dispatchDeleteNestedResourceTypeSecond(req)
	case "SKUsClient.DeleteNestedResourceTypeThird":
		resp, err = s.dispatchDeleteNestedResourceTypeThird(req)
	case "SKUsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SKUsClient.GetNestedResourceTypeFirst":
		resp, err = s.dispatchGetNestedResourceTypeFirst(req)
	case "SKUsClient.GetNestedResourceTypeSecond":
		resp, err = s.dispatchGetNestedResourceTypeSecond(req)
	case "SKUsClient.GetNestedResourceTypeThird":
		resp, err = s.dispatchGetNestedResourceTypeThird(req)
	case "SKUsClient.NewListByResourceTypeRegistrationsPager":
		resp, err = s.dispatchNewListByResourceTypeRegistrationsPager(req)
	case "SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager":
		resp, err = s.dispatchNewListByResourceTypeRegistrationsNestedResourceTypeFirstPager(req)
	case "SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager":
		resp, err = s.dispatchNewListByResourceTypeRegistrationsNestedResourceTypeSecondPager(req)
	case "SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager":
		resp, err = s.dispatchNewListByResourceTypeRegistrationsNestedResourceTypeThirdPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SKUsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armproviderhub.SKUResource](req)
	if err != nil {
		return nil, err
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), providerNamespaceParam, resourceTypeParam, skuParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchCreateOrUpdateNestedResourceTypeFirst(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateNestedResourceTypeFirst == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateNestedResourceTypeFirst not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armproviderhub.SKUResource](req)
	if err != nil {
		return nil, err
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateNestedResourceTypeFirst(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, skuParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchCreateOrUpdateNestedResourceTypeSecond(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateNestedResourceTypeSecond == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateNestedResourceTypeSecond not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeSecond>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armproviderhub.SKUResource](req)
	if err != nil {
		return nil, err
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeSecondParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeSecond")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateNestedResourceTypeSecond(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nestedResourceTypeSecondParam, skuParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchCreateOrUpdateNestedResourceTypeThird(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdateNestedResourceTypeThird == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateNestedResourceTypeThird not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeSecond>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeThird>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armproviderhub.SKUResource](req)
	if err != nil {
		return nil, err
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeSecondParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeSecond")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeThirdParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeThird")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdateNestedResourceTypeThird(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nestedResourceTypeSecondParam, nestedResourceTypeThirdParam, skuParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), providerNamespaceParam, resourceTypeParam, skuParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchDeleteNestedResourceTypeFirst(req *http.Request) (*http.Response, error) {
	if s.srv.DeleteNestedResourceTypeFirst == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteNestedResourceTypeFirst not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DeleteNestedResourceTypeFirst(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, skuParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchDeleteNestedResourceTypeSecond(req *http.Request) (*http.Response, error) {
	if s.srv.DeleteNestedResourceTypeSecond == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteNestedResourceTypeSecond not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeSecond>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeSecondParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeSecond")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DeleteNestedResourceTypeSecond(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nestedResourceTypeSecondParam, skuParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchDeleteNestedResourceTypeThird(req *http.Request) (*http.Response, error) {
	if s.srv.DeleteNestedResourceTypeThird == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteNestedResourceTypeThird not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeSecond>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeThird>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeSecondParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeSecond")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeThirdParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeThird")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.DeleteNestedResourceTypeThird(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nestedResourceTypeSecondParam, nestedResourceTypeThirdParam, skuParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), providerNamespaceParam, resourceTypeParam, skuParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchGetNestedResourceTypeFirst(req *http.Request) (*http.Response, error) {
	if s.srv.GetNestedResourceTypeFirst == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNestedResourceTypeFirst not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetNestedResourceTypeFirst(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, skuParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchGetNestedResourceTypeSecond(req *http.Request) (*http.Response, error) {
	if s.srv.GetNestedResourceTypeSecond == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNestedResourceTypeSecond not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeSecond>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeSecondParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeSecond")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetNestedResourceTypeSecond(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nestedResourceTypeSecondParam, skuParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchGetNestedResourceTypeThird(req *http.Request) (*http.Response, error) {
	if s.srv.GetNestedResourceTypeThird == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetNestedResourceTypeThird not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeSecond>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeThird>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus/(?P<sku>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeSecondParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeSecond")])
	if err != nil {
		return nil, err
	}
	nestedResourceTypeThirdParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeThird")])
	if err != nil {
		return nil, err
	}
	skuParam, err := url.PathUnescape(matches[regex.SubexpIndex("sku")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetNestedResourceTypeThird(req.Context(), providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nestedResourceTypeSecondParam, nestedResourceTypeThirdParam, skuParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchNewListByResourceTypeRegistrationsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceTypeRegistrationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceTypeRegistrationsPager not implemented")}
	}
	newListByResourceTypeRegistrationsPager := s.newListByResourceTypeRegistrationsPager.get(req)
	if newListByResourceTypeRegistrationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByResourceTypeRegistrationsPager(providerNamespaceParam, resourceTypeParam, nil)
		newListByResourceTypeRegistrationsPager = &resp
		s.newListByResourceTypeRegistrationsPager.add(req, newListByResourceTypeRegistrationsPager)
		server.PagerResponderInjectNextLinks(newListByResourceTypeRegistrationsPager, req, func(page *armproviderhub.SKUsClientListByResourceTypeRegistrationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceTypeRegistrationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceTypeRegistrationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceTypeRegistrationsPager) {
		s.newListByResourceTypeRegistrationsPager.remove(req)
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchNewListByResourceTypeRegistrationsNestedResourceTypeFirstPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager not implemented")}
	}
	newListByResourceTypeRegistrationsNestedResourceTypeFirstPager := s.newListByResourceTypeRegistrationsNestedResourceTypeFirstPager.get(req)
	if newListByResourceTypeRegistrationsNestedResourceTypeFirstPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager(providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nil)
		newListByResourceTypeRegistrationsNestedResourceTypeFirstPager = &resp
		s.newListByResourceTypeRegistrationsNestedResourceTypeFirstPager.add(req, newListByResourceTypeRegistrationsNestedResourceTypeFirstPager)
		server.PagerResponderInjectNextLinks(newListByResourceTypeRegistrationsNestedResourceTypeFirstPager, req, func(page *armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceTypeRegistrationsNestedResourceTypeFirstPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceTypeRegistrationsNestedResourceTypeFirstPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceTypeRegistrationsNestedResourceTypeFirstPager) {
		s.newListByResourceTypeRegistrationsNestedResourceTypeFirstPager.remove(req)
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchNewListByResourceTypeRegistrationsNestedResourceTypeSecondPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager not implemented")}
	}
	newListByResourceTypeRegistrationsNestedResourceTypeSecondPager := s.newListByResourceTypeRegistrationsNestedResourceTypeSecondPager.get(req)
	if newListByResourceTypeRegistrationsNestedResourceTypeSecondPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeSecond>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
		if err != nil {
			return nil, err
		}
		nestedResourceTypeSecondParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeSecond")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager(providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nestedResourceTypeSecondParam, nil)
		newListByResourceTypeRegistrationsNestedResourceTypeSecondPager = &resp
		s.newListByResourceTypeRegistrationsNestedResourceTypeSecondPager.add(req, newListByResourceTypeRegistrationsNestedResourceTypeSecondPager)
		server.PagerResponderInjectNextLinks(newListByResourceTypeRegistrationsNestedResourceTypeSecondPager, req, func(page *armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceTypeRegistrationsNestedResourceTypeSecondPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceTypeRegistrationsNestedResourceTypeSecondPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceTypeRegistrationsNestedResourceTypeSecondPager) {
		s.newListByResourceTypeRegistrationsNestedResourceTypeSecondPager.remove(req)
	}
	return resp, nil
}

func (s *SKUsServerTransport) dispatchNewListByResourceTypeRegistrationsNestedResourceTypeThirdPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager not implemented")}
	}
	newListByResourceTypeRegistrationsNestedResourceTypeThirdPager := s.newListByResourceTypeRegistrationsNestedResourceTypeThirdPager.get(req)
	if newListByResourceTypeRegistrationsNestedResourceTypeThirdPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeFirst>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeSecond>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<nestedResourceTypeThird>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		nestedResourceTypeFirstParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeFirst")])
		if err != nil {
			return nil, err
		}
		nestedResourceTypeSecondParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeSecond")])
		if err != nil {
			return nil, err
		}
		nestedResourceTypeThirdParam, err := url.PathUnescape(matches[regex.SubexpIndex("nestedResourceTypeThird")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager(providerNamespaceParam, resourceTypeParam, nestedResourceTypeFirstParam, nestedResourceTypeSecondParam, nestedResourceTypeThirdParam, nil)
		newListByResourceTypeRegistrationsNestedResourceTypeThirdPager = &resp
		s.newListByResourceTypeRegistrationsNestedResourceTypeThirdPager.add(req, newListByResourceTypeRegistrationsNestedResourceTypeThirdPager)
		server.PagerResponderInjectNextLinks(newListByResourceTypeRegistrationsNestedResourceTypeThirdPager, req, func(page *armproviderhub.SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceTypeRegistrationsNestedResourceTypeThirdPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceTypeRegistrationsNestedResourceTypeThirdPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceTypeRegistrationsNestedResourceTypeThirdPager) {
		s.newListByResourceTypeRegistrationsNestedResourceTypeThirdPager.remove(req)
	}
	return resp, nil
}
