//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewClient creates a new instance of Client.
func (c *ClientFactory) NewClient() *Client {
	return &Client{
		internal: c.internal,
	}
}

// NewGroupQuotaLimitsClient creates a new instance of GroupQuotaLimitsClient.
func (c *ClientFactory) NewGroupQuotaLimitsClient() *GroupQuotaLimitsClient {
	return &GroupQuotaLimitsClient{
		internal: c.internal,
	}
}

// NewGroupQuotaLimitsRequestClient creates a new instance of GroupQuotaLimitsRequestClient.
func (c *ClientFactory) NewGroupQuotaLimitsRequestClient() *GroupQuotaLimitsRequestClient {
	return &GroupQuotaLimitsRequestClient{
		internal: c.internal,
	}
}

// NewGroupQuotaLocationSettingsClient creates a new instance of GroupQuotaLocationSettingsClient.
func (c *ClientFactory) NewGroupQuotaLocationSettingsClient() *GroupQuotaLocationSettingsClient {
	return &GroupQuotaLocationSettingsClient{
		internal: c.internal,
	}
}

// NewGroupQuotaSubscriptionAllocationClient creates a new instance of GroupQuotaSubscriptionAllocationClient.
func (c *ClientFactory) NewGroupQuotaSubscriptionAllocationClient() *GroupQuotaSubscriptionAllocationClient {
	return &GroupQuotaSubscriptionAllocationClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewGroupQuotaSubscriptionAllocationRequestClient creates a new instance of GroupQuotaSubscriptionAllocationRequestClient.
func (c *ClientFactory) NewGroupQuotaSubscriptionAllocationRequestClient() *GroupQuotaSubscriptionAllocationRequestClient {
	return &GroupQuotaSubscriptionAllocationRequestClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewGroupQuotaSubscriptionRequestsClient creates a new instance of GroupQuotaSubscriptionRequestsClient.
func (c *ClientFactory) NewGroupQuotaSubscriptionRequestsClient() *GroupQuotaSubscriptionRequestsClient {
	return &GroupQuotaSubscriptionRequestsClient{
		internal: c.internal,
	}
}

// NewGroupQuotaSubscriptionsClient creates a new instance of GroupQuotaSubscriptionsClient.
func (c *ClientFactory) NewGroupQuotaSubscriptionsClient() *GroupQuotaSubscriptionsClient {
	return &GroupQuotaSubscriptionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewGroupQuotaUsagesClient creates a new instance of GroupQuotaUsagesClient.
func (c *ClientFactory) NewGroupQuotaUsagesClient() *GroupQuotaUsagesClient {
	return &GroupQuotaUsagesClient{
		internal: c.internal,
	}
}

// NewGroupQuotasClient creates a new instance of GroupQuotasClient.
func (c *ClientFactory) NewGroupQuotasClient() *GroupQuotasClient {
	return &GroupQuotasClient{
		internal: c.internal,
	}
}

// NewOperationClient creates a new instance of OperationClient.
func (c *ClientFactory) NewOperationClient() *OperationClient {
	return &OperationClient{
		internal: c.internal,
	}
}

// NewRequestStatusClient creates a new instance of RequestStatusClient.
func (c *ClientFactory) NewRequestStatusClient() *RequestStatusClient {
	return &RequestStatusClient{
		internal: c.internal,
	}
}

// NewUsagesClient creates a new instance of UsagesClient.
func (c *ClientFactory) NewUsagesClient() *UsagesClient {
	return &UsagesClient{
		internal: c.internal,
	}
}
