//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GroupQuotaLimitsRequestClient contains the methods for the GroupQuotaLimitsRequest group.
// Don't use this type directly, use NewGroupQuotaLimitsRequestClient() instead.
type GroupQuotaLimitsRequestClient struct {
	internal *arm.Client
}

// NewGroupQuotaLimitsRequestClient creates a new instance of GroupQuotaLimitsRequestClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGroupQuotaLimitsRequestClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*GroupQuotaLimitsRequestClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GroupQuotaLimitsRequestClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Put the GroupQuota requests for a specific ResourceProvider/Location/Resource. the location and resourceName
// ("name": {"value" : "resourceName") properties are specified in the request body. Only 1
// resource quota can be requested. Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field,
// with retry-after duration in seconds to check the intermediate status. This
// API provides the finals status with the request details and status.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - resourceName - Resource name.
//   - options - GroupQuotaLimitsRequestClientBeginCreateOrUpdateOptions contains the optional parameters for the GroupQuotaLimitsRequestClient.BeginCreateOrUpdate
//     method.
func (client *GroupQuotaLimitsRequestClient) BeginCreateOrUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, options *GroupQuotaLimitsRequestClientBeginCreateOrUpdateOptions) (*runtime.Poller[GroupQuotaLimitsRequestClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, managementGroupID, groupQuotaName, resourceProviderName, resourceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GroupQuotaLimitsRequestClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GroupQuotaLimitsRequestClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Put the GroupQuota requests for a specific ResourceProvider/Location/Resource. the location and resourceName
// ("name": {"value" : "resourceName") properties are specified in the request body. Only 1
// resource quota can be requested. Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field,
// with retry-after duration in seconds to check the intermediate status. This
// API provides the finals status with the request details and status.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
func (client *GroupQuotaLimitsRequestClient) createOrUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, options *GroupQuotaLimitsRequestClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GroupQuotaLimitsRequestClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, resourceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *GroupQuotaLimitsRequestClient) createOrUpdateCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, options *GroupQuotaLimitsRequestClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/groupQuotaRequests/{resourceName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.GroupQuotaRequest != nil {
		if err := runtime.MarshalAsJSON(req, *options.GroupQuotaRequest); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// Get - Get API to check the status of a GroupQuota request by requestId.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - requestID - Request Id.
//   - options - GroupQuotaLimitsRequestClientGetOptions contains the optional parameters for the GroupQuotaLimitsRequestClient.Get
//     method.
func (client *GroupQuotaLimitsRequestClient) Get(ctx context.Context, managementGroupID string, groupQuotaName string, requestID string, options *GroupQuotaLimitsRequestClientGetOptions) (GroupQuotaLimitsRequestClientGetResponse, error) {
	var err error
	const operationName = "GroupQuotaLimitsRequestClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, managementGroupID, groupQuotaName, requestID, options)
	if err != nil {
		return GroupQuotaLimitsRequestClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GroupQuotaLimitsRequestClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GroupQuotaLimitsRequestClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *GroupQuotaLimitsRequestClient) getCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, requestID string, options *GroupQuotaLimitsRequestClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/groupQuotaRequests/{requestId}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if requestID == "" {
		return nil, errors.New("parameter requestID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestId}", url.PathEscape(requestID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GroupQuotaLimitsRequestClient) getHandleResponse(resp *http.Response) (GroupQuotaLimitsRequestClientGetResponse, error) {
	result := GroupQuotaLimitsRequestClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubmittedResourceRequestStatus); err != nil {
		return GroupQuotaLimitsRequestClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get API to check the status of a GroupQuota request by requestId.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - filter - FIELD SUPPORTED OPERATORS
//     location eq {location} and resource eq {resourceName}
//     Example: $filter=location eq eastus and resourceName eq cores
//   - options - GroupQuotaLimitsRequestClientListOptions contains the optional parameters for the GroupQuotaLimitsRequestClient.NewListPager
//     method.
func (client *GroupQuotaLimitsRequestClient) NewListPager(managementGroupID string, groupQuotaName string, resourceProviderName string, filter string, options *GroupQuotaLimitsRequestClientListOptions) *runtime.Pager[GroupQuotaLimitsRequestClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GroupQuotaLimitsRequestClientListResponse]{
		More: func(page GroupQuotaLimitsRequestClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GroupQuotaLimitsRequestClientListResponse) (GroupQuotaLimitsRequestClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GroupQuotaLimitsRequestClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, filter, options)
			}, nil)
			if err != nil {
				return GroupQuotaLimitsRequestClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GroupQuotaLimitsRequestClient) listCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, filter string, options *GroupQuotaLimitsRequestClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/groupQuotaRequests"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("$filter", filter)
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GroupQuotaLimitsRequestClient) listHandleResponse(resp *http.Response) (GroupQuotaLimitsRequestClientListResponse, error) {
	result := GroupQuotaLimitsRequestClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubmittedResourceRequestStatusList); err != nil {
		return GroupQuotaLimitsRequestClientListResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. the location and resourceName
// properties are specified in the request body. Only 1 resource quota can be requested.
// Please note that patch request creates a new groupQuota request. Use the polling API - OperationsStatus URI specified in
// Azure-AsyncOperation header field, with retry-after duration in seconds to
// check the intermediate status. This API provides the finals status with the request details and status.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - resourceName - Resource name.
//   - options - GroupQuotaLimitsRequestClientBeginUpdateOptions contains the optional parameters for the GroupQuotaLimitsRequestClient.BeginUpdate
//     method.
func (client *GroupQuotaLimitsRequestClient) BeginUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, options *GroupQuotaLimitsRequestClientBeginUpdateOptions) (*runtime.Poller[GroupQuotaLimitsRequestClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, managementGroupID, groupQuotaName, resourceProviderName, resourceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GroupQuotaLimitsRequestClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GroupQuotaLimitsRequestClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. the location and resourceName
// properties are specified in the request body. Only 1 resource quota can be requested.
// Please note that patch request creates a new groupQuota request. Use the polling API - OperationsStatus URI specified in
// Azure-AsyncOperation header field, with retry-after duration in seconds to
// check the intermediate status. This API provides the finals status with the request details and status.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
func (client *GroupQuotaLimitsRequestClient) update(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, options *GroupQuotaLimitsRequestClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GroupQuotaLimitsRequestClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, resourceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *GroupQuotaLimitsRequestClient) updateCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, options *GroupQuotaLimitsRequestClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/groupQuotaRequests/{resourceName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.GroupQuotaRequest != nil {
		if err := runtime.MarshalAsJSON(req, *options.GroupQuotaRequest); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}
