//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservices"
	"net/http"
	"net/url"
	"regexp"
)

// RegisteredIdentitiesServer is a fake server for instances of the armrecoveryservices.RegisteredIdentitiesClient type.
type RegisteredIdentitiesServer struct {
	// Delete is the fake for method RegisteredIdentitiesClient.Delete
	// HTTP status codes to indicate success: http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, vaultName string, identityName string, options *armrecoveryservices.RegisteredIdentitiesClientDeleteOptions) (resp azfake.Responder[armrecoveryservices.RegisteredIdentitiesClientDeleteResponse], errResp azfake.ErrorResponder)
}

// NewRegisteredIdentitiesServerTransport creates a new instance of RegisteredIdentitiesServerTransport with the provided implementation.
// The returned RegisteredIdentitiesServerTransport instance is connected to an instance of armrecoveryservices.RegisteredIdentitiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRegisteredIdentitiesServerTransport(srv *RegisteredIdentitiesServer) *RegisteredIdentitiesServerTransport {
	return &RegisteredIdentitiesServerTransport{srv: srv}
}

// RegisteredIdentitiesServerTransport connects instances of armrecoveryservices.RegisteredIdentitiesClient to instances of RegisteredIdentitiesServer.
// Don't use this type directly, use NewRegisteredIdentitiesServerTransport instead.
type RegisteredIdentitiesServerTransport struct {
	srv *RegisteredIdentitiesServer
}

// Do implements the policy.Transporter interface for RegisteredIdentitiesServerTransport.
func (r *RegisteredIdentitiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RegisteredIdentitiesClient.Delete":
		resp, err = r.dispatchDelete(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RegisteredIdentitiesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/registeredIdentities/(?P<identityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	identityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("identityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Delete(req.Context(), resourceGroupNameParam, vaultNameParam, identityNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
