//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesdatareplication

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// EmailConfigurationClient contains the methods for the EmailConfiguration group.
// Don't use this type directly, use NewEmailConfigurationClient() instead.
type EmailConfigurationClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewEmailConfigurationClient creates a new instance of EmailConfigurationClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewEmailConfigurationClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*EmailConfigurationClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &EmailConfigurationClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Create - Creates an alert configuration setting for the given vault.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-02-16-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - vaultName - The vault name.
//   - emailConfigurationName - The email configuration name.
//   - body - EmailConfiguration model.
//   - options - EmailConfigurationClientCreateOptions contains the optional parameters for the EmailConfigurationClient.Create
//     method.
func (client *EmailConfigurationClient) Create(ctx context.Context, resourceGroupName string, vaultName string, emailConfigurationName string, body EmailConfigurationModel, options *EmailConfigurationClientCreateOptions) (EmailConfigurationClientCreateResponse, error) {
	var err error
	const operationName = "EmailConfigurationClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, vaultName, emailConfigurationName, body, options)
	if err != nil {
		return EmailConfigurationClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EmailConfigurationClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return EmailConfigurationClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *EmailConfigurationClient) createCreateRequest(ctx context.Context, resourceGroupName string, vaultName string, emailConfigurationName string, body EmailConfigurationModel, options *EmailConfigurationClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vaultName == "" {
		return nil, errors.New("parameter vaultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vaultName}", url.PathEscape(vaultName))
	if emailConfigurationName == "" {
		return nil, errors.New("parameter emailConfigurationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailConfigurationName}", url.PathEscape(emailConfigurationName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-02-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *EmailConfigurationClient) createHandleResponse(resp *http.Response) (EmailConfigurationClientCreateResponse, error) {
	result := EmailConfigurationClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EmailConfigurationModel); err != nil {
		return EmailConfigurationClientCreateResponse{}, err
	}
	return result, nil
}

// Get - Gets the details of the alert configuration setting.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-02-16-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - vaultName - The vault name.
//   - emailConfigurationName - The email configuration name.
//   - options - EmailConfigurationClientGetOptions contains the optional parameters for the EmailConfigurationClient.Get method.
func (client *EmailConfigurationClient) Get(ctx context.Context, resourceGroupName string, vaultName string, emailConfigurationName string, options *EmailConfigurationClientGetOptions) (EmailConfigurationClientGetResponse, error) {
	var err error
	const operationName = "EmailConfigurationClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, vaultName, emailConfigurationName, options)
	if err != nil {
		return EmailConfigurationClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EmailConfigurationClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EmailConfigurationClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *EmailConfigurationClient) getCreateRequest(ctx context.Context, resourceGroupName string, vaultName string, emailConfigurationName string, options *EmailConfigurationClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vaultName == "" {
		return nil, errors.New("parameter vaultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vaultName}", url.PathEscape(vaultName))
	if emailConfigurationName == "" {
		return nil, errors.New("parameter emailConfigurationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailConfigurationName}", url.PathEscape(emailConfigurationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-02-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *EmailConfigurationClient) getHandleResponse(resp *http.Response) (EmailConfigurationClientGetResponse, error) {
	result := EmailConfigurationClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EmailConfigurationModel); err != nil {
		return EmailConfigurationClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Gets the list of alert configuration settings for the given vault.
//
// Generated from API version 2021-02-16-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - vaultName - The vault name.
//   - options - EmailConfigurationClientListOptions contains the optional parameters for the EmailConfigurationClient.NewListPager
//     method.
func (client *EmailConfigurationClient) NewListPager(resourceGroupName string, vaultName string, options *EmailConfigurationClientListOptions) *runtime.Pager[EmailConfigurationClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[EmailConfigurationClientListResponse]{
		More: func(page EmailConfigurationClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EmailConfigurationClientListResponse) (EmailConfigurationClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "EmailConfigurationClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, vaultName, options)
			}, nil)
			if err != nil {
				return EmailConfigurationClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *EmailConfigurationClient) listCreateRequest(ctx context.Context, resourceGroupName string, vaultName string, options *EmailConfigurationClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vaultName == "" {
		return nil, errors.New("parameter vaultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vaultName}", url.PathEscape(vaultName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-02-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *EmailConfigurationClient) listHandleResponse(resp *http.Response) (EmailConfigurationClientListResponse, error) {
	result := EmailConfigurationClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EmailConfigurationModelCollection); err != nil {
		return EmailConfigurationClientListResponse{}, err
	}
	return result, nil
}
