//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcehealth/armresourcehealth"
	"net/http"
	"net/url"
	"regexp"
)

// EventsServer is a fake server for instances of the armresourcehealth.EventsClient type.
type EventsServer struct {
	// NewListBySingleResourcePager is the fake for method EventsClient.NewListBySingleResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySingleResourcePager func(resourceURI string, options *armresourcehealth.EventsClientListBySingleResourceOptions) (resp azfake.PagerResponder[armresourcehealth.EventsClientListBySingleResourceResponse])

	// NewListBySubscriptionIDPager is the fake for method EventsClient.NewListBySubscriptionIDPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionIDPager func(options *armresourcehealth.EventsClientListBySubscriptionIDOptions) (resp azfake.PagerResponder[armresourcehealth.EventsClientListBySubscriptionIDResponse])

	// NewListByTenantIDPager is the fake for method EventsClient.NewListByTenantIDPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTenantIDPager func(options *armresourcehealth.EventsClientListByTenantIDOptions) (resp azfake.PagerResponder[armresourcehealth.EventsClientListByTenantIDResponse])
}

// NewEventsServerTransport creates a new instance of EventsServerTransport with the provided implementation.
// The returned EventsServerTransport instance is connected to an instance of armresourcehealth.EventsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEventsServerTransport(srv *EventsServer) *EventsServerTransport {
	return &EventsServerTransport{
		srv:                          srv,
		newListBySingleResourcePager: newTracker[azfake.PagerResponder[armresourcehealth.EventsClientListBySingleResourceResponse]](),
		newListBySubscriptionIDPager: newTracker[azfake.PagerResponder[armresourcehealth.EventsClientListBySubscriptionIDResponse]](),
		newListByTenantIDPager:       newTracker[azfake.PagerResponder[armresourcehealth.EventsClientListByTenantIDResponse]](),
	}
}

// EventsServerTransport connects instances of armresourcehealth.EventsClient to instances of EventsServer.
// Don't use this type directly, use NewEventsServerTransport instead.
type EventsServerTransport struct {
	srv                          *EventsServer
	newListBySingleResourcePager *tracker[azfake.PagerResponder[armresourcehealth.EventsClientListBySingleResourceResponse]]
	newListBySubscriptionIDPager *tracker[azfake.PagerResponder[armresourcehealth.EventsClientListBySubscriptionIDResponse]]
	newListByTenantIDPager       *tracker[azfake.PagerResponder[armresourcehealth.EventsClientListByTenantIDResponse]]
}

// Do implements the policy.Transporter interface for EventsServerTransport.
func (e *EventsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EventsClient.NewListBySingleResourcePager":
		resp, err = e.dispatchNewListBySingleResourcePager(req)
	case "EventsClient.NewListBySubscriptionIDPager":
		resp, err = e.dispatchNewListBySubscriptionIDPager(req)
	case "EventsClient.NewListByTenantIDPager":
		resp, err = e.dispatchNewListByTenantIDPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EventsServerTransport) dispatchNewListBySingleResourcePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListBySingleResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySingleResourcePager not implemented")}
	}
	newListBySingleResourcePager := e.newListBySingleResourcePager.get(req)
	if newListBySingleResourcePager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/events`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armresourcehealth.EventsClientListBySingleResourceOptions
		if filterParam != nil {
			options = &armresourcehealth.EventsClientListBySingleResourceOptions{
				Filter: filterParam,
			}
		}
		resp := e.srv.NewListBySingleResourcePager(resourceURIParam, options)
		newListBySingleResourcePager = &resp
		e.newListBySingleResourcePager.add(req, newListBySingleResourcePager)
		server.PagerResponderInjectNextLinks(newListBySingleResourcePager, req, func(page *armresourcehealth.EventsClientListBySingleResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySingleResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListBySingleResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySingleResourcePager) {
		e.newListBySingleResourcePager.remove(req)
	}
	return resp, nil
}

func (e *EventsServerTransport) dispatchNewListBySubscriptionIDPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListBySubscriptionIDPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionIDPager not implemented")}
	}
	newListBySubscriptionIDPager := e.newListBySubscriptionIDPager.get(req)
	if newListBySubscriptionIDPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/events`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		queryStartTimeUnescaped, err := url.QueryUnescape(qp.Get("queryStartTime"))
		if err != nil {
			return nil, err
		}
		queryStartTimeParam := getOptional(queryStartTimeUnescaped)
		var options *armresourcehealth.EventsClientListBySubscriptionIDOptions
		if filterParam != nil || queryStartTimeParam != nil {
			options = &armresourcehealth.EventsClientListBySubscriptionIDOptions{
				Filter:         filterParam,
				QueryStartTime: queryStartTimeParam,
			}
		}
		resp := e.srv.NewListBySubscriptionIDPager(options)
		newListBySubscriptionIDPager = &resp
		e.newListBySubscriptionIDPager.add(req, newListBySubscriptionIDPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionIDPager, req, func(page *armresourcehealth.EventsClientListBySubscriptionIDResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionIDPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListBySubscriptionIDPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionIDPager) {
		e.newListBySubscriptionIDPager.remove(req)
	}
	return resp, nil
}

func (e *EventsServerTransport) dispatchNewListByTenantIDPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByTenantIDPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTenantIDPager not implemented")}
	}
	newListByTenantIDPager := e.newListByTenantIDPager.get(req)
	if newListByTenantIDPager == nil {
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		queryStartTimeUnescaped, err := url.QueryUnescape(qp.Get("queryStartTime"))
		if err != nil {
			return nil, err
		}
		queryStartTimeParam := getOptional(queryStartTimeUnescaped)
		var options *armresourcehealth.EventsClientListByTenantIDOptions
		if filterParam != nil || queryStartTimeParam != nil {
			options = &armresourcehealth.EventsClientListByTenantIDOptions{
				Filter:         filterParam,
				QueryStartTime: queryStartTimeParam,
			}
		}
		resp := e.srv.NewListByTenantIDPager(options)
		newListByTenantIDPager = &resp
		e.newListByTenantIDPager.add(req, newListByTenantIDPager)
		server.PagerResponderInjectNextLinks(newListByTenantIDPager, req, func(page *armresourcehealth.EventsClientListByTenantIDResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTenantIDPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByTenantIDPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTenantIDPager) {
		e.newListByTenantIDPager.remove(req)
	}
	return resp, nil
}
