//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armfeatures"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// SubscriptionFeatureRegistrationsServer is a fake server for instances of the armfeatures.SubscriptionFeatureRegistrationsClient type.
type SubscriptionFeatureRegistrationsServer struct {
	// CreateOrUpdate is the fake for method SubscriptionFeatureRegistrationsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, providerNamespace string, featureName string, options *armfeatures.SubscriptionFeatureRegistrationsClientCreateOrUpdateOptions) (resp azfake.Responder[armfeatures.SubscriptionFeatureRegistrationsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SubscriptionFeatureRegistrationsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, providerNamespace string, featureName string, options *armfeatures.SubscriptionFeatureRegistrationsClientDeleteOptions) (resp azfake.Responder[armfeatures.SubscriptionFeatureRegistrationsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SubscriptionFeatureRegistrationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, providerNamespace string, featureName string, options *armfeatures.SubscriptionFeatureRegistrationsClientGetOptions) (resp azfake.Responder[armfeatures.SubscriptionFeatureRegistrationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListAllBySubscriptionPager is the fake for method SubscriptionFeatureRegistrationsClient.NewListAllBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllBySubscriptionPager func(options *armfeatures.SubscriptionFeatureRegistrationsClientListAllBySubscriptionOptions) (resp azfake.PagerResponder[armfeatures.SubscriptionFeatureRegistrationsClientListAllBySubscriptionResponse])

	// NewListBySubscriptionPager is the fake for method SubscriptionFeatureRegistrationsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(providerNamespace string, options *armfeatures.SubscriptionFeatureRegistrationsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armfeatures.SubscriptionFeatureRegistrationsClientListBySubscriptionResponse])
}

// NewSubscriptionFeatureRegistrationsServerTransport creates a new instance of SubscriptionFeatureRegistrationsServerTransport with the provided implementation.
// The returned SubscriptionFeatureRegistrationsServerTransport instance is connected to an instance of armfeatures.SubscriptionFeatureRegistrationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSubscriptionFeatureRegistrationsServerTransport(srv *SubscriptionFeatureRegistrationsServer) *SubscriptionFeatureRegistrationsServerTransport {
	return &SubscriptionFeatureRegistrationsServerTransport{
		srv:                           srv,
		newListAllBySubscriptionPager: newTracker[azfake.PagerResponder[armfeatures.SubscriptionFeatureRegistrationsClientListAllBySubscriptionResponse]](),
		newListBySubscriptionPager:    newTracker[azfake.PagerResponder[armfeatures.SubscriptionFeatureRegistrationsClientListBySubscriptionResponse]](),
	}
}

// SubscriptionFeatureRegistrationsServerTransport connects instances of armfeatures.SubscriptionFeatureRegistrationsClient to instances of SubscriptionFeatureRegistrationsServer.
// Don't use this type directly, use NewSubscriptionFeatureRegistrationsServerTransport instead.
type SubscriptionFeatureRegistrationsServerTransport struct {
	srv                           *SubscriptionFeatureRegistrationsServer
	newListAllBySubscriptionPager *tracker[azfake.PagerResponder[armfeatures.SubscriptionFeatureRegistrationsClientListAllBySubscriptionResponse]]
	newListBySubscriptionPager    *tracker[azfake.PagerResponder[armfeatures.SubscriptionFeatureRegistrationsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for SubscriptionFeatureRegistrationsServerTransport.
func (s *SubscriptionFeatureRegistrationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SubscriptionFeatureRegistrationsClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SubscriptionFeatureRegistrationsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SubscriptionFeatureRegistrationsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SubscriptionFeatureRegistrationsClient.NewListAllBySubscriptionPager":
		resp, err = s.dispatchNewListAllBySubscriptionPager(req)
	case "SubscriptionFeatureRegistrationsClient.NewListBySubscriptionPager":
		resp, err = s.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SubscriptionFeatureRegistrationsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Features/featureProviders/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptionFeatureRegistrations/(?P<featureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armfeatures.SubscriptionFeatureRegistration](req)
	if err != nil {
		return nil, err
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	featureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("featureName")])
	if err != nil {
		return nil, err
	}
	var options *armfeatures.SubscriptionFeatureRegistrationsClientCreateOrUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armfeatures.SubscriptionFeatureRegistrationsClientCreateOrUpdateOptions{
			SubscriptionFeatureRegistrationType: &body,
		}
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), providerNamespaceParam, featureNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SubscriptionFeatureRegistration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubscriptionFeatureRegistrationsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Features/featureProviders/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptionFeatureRegistrations/(?P<featureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	featureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("featureName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), providerNamespaceParam, featureNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubscriptionFeatureRegistrationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Features/featureProviders/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptionFeatureRegistrations/(?P<featureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	featureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("featureName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), providerNamespaceParam, featureNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SubscriptionFeatureRegistration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubscriptionFeatureRegistrationsServerTransport) dispatchNewListAllBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListAllBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllBySubscriptionPager not implemented")}
	}
	newListAllBySubscriptionPager := s.newListAllBySubscriptionPager.get(req)
	if newListAllBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Features/subscriptionFeatureRegistrations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListAllBySubscriptionPager(nil)
		newListAllBySubscriptionPager = &resp
		s.newListAllBySubscriptionPager.add(req, newListAllBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListAllBySubscriptionPager, req, func(page *armfeatures.SubscriptionFeatureRegistrationsClientListAllBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListAllBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllBySubscriptionPager) {
		s.newListAllBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (s *SubscriptionFeatureRegistrationsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := s.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Features/featureProviders/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptionFeatureRegistrations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListBySubscriptionPager(providerNamespaceParam, nil)
		newListBySubscriptionPager = &resp
		s.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armfeatures.SubscriptionFeatureRegistrationsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		s.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
