//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicy

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAssignmentsClient creates a new instance of AssignmentsClient.
func (c *ClientFactory) NewAssignmentsClient() *AssignmentsClient {
	subClient, _ := NewAssignmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataPolicyManifestsClient creates a new instance of DataPolicyManifestsClient.
func (c *ClientFactory) NewDataPolicyManifestsClient() *DataPolicyManifestsClient {
	subClient, _ := NewDataPolicyManifestsClient(c.credential, c.options)
	return subClient
}

// NewDefinitionsClient creates a new instance of DefinitionsClient.
func (c *ClientFactory) NewDefinitionsClient() *DefinitionsClient {
	subClient, _ := NewDefinitionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewExemptionsClient creates a new instance of ExemptionsClient.
func (c *ClientFactory) NewExemptionsClient() *ExemptionsClient {
	subClient, _ := NewExemptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSetDefinitionsClient creates a new instance of SetDefinitionsClient.
func (c *ClientFactory) NewSetDefinitionsClient() *SetDefinitionsClient {
	subClient, _ := NewSetDefinitionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVariableValuesClient creates a new instance of VariableValuesClient.
func (c *ClientFactory) NewVariableValuesClient() *VariableValuesClient {
	subClient, _ := NewVariableValuesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVariablesClient creates a new instance of VariablesClient.
func (c *ClientFactory) NewVariablesClient() *VariablesClient {
	subClient, _ := NewVariablesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
