//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicy_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armpolicy"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/createOrUpdatePolicySetDefinition.json
func ExampleSetDefinitionsClient_CreateOrUpdate_createOrUpdateAPolicySetDefinition() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSetDefinitionsClient().CreateOrUpdate(ctx, "CostManagement", armpolicy.SetDefinition{
		Properties: &armpolicy.SetDefinitionProperties{
			Description: to.Ptr("Policies to enforce low cost storage SKUs"),
			DisplayName: to.Ptr("Cost Management"),
			Metadata: map[string]any{
				"category": "Cost Management",
			},
			Parameters: map[string]*armpolicy.ParameterDefinitionsValue{
				"namePrefix": {
					Type:         to.Ptr(armpolicy.ParameterTypeString),
					DefaultValue: "myPrefix",
					Metadata: &armpolicy.ParameterDefinitionsValueMetadata{
						DisplayName: to.Ptr("Prefix to enforce on resource names"),
					},
				},
			},
			PolicyDefinitions: []*armpolicy.DefinitionReference{
				{
					Parameters: map[string]*armpolicy.ParameterValuesValue{
						"listOfAllowedSKUs": {
							Value: []any{
								"Standard_GRS",
								"Standard_LRS",
							},
						},
					},
					PolicyDefinitionID:          to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
					PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
				},
				{
					Parameters: map[string]*armpolicy.ParameterValuesValue{
						"prefix": {
							Value: "[parameters('namePrefix')]",
						},
						"suffix": {
							Value: "-LC",
						},
					},
					PolicyDefinitionID:          to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
					PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SetDefinition = armpolicy.SetDefinition{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 	Properties: &armpolicy.SetDefinitionProperties{
	// 		Description: to.Ptr("Policies to enforce low cost storage SKUs"),
	// 		DisplayName: to.Ptr("Cost Management"),
	// 		Metadata: map[string]any{
	// 			"category": "Cost Management",
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterDefinitionsValue{
	// 			"namePrefix": &armpolicy.ParameterDefinitionsValue{
	// 				Type: to.Ptr(armpolicy.ParameterTypeString),
	// 				DefaultValue: "myPrefix",
	// 				Metadata: &armpolicy.ParameterDefinitionsValueMetadata{
	// 					DisplayName: to.Ptr("Prefix to enforce on resource names"),
	// 				},
	// 			},
	// 		},
	// 		PolicyDefinitions: []*armpolicy.DefinitionReference{
	// 			{
	// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 					"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 						Value: []any{
	// 							"Standard_GRS",
	// 							"Standard_LRS",
	// 						},
	// 					},
	// 				},
	// 				PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 				PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
	// 			},
	// 			{
	// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 					"prefix": &armpolicy.ParameterValuesValue{
	// 						Value: "[parameters('namePrefix')]",
	// 					},
	// 					"suffix": &armpolicy.ParameterValuesValue{
	// 						Value: "-LC",
	// 					},
	// 				},
	// 				PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 				PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/createOrUpdatePolicySetDefinitionWithGroups.json
func ExampleSetDefinitionsClient_CreateOrUpdate_createOrUpdateAPolicySetDefinitionWithGroups() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSetDefinitionsClient().CreateOrUpdate(ctx, "CostManagement", armpolicy.SetDefinition{
		Properties: &armpolicy.SetDefinitionProperties{
			Description: to.Ptr("Policies to enforce low cost storage SKUs"),
			DisplayName: to.Ptr("Cost Management"),
			Metadata: map[string]any{
				"category": "Cost Management",
			},
			PolicyDefinitionGroups: []*armpolicy.DefinitionGroup{
				{
					Name:        to.Ptr("CostSaving"),
					Description: to.Ptr("Policies designed to control spend within a subscription."),
					DisplayName: to.Ptr("Cost Management Policies"),
				},
				{
					Name:        to.Ptr("Organizational"),
					Description: to.Ptr("Policies that help enforce resource organization standards within a subscription."),
					DisplayName: to.Ptr("Organizational Policies"),
				}},
			PolicyDefinitions: []*armpolicy.DefinitionReference{
				{
					GroupNames: []*string{
						to.Ptr("CostSaving")},
					Parameters: map[string]*armpolicy.ParameterValuesValue{
						"listOfAllowedSKUs": {
							Value: []any{
								"Standard_GRS",
								"Standard_LRS",
							},
						},
					},
					PolicyDefinitionID:          to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
					PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
				},
				{
					GroupNames: []*string{
						to.Ptr("Organizational")},
					Parameters: map[string]*armpolicy.ParameterValuesValue{
						"prefix": {
							Value: "DeptA",
						},
						"suffix": {
							Value: "-LC",
						},
					},
					PolicyDefinitionID:          to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
					PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SetDefinition = armpolicy.SetDefinition{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 	Properties: &armpolicy.SetDefinitionProperties{
	// 		Description: to.Ptr("Policies to enforce low cost storage SKUs"),
	// 		DisplayName: to.Ptr("Cost Management"),
	// 		Metadata: map[string]any{
	// 			"category": "Cost Management",
	// 		},
	// 		PolicyDefinitionGroups: []*armpolicy.DefinitionGroup{
	// 			{
	// 				Name: to.Ptr("CostSaving"),
	// 				Description: to.Ptr("Policies designed to control spend within a subscription."),
	// 				DisplayName: to.Ptr("Cost Management Policies"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Organizational"),
	// 				Description: to.Ptr("Policies that help enforce resource organization standards within a subscription."),
	// 				DisplayName: to.Ptr("Organizational Policies"),
	// 		}},
	// 		PolicyDefinitions: []*armpolicy.DefinitionReference{
	// 			{
	// 				GroupNames: []*string{
	// 					to.Ptr("CostSaving")},
	// 					Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 						"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 							Value: []any{
	// 								"Standard_GRS",
	// 								"Standard_LRS",
	// 							},
	// 						},
	// 					},
	// 					PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 					PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
	// 				},
	// 				{
	// 					GroupNames: []*string{
	// 						to.Ptr("Organizational")},
	// 						Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 							"prefix": &armpolicy.ParameterValuesValue{
	// 								Value: "DeptA",
	// 							},
	// 							"suffix": &armpolicy.ParameterValuesValue{
	// 								Value: "-LC",
	// 							},
	// 						},
	// 						PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 						PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
	// 				}},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/deletePolicySetDefinition.json
func ExampleSetDefinitionsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSetDefinitionsClient().Delete(ctx, "CostManagement", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/getPolicySetDefinition.json
func ExampleSetDefinitionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSetDefinitionsClient().Get(ctx, "CostManagement", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SetDefinition = armpolicy.SetDefinition{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 	Properties: &armpolicy.SetDefinitionProperties{
	// 		Description: to.Ptr("Policies to enforce low cost storage SKUs"),
	// 		DisplayName: to.Ptr("Cost Management"),
	// 		Metadata: map[string]any{
	// 			"category": "Cost Management",
	// 		},
	// 		PolicyDefinitionGroups: []*armpolicy.DefinitionGroup{
	// 			{
	// 				Name: to.Ptr("CostSaving"),
	// 				Description: to.Ptr("Policies designed to control spend within a subscription."),
	// 				DisplayName: to.Ptr("Cost Management Policies"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Organizational"),
	// 				Description: to.Ptr("Policies that help enforce resource organization standards within a subscription."),
	// 				DisplayName: to.Ptr("Organizational Policies"),
	// 		}},
	// 		PolicyDefinitions: []*armpolicy.DefinitionReference{
	// 			{
	// 				GroupNames: []*string{
	// 					to.Ptr("CostSaving")},
	// 					Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 						"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 							Value: []any{
	// 								"Standard_GRS",
	// 								"Standard_LRS",
	// 							},
	// 						},
	// 					},
	// 					PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 					PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
	// 				},
	// 				{
	// 					GroupNames: []*string{
	// 						to.Ptr("Organizational")},
	// 						Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 							"prefix": &armpolicy.ParameterValuesValue{
	// 								Value: "DeptA",
	// 							},
	// 							"suffix": &armpolicy.ParameterValuesValue{
	// 								Value: "-LC",
	// 							},
	// 						},
	// 						PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 						PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
	// 				}},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/getBuiltInPolicySetDefinition.json
func ExampleSetDefinitionsClient_GetBuiltIn() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSetDefinitionsClient().GetBuiltIn(ctx, "1f3afdf9-d0c9-4c3d-847f-89da613e70a8", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SetDefinition = armpolicy.SetDefinition{
	// 	Name: to.Ptr("1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
	// 	Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
	// 	ID: to.Ptr("/providers/Microsoft.Authorization/policySetDefinitions/1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
	// 	Properties: &armpolicy.SetDefinitionProperties{
	// 		Description: to.Ptr("Monitor all the available security recommendations in Azure Security Center. This is the default policy for Azure Security Center."),
	// 		DisplayName: to.Ptr("[Preview]: Enable Monitoring in Azure Security Center"),
	// 		Metadata: map[string]any{
	// 			"category": "Security Center",
	// 		},
	// 		Parameters: map[string]*armpolicy.ParameterDefinitionsValue{
	// 		},
	// 		PolicyDefinitions: []*armpolicy.DefinitionReference{
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/a8bef009-a5c9-4d0f-90d7-6018734e8a16"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId1"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/af8051bf-258b-44e2-a2bf-165330459f9d"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId2"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/86b3d65f-7626-441e-b690-81a8b71cff60"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId3"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/655cb504-bcee-4362-bd4c-402e6aa38759"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId4"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/b0f33259-77d7-4c9e-aac6-3aabcfae693c"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId5"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/47a6b606-51aa-4496-8bb7-64b11cf66adc"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId6"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/44452482-524f-4bf4-b852-0bff7cc4a3ed"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId7"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/e1e5fd5d-3e4c-4ce1-8661-7d1873ae6b15"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId8"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/af6cd1bd-1635-48cb-bde7-5b15693900b9"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId9"),
	// 			},
	// 			{
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/0961003e-5a0a-4549-abde-af6a37f2724d"),
	// 				PolicyDefinitionReferenceID: to.Ptr("RefId10"),
	// 		}},
	// 		PolicyType: to.Ptr(armpolicy.PolicyTypeBuiltIn),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/listPolicySetDefinitions.json
func ExampleSetDefinitionsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSetDefinitionsClient().NewListPager(&armpolicy.SetDefinitionsClientListOptions{Filter: nil,
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SetDefinitionListResult = armpolicy.SetDefinitionListResult{
		// 	Value: []*armpolicy.SetDefinition{
		// 		{
		// 			Name: to.Ptr("1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
		// 			Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
		// 			ID: to.Ptr("/providers/Microsoft.Authorization/policySetDefinitions/1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
		// 			Properties: &armpolicy.SetDefinitionProperties{
		// 				Description: to.Ptr("Monitor all the available security recommendations in Azure Security Center. This is the default policy for Azure Security Center."),
		// 				DisplayName: to.Ptr("[Preview]: Enable Monitoring in Azure Security Center"),
		// 				Metadata: map[string]any{
		// 					"category": "Security Center",
		// 				},
		// 				Parameters: map[string]*armpolicy.ParameterDefinitionsValue{
		// 				},
		// 				PolicyDefinitions: []*armpolicy.DefinitionReference{
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/a8bef009-a5c9-4d0f-90d7-6018734e8a16"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId1"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/af8051bf-258b-44e2-a2bf-165330459f9d"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId2"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/86b3d65f-7626-441e-b690-81a8b71cff60"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId3"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/655cb504-bcee-4362-bd4c-402e6aa38759"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId4"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/b0f33259-77d7-4c9e-aac6-3aabcfae693c"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId5"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/47a6b606-51aa-4496-8bb7-64b11cf66adc"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId6"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/44452482-524f-4bf4-b852-0bff7cc4a3ed"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId7"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/e1e5fd5d-3e4c-4ce1-8661-7d1873ae6b15"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId8"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/af6cd1bd-1635-48cb-bde7-5b15693900b9"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId9"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/0961003e-5a0a-4549-abde-af6a37f2724d"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId10"),
		// 				}},
		// 				PolicyType: to.Ptr(armpolicy.PolicyTypeBuiltIn),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("CostManagement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
		// 			Properties: &armpolicy.SetDefinitionProperties{
		// 				Description: to.Ptr("Policies to enforce low cost storage SKUs"),
		// 				DisplayName: to.Ptr("Cost Management"),
		// 				Metadata: map[string]any{
		// 					"category": "Cost Management",
		// 				},
		// 				PolicyDefinitions: []*armpolicy.DefinitionReference{
		// 					{
		// 						Parameters: map[string]*armpolicy.ParameterValuesValue{
		// 							"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
		// 								Value: []any{
		// 									"Standard_GRS",
		// 									"Standard_LRS",
		// 								},
		// 							},
		// 						},
		// 						PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
		// 						PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
		// 					},
		// 					{
		// 						Parameters: map[string]*armpolicy.ParameterValuesValue{
		// 							"prefix": &armpolicy.ParameterValuesValue{
		// 								Value: "DeptA",
		// 							},
		// 							"suffix": &armpolicy.ParameterValuesValue{
		// 								Value: "-LC",
		// 							},
		// 						},
		// 						PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
		// 						PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
		// 				}},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/listBuiltInPolicySetDefinitions.json
func ExampleSetDefinitionsClient_NewListBuiltInPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSetDefinitionsClient().NewListBuiltInPager(&armpolicy.SetDefinitionsClientListBuiltInOptions{Filter: nil,
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SetDefinitionListResult = armpolicy.SetDefinitionListResult{
		// 	Value: []*armpolicy.SetDefinition{
		// 		{
		// 			Name: to.Ptr("1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
		// 			Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
		// 			ID: to.Ptr("/providers/Microsoft.Authorization/policySetDefinitions/1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
		// 			Properties: &armpolicy.SetDefinitionProperties{
		// 				Description: to.Ptr("Monitor all the available security recommendations in Azure Security Center. This is the default policy for Azure Security Center."),
		// 				DisplayName: to.Ptr("[Preview]: Enable Monitoring in Azure Security Center"),
		// 				Metadata: map[string]any{
		// 					"category": "Security Center",
		// 				},
		// 				Parameters: map[string]*armpolicy.ParameterDefinitionsValue{
		// 				},
		// 				PolicyDefinitions: []*armpolicy.DefinitionReference{
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/a8bef009-a5c9-4d0f-90d7-6018734e8a16"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId1"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/af8051bf-258b-44e2-a2bf-165330459f9d"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId2"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/86b3d65f-7626-441e-b690-81a8b71cff60"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId3"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/655cb504-bcee-4362-bd4c-402e6aa38759"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId4"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/b0f33259-77d7-4c9e-aac6-3aabcfae693c"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId5"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/47a6b606-51aa-4496-8bb7-64b11cf66adc"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId6"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/44452482-524f-4bf4-b852-0bff7cc4a3ed"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId7"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/e1e5fd5d-3e4c-4ce1-8661-7d1873ae6b15"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId8"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/af6cd1bd-1635-48cb-bde7-5b15693900b9"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId9"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/0961003e-5a0a-4549-abde-af6a37f2724d"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId10"),
		// 				}},
		// 				PolicyType: to.Ptr(armpolicy.PolicyTypeBuiltIn),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/createOrUpdatePolicySetDefinitionAtManagementGroup.json
func ExampleSetDefinitionsClient_CreateOrUpdateAtManagementGroup_createOrUpdateAPolicySetDefinitionAtManagementGroupLevel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSetDefinitionsClient().CreateOrUpdateAtManagementGroup(ctx, "CostManagement", "MyManagementGroup", armpolicy.SetDefinition{
		Properties: &armpolicy.SetDefinitionProperties{
			Description: to.Ptr("Policies to enforce low cost storage SKUs"),
			DisplayName: to.Ptr("Cost Management"),
			Metadata: map[string]any{
				"category": "Cost Management",
			},
			PolicyDefinitions: []*armpolicy.DefinitionReference{
				{
					Parameters: map[string]*armpolicy.ParameterValuesValue{
						"listOfAllowedSKUs": {
							Value: []any{
								"Standard_GRS",
								"Standard_LRS",
							},
						},
					},
					PolicyDefinitionID:          to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
					PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
				},
				{
					Parameters: map[string]*armpolicy.ParameterValuesValue{
						"prefix": {
							Value: "DeptA",
						},
						"suffix": {
							Value: "-LC",
						},
					},
					PolicyDefinitionID:          to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
					PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SetDefinition = armpolicy.SetDefinition{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 	Properties: &armpolicy.SetDefinitionProperties{
	// 		Description: to.Ptr("Policies to enforce low cost storage SKUs"),
	// 		DisplayName: to.Ptr("Cost Management"),
	// 		Metadata: map[string]any{
	// 			"category": "Cost Management",
	// 		},
	// 		PolicyDefinitions: []*armpolicy.DefinitionReference{
	// 			{
	// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 					"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 						Value: []any{
	// 							"Standard_GRS",
	// 							"Standard_LRS",
	// 						},
	// 					},
	// 				},
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 				PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
	// 			},
	// 			{
	// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 					"prefix": &armpolicy.ParameterValuesValue{
	// 						Value: "DeptA",
	// 					},
	// 					"suffix": &armpolicy.ParameterValuesValue{
	// 						Value: "-LC",
	// 					},
	// 				},
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 				PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/createOrUpdatePolicySetDefinitionWithGroupsAtManagementGroup.json
func ExampleSetDefinitionsClient_CreateOrUpdateAtManagementGroup_createOrUpdateAPolicySetDefinitionWithGroupsAtManagementGroupLevel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSetDefinitionsClient().CreateOrUpdateAtManagementGroup(ctx, "CostManagement", "MyManagementGroup", armpolicy.SetDefinition{
		Properties: &armpolicy.SetDefinitionProperties{
			Description: to.Ptr("Policies to enforce low cost storage SKUs"),
			DisplayName: to.Ptr("Cost Management"),
			Metadata: map[string]any{
				"category": "Cost Management",
			},
			PolicyDefinitionGroups: []*armpolicy.DefinitionGroup{
				{
					Name:        to.Ptr("CostSaving"),
					Description: to.Ptr("Policies designed to control spend within a subscription."),
					DisplayName: to.Ptr("Cost Management Policies"),
				},
				{
					Name:        to.Ptr("Organizational"),
					Description: to.Ptr("Policies that help enforce resource organization standards within a subscription."),
					DisplayName: to.Ptr("Organizational Policies"),
				}},
			PolicyDefinitions: []*armpolicy.DefinitionReference{
				{
					GroupNames: []*string{
						to.Ptr("CostSaving")},
					Parameters: map[string]*armpolicy.ParameterValuesValue{
						"listOfAllowedSKUs": {
							Value: []any{
								"Standard_GRS",
								"Standard_LRS",
							},
						},
					},
					PolicyDefinitionID:          to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
					PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
				},
				{
					GroupNames: []*string{
						to.Ptr("Organizational")},
					Parameters: map[string]*armpolicy.ParameterValuesValue{
						"prefix": {
							Value: "DeptA",
						},
						"suffix": {
							Value: "-LC",
						},
					},
					PolicyDefinitionID:          to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
					PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SetDefinition = armpolicy.SetDefinition{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 	Properties: &armpolicy.SetDefinitionProperties{
	// 		Description: to.Ptr("Policies to enforce low cost storage SKUs"),
	// 		DisplayName: to.Ptr("Cost Management"),
	// 		Metadata: map[string]any{
	// 			"category": "Cost Management",
	// 		},
	// 		PolicyDefinitionGroups: []*armpolicy.DefinitionGroup{
	// 			{
	// 				Name: to.Ptr("CostSaving"),
	// 				Description: to.Ptr("Policies designed to control spend within a subscription."),
	// 				DisplayName: to.Ptr("Cost Management Policies"),
	// 			},
	// 			{
	// 				Name: to.Ptr("Organizational"),
	// 				Description: to.Ptr("Policies that help enforce resource organization standards within a subscription."),
	// 				DisplayName: to.Ptr("Organizational Policies"),
	// 		}},
	// 		PolicyDefinitions: []*armpolicy.DefinitionReference{
	// 			{
	// 				GroupNames: []*string{
	// 					to.Ptr("CostSaving")},
	// 					Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 						"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 							Value: []any{
	// 								"Standard_GRS",
	// 								"Standard_LRS",
	// 							},
	// 						},
	// 					},
	// 					PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 					PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
	// 				},
	// 				{
	// 					GroupNames: []*string{
	// 						to.Ptr("Organizational")},
	// 						Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 							"prefix": &armpolicy.ParameterValuesValue{
	// 								Value: "DeptA",
	// 							},
	// 							"suffix": &armpolicy.ParameterValuesValue{
	// 								Value: "-LC",
	// 							},
	// 						},
	// 						PolicyDefinitionID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 						PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
	// 				}},
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/deletePolicySetDefinitionAtManagementGroup.json
func ExampleSetDefinitionsClient_DeleteAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSetDefinitionsClient().DeleteAtManagementGroup(ctx, "CostManagement", "MyManagementGroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/getPolicySetDefinitionAtManagementGroup.json
func ExampleSetDefinitionsClient_GetAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSetDefinitionsClient().GetAtManagementGroup(ctx, "CostManagement", "MyManagementGroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SetDefinition = armpolicy.SetDefinition{
	// 	Name: to.Ptr("CostManagement"),
	// 	Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
	// 	Properties: &armpolicy.SetDefinitionProperties{
	// 		Description: to.Ptr("Policies to enforce low cost storage SKUs"),
	// 		DisplayName: to.Ptr("Cost Management"),
	// 		Metadata: map[string]any{
	// 			"category": "Cost Management",
	// 		},
	// 		PolicyDefinitions: []*armpolicy.DefinitionReference{
	// 			{
	// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 					"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
	// 						Value: []any{
	// 							"Standard_GRS",
	// 							"Standard_LRS",
	// 						},
	// 					},
	// 				},
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
	// 				PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
	// 			},
	// 			{
	// 				Parameters: map[string]*armpolicy.ParameterValuesValue{
	// 					"prefix": &armpolicy.ParameterValuesValue{
	// 						Value: "DeptA",
	// 					},
	// 					"suffix": &armpolicy.ParameterValuesValue{
	// 						Value: "-LC",
	// 					},
	// 				},
	// 				PolicyDefinitionID: to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
	// 				PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/listPolicySetDefinitionsByManagementGroup.json
func ExampleSetDefinitionsClient_NewListByManagementGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSetDefinitionsClient().NewListByManagementGroupPager("MyManagementGroup", &armpolicy.SetDefinitionsClientListByManagementGroupOptions{Filter: nil,
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SetDefinitionListResult = armpolicy.SetDefinitionListResult{
		// 	Value: []*armpolicy.SetDefinition{
		// 		{
		// 			Name: to.Ptr("1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
		// 			Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
		// 			ID: to.Ptr("/providers/Microsoft.Authorization/policySetDefinitions/1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
		// 			Properties: &armpolicy.SetDefinitionProperties{
		// 				Description: to.Ptr("Monitor all the available security recommendations in Azure Security Center. This is the default policy for Azure Security Center."),
		// 				DisplayName: to.Ptr("[Preview]: Enable Monitoring in Azure Security Center"),
		// 				Metadata: map[string]any{
		// 					"category": "Security Center",
		// 				},
		// 				Parameters: map[string]*armpolicy.ParameterDefinitionsValue{
		// 				},
		// 				PolicyDefinitions: []*armpolicy.DefinitionReference{
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/a8bef009-a5c9-4d0f-90d7-6018734e8a16"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId1"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/af8051bf-258b-44e2-a2bf-165330459f9d"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId2"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/86b3d65f-7626-441e-b690-81a8b71cff60"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId3"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/655cb504-bcee-4362-bd4c-402e6aa38759"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId4"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/b0f33259-77d7-4c9e-aac6-3aabcfae693c"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId5"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/47a6b606-51aa-4496-8bb7-64b11cf66adc"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId6"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/44452482-524f-4bf4-b852-0bff7cc4a3ed"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId7"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/e1e5fd5d-3e4c-4ce1-8661-7d1873ae6b15"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId8"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/af6cd1bd-1635-48cb-bde7-5b15693900b9"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId9"),
		// 					},
		// 					{
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/0961003e-5a0a-4549-abde-af6a37f2724d"),
		// 						PolicyDefinitionReferenceID: to.Ptr("RefId10"),
		// 				}},
		// 				PolicyType: to.Ptr(armpolicy.PolicyTypeBuiltIn),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("CostManagement"),
		// 			Type: to.Ptr("Microsoft.Authorization/policySetDefinitions"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
		// 			Properties: &armpolicy.SetDefinitionProperties{
		// 				Description: to.Ptr("Policies to enforce low cost storage SKUs"),
		// 				DisplayName: to.Ptr("Cost Management"),
		// 				Metadata: map[string]any{
		// 					"category": "Cost Management",
		// 				},
		// 				PolicyDefinitions: []*armpolicy.DefinitionReference{
		// 					{
		// 						Parameters: map[string]*armpolicy.ParameterValuesValue{
		// 							"listOfAllowedSKUs": &armpolicy.ParameterValuesValue{
		// 								Value: []any{
		// 									"Standard_GRS",
		// 									"Standard_LRS",
		// 								},
		// 							},
		// 						},
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
		// 						PolicyDefinitionReferenceID: to.Ptr("Limit_Skus"),
		// 					},
		// 					{
		// 						Parameters: map[string]*armpolicy.ParameterValuesValue{
		// 							"prefix": &armpolicy.ParameterValuesValue{
		// 								Value: "DeptA",
		// 							},
		// 							"suffix": &armpolicy.ParameterValuesValue{
		// 								Value: "-LC",
		// 							},
		// 						},
		// 						PolicyDefinitionID: to.Ptr("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
		// 						PolicyDefinitionReferenceID: to.Ptr("Resource_Naming"),
		// 				}},
		// 			},
		// 	}},
		// }
	}
}
