//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// APICollectionsClient contains the methods for the APICollections group.
// Don't use this type directly, use NewAPICollectionsClient() instead.
type APICollectionsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAPICollectionsClient creates a new instance of APICollectionsClient with the specified values.
//   - subscriptionID - Azure subscription ID
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAPICollectionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*APICollectionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &APICollectionsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// GetByAzureAPIManagementService - Gets an Azure API Management API if it has been onboarded to Microsoft Defender for APIs.
// If an Azure API Management API is onboarded to Microsoft Defender for APIs, the system will monitor the
// operations within the Azure API Management API for intrusive behaviors and provide alerts for attacks that have been detected.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - serviceName - The name of the API Management service.
//   - apiID - API revision identifier. Must be unique in the API Management service instance. Non-current revision has ;rev=n
//     as a suffix where n is the revision number.
//   - options - APICollectionsClientGetByAzureAPIManagementServiceOptions contains the optional parameters for the APICollectionsClient.GetByAzureAPIManagementService
//     method.
func (client *APICollectionsClient) GetByAzureAPIManagementService(ctx context.Context, resourceGroupName string, serviceName string, apiID string, options *APICollectionsClientGetByAzureAPIManagementServiceOptions) (APICollectionsClientGetByAzureAPIManagementServiceResponse, error) {
	var err error
	const operationName = "APICollectionsClient.GetByAzureAPIManagementService"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getByAzureAPIManagementServiceCreateRequest(ctx, resourceGroupName, serviceName, apiID, options)
	if err != nil {
		return APICollectionsClientGetByAzureAPIManagementServiceResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return APICollectionsClientGetByAzureAPIManagementServiceResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return APICollectionsClientGetByAzureAPIManagementServiceResponse{}, err
	}
	resp, err := client.getByAzureAPIManagementServiceHandleResponse(httpResp)
	return resp, err
}

// getByAzureAPIManagementServiceCreateRequest creates the GetByAzureAPIManagementService request.
func (client *APICollectionsClient) getByAzureAPIManagementServiceCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, apiID string, options *APICollectionsClientGetByAzureAPIManagementServiceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/providers/Microsoft.Security/apiCollections/{apiId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if apiID == "" {
		return nil, errors.New("parameter apiID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{apiId}", url.PathEscape(apiID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getByAzureAPIManagementServiceHandleResponse handles the GetByAzureAPIManagementService response.
func (client *APICollectionsClient) getByAzureAPIManagementServiceHandleResponse(resp *http.Response) (APICollectionsClientGetByAzureAPIManagementServiceResponse, error) {
	result := APICollectionsClientGetByAzureAPIManagementServiceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APICollection); err != nil {
		return APICollectionsClientGetByAzureAPIManagementServiceResponse{}, err
	}
	return result, nil
}

// NewListByAzureAPIManagementServicePager - Gets a list of Azure API Management APIs that have been onboarded to Microsoft
// Defender for APIs. If an Azure API Management API is onboarded to Microsoft Defender for APIs, the system will monitor
// the operations within the Azure API Management API for intrusive behaviors and provide alerts for attacks that have been
// detected.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - serviceName - The name of the API Management service.
//   - options - APICollectionsClientListByAzureAPIManagementServiceOptions contains the optional parameters for the APICollectionsClient.NewListByAzureAPIManagementServicePager
//     method.
func (client *APICollectionsClient) NewListByAzureAPIManagementServicePager(resourceGroupName string, serviceName string, options *APICollectionsClientListByAzureAPIManagementServiceOptions) *runtime.Pager[APICollectionsClientListByAzureAPIManagementServiceResponse] {
	return runtime.NewPager(runtime.PagingHandler[APICollectionsClientListByAzureAPIManagementServiceResponse]{
		More: func(page APICollectionsClientListByAzureAPIManagementServiceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *APICollectionsClientListByAzureAPIManagementServiceResponse) (APICollectionsClientListByAzureAPIManagementServiceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "APICollectionsClient.NewListByAzureAPIManagementServicePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByAzureAPIManagementServiceCreateRequest(ctx, resourceGroupName, serviceName, options)
			}, nil)
			if err != nil {
				return APICollectionsClientListByAzureAPIManagementServiceResponse{}, err
			}
			return client.listByAzureAPIManagementServiceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByAzureAPIManagementServiceCreateRequest creates the ListByAzureAPIManagementService request.
func (client *APICollectionsClient) listByAzureAPIManagementServiceCreateRequest(ctx context.Context, resourceGroupName string, serviceName string, options *APICollectionsClientListByAzureAPIManagementServiceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/providers/Microsoft.Security/apiCollections"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByAzureAPIManagementServiceHandleResponse handles the ListByAzureAPIManagementService response.
func (client *APICollectionsClient) listByAzureAPIManagementServiceHandleResponse(resp *http.Response) (APICollectionsClientListByAzureAPIManagementServiceResponse, error) {
	result := APICollectionsClientListByAzureAPIManagementServiceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APICollectionList); err != nil {
		return APICollectionsClientListByAzureAPIManagementServiceResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Gets a list of API collections within a resource group that have been onboarded to Microsoft
// Defender for APIs.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - APICollectionsClientListByResourceGroupOptions contains the optional parameters for the APICollectionsClient.NewListByResourceGroupPager
//     method.
func (client *APICollectionsClient) NewListByResourceGroupPager(resourceGroupName string, options *APICollectionsClientListByResourceGroupOptions) *runtime.Pager[APICollectionsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[APICollectionsClientListByResourceGroupResponse]{
		More: func(page APICollectionsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *APICollectionsClientListByResourceGroupResponse) (APICollectionsClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "APICollectionsClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return APICollectionsClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *APICollectionsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *APICollectionsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/apiCollections"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *APICollectionsClient) listByResourceGroupHandleResponse(resp *http.Response) (APICollectionsClientListByResourceGroupResponse, error) {
	result := APICollectionsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APICollectionList); err != nil {
		return APICollectionsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Gets a list of API collections within a subscription that have been onboarded to Microsoft
// Defender for APIs.
//
// Generated from API version 2023-11-15
//   - options - APICollectionsClientListBySubscriptionOptions contains the optional parameters for the APICollectionsClient.NewListBySubscriptionPager
//     method.
func (client *APICollectionsClient) NewListBySubscriptionPager(options *APICollectionsClientListBySubscriptionOptions) *runtime.Pager[APICollectionsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[APICollectionsClientListBySubscriptionResponse]{
		More: func(page APICollectionsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *APICollectionsClientListBySubscriptionResponse) (APICollectionsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "APICollectionsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return APICollectionsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *APICollectionsClient) listBySubscriptionCreateRequest(ctx context.Context, options *APICollectionsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/apiCollections"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *APICollectionsClient) listBySubscriptionHandleResponse(resp *http.Response) (APICollectionsClientListBySubscriptionResponse, error) {
	result := APICollectionsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.APICollectionList); err != nil {
		return APICollectionsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// OffboardAzureAPIManagementAPI - Offboard an Azure API Management API from Microsoft Defender for APIs. The system will
// stop monitoring the operations within the Azure API Management API for intrusive behaviors.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - serviceName - The name of the API Management service.
//   - apiID - API revision identifier. Must be unique in the API Management service instance. Non-current revision has ;rev=n
//     as a suffix where n is the revision number.
//   - options - APICollectionsClientOffboardAzureAPIManagementAPIOptions contains the optional parameters for the APICollectionsClient.OffboardAzureAPIManagementAPI
//     method.
func (client *APICollectionsClient) OffboardAzureAPIManagementAPI(ctx context.Context, resourceGroupName string, serviceName string, apiID string, options *APICollectionsClientOffboardAzureAPIManagementAPIOptions) (APICollectionsClientOffboardAzureAPIManagementAPIResponse, error) {
	var err error
	const operationName = "APICollectionsClient.OffboardAzureAPIManagementAPI"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.offboardAzureAPIManagementAPICreateRequest(ctx, resourceGroupName, serviceName, apiID, options)
	if err != nil {
		return APICollectionsClientOffboardAzureAPIManagementAPIResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return APICollectionsClientOffboardAzureAPIManagementAPIResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return APICollectionsClientOffboardAzureAPIManagementAPIResponse{}, err
	}
	return APICollectionsClientOffboardAzureAPIManagementAPIResponse{}, nil
}

// offboardAzureAPIManagementAPICreateRequest creates the OffboardAzureAPIManagementAPI request.
func (client *APICollectionsClient) offboardAzureAPIManagementAPICreateRequest(ctx context.Context, resourceGroupName string, serviceName string, apiID string, options *APICollectionsClientOffboardAzureAPIManagementAPIOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/providers/Microsoft.Security/apiCollections/{apiId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if apiID == "" {
		return nil, errors.New("parameter apiID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{apiId}", url.PathEscape(apiID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginOnboardAzureAPIManagementAPI - Onboard an Azure API Management API to Microsoft Defender for APIs. The system will
// start monitoring the operations within the Azure Management API for intrusive behaviors and provide alerts for
// attacks that have been detected.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - serviceName - The name of the API Management service.
//   - apiID - API revision identifier. Must be unique in the API Management service instance. Non-current revision has ;rev=n
//     as a suffix where n is the revision number.
//   - options - APICollectionsClientBeginOnboardAzureAPIManagementAPIOptions contains the optional parameters for the APICollectionsClient.BeginOnboardAzureAPIManagementAPI
//     method.
func (client *APICollectionsClient) BeginOnboardAzureAPIManagementAPI(ctx context.Context, resourceGroupName string, serviceName string, apiID string, options *APICollectionsClientBeginOnboardAzureAPIManagementAPIOptions) (*runtime.Poller[APICollectionsClientOnboardAzureAPIManagementAPIResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.onboardAzureAPIManagementAPI(ctx, resourceGroupName, serviceName, apiID, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[APICollectionsClientOnboardAzureAPIManagementAPIResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[APICollectionsClientOnboardAzureAPIManagementAPIResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// OnboardAzureAPIManagementAPI - Onboard an Azure API Management API to Microsoft Defender for APIs. The system will start
// monitoring the operations within the Azure Management API for intrusive behaviors and provide alerts for
// attacks that have been detected.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
func (client *APICollectionsClient) onboardAzureAPIManagementAPI(ctx context.Context, resourceGroupName string, serviceName string, apiID string, options *APICollectionsClientBeginOnboardAzureAPIManagementAPIOptions) (*http.Response, error) {
	var err error
	const operationName = "APICollectionsClient.BeginOnboardAzureAPIManagementAPI"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.onboardAzureAPIManagementAPICreateRequest(ctx, resourceGroupName, serviceName, apiID, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// onboardAzureAPIManagementAPICreateRequest creates the OnboardAzureAPIManagementAPI request.
func (client *APICollectionsClient) onboardAzureAPIManagementAPICreateRequest(ctx context.Context, resourceGroupName string, serviceName string, apiID string, options *APICollectionsClientBeginOnboardAzureAPIManagementAPIOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/providers/Microsoft.Security/apiCollections/{apiId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if apiID == "" {
		return nil, errors.New("parameter apiID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{apiId}", url.PathEscape(apiID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
