//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// TopologyServer is a fake server for instances of the armsecurity.TopologyClient type.
type TopologyServer struct {
	// Get is the fake for method TopologyClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, ascLocation string, topologyResourceName string, options *armsecurity.TopologyClientGetOptions) (resp azfake.Responder[armsecurity.TopologyClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method TopologyClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.TopologyClientListOptions) (resp azfake.PagerResponder[armsecurity.TopologyClientListResponse])

	// NewListByHomeRegionPager is the fake for method TopologyClient.NewListByHomeRegionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByHomeRegionPager func(ascLocation string, options *armsecurity.TopologyClientListByHomeRegionOptions) (resp azfake.PagerResponder[armsecurity.TopologyClientListByHomeRegionResponse])
}

// NewTopologyServerTransport creates a new instance of TopologyServerTransport with the provided implementation.
// The returned TopologyServerTransport instance is connected to an instance of armsecurity.TopologyClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTopologyServerTransport(srv *TopologyServer) *TopologyServerTransport {
	return &TopologyServerTransport{
		srv:                      srv,
		newListPager:             newTracker[azfake.PagerResponder[armsecurity.TopologyClientListResponse]](),
		newListByHomeRegionPager: newTracker[azfake.PagerResponder[armsecurity.TopologyClientListByHomeRegionResponse]](),
	}
}

// TopologyServerTransport connects instances of armsecurity.TopologyClient to instances of TopologyServer.
// Don't use this type directly, use NewTopologyServerTransport instead.
type TopologyServerTransport struct {
	srv                      *TopologyServer
	newListPager             *tracker[azfake.PagerResponder[armsecurity.TopologyClientListResponse]]
	newListByHomeRegionPager *tracker[azfake.PagerResponder[armsecurity.TopologyClientListByHomeRegionResponse]]
}

// Do implements the policy.Transporter interface for TopologyServerTransport.
func (t *TopologyServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TopologyClient.Get":
		resp, err = t.dispatchGet(req)
	case "TopologyClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	case "TopologyClient.NewListByHomeRegionPager":
		resp, err = t.dispatchNewListByHomeRegionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TopologyServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/topologies/(?P<topologyResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	topologyResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("topologyResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, ascLocationParam, topologyResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TopologyResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TopologyServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/topologies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := t.srv.NewListPager(nil)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.TopologyClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}

func (t *TopologyServerTransport) dispatchNewListByHomeRegionPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByHomeRegionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByHomeRegionPager not implemented")}
	}
	newListByHomeRegionPager := t.newListByHomeRegionPager.get(req)
	if newListByHomeRegionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/topologies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListByHomeRegionPager(ascLocationParam, nil)
		newListByHomeRegionPager = &resp
		t.newListByHomeRegionPager.add(req, newListByHomeRegionPager)
		server.PagerResponderInjectNextLinks(newListByHomeRegionPager, req, func(page *armsecurity.TopologyClientListByHomeRegionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByHomeRegionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByHomeRegionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByHomeRegionPager) {
		t.newListByHomeRegionPager.remove(req)
	}
	return resp, nil
}
