//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/ListByManagementGroupGovernanceRules_example.json
func ExampleGovernanceRulesClient_NewListPager_listGovernanceRulesByManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewGovernanceRulesClient().NewListPager("providers/Microsoft.Management/managementGroups/contoso", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.GovernanceRuleList = armsecurity.GovernanceRuleList{
		// 	Value: []*armsecurity.GovernanceRule{
		// 		{
		// 			Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
		// 			Type: to.Ptr("Microsoft.Security/governanceRules"),
		// 			ID: to.Ptr("providers/Microsoft.Management/managementGroups/contoso/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
		// 			Properties: &armsecurity.GovernanceRuleProperties{
		// 				Description: to.Ptr("A rule for a management group"),
		// 				ConditionSets: []any{
		// 					map[string]any{
		// 						"conditions":[]any{
		// 							map[string]any{
		// 								"operator": "In",
		// 								"property": "$.AssessmentKey",
		// 								"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
		// 							},
		// 						},
		// 				}},
		// 				DisplayName: to.Ptr("Management group rule"),
		// 				GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
		// 					DisableManagerEmailNotification: to.Ptr(false),
		// 					DisableOwnerEmailNotification: to.Ptr(false),
		// 				},
		// 				IsDisabled: to.Ptr(false),
		// 				IsGracePeriod: to.Ptr(true),
		// 				Metadata: &armsecurity.GovernanceRuleMetadata{
		// 					CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 					UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 				},
		// 				OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
		// 					Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
		// 					Value: to.Ptr("user@contoso.com"),
		// 				},
		// 				RemediationTimeframe: to.Ptr("7.00:00:00"),
		// 				RulePriority: to.Ptr[int32](100),
		// 				RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
		// 				SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		// 				TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("4106f43c-6d82-4fc8-a92c-dcfe50799d1d"),
		// 			Type: to.Ptr("Microsoft.Security/governanceRules"),
		// 			ID: to.Ptr("providers/Microsoft.Management/managementGroups/contoso/providers/Microsoft.Security/governanceRules/4106f43c-6d82-4fc8-a92c-dcfe50799d1d"),
		// 			Properties: &armsecurity.GovernanceRuleProperties{
		// 				Description: to.Ptr("A rule for a management group"),
		// 				ConditionSets: []any{
		// 					map[string]any{
		// 						"conditions":[]any{
		// 							map[string]any{
		// 								"operator": "Equals",
		// 								"property": "$.Metadata.Severity",
		// 								"value": "Low",
		// 							},
		// 						},
		// 				}},
		// 				DisplayName: to.Ptr("Management group rule 2"),
		// 				ExcludedScopes: []*string{
		// 					to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")},
		// 					GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
		// 						DisableManagerEmailNotification: to.Ptr(false),
		// 						DisableOwnerEmailNotification: to.Ptr(false),
		// 					},
		// 					IncludeMemberScopes: to.Ptr(false),
		// 					IsDisabled: to.Ptr(false),
		// 					IsGracePeriod: to.Ptr(true),
		// 					Metadata: &armsecurity.GovernanceRuleMetadata{
		// 						CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 						CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 						UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 						UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 					},
		// 					OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
		// 						Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
		// 						Value: to.Ptr("user@contoso.com"),
		// 					},
		// 					RemediationTimeframe: to.Ptr("7.00:00:00"),
		// 					RulePriority: to.Ptr[int32](200),
		// 					RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
		// 					SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		// 					TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/ListBySecurityConnectorGovernanceRules_example.json
func ExampleGovernanceRulesClient_NewListPager_listGovernanceRulesBySecurityConnectorScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewGovernanceRulesClient().NewListPager("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.GovernanceRuleList = armsecurity.GovernanceRuleList{
		// 	Value: []*armsecurity.GovernanceRule{
		// 		{
		// 			Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
		// 			Type: to.Ptr("Microsoft.Security/governanceRules"),
		// 			ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
		// 			Properties: &armsecurity.GovernanceRuleProperties{
		// 				Description: to.Ptr("A rule on critical GCP recommendations"),
		// 				ConditionSets: []any{
		// 					map[string]any{
		// 						"conditions":[]any{
		// 							map[string]any{
		// 								"operator": "In",
		// 								"property": "$.AssessmentKey",
		// 								"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
		// 							},
		// 						},
		// 				}},
		// 				DisplayName: to.Ptr("Admin's GCP rule"),
		// 				ExcludedScopes: []*string{
		// 				},
		// 				GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
		// 					DisableManagerEmailNotification: to.Ptr(false),
		// 					DisableOwnerEmailNotification: to.Ptr(false),
		// 				},
		// 				IncludeMemberScopes: to.Ptr(false),
		// 				IsDisabled: to.Ptr(false),
		// 				IsGracePeriod: to.Ptr(true),
		// 				Metadata: &armsecurity.GovernanceRuleMetadata{
		// 					CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 					UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 				},
		// 				OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
		// 					Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
		// 					Value: to.Ptr("user@contoso.com"),
		// 				},
		// 				RemediationTimeframe: to.Ptr("7.00:00:00"),
		// 				RulePriority: to.Ptr[int32](100),
		// 				RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
		// 				SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		// 				TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("4106f43c-6d82-4fc8-a92c-dcfe50799d1d"),
		// 			Type: to.Ptr("Microsoft.Security/governanceRules"),
		// 			ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector/providers/Microsoft.Security/governanceRules/4106f43c-6d82-4fc8-a92c-dcfe50799d1d"),
		// 			Properties: &armsecurity.GovernanceRuleProperties{
		// 				Description: to.Ptr("A rule on critical GCP recommendations"),
		// 				ConditionSets: []any{
		// 					map[string]any{
		// 						"conditions":[]any{
		// 							map[string]any{
		// 								"operator": "Equals",
		// 								"property": "$.Metadata.Severity",
		// 								"value": "Low",
		// 							},
		// 						},
		// 				}},
		// 				DisplayName: to.Ptr("GCP Admin's rule"),
		// 				ExcludedScopes: []*string{
		// 				},
		// 				GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
		// 					DisableManagerEmailNotification: to.Ptr(false),
		// 					DisableOwnerEmailNotification: to.Ptr(false),
		// 				},
		// 				IncludeMemberScopes: to.Ptr(false),
		// 				IsDisabled: to.Ptr(false),
		// 				IsGracePeriod: to.Ptr(true),
		// 				Metadata: &armsecurity.GovernanceRuleMetadata{
		// 					CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 					UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 				},
		// 				OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
		// 					Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
		// 					Value: to.Ptr("user@contoso.com"),
		// 				},
		// 				RemediationTimeframe: to.Ptr("7.00:00:00"),
		// 				RulePriority: to.Ptr[int32](200),
		// 				RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
		// 				SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		// 				TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/ListBySubscriptionGovernanceRules_example.json
func ExampleGovernanceRulesClient_NewListPager_listGovernanceRulesBySubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewGovernanceRulesClient().NewListPager("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.GovernanceRuleList = armsecurity.GovernanceRuleList{
		// 	Value: []*armsecurity.GovernanceRule{
		// 		{
		// 			Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
		// 			Type: to.Ptr("Microsoft.Security/governanceRules"),
		// 			ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
		// 			Properties: &armsecurity.GovernanceRuleProperties{
		// 				Description: to.Ptr("A rule for critical recommendations"),
		// 				ConditionSets: []any{
		// 					map[string]any{
		// 						"conditions":[]any{
		// 							map[string]any{
		// 								"operator": "In",
		// 								"property": "$.AssessmentKey",
		// 								"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
		// 							},
		// 						},
		// 				}},
		// 				DisplayName: to.Ptr("Admin's rule"),
		// 				ExcludedScopes: []*string{
		// 				},
		// 				GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
		// 					DisableManagerEmailNotification: to.Ptr(false),
		// 					DisableOwnerEmailNotification: to.Ptr(false),
		// 				},
		// 				IncludeMemberScopes: to.Ptr(false),
		// 				IsDisabled: to.Ptr(false),
		// 				IsGracePeriod: to.Ptr(true),
		// 				Metadata: &armsecurity.GovernanceRuleMetadata{
		// 					CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 					UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 				},
		// 				OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
		// 					Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
		// 					Value: to.Ptr("user@contoso.com"),
		// 				},
		// 				RemediationTimeframe: to.Ptr("7.00:00:00"),
		// 				RulePriority: to.Ptr[int32](100),
		// 				RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
		// 				SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		// 				TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("4106f43c-6d82-4fc8-a92c-dcfe50799d1d"),
		// 			Type: to.Ptr("Microsoft.Security/governanceRules"),
		// 			ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/governanceRules/4106f43c-6d82-4fc8-a92c-dcfe50799d1d"),
		// 			Properties: &armsecurity.GovernanceRuleProperties{
		// 				Description: to.Ptr("A rule for critical recommendations"),
		// 				ConditionSets: []any{
		// 					map[string]any{
		// 						"conditions":[]any{
		// 							map[string]any{
		// 								"operator": "Equals",
		// 								"property": "$.Metadata.Severity",
		// 								"value": "Low",
		// 							},
		// 						},
		// 				}},
		// 				DisplayName: to.Ptr("Admin's rule"),
		// 				ExcludedScopes: []*string{
		// 				},
		// 				GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
		// 					DisableManagerEmailNotification: to.Ptr(true),
		// 					DisableOwnerEmailNotification: to.Ptr(true),
		// 				},
		// 				IncludeMemberScopes: to.Ptr(false),
		// 				IsDisabled: to.Ptr(false),
		// 				IsGracePeriod: to.Ptr(true),
		// 				Metadata: &armsecurity.GovernanceRuleMetadata{
		// 					CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 					UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
		// 					UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
		// 				},
		// 				OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
		// 					Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
		// 					Value: to.Ptr("user@contoso.com"),
		// 				},
		// 				RemediationTimeframe: to.Ptr("7.00:00:00"),
		// 				RulePriority: to.Ptr[int32](200),
		// 				RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
		// 				SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		// 				TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/GetManagementGroupGovernanceRule_example.json
func ExampleGovernanceRulesClient_Get_getAGovernanceRuleOverManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().Get(ctx, "providers/Microsoft.Management/managementGroups/contoso", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GovernanceRule = armsecurity.GovernanceRule{
	// 	Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Type: to.Ptr("Microsoft.Security/governanceRules"),
	// 	ID: to.Ptr("providers/Microsoft.Management/managementGroups/contoso/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Properties: &armsecurity.GovernanceRuleProperties{
	// 		Description: to.Ptr("A rule for a management group"),
	// 		ConditionSets: []any{
	// 			map[string]any{
	// 				"conditions":[]any{
	// 					map[string]any{
	// 						"operator": "In",
	// 						"property": "$.AssessmentKey",
	// 						"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
	// 					},
	// 				},
	// 		}},
	// 		DisplayName: to.Ptr("Management group rule"),
	// 		ExcludedScopes: []*string{
	// 			to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")},
	// 			GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
	// 				DisableManagerEmailNotification: to.Ptr(false),
	// 				DisableOwnerEmailNotification: to.Ptr(false),
	// 			},
	// 			IncludeMemberScopes: to.Ptr(false),
	// 			IsDisabled: to.Ptr(false),
	// 			IsGracePeriod: to.Ptr(true),
	// 			Metadata: &armsecurity.GovernanceRuleMetadata{
	// 				CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 				UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 				UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 			},
	// 			OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
	// 				Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
	// 				Value: to.Ptr("user@contoso.com"),
	// 			},
	// 			RemediationTimeframe: to.Ptr("7.00:00:00"),
	// 			RulePriority: to.Ptr[int32](200),
	// 			RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
	// 			SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
	// 			TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/GetSecurityConnectorGovernanceRule_example.json
func ExampleGovernanceRulesClient_Get_getAGovernanceRuleOverSecurityConnectorScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().Get(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GovernanceRule = armsecurity.GovernanceRule{
	// 	Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Type: to.Ptr("Microsoft.Security/governanceRules"),
	// 	ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Properties: &armsecurity.GovernanceRuleProperties{
	// 		Description: to.Ptr("A rule on critical GCP recommendations"),
	// 		ConditionSets: []any{
	// 			map[string]any{
	// 				"conditions":[]any{
	// 					map[string]any{
	// 						"operator": "In",
	// 						"property": "$.AssessmentKey",
	// 						"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
	// 					},
	// 				},
	// 		}},
	// 		DisplayName: to.Ptr("GCP Admin's rule"),
	// 		ExcludedScopes: []*string{
	// 		},
	// 		GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
	// 			DisableManagerEmailNotification: to.Ptr(false),
	// 			DisableOwnerEmailNotification: to.Ptr(false),
	// 		},
	// 		IncludeMemberScopes: to.Ptr(false),
	// 		IsDisabled: to.Ptr(false),
	// 		IsGracePeriod: to.Ptr(true),
	// 		Metadata: &armsecurity.GovernanceRuleMetadata{
	// 			CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 			UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 			UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 		},
	// 		OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
	// 			Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
	// 			Value: to.Ptr("user@contoso.com"),
	// 		},
	// 		RemediationTimeframe: to.Ptr("7.00:00:00"),
	// 		RulePriority: to.Ptr[int32](200),
	// 		RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
	// 		SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
	// 		TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/GetGovernanceRule_example.json
func ExampleGovernanceRulesClient_Get_getAGovernanceRuleOverSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().Get(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GovernanceRule = armsecurity.GovernanceRule{
	// 	Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Type: to.Ptr("Microsoft.Security/governanceRules"),
	// 	ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Properties: &armsecurity.GovernanceRuleProperties{
	// 		Description: to.Ptr("A rule for critical recommendations"),
	// 		ConditionSets: []any{
	// 			map[string]any{
	// 				"conditions":[]any{
	// 					map[string]any{
	// 						"operator": "In",
	// 						"property": "$.AssessmentKey",
	// 						"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
	// 					},
	// 				},
	// 		}},
	// 		DisplayName: to.Ptr("Admin's rule"),
	// 		ExcludedScopes: []*string{
	// 		},
	// 		GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
	// 			DisableManagerEmailNotification: to.Ptr(false),
	// 			DisableOwnerEmailNotification: to.Ptr(false),
	// 		},
	// 		IncludeMemberScopes: to.Ptr(false),
	// 		IsDisabled: to.Ptr(false),
	// 		IsGracePeriod: to.Ptr(true),
	// 		Metadata: &armsecurity.GovernanceRuleMetadata{
	// 			CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 			UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 			UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 		},
	// 		OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
	// 			Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
	// 			Value: to.Ptr("user@contoso.com"),
	// 		},
	// 		RemediationTimeframe: to.Ptr("7.00:00:00"),
	// 		RulePriority: to.Ptr[int32](200),
	// 		RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
	// 		SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
	// 		TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/PutManagementGroupGovernanceRule_example.json
func ExampleGovernanceRulesClient_CreateOrUpdate_createOrUpdateGovernanceRuleOverManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().CreateOrUpdate(ctx, "providers/Microsoft.Management/managementGroups/contoso", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", armsecurity.GovernanceRule{
		Properties: &armsecurity.GovernanceRuleProperties{
			Description: to.Ptr("A rule for a management group"),
			ConditionSets: []any{
				map[string]any{
					"conditions": []any{
						map[string]any{
							"operator": "In",
							"property": "$.AssessmentKey",
							"value":    "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
						},
					},
				}},
			DisplayName: to.Ptr("Management group rule"),
			ExcludedScopes: []*string{
				to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")},
			GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
				DisableManagerEmailNotification: to.Ptr(true),
				DisableOwnerEmailNotification:   to.Ptr(false),
			},
			IsDisabled:    to.Ptr(false),
			IsGracePeriod: to.Ptr(true),
			OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
				Type:  to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
				Value: to.Ptr("user@contoso.com"),
			},
			RemediationTimeframe: to.Ptr("7.00:00:00"),
			RulePriority:         to.Ptr[int32](200),
			RuleType:             to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
			SourceResourceType:   to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GovernanceRule = armsecurity.GovernanceRule{
	// 	Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Type: to.Ptr("Microsoft.Security/governanceRules"),
	// 	ID: to.Ptr("providers/Microsoft.Management/managementGroups/contoso/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Properties: &armsecurity.GovernanceRuleProperties{
	// 		Description: to.Ptr("A rule for a management group"),
	// 		ConditionSets: []any{
	// 			map[string]any{
	// 				"conditions":[]any{
	// 					map[string]any{
	// 						"operator": "In",
	// 						"property": "$.AssessmentKey",
	// 						"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
	// 					},
	// 				},
	// 		}},
	// 		DisplayName: to.Ptr("Management group rule"),
	// 		ExcludedScopes: []*string{
	// 			to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")},
	// 			GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
	// 				DisableManagerEmailNotification: to.Ptr(true),
	// 				DisableOwnerEmailNotification: to.Ptr(false),
	// 			},
	// 			IncludeMemberScopes: to.Ptr(false),
	// 			IsDisabled: to.Ptr(false),
	// 			IsGracePeriod: to.Ptr(true),
	// 			Metadata: &armsecurity.GovernanceRuleMetadata{
	// 				CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 				UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 				UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 			},
	// 			OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
	// 				Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
	// 				Value: to.Ptr("user@contoso.com"),
	// 			},
	// 			RemediationTimeframe: to.Ptr("7.00:00:00"),
	// 			RulePriority: to.Ptr[int32](200),
	// 			RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
	// 			SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
	// 			TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/PutSecurityConnectorGovernanceRule_example.json
func ExampleGovernanceRulesClient_CreateOrUpdate_createOrUpdateGovernanceRuleOverSecurityConnectorScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().CreateOrUpdate(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", armsecurity.GovernanceRule{
		Properties: &armsecurity.GovernanceRuleProperties{
			Description: to.Ptr("A rule on critical GCP recommendations"),
			ConditionSets: []any{
				map[string]any{
					"conditions": []any{
						map[string]any{
							"operator": "In",
							"property": "$.AssessmentKey",
							"value":    "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
						},
					},
				}},
			DisplayName: to.Ptr("GCP Admin's rule"),
			GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
				DisableManagerEmailNotification: to.Ptr(true),
				DisableOwnerEmailNotification:   to.Ptr(false),
			},
			IsDisabled:    to.Ptr(false),
			IsGracePeriod: to.Ptr(true),
			OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
				Type:  to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
				Value: to.Ptr("user@contoso.com"),
			},
			RemediationTimeframe: to.Ptr("7.00:00:00"),
			RulePriority:         to.Ptr[int32](200),
			RuleType:             to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
			SourceResourceType:   to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GovernanceRule = armsecurity.GovernanceRule{
	// 	Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Type: to.Ptr("Microsoft.Security/governanceRules"),
	// 	ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Properties: &armsecurity.GovernanceRuleProperties{
	// 		Description: to.Ptr("A rule on critical GCP recommendations"),
	// 		ConditionSets: []any{
	// 			map[string]any{
	// 				"conditions":[]any{
	// 					map[string]any{
	// 						"operator": "In",
	// 						"property": "$.AssessmentKey",
	// 						"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
	// 					},
	// 				},
	// 		}},
	// 		DisplayName: to.Ptr("GCP Admin's rule"),
	// 		ExcludedScopes: []*string{
	// 		},
	// 		GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
	// 			DisableManagerEmailNotification: to.Ptr(true),
	// 			DisableOwnerEmailNotification: to.Ptr(false),
	// 		},
	// 		IncludeMemberScopes: to.Ptr(false),
	// 		IsDisabled: to.Ptr(false),
	// 		IsGracePeriod: to.Ptr(true),
	// 		Metadata: &armsecurity.GovernanceRuleMetadata{
	// 			CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 			UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 			UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 		},
	// 		OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
	// 			Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
	// 			Value: to.Ptr("user@contoso.com"),
	// 		},
	// 		RemediationTimeframe: to.Ptr("7.00:00:00"),
	// 		RulePriority: to.Ptr[int32](200),
	// 		RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
	// 		SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
	// 		TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/PutGovernanceRule_example.json
func ExampleGovernanceRulesClient_CreateOrUpdate_createOrUpdateGovernanceRuleOverSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().CreateOrUpdate(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", armsecurity.GovernanceRule{
		Properties: &armsecurity.GovernanceRuleProperties{
			Description: to.Ptr("A rule for critical recommendations"),
			ConditionSets: []any{
				map[string]any{
					"conditions": []any{
						map[string]any{
							"operator": "In",
							"property": "$.AssessmentKey",
							"value":    "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
						},
					},
				}},
			DisplayName: to.Ptr("Admin's rule"),
			GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
				DisableManagerEmailNotification: to.Ptr(false),
				DisableOwnerEmailNotification:   to.Ptr(false),
			},
			IsDisabled:    to.Ptr(false),
			IsGracePeriod: to.Ptr(true),
			OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
				Type:  to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
				Value: to.Ptr("user@contoso.com"),
			},
			RemediationTimeframe: to.Ptr("7.00:00:00"),
			RulePriority:         to.Ptr[int32](200),
			RuleType:             to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
			SourceResourceType:   to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GovernanceRule = armsecurity.GovernanceRule{
	// 	Name: to.Ptr("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Type: to.Ptr("Microsoft.Security/governanceRules"),
	// 	ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/governanceRules/ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
	// 	Properties: &armsecurity.GovernanceRuleProperties{
	// 		Description: to.Ptr("A rule for critical recommendations"),
	// 		ConditionSets: []any{
	// 			map[string]any{
	// 				"conditions":[]any{
	// 					map[string]any{
	// 						"operator": "In",
	// 						"property": "$.AssessmentKey",
	// 						"value": "[\"b1cd27e0-4ecc-4246-939f-49c426d9d72f\", \"fe83f80b-073d-4ccf-93d9-6797eb870201\"]",
	// 					},
	// 				},
	// 		}},
	// 		DisplayName: to.Ptr("Admin's rule"),
	// 		ExcludedScopes: []*string{
	// 		},
	// 		GovernanceEmailNotification: &armsecurity.GovernanceRuleEmailNotification{
	// 			DisableManagerEmailNotification: to.Ptr(false),
	// 			DisableOwnerEmailNotification: to.Ptr(false),
	// 		},
	// 		IncludeMemberScopes: to.Ptr(false),
	// 		IsDisabled: to.Ptr(false),
	// 		IsGracePeriod: to.Ptr(true),
	// 		Metadata: &armsecurity.GovernanceRuleMetadata{
	// 			CreatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 			UpdatedBy: to.Ptr("c23b5354-ff0a-4b2a-9f92-6f144effd936"),
	// 			UpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-10T08:31:26.799Z"); return t}()),
	// 		},
	// 		OwnerSource: &armsecurity.GovernanceRuleOwnerSource{
	// 			Type: to.Ptr(armsecurity.GovernanceRuleOwnerSourceTypeManually),
	// 			Value: to.Ptr("user@contoso.com"),
	// 		},
	// 		RemediationTimeframe: to.Ptr("7.00:00:00"),
	// 		RulePriority: to.Ptr[int32](200),
	// 		RuleType: to.Ptr(armsecurity.GovernanceRuleTypeIntegrated),
	// 		SourceResourceType: to.Ptr(armsecurity.GovernanceRuleSourceResourceTypeAssessments),
	// 		TenantID: to.Ptr("f0b6d37b-e4bc-4719-9291-c066c3194f23"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/DeleteManagementGroupGovernanceRule_example.json
func ExampleGovernanceRulesClient_BeginDelete_deleteAGovernanceRuleOverManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGovernanceRulesClient().BeginDelete(ctx, "providers/Microsoft.Management/managementGroups/contoso", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/DeleteSecurityConnectorGovernanceRule_example.json
func ExampleGovernanceRulesClient_BeginDelete_deleteAGovernanceRuleOverSecurityConnectorScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGovernanceRulesClient().BeginDelete(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/DeleteGovernanceRule_example.json
func ExampleGovernanceRulesClient_BeginDelete_deleteAGovernanceRuleOverSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGovernanceRulesClient().BeginDelete(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/PostGovernanceRule_example.json
func ExampleGovernanceRulesClient_BeginExecute_executeGovernanceRuleOverSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGovernanceRulesClient().BeginExecute(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", &armsecurity.GovernanceRulesClientBeginExecuteOptions{ExecuteGovernanceRuleParams: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/PostManagementGroupGovernanceRule_example.json
func ExampleGovernanceRulesClient_BeginExecute_executeGovernanceRuleOverManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGovernanceRulesClient().BeginExecute(ctx, "providers/Microsoft.Management/managementGroups/contoso", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", &armsecurity.GovernanceRulesClientBeginExecuteOptions{ExecuteGovernanceRuleParams: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/PostSecurityConnectorGovernanceRule_example.json
func ExampleGovernanceRulesClient_BeginExecute_executeGovernanceRuleOverSecurityConnectorScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGovernanceRulesClient().BeginExecute(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", &armsecurity.GovernanceRulesClientBeginExecuteOptions{ExecuteGovernanceRuleParams: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/GetManagementGroupGovernanceRuleExecuteStatus_example.json
func ExampleGovernanceRulesClient_OperationResults_getGovernanceRulesLongRunOperationResultOverManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().OperationResults(ctx, "providers/Microsoft.Management/managementGroups/contoso", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", "58b33f4f-c8c7-4b01-99cc-d437db4d40dd", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationResultAutoGenerated = armsecurity.OperationResultAutoGenerated{
	// 	Status: to.Ptr(armsecurity.OperationResultSucceeded),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/GetSecurityConnectorGovernanceRuleExecuteStatus_example.json
func ExampleGovernanceRulesClient_OperationResults_getGovernanceRulesLongRunOperationResultOverSecurityConnector() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().OperationResults(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/gcpResourceGroup/providers/Microsoft.Security/securityConnectors/gcpconnector", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", "58b33f4f-c8c7-4b01-99cc-d437db4d40dd", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationResultAutoGenerated = armsecurity.OperationResultAutoGenerated{
	// 	Status: to.Ptr(armsecurity.OperationResultSucceeded),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/GetGovernanceRuleExecuteStatus_example.json
func ExampleGovernanceRulesClient_OperationResults_getGovernanceRulesLongRunOperationResultOverSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGovernanceRulesClient().OperationResults(ctx, "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23", "ad9a8e26-29d9-4829-bb30-e597a58cdbb8", "58b33f4f-c8c7-4b01-99cc-d437db4d40dd", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationResultAutoGenerated = armsecurity.OperationResultAutoGenerated{
	// 	Status: to.Ptr(armsecurity.OperationResultSucceeded),
	// }
}
