//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securityinsights/armsecurityinsights"
	"net/http"
	"net/url"
	"regexp"
)

// ActionsServer is a fake server for instances of the armsecurityinsights.ActionsClient type.
type ActionsServer struct {
	// CreateOrUpdate is the fake for method ActionsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, ruleID string, actionID string, action armsecurityinsights.ActionRequest, options *armsecurityinsights.ActionsClientCreateOrUpdateOptions) (resp azfake.Responder[armsecurityinsights.ActionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ActionsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, workspaceName string, ruleID string, actionID string, options *armsecurityinsights.ActionsClientDeleteOptions) (resp azfake.Responder[armsecurityinsights.ActionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ActionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, ruleID string, actionID string, options *armsecurityinsights.ActionsClientGetOptions) (resp azfake.Responder[armsecurityinsights.ActionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByAlertRulePager is the fake for method ActionsClient.NewListByAlertRulePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAlertRulePager func(resourceGroupName string, workspaceName string, ruleID string, options *armsecurityinsights.ActionsClientListByAlertRuleOptions) (resp azfake.PagerResponder[armsecurityinsights.ActionsClientListByAlertRuleResponse])
}

// NewActionsServerTransport creates a new instance of ActionsServerTransport with the provided implementation.
// The returned ActionsServerTransport instance is connected to an instance of armsecurityinsights.ActionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewActionsServerTransport(srv *ActionsServer) *ActionsServerTransport {
	return &ActionsServerTransport{
		srv:                     srv,
		newListByAlertRulePager: newTracker[azfake.PagerResponder[armsecurityinsights.ActionsClientListByAlertRuleResponse]](),
	}
}

// ActionsServerTransport connects instances of armsecurityinsights.ActionsClient to instances of ActionsServer.
// Don't use this type directly, use NewActionsServerTransport instead.
type ActionsServerTransport struct {
	srv                     *ActionsServer
	newListByAlertRulePager *tracker[azfake.PagerResponder[armsecurityinsights.ActionsClientListByAlertRuleResponse]]
}

// Do implements the policy.Transporter interface for ActionsServerTransport.
func (a *ActionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ActionsClient.CreateOrUpdate":
		resp, err = a.dispatchCreateOrUpdate(req)
	case "ActionsClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "ActionsClient.Get":
		resp, err = a.dispatchGet(req)
	case "ActionsClient.NewListByAlertRulePager":
		resp, err = a.dispatchNewListByAlertRulePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ActionsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/alertRules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/actions/(?P<actionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurityinsights.ActionRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	actionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("actionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, ruleIDParam, actionIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ActionResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ActionsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/alertRules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/actions/(?P<actionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	actionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("actionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), resourceGroupNameParam, workspaceNameParam, ruleIDParam, actionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ActionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/alertRules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/actions/(?P<actionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	actionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("actionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, ruleIDParam, actionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ActionResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ActionsServerTransport) dispatchNewListByAlertRulePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByAlertRulePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAlertRulePager not implemented")}
	}
	newListByAlertRulePager := a.newListByAlertRulePager.get(req)
	if newListByAlertRulePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/alertRules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/actions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByAlertRulePager(resourceGroupNameParam, workspaceNameParam, ruleIDParam, nil)
		newListByAlertRulePager = &resp
		a.newListByAlertRulePager.add(req, newListByAlertRulePager)
		server.PagerResponderInjectNextLinks(newListByAlertRulePager, req, func(page *armsecurityinsights.ActionsClientListByAlertRuleResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAlertRulePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByAlertRulePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAlertRulePager) {
		a.newListByAlertRulePager.remove(req)
	}
	return resp, nil
}
