//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurityinsights

import "encoding/json"

func unmarshalAlertRuleClassification(rawMsg json.RawMessage) (AlertRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AlertRuleClassification
	switch m["kind"] {
	case string(AlertRuleKindFusion):
		b = &FusionAlertRule{}
	case string(AlertRuleKindMicrosoftSecurityIncidentCreation):
		b = &MicrosoftSecurityIncidentCreationAlertRule{}
	case string(AlertRuleKindScheduled):
		b = &ScheduledAlertRule{}
	default:
		b = &AlertRule{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAlertRuleClassificationArray(rawMsg json.RawMessage) ([]AlertRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AlertRuleClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAlertRuleClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAlertRuleTemplateClassification(rawMsg json.RawMessage) (AlertRuleTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AlertRuleTemplateClassification
	switch m["kind"] {
	case string(AlertRuleKindFusion):
		b = &FusionAlertRuleTemplate{}
	case string(AlertRuleKindMicrosoftSecurityIncidentCreation):
		b = &MicrosoftSecurityIncidentCreationAlertRuleTemplate{}
	case string(AlertRuleKindScheduled):
		b = &ScheduledAlertRuleTemplate{}
	default:
		b = &AlertRuleTemplate{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAlertRuleTemplateClassificationArray(rawMsg json.RawMessage) ([]AlertRuleTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AlertRuleTemplateClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAlertRuleTemplateClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAutomationRuleActionClassification(rawMsg json.RawMessage) (AutomationRuleActionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AutomationRuleActionClassification
	switch m["actionType"] {
	case string(ActionTypeModifyProperties):
		b = &AutomationRuleModifyPropertiesAction{}
	case string(ActionTypeRunPlaybook):
		b = &AutomationRuleRunPlaybookAction{}
	default:
		b = &AutomationRuleAction{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAutomationRuleActionClassificationArray(rawMsg json.RawMessage) ([]AutomationRuleActionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AutomationRuleActionClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAutomationRuleActionClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAutomationRuleConditionClassification(rawMsg json.RawMessage) (AutomationRuleConditionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AutomationRuleConditionClassification
	switch m["conditionType"] {
	case string(ConditionTypeProperty):
		b = &PropertyConditionProperties{}
	default:
		b = &AutomationRuleCondition{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAutomationRuleConditionClassificationArray(rawMsg json.RawMessage) ([]AutomationRuleConditionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AutomationRuleConditionClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAutomationRuleConditionClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalDataConnectorClassification(rawMsg json.RawMessage) (DataConnectorClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DataConnectorClassification
	switch m["kind"] {
	case string(DataConnectorKindAmazonWebServicesCloudTrail):
		b = &AwsCloudTrailDataConnector{}
	case string(DataConnectorKindAzureActiveDirectory):
		b = &AADDataConnector{}
	case string(DataConnectorKindAzureAdvancedThreatProtection):
		b = &AATPDataConnector{}
	case string(DataConnectorKindAzureSecurityCenter):
		b = &ASCDataConnector{}
	case string(DataConnectorKindMicrosoftCloudAppSecurity):
		b = &MCASDataConnector{}
	case string(DataConnectorKindMicrosoftDefenderAdvancedThreatProtection):
		b = &MDATPDataConnector{}
	case string(DataConnectorKindOffice365):
		b = &OfficeDataConnector{}
	case string(DataConnectorKindThreatIntelligence):
		b = &TIDataConnector{}
	default:
		b = &DataConnector{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDataConnectorClassificationArray(rawMsg json.RawMessage) ([]DataConnectorClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]DataConnectorClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalDataConnectorClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalEntityClassification(rawMsg json.RawMessage) (EntityClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EntityClassification
	switch m["kind"] {
	case string(EntityKindEnumAccount):
		b = &AccountEntity{}
	case string(EntityKindEnumAzureResource):
		b = &AzureResourceEntity{}
	case string(EntityKindEnumBookmark):
		b = &HuntingBookmark{}
	case string(EntityKindEnumCloudApplication):
		b = &CloudApplicationEntity{}
	case string(EntityKindEnumDNSResolution):
		b = &DNSEntity{}
	case string(EntityKindEnumFile):
		b = &FileEntity{}
	case string(EntityKindEnumFileHash):
		b = &FileHashEntity{}
	case string(EntityKindEnumHost):
		b = &HostEntity{}
	case string(EntityKindEnumIP):
		b = &IPEntity{}
	case string(EntityKindEnumIoTDevice):
		b = &IoTDeviceEntity{}
	case string(EntityKindEnumMailCluster):
		b = &MailClusterEntity{}
	case string(EntityKindEnumMailMessage):
		b = &MailMessageEntity{}
	case string(EntityKindEnumMailbox):
		b = &MailboxEntity{}
	case string(EntityKindEnumMalware):
		b = &MalwareEntity{}
	case string(EntityKindEnumProcess):
		b = &ProcessEntity{}
	case string(EntityKindEnumRegistryKey):
		b = &RegistryKeyEntity{}
	case string(EntityKindEnumRegistryValue):
		b = &RegistryValueEntity{}
	case string(EntityKindEnumSecurityAlert):
		b = &SecurityAlert{}
	case string(EntityKindEnumSecurityGroup):
		b = &SecurityGroupEntity{}
	case string(EntityKindEnumSubmissionMail):
		b = &SubmissionMailEntity{}
	case string(EntityKindEnumURL):
		b = &URLEntity{}
	default:
		b = &Entity{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalEntityClassificationArray(rawMsg json.RawMessage) ([]EntityClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]EntityClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalEntityClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalThreatIntelligenceInformationClassification(rawMsg json.RawMessage) (ThreatIntelligenceInformationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ThreatIntelligenceInformationClassification
	switch m["kind"] {
	case string(ThreatIntelligenceResourceInnerKindIndicator):
		b = &ThreatIntelligenceIndicatorModel{}
	default:
		b = &ThreatIntelligenceInformation{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalThreatIntelligenceInformationClassificationArray(rawMsg json.RawMessage) ([]ThreatIntelligenceInformationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ThreatIntelligenceInformationClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalThreatIntelligenceInformationClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}
