//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DiagnosticsClient contains the methods for the Diagnostics group.
// Don't use this type directly, use NewDiagnosticsClient() instead.
type DiagnosticsClient struct {
	internal *arm.Client
}

// NewDiagnosticsClient creates a new instance of DiagnosticsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDiagnosticsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*DiagnosticsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DiagnosticsClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreate - Creates a diagnostic for the specific resource using solutionId from discovery solutions. Diagnostics are
// powerful solutions that access product resources or other relevant data and provide the root
// cause of the issue and the steps to address the issue.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - diagnosticsResourceName - Unique resource name for insight resources
//   - diagnosticResourceRequest - The required request body for this insightResource invocation.
//   - options - DiagnosticsClientBeginCreateOptions contains the optional parameters for the DiagnosticsClient.BeginCreate method.
func (client *DiagnosticsClient) BeginCreate(ctx context.Context, scope string, diagnosticsResourceName string, diagnosticResourceRequest DiagnosticResource, options *DiagnosticsClientBeginCreateOptions) (*runtime.Poller[DiagnosticsClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, scope, diagnosticsResourceName, diagnosticResourceRequest, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DiagnosticsClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DiagnosticsClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Creates a diagnostic for the specific resource using solutionId from discovery solutions. Diagnostics are powerful
// solutions that access product resources or other relevant data and provide the root
// cause of the issue and the steps to address the issue.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
func (client *DiagnosticsClient) create(ctx context.Context, scope string, diagnosticsResourceName string, diagnosticResourceRequest DiagnosticResource, options *DiagnosticsClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "DiagnosticsClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, scope, diagnosticsResourceName, diagnosticResourceRequest, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *DiagnosticsClient) createCreateRequest(ctx context.Context, scope string, diagnosticsResourceName string, diagnosticResourceRequest DiagnosticResource, options *DiagnosticsClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/diagnostics/{diagnosticsResourceName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if diagnosticsResourceName == "" {
		return nil, errors.New("parameter diagnosticsResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticsResourceName}", url.PathEscape(diagnosticsResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, diagnosticResourceRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// Get - Get the diagnostics using the 'diagnosticsResourceName' you chose while creating the diagnostic.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - scope - scope = resourceUri of affected resource.
//     For example: /subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read
//   - diagnosticsResourceName - Unique resource name for insight resources
//   - options - DiagnosticsClientGetOptions contains the optional parameters for the DiagnosticsClient.Get method.
func (client *DiagnosticsClient) Get(ctx context.Context, scope string, diagnosticsResourceName string, options *DiagnosticsClientGetOptions) (DiagnosticsClientGetResponse, error) {
	var err error
	const operationName = "DiagnosticsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scope, diagnosticsResourceName, options)
	if err != nil {
		return DiagnosticsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DiagnosticsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DiagnosticsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DiagnosticsClient) getCreateRequest(ctx context.Context, scope string, diagnosticsResourceName string, options *DiagnosticsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Help/diagnostics/{diagnosticsResourceName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if diagnosticsResourceName == "" {
		return nil, errors.New("parameter diagnosticsResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{diagnosticsResourceName}", url.PathEscape(diagnosticsResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DiagnosticsClient) getHandleResponse(resp *http.Response) (DiagnosticsClientGetResponse, error) {
	result := DiagnosticsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiagnosticResource); err != nil {
		return DiagnosticsClientGetResponse{}, err
	}
	return result, nil
}
