//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/selfhelp/armselfhelp/v2"
	"net/http"
	"reflect"
)

// DiscoverySolutionNLPTenantScopeServer is a fake server for instances of the armselfhelp.DiscoverySolutionNLPTenantScopeClient type.
type DiscoverySolutionNLPTenantScopeServer struct {
	// Post is the fake for method DiscoverySolutionNLPTenantScopeClient.Post
	// HTTP status codes to indicate success: http.StatusOK
	Post func(ctx context.Context, options *armselfhelp.DiscoverySolutionNLPTenantScopeClientPostOptions) (resp azfake.Responder[armselfhelp.DiscoverySolutionNLPTenantScopeClientPostResponse], errResp azfake.ErrorResponder)
}

// NewDiscoverySolutionNLPTenantScopeServerTransport creates a new instance of DiscoverySolutionNLPTenantScopeServerTransport with the provided implementation.
// The returned DiscoverySolutionNLPTenantScopeServerTransport instance is connected to an instance of armselfhelp.DiscoverySolutionNLPTenantScopeClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiscoverySolutionNLPTenantScopeServerTransport(srv *DiscoverySolutionNLPTenantScopeServer) *DiscoverySolutionNLPTenantScopeServerTransport {
	return &DiscoverySolutionNLPTenantScopeServerTransport{srv: srv}
}

// DiscoverySolutionNLPTenantScopeServerTransport connects instances of armselfhelp.DiscoverySolutionNLPTenantScopeClient to instances of DiscoverySolutionNLPTenantScopeServer.
// Don't use this type directly, use NewDiscoverySolutionNLPTenantScopeServerTransport instead.
type DiscoverySolutionNLPTenantScopeServerTransport struct {
	srv *DiscoverySolutionNLPTenantScopeServer
}

// Do implements the policy.Transporter interface for DiscoverySolutionNLPTenantScopeServerTransport.
func (d *DiscoverySolutionNLPTenantScopeServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiscoverySolutionNLPTenantScopeClient.Post":
		resp, err = d.dispatchPost(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiscoverySolutionNLPTenantScopeServerTransport) dispatchPost(req *http.Request) (*http.Response, error) {
	if d.srv.Post == nil {
		return nil, &nonRetriableError{errors.New("fake for method Post not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[armselfhelp.DiscoveryNlpRequest](req)
	if err != nil {
		return nil, err
	}
	var options *armselfhelp.DiscoverySolutionNLPTenantScopeClientPostOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armselfhelp.DiscoverySolutionNLPTenantScopeClientPostOptions{
			DiscoverSolutionRequest: &body,
		}
	}
	respr, errRespr := d.srv.Post(req.Context(), options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiscoveryNlpResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
