//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/selfhelp/armselfhelp/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// SolutionServer is a fake server for instances of the armselfhelp.SolutionClient type.
type SolutionServer struct {
	// BeginCreate is the fake for method SolutionClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, scope string, solutionResourceName string, solutionRequestBody armselfhelp.SolutionResource, options *armselfhelp.SolutionClientBeginCreateOptions) (resp azfake.PollerResponder[armselfhelp.SolutionClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SolutionClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, solutionResourceName string, options *armselfhelp.SolutionClientGetOptions) (resp azfake.Responder[armselfhelp.SolutionClientGetResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method SolutionClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, scope string, solutionResourceName string, solutionPatchRequestBody armselfhelp.SolutionPatchRequestBody, options *armselfhelp.SolutionClientBeginUpdateOptions) (resp azfake.PollerResponder[armselfhelp.SolutionClientUpdateResponse], errResp azfake.ErrorResponder)

	// WarmUp is the fake for method SolutionClient.WarmUp
	// HTTP status codes to indicate success: http.StatusNoContent
	WarmUp func(ctx context.Context, scope string, solutionResourceName string, options *armselfhelp.SolutionClientWarmUpOptions) (resp azfake.Responder[armselfhelp.SolutionClientWarmUpResponse], errResp azfake.ErrorResponder)
}

// NewSolutionServerTransport creates a new instance of SolutionServerTransport with the provided implementation.
// The returned SolutionServerTransport instance is connected to an instance of armselfhelp.SolutionClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSolutionServerTransport(srv *SolutionServer) *SolutionServerTransport {
	return &SolutionServerTransport{
		srv:         srv,
		beginCreate: newTracker[azfake.PollerResponder[armselfhelp.SolutionClientCreateResponse]](),
		beginUpdate: newTracker[azfake.PollerResponder[armselfhelp.SolutionClientUpdateResponse]](),
	}
}

// SolutionServerTransport connects instances of armselfhelp.SolutionClient to instances of SolutionServer.
// Don't use this type directly, use NewSolutionServerTransport instead.
type SolutionServerTransport struct {
	srv         *SolutionServer
	beginCreate *tracker[azfake.PollerResponder[armselfhelp.SolutionClientCreateResponse]]
	beginUpdate *tracker[azfake.PollerResponder[armselfhelp.SolutionClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for SolutionServerTransport.
func (s *SolutionServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SolutionClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "SolutionClient.Get":
		resp, err = s.dispatchGet(req)
	case "SolutionClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	case "SolutionClient.WarmUp":
		resp, err = s.dispatchWarmUp(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SolutionServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Help/solutions/(?P<solutionResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armselfhelp.SolutionResource](req)
		if err != nil {
			return nil, err
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		solutionResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("solutionResourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), scopeParam, solutionResourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *SolutionServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Help/solutions/(?P<solutionResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	solutionResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("solutionResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), scopeParam, solutionResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SolutionResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SolutionServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Help/solutions/(?P<solutionResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armselfhelp.SolutionPatchRequestBody](req)
		if err != nil {
			return nil, err
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		solutionResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("solutionResourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), scopeParam, solutionResourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}

func (s *SolutionServerTransport) dispatchWarmUp(req *http.Request) (*http.Response, error) {
	if s.srv.WarmUp == nil {
		return nil, &nonRetriableError{errors.New("fake for method WarmUp not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Help/solutions/(?P<solutionResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/warmup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armselfhelp.SolutionWarmUpRequestBody](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	solutionResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("solutionResourceName")])
	if err != nil {
		return nil, err
	}
	var options *armselfhelp.SolutionClientWarmUpOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armselfhelp.SolutionClientWarmUpOptions{
			SolutionWarmUpRequestBody: &body,
		}
	}
	respr, errRespr := s.srv.WarmUp(req.Context(), scopeParam, solutionResourceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
