//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/selfhelp/armselfhelp/v2"
	"net/http"
	"net/url"
	"regexp"
)

// SolutionSelfHelpServer is a fake server for instances of the armselfhelp.SolutionSelfHelpClient type.
type SolutionSelfHelpServer struct {
	// Get is the fake for method SolutionSelfHelpClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, solutionID string, options *armselfhelp.SolutionSelfHelpClientGetOptions) (resp azfake.Responder[armselfhelp.SolutionSelfHelpClientGetResponse], errResp azfake.ErrorResponder)
}

// NewSolutionSelfHelpServerTransport creates a new instance of SolutionSelfHelpServerTransport with the provided implementation.
// The returned SolutionSelfHelpServerTransport instance is connected to an instance of armselfhelp.SolutionSelfHelpClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSolutionSelfHelpServerTransport(srv *SolutionSelfHelpServer) *SolutionSelfHelpServerTransport {
	return &SolutionSelfHelpServerTransport{srv: srv}
}

// SolutionSelfHelpServerTransport connects instances of armselfhelp.SolutionSelfHelpClient to instances of SolutionSelfHelpServer.
// Don't use this type directly, use NewSolutionSelfHelpServerTransport instead.
type SolutionSelfHelpServerTransport struct {
	srv *SolutionSelfHelpServer
}

// Do implements the policy.Transporter interface for SolutionSelfHelpServerTransport.
func (s *SolutionSelfHelpServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SolutionSelfHelpClient.Get":
		resp, err = s.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SolutionSelfHelpServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Help/selfHelp/(?P<solutionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	solutionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("solutionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), solutionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SolutionResourceSelfHelp, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
