//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicebus

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Subscription credentials that uniquely identify a Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewDisasterRecoveryConfigsClient creates a new instance of DisasterRecoveryConfigsClient.
func (c *ClientFactory) NewDisasterRecoveryConfigsClient() *DisasterRecoveryConfigsClient {
	subClient, _ := NewDisasterRecoveryConfigsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMigrationConfigsClient creates a new instance of MigrationConfigsClient.
func (c *ClientFactory) NewMigrationConfigsClient() *MigrationConfigsClient {
	subClient, _ := NewMigrationConfigsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNamespacesClient creates a new instance of NamespacesClient.
func (c *ClientFactory) NewNamespacesClient() *NamespacesClient {
	subClient, _ := NewNamespacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewQueuesClient creates a new instance of QueuesClient.
func (c *ClientFactory) NewQueuesClient() *QueuesClient {
	subClient, _ := NewQueuesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRulesClient creates a new instance of RulesClient.
func (c *ClientFactory) NewRulesClient() *RulesClient {
	subClient, _ := NewRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSubscriptionsClient creates a new instance of SubscriptionsClient.
func (c *ClientFactory) NewSubscriptionsClient() *SubscriptionsClient {
	subClient, _ := NewSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTopicsClient creates a new instance of TopicsClient.
func (c *ClientFactory) NewTopicsClient() *TopicsClient {
	subClient, _ := NewTopicsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
