//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicelinker

import "encoding/json"

func unmarshalAuthInfoBaseClassification(rawMsg json.RawMessage) (AuthInfoBaseClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AuthInfoBaseClassification
	switch m["authType"] {
	case string(AuthTypeAccessKey):
		b = &AccessKeyInfoBase{}
	case string(AuthTypeEasyAuthMicrosoftEntraID):
		b = &EasyAuthMicrosoftEntraIDAuthInfo{}
	case string(AuthTypeSecret):
		b = &SecretAuthInfo{}
	case string(AuthTypeServicePrincipalCertificate):
		b = &ServicePrincipalCertificateAuthInfo{}
	case string(AuthTypeServicePrincipalSecret):
		b = &ServicePrincipalSecretAuthInfo{}
	case string(AuthTypeSystemAssignedIdentity):
		b = &SystemAssignedIdentityAuthInfo{}
	case string(AuthTypeUserAccount):
		b = &UserAccountAuthInfo{}
	case string(AuthTypeUserAssignedIdentity):
		b = &UserAssignedIdentityAuthInfo{}
	default:
		b = &AuthInfoBase{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAzureResourcePropertiesBaseClassification(rawMsg json.RawMessage) (AzureResourcePropertiesBaseClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureResourcePropertiesBaseClassification
	switch m["type"] {
	case string(AzureResourceTypeKeyVault):
		b = &AzureKeyVaultProperties{}
	default:
		b = &AzureResourcePropertiesBase{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDryrunParametersClassification(rawMsg json.RawMessage) (DryrunParametersClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DryrunParametersClassification
	switch m["actionName"] {
	case string(DryrunActionNameCreateOrUpdate):
		b = &CreateOrUpdateDryrunParameters{}
	default:
		b = &DryrunParameters{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDryrunPrerequisiteResultClassification(rawMsg json.RawMessage) (DryrunPrerequisiteResultClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DryrunPrerequisiteResultClassification
	switch m["type"] {
	case string(DryrunPrerequisiteResultTypeBasicError):
		b = &BasicErrorDryrunPrerequisiteResult{}
	case string(DryrunPrerequisiteResultTypePermissionsMissing):
		b = &PermissionsMissingDryrunPrerequisiteResult{}
	default:
		b = &DryrunPrerequisiteResult{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDryrunPrerequisiteResultClassificationArray(rawMsg json.RawMessage) ([]DryrunPrerequisiteResultClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]DryrunPrerequisiteResultClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalDryrunPrerequisiteResultClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalSecretInfoBaseClassification(rawMsg json.RawMessage) (SecretInfoBaseClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b SecretInfoBaseClassification
	switch m["secretType"] {
	case string(SecretTypeKeyVaultSecretReference):
		b = &KeyVaultSecretReferenceSecretInfo{}
	case string(SecretTypeKeyVaultSecretURI):
		b = &KeyVaultSecretURISecretInfo{}
	case string(SecretTypeRawValue):
		b = &ValueSecretInfo{}
	default:
		b = &SecretInfoBase{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalTargetServiceBaseClassification(rawMsg json.RawMessage) (TargetServiceBaseClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b TargetServiceBaseClassification
	switch m["type"] {
	case string(TargetServiceTypeAzureResource):
		b = &AzureResource{}
	case string(TargetServiceTypeConfluentBootstrapServer):
		b = &ConfluentBootstrapServer{}
	case string(TargetServiceTypeConfluentSchemaRegistry):
		b = &ConfluentSchemaRegistry{}
	case string(TargetServiceTypeSelfHostedServer):
		b = &SelfHostedServer{}
	default:
		b = &TargetServiceBase{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
