//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/solutions/armmanagedapplications/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ApplicationDefinitionsServer is a fake server for instances of the armmanagedapplications.ApplicationDefinitionsClient type.
type ApplicationDefinitionsServer struct {
	// CreateOrUpdate is the fake for method ApplicationDefinitionsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, applicationDefinitionName string, parameters armmanagedapplications.ApplicationDefinition, options *armmanagedapplications.ApplicationDefinitionsClientCreateOrUpdateOptions) (resp azfake.Responder[armmanagedapplications.ApplicationDefinitionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateByID is the fake for method ApplicationDefinitionsClient.CreateOrUpdateByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateByID func(ctx context.Context, resourceGroupName string, applicationDefinitionName string, parameters armmanagedapplications.ApplicationDefinition, options *armmanagedapplications.ApplicationDefinitionsClientCreateOrUpdateByIDOptions) (resp azfake.Responder[armmanagedapplications.ApplicationDefinitionsClientCreateOrUpdateByIDResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ApplicationDefinitionsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, applicationDefinitionName string, options *armmanagedapplications.ApplicationDefinitionsClientDeleteOptions) (resp azfake.Responder[armmanagedapplications.ApplicationDefinitionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteByID is the fake for method ApplicationDefinitionsClient.DeleteByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteByID func(ctx context.Context, resourceGroupName string, applicationDefinitionName string, options *armmanagedapplications.ApplicationDefinitionsClientDeleteByIDOptions) (resp azfake.Responder[armmanagedapplications.ApplicationDefinitionsClientDeleteByIDResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ApplicationDefinitionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotFound
	Get func(ctx context.Context, resourceGroupName string, applicationDefinitionName string, options *armmanagedapplications.ApplicationDefinitionsClientGetOptions) (resp azfake.Responder[armmanagedapplications.ApplicationDefinitionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByID is the fake for method ApplicationDefinitionsClient.GetByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotFound
	GetByID func(ctx context.Context, resourceGroupName string, applicationDefinitionName string, options *armmanagedapplications.ApplicationDefinitionsClientGetByIDOptions) (resp azfake.Responder[armmanagedapplications.ApplicationDefinitionsClientGetByIDResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method ApplicationDefinitionsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armmanagedapplications.ApplicationDefinitionsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armmanagedapplications.ApplicationDefinitionsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method ApplicationDefinitionsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armmanagedapplications.ApplicationDefinitionsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armmanagedapplications.ApplicationDefinitionsClientListBySubscriptionResponse])

	// Update is the fake for method ApplicationDefinitionsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, applicationDefinitionName string, parameters armmanagedapplications.ApplicationDefinitionPatchable, options *armmanagedapplications.ApplicationDefinitionsClientUpdateOptions) (resp azfake.Responder[armmanagedapplications.ApplicationDefinitionsClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateByID is the fake for method ApplicationDefinitionsClient.UpdateByID
	// HTTP status codes to indicate success: http.StatusOK
	UpdateByID func(ctx context.Context, resourceGroupName string, applicationDefinitionName string, parameters armmanagedapplications.ApplicationDefinitionPatchable, options *armmanagedapplications.ApplicationDefinitionsClientUpdateByIDOptions) (resp azfake.Responder[armmanagedapplications.ApplicationDefinitionsClientUpdateByIDResponse], errResp azfake.ErrorResponder)
}

// NewApplicationDefinitionsServerTransport creates a new instance of ApplicationDefinitionsServerTransport with the provided implementation.
// The returned ApplicationDefinitionsServerTransport instance is connected to an instance of armmanagedapplications.ApplicationDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewApplicationDefinitionsServerTransport(srv *ApplicationDefinitionsServer) *ApplicationDefinitionsServerTransport {
	return &ApplicationDefinitionsServerTransport{
		srv:                         srv,
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armmanagedapplications.ApplicationDefinitionsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armmanagedapplications.ApplicationDefinitionsClientListBySubscriptionResponse]](),
	}
}

// ApplicationDefinitionsServerTransport connects instances of armmanagedapplications.ApplicationDefinitionsClient to instances of ApplicationDefinitionsServer.
// Don't use this type directly, use NewApplicationDefinitionsServerTransport instead.
type ApplicationDefinitionsServerTransport struct {
	srv                         *ApplicationDefinitionsServer
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armmanagedapplications.ApplicationDefinitionsClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armmanagedapplications.ApplicationDefinitionsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for ApplicationDefinitionsServerTransport.
func (a *ApplicationDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ApplicationDefinitionsClient.CreateOrUpdate":
		resp, err = a.dispatchCreateOrUpdate(req)
	case "ApplicationDefinitionsClient.CreateOrUpdateByID":
		resp, err = a.dispatchCreateOrUpdateByID(req)
	case "ApplicationDefinitionsClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "ApplicationDefinitionsClient.DeleteByID":
		resp, err = a.dispatchDeleteByID(req)
	case "ApplicationDefinitionsClient.Get":
		resp, err = a.dispatchGet(req)
	case "ApplicationDefinitionsClient.GetByID":
		resp, err = a.dispatchGetByID(req)
	case "ApplicationDefinitionsClient.NewListByResourceGroupPager":
		resp, err = a.dispatchNewListByResourceGroupPager(req)
	case "ApplicationDefinitionsClient.NewListBySubscriptionPager":
		resp, err = a.dispatchNewListBySubscriptionPager(req)
	case "ApplicationDefinitionsClient.Update":
		resp, err = a.dispatchUpdate(req)
	case "ApplicationDefinitionsClient.UpdateByID":
		resp, err = a.dispatchUpdateByID(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions/(?P<applicationDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.ApplicationDefinition](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, applicationDefinitionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplicationDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchCreateOrUpdateByID(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdateByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions/(?P<applicationDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.ApplicationDefinition](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdateByID(req.Context(), resourceGroupNameParam, applicationDefinitionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplicationDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions/(?P<applicationDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), resourceGroupNameParam, applicationDefinitionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchDeleteByID(req *http.Request) (*http.Response, error) {
	if a.srv.DeleteByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions/(?P<applicationDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.DeleteByID(req.Context(), resourceGroupNameParam, applicationDefinitionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions/(?P<applicationDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, applicationDefinitionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplicationDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchGetByID(req *http.Request) (*http.Response, error) {
	if a.srv.GetByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions/(?P<applicationDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetByID(req.Context(), resourceGroupNameParam, applicationDefinitionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplicationDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := a.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		a.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armmanagedapplications.ApplicationDefinitionsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		a.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := a.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		a.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armmanagedapplications.ApplicationDefinitionsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		a.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions/(?P<applicationDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.ApplicationDefinitionPatchable](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Update(req.Context(), resourceGroupNameParam, applicationDefinitionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplicationDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationDefinitionsServerTransport) dispatchUpdateByID(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applicationDefinitions/(?P<applicationDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.ApplicationDefinitionPatchable](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateByID(req.Context(), resourceGroupNameParam, applicationDefinitionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplicationDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
