//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armspringappdiscovery

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SpringbootappsClient contains the methods for the Springbootapps group.
// Don't use this type directly, use NewSpringbootappsClient() instead.
type SpringbootappsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSpringbootappsClient creates a new instance of SpringbootappsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSpringbootappsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SpringbootappsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SpringbootappsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Get a springbootapps resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - siteName - The springbootsites name.
//   - springbootappsName - The springbootapps name.
//   - options - SpringbootappsClientGetOptions contains the optional parameters for the SpringbootappsClient.Get method.
func (client *SpringbootappsClient) Get(ctx context.Context, resourceGroupName string, siteName string, springbootappsName string, options *SpringbootappsClientGetOptions) (SpringbootappsClientGetResponse, error) {
	var err error
	const operationName = "SpringbootappsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, siteName, springbootappsName, options)
	if err != nil {
		return SpringbootappsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SpringbootappsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SpringbootappsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SpringbootappsClient) getCreateRequest(ctx context.Context, resourceGroupName string, siteName string, springbootappsName string, options *SpringbootappsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if springbootappsName == "" {
		return nil, errors.New("parameter springbootappsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{springbootappsName}", url.PathEscape(springbootappsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SpringbootappsClient) getHandleResponse(resp *http.Response) (SpringbootappsClientGetResponse, error) {
	result := SpringbootappsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SpringbootappsModel); err != nil {
		return SpringbootappsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - List springbootapps resource by resourceGroup
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - siteName - The springbootsites name.
//   - options - SpringbootappsClientListByResourceGroupOptions contains the optional parameters for the SpringbootappsClient.NewListByResourceGroupPager
//     method.
func (client *SpringbootappsClient) NewListByResourceGroupPager(resourceGroupName string, siteName string, options *SpringbootappsClientListByResourceGroupOptions) *runtime.Pager[SpringbootappsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[SpringbootappsClientListByResourceGroupResponse]{
		More: func(page SpringbootappsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SpringbootappsClientListByResourceGroupResponse) (SpringbootappsClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SpringbootappsClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, siteName, options)
			}, nil)
			if err != nil {
				return SpringbootappsClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *SpringbootappsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, siteName string, options *SpringbootappsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *SpringbootappsClient) listByResourceGroupHandleResponse(resp *http.Response) (SpringbootappsClientListByResourceGroupResponse, error) {
	result := SpringbootappsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SpringbootappsListResult); err != nil {
		return SpringbootappsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List springbootapps resource by subscription
//
// Generated from API version 2023-01-01-preview
//   - siteName - The springbootsites name.
//   - options - SpringbootappsClientListBySubscriptionOptions contains the optional parameters for the SpringbootappsClient.NewListBySubscriptionPager
//     method.
func (client *SpringbootappsClient) NewListBySubscriptionPager(siteName string, options *SpringbootappsClientListBySubscriptionOptions) *runtime.Pager[SpringbootappsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[SpringbootappsClientListBySubscriptionResponse]{
		More: func(page SpringbootappsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SpringbootappsClientListBySubscriptionResponse) (SpringbootappsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SpringbootappsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, siteName, options)
			}, nil)
			if err != nil {
				return SpringbootappsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *SpringbootappsClient) listBySubscriptionCreateRequest(ctx context.Context, siteName string, options *SpringbootappsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *SpringbootappsClient) listBySubscriptionHandleResponse(resp *http.Response) (SpringbootappsClientListBySubscriptionResponse, error) {
	result := SpringbootappsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SpringbootappsListResult); err != nil {
		return SpringbootappsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Update a springbootapps resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - siteName - The springbootsites name.
//   - springbootappsName - The springbootapps name.
//   - springbootapps - Update a springbootapps payload.
//   - options - SpringbootappsClientBeginUpdateOptions contains the optional parameters for the SpringbootappsClient.BeginUpdate
//     method.
func (client *SpringbootappsClient) BeginUpdate(ctx context.Context, resourceGroupName string, siteName string, springbootappsName string, springbootapps SpringbootappsPatch, options *SpringbootappsClientBeginUpdateOptions) (*runtime.Poller[SpringbootappsClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, siteName, springbootappsName, springbootapps, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SpringbootappsClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SpringbootappsClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Update a springbootapps resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
func (client *SpringbootappsClient) update(ctx context.Context, resourceGroupName string, siteName string, springbootappsName string, springbootapps SpringbootappsPatch, options *SpringbootappsClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "SpringbootappsClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, siteName, springbootappsName, springbootapps, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *SpringbootappsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, siteName string, springbootappsName string, springbootapps SpringbootappsPatch, options *SpringbootappsClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if springbootappsName == "" {
		return nil, errors.New("parameter springbootappsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{springbootappsName}", url.PathEscape(springbootappsName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, springbootapps); err != nil {
		return nil, err
	}
	return req, nil
}
