//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armspringappdiscovery_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/springappdiscovery/armspringappdiscovery"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_Get_MaximumSet_Gen.json
func ExampleSpringbootserversClient_Get_springbootserversGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpringbootserversClient().Get(ctx, "rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootserversModel = armspringappdiscovery.SpringbootserversModel{
	// 	Name: to.Ptr("licrobomiqalwnrti"),
	// 	Type: to.Ptr("wlmmljjoqbqnhbotk"),
	// 	ID: to.Ptr("xsfjeazznmryzgjsuvymj"),
	// 	SystemData: &armspringappdiscovery.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
	// 		CreatedBy: to.Ptr("wnkpkjmpusyo"),
	// 		CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("pbpaajxtbivcftbnhqtngytbx"),
	// 		LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 	},
	// 	Properties: &armspringappdiscovery.SpringbootserversProperties{
	// 		Errors: []*armspringappdiscovery.Error{
	// 		},
	// 		FqdnAndIPAddressList: []*string{
	// 		},
	// 		MachineArmID: to.Ptr("fvfkiapbqsprnbzczdfmuryknrna"),
	// 		Port: to.Ptr[int32](10),
	// 		ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
	// 		Server: to.Ptr("thhuxocfyqpeluqcgnypi"),
	// 		SpringBootApps: to.Ptr[int32](17),
	// 		TotalApps: to.Ptr[int32](5),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_Get_MinimumSet_Gen.json
func ExampleSpringbootserversClient_Get_springbootserversGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpringbootserversClient().Get(ctx, "rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootserversModel = armspringappdiscovery.SpringbootserversModel{
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.OffAzureSpringBoot/springbootsites/testsite1/springbootservers/server1"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_CreateOrUpdate_MaximumSet_Gen.json
func ExampleSpringbootserversClient_CreateOrUpdate_springbootserversCreateOrUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpringbootserversClient().CreateOrUpdate(ctx, "rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn", armspringappdiscovery.SpringbootserversModel{
		Properties: &armspringappdiscovery.SpringbootserversProperties{
			Errors:               []*armspringappdiscovery.Error{},
			FqdnAndIPAddressList: []*string{},
			MachineArmID:         to.Ptr("fvfkiapbqsprnbzczdfmuryknrna"),
			Port:                 to.Ptr[int32](10),
			Server:               to.Ptr("thhuxocfyqpeluqcgnypi"),
			SpringBootApps:       to.Ptr[int32](17),
			TotalApps:            to.Ptr[int32](5),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootserversModel = armspringappdiscovery.SpringbootserversModel{
	// 	Name: to.Ptr("licrobomiqalwnrti"),
	// 	Type: to.Ptr("wlmmljjoqbqnhbotk"),
	// 	ID: to.Ptr("xsfjeazznmryzgjsuvymj"),
	// 	SystemData: &armspringappdiscovery.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
	// 		CreatedBy: to.Ptr("wnkpkjmpusyo"),
	// 		CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("pbpaajxtbivcftbnhqtngytbx"),
	// 		LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 	},
	// 	Properties: &armspringappdiscovery.SpringbootserversProperties{
	// 		Errors: []*armspringappdiscovery.Error{
	// 		},
	// 		FqdnAndIPAddressList: []*string{
	// 		},
	// 		MachineArmID: to.Ptr("fvfkiapbqsprnbzczdfmuryknrna"),
	// 		Port: to.Ptr[int32](10),
	// 		ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
	// 		Server: to.Ptr("thhuxocfyqpeluqcgnypi"),
	// 		SpringBootApps: to.Ptr[int32](17),
	// 		TotalApps: to.Ptr[int32](5),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_CreateOrUpdate_MinimumSet_Gen.json
func ExampleSpringbootserversClient_CreateOrUpdate_springbootserversCreateOrUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpringbootserversClient().CreateOrUpdate(ctx, "rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn", armspringappdiscovery.SpringbootserversModel{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootserversModel = armspringappdiscovery.SpringbootserversModel{
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.OffAzureSpringBoot/springbootsites/testsite1/springbootservers/server1"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_Delete_MaximumSet_Gen.json
func ExampleSpringbootserversClient_BeginDelete_springbootserversDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootserversClient().BeginDelete(ctx, "rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_Delete_MinimumSet_Gen.json
func ExampleSpringbootserversClient_BeginDelete_springbootserversDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootserversClient().BeginDelete(ctx, "rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_Update_MaximumSet_Gen.json
func ExampleSpringbootserversClient_BeginUpdate_springbootserversUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootserversClient().BeginUpdate(ctx, "rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn", armspringappdiscovery.SpringbootserversPatch{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootserversModel = armspringappdiscovery.SpringbootserversModel{
	// 	Name: to.Ptr("licrobomiqalwnrti"),
	// 	Type: to.Ptr("wlmmljjoqbqnhbotk"),
	// 	ID: to.Ptr("xsfjeazznmryzgjsuvymj"),
	// 	SystemData: &armspringappdiscovery.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
	// 		CreatedBy: to.Ptr("wnkpkjmpusyo"),
	// 		CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("pbpaajxtbivcftbnhqtngytbx"),
	// 		LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 	},
	// 	Properties: &armspringappdiscovery.SpringbootserversProperties{
	// 		Errors: []*armspringappdiscovery.Error{
	// 		},
	// 		FqdnAndIPAddressList: []*string{
	// 		},
	// 		MachineArmID: to.Ptr("fvfkiapbqsprnbzczdfmuryknrna"),
	// 		Port: to.Ptr[int32](10),
	// 		ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
	// 		Server: to.Ptr("thhuxocfyqpeluqcgnypi"),
	// 		SpringBootApps: to.Ptr[int32](17),
	// 		TotalApps: to.Ptr[int32](5),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_Update_MinimumSet_Gen.json
func ExampleSpringbootserversClient_BeginUpdate_springbootserversUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootserversClient().BeginUpdate(ctx, "rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn", armspringappdiscovery.SpringbootserversPatch{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootserversModel = armspringappdiscovery.SpringbootserversModel{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_ListByResourceGroup_MaximumSet_Gen.json
func ExampleSpringbootserversClient_NewListByResourceGroupPager_springbootserversListByResourceGroupMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpringbootserversClient().NewListByResourceGroupPager("rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpringbootserversListResult = armspringappdiscovery.SpringbootserversListResult{
		// 	Value: []*armspringappdiscovery.SpringbootserversModel{
		// 		{
		// 			Name: to.Ptr("licrobomiqalwnrti"),
		// 			Type: to.Ptr("wlmmljjoqbqnhbotk"),
		// 			ID: to.Ptr("xsfjeazznmryzgjsuvymj"),
		// 			SystemData: &armspringappdiscovery.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
		// 				CreatedBy: to.Ptr("wnkpkjmpusyo"),
		// 				CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("pbpaajxtbivcftbnhqtngytbx"),
		// 				LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
		// 			},
		// 			Properties: &armspringappdiscovery.SpringbootserversProperties{
		// 				Errors: []*armspringappdiscovery.Error{
		// 				},
		// 				FqdnAndIPAddressList: []*string{
		// 				},
		// 				MachineArmID: to.Ptr("fvfkiapbqsprnbzczdfmuryknrna"),
		// 				Port: to.Ptr[int32](10),
		// 				ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
		// 				Server: to.Ptr("thhuxocfyqpeluqcgnypi"),
		// 				SpringBootApps: to.Ptr[int32](17),
		// 				TotalApps: to.Ptr[int32](5),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_ListByResourceGroup_MinimumSet_Gen.json
func ExampleSpringbootserversClient_NewListByResourceGroupPager_springbootserversListByResourceGroupMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpringbootserversClient().NewListByResourceGroupPager("rgspringbootservers", "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpringbootserversListResult = armspringappdiscovery.SpringbootserversListResult{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_ListBySubscription_MaximumSet_Gen.json
func ExampleSpringbootserversClient_NewListBySubscriptionPager_springbootserversListBySubscriptionMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpringbootserversClient().NewListBySubscriptionPager("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpringbootserversListResult = armspringappdiscovery.SpringbootserversListResult{
		// 	Value: []*armspringappdiscovery.SpringbootserversModel{
		// 		{
		// 			Name: to.Ptr("licrobomiqalwnrti"),
		// 			Type: to.Ptr("wlmmljjoqbqnhbotk"),
		// 			ID: to.Ptr("xsfjeazznmryzgjsuvymj"),
		// 			SystemData: &armspringappdiscovery.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
		// 				CreatedBy: to.Ptr("wnkpkjmpusyo"),
		// 				CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T09:00:31.448Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("pbpaajxtbivcftbnhqtngytbx"),
		// 				LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
		// 			},
		// 			Properties: &armspringappdiscovery.SpringbootserversProperties{
		// 				Errors: []*armspringappdiscovery.Error{
		// 				},
		// 				FqdnAndIPAddressList: []*string{
		// 				},
		// 				MachineArmID: to.Ptr("fvfkiapbqsprnbzczdfmuryknrna"),
		// 				Port: to.Ptr[int32](10),
		// 				ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
		// 				Server: to.Ptr("thhuxocfyqpeluqcgnypi"),
		// 				SpringBootApps: to.Ptr[int32](17),
		// 				TotalApps: to.Ptr[int32](5),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootservers_ListBySubscription_MinimumSet_Gen.json
func ExampleSpringbootserversClient_NewListBySubscriptionPager_springbootserversListBySubscriptionMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpringbootserversClient().NewListBySubscriptionPager("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpringbootserversListResult = armspringappdiscovery.SpringbootserversListResult{
		// }
	}
}
