//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armspringappdiscovery_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/springappdiscovery/armspringappdiscovery"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_Get_MaximumSet_Gen.json
func ExampleSpringbootsitesClient_Get_springbootsitesGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpringbootsitesClient().Get(ctx, "rgspringbootsites", "xrmzlavpewxtfeitghdrj", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootsitesModel = armspringappdiscovery.SpringbootsitesModel{
	// 	Name: to.Ptr("jjyngfg"),
	// 	Type: to.Ptr("jnhikchnunglggvsuyy"),
	// 	ID: to.Ptr("dynfdywpzysyqnfgdddj"),
	// 	SystemData: &armspringappdiscovery.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
	// 		CreatedBy: to.Ptr("cqwftvyr"),
	// 		CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("yezjizjfobybuslq"),
	// 		LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
	// 	Tags: map[string]*string{
	// 		"key3558": to.Ptr("xeuhtglamqzj"),
	// 	},
	// 	ExtendedLocation: &armspringappdiscovery.SpringbootsitesModelExtendedLocation{
	// 		Name: to.Ptr("rywvpbfsqovhlfirtwisugsdsfsgf"),
	// 		Type: to.Ptr("lvsb"),
	// 	},
	// 	Properties: &armspringappdiscovery.SpringbootsitesProperties{
	// 		MasterSiteID: to.Ptr("xsoimrgshsactearljwuljmi"),
	// 		MigrateProjectID: to.Ptr("wwuattybgco"),
	// 		ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_Get_MinimumSet_Gen.json
func ExampleSpringbootsitesClient_Get_springbootsitesGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpringbootsitesClient().Get(ctx, "rgspringbootsites", "xrmzlavpewxtfeitghdrj", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootsitesModel = armspringappdiscovery.SpringbootsitesModel{
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.OffAzureSpringBoot/springbootsites/testsite1"),
	// 	Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_CreateOrUpdate_MaximumSet_Gen.json
func ExampleSpringbootsitesClient_CreateOrUpdate_springbootsitesCreateOrUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpringbootsitesClient().CreateOrUpdate(ctx, "rgspringbootsites", "xrmzlavpewxtfeitghdrj", armspringappdiscovery.SpringbootsitesModel{
		Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
		Tags: map[string]*string{
			"key3558": to.Ptr("xeuhtglamqzj"),
		},
		ExtendedLocation: &armspringappdiscovery.SpringbootsitesModelExtendedLocation{
			Name: to.Ptr("rywvpbfsqovhlfirtwisugsdsfsgf"),
			Type: to.Ptr("lvsb"),
		},
		Properties: &armspringappdiscovery.SpringbootsitesProperties{
			MasterSiteID:     to.Ptr("xsoimrgshsactearljwuljmi"),
			MigrateProjectID: to.Ptr("wwuattybgco"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootsitesModel = armspringappdiscovery.SpringbootsitesModel{
	// 	Name: to.Ptr("jjyngfg"),
	// 	Type: to.Ptr("jnhikchnunglggvsuyy"),
	// 	ID: to.Ptr("dynfdywpzysyqnfgdddj"),
	// 	SystemData: &armspringappdiscovery.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
	// 		CreatedBy: to.Ptr("cqwftvyr"),
	// 		CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("yezjizjfobybuslq"),
	// 		LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
	// 	Tags: map[string]*string{
	// 		"key3558": to.Ptr("xeuhtglamqzj"),
	// 	},
	// 	ExtendedLocation: &armspringappdiscovery.SpringbootsitesModelExtendedLocation{
	// 		Name: to.Ptr("rywvpbfsqovhlfirtwisugsdsfsgf"),
	// 		Type: to.Ptr("lvsb"),
	// 	},
	// 	Properties: &armspringappdiscovery.SpringbootsitesProperties{
	// 		MasterSiteID: to.Ptr("xsoimrgshsactearljwuljmi"),
	// 		MigrateProjectID: to.Ptr("wwuattybgco"),
	// 		ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_CreateOrUpdate_MinimumSet_Gen.json
func ExampleSpringbootsitesClient_CreateOrUpdate_springbootsitesCreateOrUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpringbootsitesClient().CreateOrUpdate(ctx, "rgspringbootsites", "xrmzlavpewxtfeitghdrj", armspringappdiscovery.SpringbootsitesModel{
		Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootsitesModel = armspringappdiscovery.SpringbootsitesModel{
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.OffAzureSpringBoot/springbootsites/testsite1"),
	// 	Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_Delete_MaximumSet_Gen.json
func ExampleSpringbootsitesClient_BeginDelete_springbootsitesDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootsitesClient().BeginDelete(ctx, "rgspringbootsites", "xrmzlavpewxtfeitghdrj", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_Delete_MinimumSet_Gen.json
func ExampleSpringbootsitesClient_BeginDelete_springbootsitesDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootsitesClient().BeginDelete(ctx, "rgspringbootsites", "xrmzlavpewxtfeitghdrj", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_Update_MaximumSet_Gen.json
func ExampleSpringbootsitesClient_BeginUpdate_springbootsitesUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootsitesClient().BeginUpdate(ctx, "rgspringbootsites", "xrmzlavpewxtfeitghdrj", armspringappdiscovery.SpringbootsitesPatch{
		Location: to.Ptr("icnumzvzzeqhuxtcefuqdcro"),
		Tags: map[string]*string{
			"key9581": to.Ptr("cgdqvbknjrwcwuesquddsxu"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootsitesModel = armspringappdiscovery.SpringbootsitesModel{
	// 	Name: to.Ptr("jjyngfg"),
	// 	Type: to.Ptr("jnhikchnunglggvsuyy"),
	// 	ID: to.Ptr("dynfdywpzysyqnfgdddj"),
	// 	SystemData: &armspringappdiscovery.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
	// 		CreatedBy: to.Ptr("cqwftvyr"),
	// 		CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("yezjizjfobybuslq"),
	// 		LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
	// 	Tags: map[string]*string{
	// 		"key3558": to.Ptr("xeuhtglamqzj"),
	// 	},
	// 	ExtendedLocation: &armspringappdiscovery.SpringbootsitesModelExtendedLocation{
	// 		Name: to.Ptr("rywvpbfsqovhlfirtwisugsdsfsgf"),
	// 		Type: to.Ptr("lvsb"),
	// 	},
	// 	Properties: &armspringappdiscovery.SpringbootsitesProperties{
	// 		MasterSiteID: to.Ptr("xsoimrgshsactearljwuljmi"),
	// 		MigrateProjectID: to.Ptr("wwuattybgco"),
	// 		ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_Update_MinimumSet_Gen.json
func ExampleSpringbootsitesClient_BeginUpdate_springbootsitesUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootsitesClient().BeginUpdate(ctx, "rgspringbootsites", "xrmzlavpewxtfeitghdrj", armspringappdiscovery.SpringbootsitesPatch{
		Location: to.Ptr("icnumzvzzeqhuxtcefuqdcro"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SpringbootsitesModel = armspringappdiscovery.SpringbootsitesModel{
	// 	Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_TriggerRefreshSite_MaximumSet_Gen.json
func ExampleSpringbootsitesClient_BeginTriggerRefreshSite_springbootsitesTriggerRefreshSiteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootsitesClient().BeginTriggerRefreshSite(ctx, "rgspringbootsites", "czarpuxwoafaqsuptutcwyu", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_TriggerRefreshSite_MinimumSet_Gen.json
func ExampleSpringbootsitesClient_BeginTriggerRefreshSite_springbootsitesTriggerRefreshSiteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpringbootsitesClient().BeginTriggerRefreshSite(ctx, "rgspringbootsites", "czarpuxwoafaqsuptutcwyu", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_ListByResourceGroup_MaximumSet_Gen.json
func ExampleSpringbootsitesClient_NewListByResourceGroupPager_springbootsitesListByResourceGroupMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpringbootsitesClient().NewListByResourceGroupPager("rgspringbootsites", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpringbootsitesListResult = armspringappdiscovery.SpringbootsitesListResult{
		// 	Value: []*armspringappdiscovery.SpringbootsitesModel{
		// 		{
		// 			Name: to.Ptr("jjyngfg"),
		// 			Type: to.Ptr("jnhikchnunglggvsuyy"),
		// 			ID: to.Ptr("dynfdywpzysyqnfgdddj"),
		// 			SystemData: &armspringappdiscovery.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
		// 				CreatedBy: to.Ptr("cqwftvyr"),
		// 				CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("yezjizjfobybuslq"),
		// 				LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
		// 			Tags: map[string]*string{
		// 				"key3558": to.Ptr("xeuhtglamqzj"),
		// 			},
		// 			ExtendedLocation: &armspringappdiscovery.SpringbootsitesModelExtendedLocation{
		// 				Name: to.Ptr("rywvpbfsqovhlfirtwisugsdsfsgf"),
		// 				Type: to.Ptr("lvsb"),
		// 			},
		// 			Properties: &armspringappdiscovery.SpringbootsitesProperties{
		// 				MasterSiteID: to.Ptr("xsoimrgshsactearljwuljmi"),
		// 				MigrateProjectID: to.Ptr("wwuattybgco"),
		// 				ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_ListByResourceGroup_MinimumSet_Gen.json
func ExampleSpringbootsitesClient_NewListByResourceGroupPager_springbootsitesListByResourceGroupMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpringbootsitesClient().NewListByResourceGroupPager("rgspringbootsites", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpringbootsitesListResult = armspringappdiscovery.SpringbootsitesListResult{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_ListBySubscription_MaximumSet_Gen.json
func ExampleSpringbootsitesClient_NewListBySubscriptionPager_springbootsitesListBySubscriptionMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpringbootsitesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpringbootsitesListResult = armspringappdiscovery.SpringbootsitesListResult{
		// 	Value: []*armspringappdiscovery.SpringbootsitesModel{
		// 		{
		// 			Name: to.Ptr("jjyngfg"),
		// 			Type: to.Ptr("jnhikchnunglggvsuyy"),
		// 			ID: to.Ptr("dynfdywpzysyqnfgdddj"),
		// 			SystemData: &armspringappdiscovery.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
		// 				CreatedBy: to.Ptr("cqwftvyr"),
		// 				CreatedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-12-02T11:53:09.096Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("yezjizjfobybuslq"),
		// 				LastModifiedByType: to.Ptr(armspringappdiscovery.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("tgobtvxktootwhhvjtsmpddvlqlrq"),
		// 			Tags: map[string]*string{
		// 				"key3558": to.Ptr("xeuhtglamqzj"),
		// 			},
		// 			ExtendedLocation: &armspringappdiscovery.SpringbootsitesModelExtendedLocation{
		// 				Name: to.Ptr("rywvpbfsqovhlfirtwisugsdsfsgf"),
		// 				Type: to.Ptr("lvsb"),
		// 			},
		// 			Properties: &armspringappdiscovery.SpringbootsitesProperties{
		// 				MasterSiteID: to.Ptr("xsoimrgshsactearljwuljmi"),
		// 				MigrateProjectID: to.Ptr("wwuattybgco"),
		// 				ProvisioningState: to.Ptr(armspringappdiscovery.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootsites_ListBySubscription_MinimumSet_Gen.json
func ExampleSpringbootsitesClient_NewListBySubscriptionPager_springbootsitesListBySubscriptionMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armspringappdiscovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpringbootsitesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpringbootsitesListResult = armspringappdiscovery.SpringbootsitesListResult{
		// }
	}
}
