//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedInstanceDtcsServer is a fake server for instances of the armsql.ManagedInstanceDtcsClient type.
type ManagedInstanceDtcsServer struct {
	// BeginCreateOrUpdate is the fake for method ManagedInstanceDtcsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, dtcName armsql.DtcName, parameters armsql.ManagedInstanceDtc, options *armsql.ManagedInstanceDtcsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.ManagedInstanceDtcsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedInstanceDtcsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, dtcName armsql.DtcName, options *armsql.ManagedInstanceDtcsClientGetOptions) (resp azfake.Responder[armsql.ManagedInstanceDtcsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagedInstancePager is the fake for method ManagedInstanceDtcsClient.NewListByManagedInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagedInstancePager func(resourceGroupName string, managedInstanceName string, options *armsql.ManagedInstanceDtcsClientListByManagedInstanceOptions) (resp azfake.PagerResponder[armsql.ManagedInstanceDtcsClientListByManagedInstanceResponse])
}

// NewManagedInstanceDtcsServerTransport creates a new instance of ManagedInstanceDtcsServerTransport with the provided implementation.
// The returned ManagedInstanceDtcsServerTransport instance is connected to an instance of armsql.ManagedInstanceDtcsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedInstanceDtcsServerTransport(srv *ManagedInstanceDtcsServer) *ManagedInstanceDtcsServerTransport {
	return &ManagedInstanceDtcsServerTransport{
		srv:                           srv,
		beginCreateOrUpdate:           newTracker[azfake.PollerResponder[armsql.ManagedInstanceDtcsClientCreateOrUpdateResponse]](),
		newListByManagedInstancePager: newTracker[azfake.PagerResponder[armsql.ManagedInstanceDtcsClientListByManagedInstanceResponse]](),
	}
}

// ManagedInstanceDtcsServerTransport connects instances of armsql.ManagedInstanceDtcsClient to instances of ManagedInstanceDtcsServer.
// Don't use this type directly, use NewManagedInstanceDtcsServerTransport instead.
type ManagedInstanceDtcsServerTransport struct {
	srv                           *ManagedInstanceDtcsServer
	beginCreateOrUpdate           *tracker[azfake.PollerResponder[armsql.ManagedInstanceDtcsClientCreateOrUpdateResponse]]
	newListByManagedInstancePager *tracker[azfake.PagerResponder[armsql.ManagedInstanceDtcsClientListByManagedInstanceResponse]]
}

// Do implements the policy.Transporter interface for ManagedInstanceDtcsServerTransport.
func (m *ManagedInstanceDtcsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedInstanceDtcsClient.BeginCreateOrUpdate":
		resp, err = m.dispatchBeginCreateOrUpdate(req)
	case "ManagedInstanceDtcsClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedInstanceDtcsClient.NewListByManagedInstancePager":
		resp, err = m.dispatchNewListByManagedInstancePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedInstanceDtcsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := m.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dtc/(?P<dtcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedInstanceDtc](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		dtcNameParam, err := parseWithCast(matches[regex.SubexpIndex("dtcName")], func(v string) (armsql.DtcName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.DtcName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, dtcNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		m.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		m.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (m *ManagedInstanceDtcsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dtc/(?P<dtcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	dtcNameParam, err := parseWithCast(matches[regex.SubexpIndex("dtcName")], func(v string) (armsql.DtcName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.DtcName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, dtcNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedInstanceDtc, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedInstanceDtcsServerTransport) dispatchNewListByManagedInstancePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByManagedInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagedInstancePager not implemented")}
	}
	newListByManagedInstancePager := m.newListByManagedInstancePager.get(req)
	if newListByManagedInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dtc`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByManagedInstancePager(resourceGroupNameParam, managedInstanceNameParam, nil)
		newListByManagedInstancePager = &resp
		m.newListByManagedInstancePager.add(req, newListByManagedInstancePager)
		server.PagerResponderInjectNextLinks(newListByManagedInstancePager, req, func(page *armsql.ManagedInstanceDtcsClientListByManagedInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByManagedInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByManagedInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagedInstancePager) {
		m.newListByManagedInstancePager.remove(req)
	}
	return resp, nil
}
