//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServiceObjectivesClient contains the methods for the ServiceObjectives group.
// Don't use this type directly, use NewServiceObjectivesClient() instead.
type ServiceObjectivesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewServiceObjectivesClient creates a new instance of ServiceObjectivesClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewServiceObjectivesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServiceObjectivesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ServiceObjectivesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets a database service objective.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2014-04-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - serviceObjectiveName - The name of the service objective to retrieve.
//   - options - ServiceObjectivesClientGetOptions contains the optional parameters for the ServiceObjectivesClient.Get method.
func (client *ServiceObjectivesClient) Get(ctx context.Context, resourceGroupName string, serverName string, serviceObjectiveName string, options *ServiceObjectivesClientGetOptions) (ServiceObjectivesClientGetResponse, error) {
	var err error
	const operationName = "ServiceObjectivesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, serviceObjectiveName, options)
	if err != nil {
		return ServiceObjectivesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServiceObjectivesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServiceObjectivesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ServiceObjectivesClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, serviceObjectiveName string, options *ServiceObjectivesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/serviceObjectives/{serviceObjectiveName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if serviceObjectiveName == "" {
		return nil, errors.New("parameter serviceObjectiveName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceObjectiveName}", url.PathEscape(serviceObjectiveName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2014-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ServiceObjectivesClient) getHandleResponse(resp *http.Response) (ServiceObjectivesClientGetResponse, error) {
	result := ServiceObjectivesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServiceObjective); err != nil {
		return ServiceObjectivesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByServerPager - Returns database service objectives.
//
// Generated from API version 2014-04-01
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - options - ServiceObjectivesClientListByServerOptions contains the optional parameters for the ServiceObjectivesClient.NewListByServerPager
//     method.
func (client *ServiceObjectivesClient) NewListByServerPager(resourceGroupName string, serverName string, options *ServiceObjectivesClientListByServerOptions) *runtime.Pager[ServiceObjectivesClientListByServerResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServiceObjectivesClientListByServerResponse]{
		More: func(page ServiceObjectivesClientListByServerResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ServiceObjectivesClientListByServerResponse) (ServiceObjectivesClientListByServerResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ServiceObjectivesClient.NewListByServerPager")
			req, err := client.listByServerCreateRequest(ctx, resourceGroupName, serverName, options)
			if err != nil {
				return ServiceObjectivesClientListByServerResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ServiceObjectivesClientListByServerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ServiceObjectivesClientListByServerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByServerHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByServerCreateRequest creates the ListByServer request.
func (client *ServiceObjectivesClient) listByServerCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *ServiceObjectivesClientListByServerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/serviceObjectives"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2014-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByServerHandleResponse handles the ListByServer response.
func (client *ServiceObjectivesClient) listByServerHandleResponse(resp *http.Response) (ServiceObjectivesClientListByServerResponse, error) {
	result := ServiceObjectivesClientListByServerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServiceObjectiveListResult); err != nil {
		return ServiceObjectivesClientListByServerResponse{}, err
	}
	return result, nil
}
