//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SubscriptionUsageListByLocation.json
func ExampleSubscriptionUsagesClient_NewListByLocationPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSubscriptionUsagesClient().NewListByLocationPager("WestUS", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SubscriptionUsageListResult = armsql.SubscriptionUsageListResult{
		// 	Value: []*armsql.SubscriptionUsage{
		// 		{
		// 			Name: to.Ptr("ServerQuota"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/usages"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Sql/locations/Onebox/usages/ServerQuota"),
		// 			Properties: &armsql.SubscriptionUsageProperties{
		// 				CurrentValue: to.Ptr[float64](1),
		// 				DisplayName: to.Ptr("Regional Server Quota for West US"),
		// 				Limit: to.Ptr[float64](20),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SubscriptionFreeDatabaseCount"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/usages"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Sql/locations/Onebox/usages/SubscriptionFreeDatabaseCount"),
		// 			Properties: &armsql.SubscriptionUsageProperties{
		// 				CurrentValue: to.Ptr[float64](0),
		// 				DisplayName: to.Ptr("Free Database Count per Subscription for West US"),
		// 				Limit: to.Ptr[float64](1),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SubscriptionFreeDatabaseDaysLeft"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/usages"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Sql/locations/Onebox/usages/SubscriptionFreeDatabaseDaysLeft"),
		// 			Properties: &armsql.SubscriptionUsageProperties{
		// 				CurrentValue: to.Ptr[float64](365),
		// 				DisplayName: to.Ptr("Free to Basic Database Upgrade count-down in West US"),
		// 				Limit: to.Ptr[float64](365),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SubscriptionUsageGet.json
func ExampleSubscriptionUsagesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionUsagesClient().Get(ctx, "WestUS", "ServerQuota", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubscriptionUsage = armsql.SubscriptionUsage{
	// 	Name: to.Ptr("ServerQuota"),
	// 	Type: to.Ptr("Microsoft.Sql/locations/usages"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Sql/locations/Onebox/usages/ServerQuota"),
	// 	Properties: &armsql.SubscriptionUsageProperties{
	// 		CurrentValue: to.Ptr[float64](1),
	// 		DisplayName: to.Ptr("Regional Server Quota for West US"),
	// 		Limit: to.Ptr[float64](20),
	// 		Unit: to.Ptr("Count"),
	// 	},
	// }
}
