//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorageactions_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storageactions/armstorageactions"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/storageactions/resource-manager/Microsoft.StorageActions/stable/2023-01-01/examples/storageTasksCrud/PutStorageTask.json
func ExampleStorageTasksClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageactions.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStorageTasksClient().BeginCreate(ctx, "res4228", "mytask1", armstorageactions.StorageTask{
		Location: to.Ptr("westus"),
		Properties: &armstorageactions.StorageTaskProperties{
			Description: to.Ptr("My Storage task"),
			Action: &armstorageactions.StorageTaskAction{
				Else: &armstorageactions.ElseCondition{
					Operations: []*armstorageactions.StorageTaskOperation{
						{
							Name:      to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
							OnFailure: to.Ptr("break"),
							OnSuccess: to.Ptr("continue"),
						}},
				},
				If: &armstorageactions.IfCondition{
					Condition: to.Ptr("[[equals(AccessTier, 'Cool')]]"),
					Operations: []*armstorageactions.StorageTaskOperation{
						{
							Name:      to.Ptr(armstorageactions.StorageTaskOperationNameSetBlobTier),
							OnFailure: to.Ptr("break"),
							OnSuccess: to.Ptr("continue"),
							Parameters: map[string]*string{
								"tier": to.Ptr("Hot"),
							},
						}},
				},
			},
			Enabled: to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StorageTask = armstorageactions.StorageTask{
	// 	Name: to.Ptr("mytask1"),
	// 	Type: to.Ptr("Microsoft.StorageActions/storageTasks"),
	// 	ID: to.Ptr("/subscriptions/c86a9c18-8373-41fa-92d4-1d7bdc16977b/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armstorageactions.StorageTaskProperties{
	// 		Description: to.Ptr("Storage task"),
	// 		Action: &armstorageactions.StorageTaskAction{
	// 			Else: &armstorageactions.ElseCondition{
	// 				Operations: []*armstorageactions.StorageTaskOperation{
	// 					{
	// 						Name: to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
	// 						OnFailure: to.Ptr("break"),
	// 						OnSuccess: to.Ptr("continue"),
	// 				}},
	// 			},
	// 			If: &armstorageactions.IfCondition{
	// 				Condition: to.Ptr("[[equals(AccessTier, 'Cool')]]"),
	// 				Operations: []*armstorageactions.StorageTaskOperation{
	// 					{
	// 						Name: to.Ptr(armstorageactions.StorageTaskOperationNameSetBlobTier),
	// 						OnFailure: to.Ptr("break"),
	// 						OnSuccess: to.Ptr("continue"),
	// 						Parameters: map[string]*string{
	// 							"tier": to.Ptr("Hot"),
	// 						},
	// 				}},
	// 			},
	// 		},
	// 		CreationTimeInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-06T00:24:59.144Z"); return t}()),
	// 		Enabled: to.Ptr(true),
	// 		ProvisioningState: to.Ptr(armstorageactions.ProvisioningStateSucceeded),
	// 		TaskVersion: to.Ptr[int64](1),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/storageactions/resource-manager/Microsoft.StorageActions/stable/2023-01-01/examples/storageTasksCrud/DeleteStorageTask.json
func ExampleStorageTasksClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageactions.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStorageTasksClient().BeginDelete(ctx, "res4228", "mytask1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/storageactions/resource-manager/Microsoft.StorageActions/stable/2023-01-01/examples/storageTasksCrud/GetStorageTask.json
func ExampleStorageTasksClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageactions.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStorageTasksClient().Get(ctx, "res4228", "mytask1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StorageTask = armstorageactions.StorageTask{
	// 	Name: to.Ptr("mytask1"),
	// 	Type: to.Ptr("Microsoft.StorageActions/storageTasks"),
	// 	ID: to.Ptr("/subscriptions/1f31ba14-ce16-4281-b9b4-3e78da6e1616/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armstorageactions.StorageTaskProperties{
	// 		Description: to.Ptr("Storage task"),
	// 		Action: &armstorageactions.StorageTaskAction{
	// 			Else: &armstorageactions.ElseCondition{
	// 				Operations: []*armstorageactions.StorageTaskOperation{
	// 					{
	// 						Name: to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
	// 						OnFailure: to.Ptr("break"),
	// 						OnSuccess: to.Ptr("continue"),
	// 				}},
	// 			},
	// 			If: &armstorageactions.IfCondition{
	// 				Condition: to.Ptr("[[equals(AccessTier, 'Cool')]]"),
	// 				Operations: []*armstorageactions.StorageTaskOperation{
	// 					{
	// 						Name: to.Ptr(armstorageactions.StorageTaskOperationNameSetBlobTier),
	// 						OnFailure: to.Ptr("break"),
	// 						OnSuccess: to.Ptr("continue"),
	// 						Parameters: map[string]*string{
	// 							"tier": to.Ptr("Hot"),
	// 						},
	// 				}},
	// 			},
	// 		},
	// 		CreationTimeInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-06T00:24:59.144Z"); return t}()),
	// 		Enabled: to.Ptr(true),
	// 		ProvisioningState: to.Ptr(armstorageactions.ProvisioningStateSucceeded),
	// 		TaskVersion: to.Ptr[int64](1),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/storageactions/resource-manager/Microsoft.StorageActions/stable/2023-01-01/examples/storageTasksCrud/PatchStorageTask.json
func ExampleStorageTasksClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageactions.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStorageTasksClient().BeginUpdate(ctx, "res4228", "mytask1", armstorageactions.StorageTaskUpdateParameters{
		Properties: &armstorageactions.StorageTaskProperties{
			Description: to.Ptr("My Storage task"),
			Action: &armstorageactions.StorageTaskAction{
				Else: &armstorageactions.ElseCondition{
					Operations: []*armstorageactions.StorageTaskOperation{
						{
							Name:      to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
							OnFailure: to.Ptr("break"),
							OnSuccess: to.Ptr("continue"),
						}},
				},
				If: &armstorageactions.IfCondition{
					Condition: to.Ptr("[[equals(AccessTier, 'Cool')]]"),
					Operations: []*armstorageactions.StorageTaskOperation{
						{
							Name:      to.Ptr(armstorageactions.StorageTaskOperationNameSetBlobTier),
							OnFailure: to.Ptr("break"),
							OnSuccess: to.Ptr("continue"),
							Parameters: map[string]*string{
								"tier": to.Ptr("Hot"),
							},
						}},
				},
			},
			Enabled: to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StorageTask = armstorageactions.StorageTask{
	// 	Name: to.Ptr("mytask1"),
	// 	Type: to.Ptr("Microsoft.StorageActions/storageTasks"),
	// 	ID: to.Ptr("/subscriptions/c86a9c18-8373-41fa-92d4-1d7bdc16977b/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armstorageactions.StorageTaskProperties{
	// 		Description: to.Ptr("Storage task"),
	// 		Action: &armstorageactions.StorageTaskAction{
	// 			Else: &armstorageactions.ElseCondition{
	// 				Operations: []*armstorageactions.StorageTaskOperation{
	// 					{
	// 						Name: to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
	// 						OnFailure: to.Ptr("break"),
	// 						OnSuccess: to.Ptr("continue"),
	// 				}},
	// 			},
	// 			If: &armstorageactions.IfCondition{
	// 				Condition: to.Ptr("[[equals(AccessTier, 'Cool')]]"),
	// 				Operations: []*armstorageactions.StorageTaskOperation{
	// 					{
	// 						Name: to.Ptr(armstorageactions.StorageTaskOperationNameSetBlobTier),
	// 						OnFailure: to.Ptr("break"),
	// 						OnSuccess: to.Ptr("continue"),
	// 						Parameters: map[string]*string{
	// 							"tier": to.Ptr("Hot"),
	// 						},
	// 				}},
	// 			},
	// 		},
	// 		CreationTimeInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-06T00:24:59.144Z"); return t}()),
	// 		Enabled: to.Ptr(true),
	// 		ProvisioningState: to.Ptr(armstorageactions.ProvisioningStateSucceeded),
	// 		TaskVersion: to.Ptr[int64](1),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/storageactions/resource-manager/Microsoft.StorageActions/stable/2023-01-01/examples/storageTasksList/ListStorageTasksBySubscription.json
func ExampleStorageTasksClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageactions.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStorageTasksClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StorageTasksListResult = armstorageactions.StorageTasksListResult{
		// 	Value: []*armstorageactions.StorageTask{
		// 		{
		// 			Name: to.Ptr("mytask1"),
		// 			Type: to.Ptr("Microsoft.StorageActions/storageTasks"),
		// 			ID: to.Ptr("/subscriptions/c86a9c18-8373-41fa-92d4-1d7bdc16977b/resourceGroups/res6117/providers/Microsoft.StorageActions/storageTasks/mytask1"),
		// 			Location: to.Ptr("eastus"),
		// 			Identity: &armstorageactions.ManagedServiceIdentity{
		// 				Type: to.Ptr(armstorageactions.ManagedServiceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("2fd475e8-8923-4597-842f-7ce1adfc6c4a"),
		// 				TenantID: to.Ptr("b4a2005c-32c1-434c-bbf0-ff486912fc75"),
		// 			},
		// 			Properties: &armstorageactions.StorageTaskProperties{
		// 				Description: to.Ptr("Storage task"),
		// 				Action: &armstorageactions.StorageTaskAction{
		// 					If: &armstorageactions.IfCondition{
		// 						Condition: to.Ptr("[[greater(Content-Length, '100')]]"),
		// 						Operations: []*armstorageactions.StorageTaskOperation{
		// 							{
		// 								Name: to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
		// 								OnFailure: to.Ptr("break"),
		// 								OnSuccess: to.Ptr("continue"),
		// 						}},
		// 					},
		// 				},
		// 				CreationTimeInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-05T23:06:50.772Z"); return t}()),
		// 				Enabled: to.Ptr(true),
		// 				ProvisioningState: to.Ptr(armstorageactions.ProvisioningStateSucceeded),
		// 				TaskVersion: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mytask2"),
		// 			Type: to.Ptr("Microsoft.StorageActions/storageTasks"),
		// 			ID: to.Ptr("/subscriptions/c86a9c18-8373-41fa-92d4-1d7bdc16977b/resourceGroups/res6117/providers/Microsoft.StorageActions/storageTasks/mytask2"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armstorageactions.StorageTaskProperties{
		// 				Description: to.Ptr("Storage task"),
		// 				Action: &armstorageactions.StorageTaskAction{
		// 					Else: &armstorageactions.ElseCondition{
		// 						Operations: []*armstorageactions.StorageTaskOperation{
		// 							{
		// 								Name: to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
		// 								OnFailure: to.Ptr("break"),
		// 								OnSuccess: to.Ptr("continue"),
		// 						}},
		// 					},
		// 					If: &armstorageactions.IfCondition{
		// 						Condition: to.Ptr("[[equals(AccessTier, 'Cool')]]"),
		// 						Operations: []*armstorageactions.StorageTaskOperation{
		// 							{
		// 								Name: to.Ptr(armstorageactions.StorageTaskOperationNameSetBlobTier),
		// 								OnFailure: to.Ptr("break"),
		// 								OnSuccess: to.Ptr("continue"),
		// 								Parameters: map[string]*string{
		// 									"tier": to.Ptr("Hot"),
		// 								},
		// 						}},
		// 					},
		// 				},
		// 				CreationTimeInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-06T00:24:59.144Z"); return t}()),
		// 				Enabled: to.Ptr(true),
		// 				ProvisioningState: to.Ptr(armstorageactions.ProvisioningStateSucceeded),
		// 				TaskVersion: to.Ptr[int64](1),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/storageactions/resource-manager/Microsoft.StorageActions/stable/2023-01-01/examples/storageTasksList/ListStorageTasksByResourceGroup.json
func ExampleStorageTasksClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageactions.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStorageTasksClient().NewListByResourceGroupPager("res6117", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StorageTasksListResult = armstorageactions.StorageTasksListResult{
		// 	Value: []*armstorageactions.StorageTask{
		// 		{
		// 			Name: to.Ptr("mytask1"),
		// 			Type: to.Ptr("Microsoft.StorageActions/storageTasks"),
		// 			ID: to.Ptr("/subscriptions/c86a9c18-8373-41fa-92d4-1d7bdc16977b/resourceGroups/res6117/providers/Microsoft.StorageActions/storageTasks/mytask1"),
		// 			Location: to.Ptr("eastus"),
		// 			Identity: &armstorageactions.ManagedServiceIdentity{
		// 				Type: to.Ptr(armstorageactions.ManagedServiceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("2fd475e8-8923-4597-842f-7ce1adfc6c4a"),
		// 				TenantID: to.Ptr("b4a2005c-32c1-434c-bbf0-ff486912fc75"),
		// 			},
		// 			Properties: &armstorageactions.StorageTaskProperties{
		// 				Description: to.Ptr("Storage task"),
		// 				Action: &armstorageactions.StorageTaskAction{
		// 					If: &armstorageactions.IfCondition{
		// 						Condition: to.Ptr("[[greater(Content-Length, '100')]]"),
		// 						Operations: []*armstorageactions.StorageTaskOperation{
		// 							{
		// 								Name: to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
		// 								OnFailure: to.Ptr("break"),
		// 								OnSuccess: to.Ptr("continue"),
		// 						}},
		// 					},
		// 				},
		// 				CreationTimeInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-05T23:06:50.772Z"); return t}()),
		// 				Enabled: to.Ptr(true),
		// 				ProvisioningState: to.Ptr(armstorageactions.ProvisioningStateSucceeded),
		// 				TaskVersion: to.Ptr[int64](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mytask2"),
		// 			Type: to.Ptr("Microsoft.StorageActions/storageTasks"),
		// 			ID: to.Ptr("/subscriptions/c86a9c18-8373-41fa-92d4-1d7bdc16977b/resourceGroups/res6117/providers/Microsoft.StorageActions/storageTasks/mytask2"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armstorageactions.StorageTaskProperties{
		// 				Description: to.Ptr("Storage task"),
		// 				Action: &armstorageactions.StorageTaskAction{
		// 					Else: &armstorageactions.ElseCondition{
		// 						Operations: []*armstorageactions.StorageTaskOperation{
		// 							{
		// 								Name: to.Ptr(armstorageactions.StorageTaskOperationNameDeleteBlob),
		// 								OnFailure: to.Ptr("break"),
		// 								OnSuccess: to.Ptr("continue"),
		// 						}},
		// 					},
		// 					If: &armstorageactions.IfCondition{
		// 						Condition: to.Ptr("[[equals(AccessTier, 'Cool')]]"),
		// 						Operations: []*armstorageactions.StorageTaskOperation{
		// 							{
		// 								Name: to.Ptr(armstorageactions.StorageTaskOperationNameSetBlobTier),
		// 								OnFailure: to.Ptr("break"),
		// 								OnSuccess: to.Ptr("continue"),
		// 								Parameters: map[string]*string{
		// 									"tier": to.Ptr("Hot"),
		// 								},
		// 						}},
		// 					},
		// 				},
		// 				CreationTimeInUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-06T00:24:59.144Z"); return t}()),
		// 				Enabled: to.Ptr(true),
		// 				ProvisioningState: to.Ptr(armstorageactions.ProvisioningStateSucceeded),
		// 				TaskVersion: to.Ptr[int64](1),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/storageactions/resource-manager/Microsoft.StorageActions/stable/2023-01-01/examples/misc/PerformStorageTaskActionsPreview.json
func ExampleStorageTasksClient_PreviewActions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageactions.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStorageTasksClient().PreviewActions(ctx, "eastus", armstorageactions.StorageTaskPreviewAction{
		Properties: &armstorageactions.StorageTaskPreviewActionProperties{
			Action: &armstorageactions.StorageTaskPreviewActionCondition{
				ElseBlockExists: to.Ptr(true),
				If: &armstorageactions.StorageTaskPreviewActionIfCondition{
					Condition: to.Ptr("[[equals(AccessTier, 'Hot')]]"),
				},
			},
			Blobs: []*armstorageactions.StorageTaskPreviewBlobProperties{
				{
					Name: to.Ptr("folder1/file1.txt"),
					Metadata: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
						{
							Key:   to.Ptr("mKey1"),
							Value: to.Ptr("mValue1"),
						}},
					Properties: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
						{
							Key:   to.Ptr("Creation-Time"),
							Value: to.Ptr("Wed, 07 Jun 2023 05:23:29 GMT"),
						},
						{
							Key:   to.Ptr("Last-Modified"),
							Value: to.Ptr("Wed, 07 Jun 2023 05:23:29 GMT"),
						},
						{
							Key:   to.Ptr("Etag"),
							Value: to.Ptr("0x8DB67175454D36D"),
						},
						{
							Key:   to.Ptr("Content-Length"),
							Value: to.Ptr("38619"),
						},
						{
							Key:   to.Ptr("Content-Type"),
							Value: to.Ptr("text/xml"),
						},
						{
							Key:   to.Ptr("Content-Encoding"),
							Value: to.Ptr(""),
						},
						{
							Key:   to.Ptr("Content-Language"),
							Value: to.Ptr(""),
						},
						{
							Key:   to.Ptr("Content-CRC64"),
							Value: to.Ptr(""),
						},
						{
							Key:   to.Ptr("Content-MD5"),
							Value: to.Ptr("njr6iDrmU9+FC89WMK22EA=="),
						},
						{
							Key:   to.Ptr("Cache-Control"),
							Value: to.Ptr(""),
						},
						{
							Key:   to.Ptr("Content-Disposition"),
							Value: to.Ptr(""),
						},
						{
							Key:   to.Ptr("BlobType"),
							Value: to.Ptr("BlockBlob"),
						},
						{
							Key:   to.Ptr("AccessTier"),
							Value: to.Ptr("Hot"),
						},
						{
							Key:   to.Ptr("AccessTierInferred"),
							Value: to.Ptr("true"),
						},
						{
							Key:   to.Ptr("LeaseStatus"),
							Value: to.Ptr("unlocked"),
						},
						{
							Key:   to.Ptr("LeaseState"),
							Value: to.Ptr("available"),
						},
						{
							Key:   to.Ptr("ServerEncrypted"),
							Value: to.Ptr("true"),
						},
						{
							Key:   to.Ptr("TagCount"),
							Value: to.Ptr("1"),
						}},
					Tags: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
						{
							Key:   to.Ptr("tKey1"),
							Value: to.Ptr("tValue1"),
						}},
				},
				{
					Name: to.Ptr("folder2/file1.txt"),
					Metadata: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
						{
							Key:   to.Ptr("mKey2"),
							Value: to.Ptr("mValue2"),
						}},
					Properties: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
						{
							Key:   to.Ptr("Creation-Time"),
							Value: to.Ptr("Wed, 06 Jun 2023 05:23:29 GMT"),
						},
						{
							Key:   to.Ptr("Last-Modified"),
							Value: to.Ptr("Wed, 06 Jun 2023 05:23:29 GMT"),
						},
						{
							Key:   to.Ptr("Etag"),
							Value: to.Ptr("0x6FB67175454D36D"),
						}},
					Tags: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
						{
							Key:   to.Ptr("tKey2"),
							Value: to.Ptr("tValue2"),
						}},
				}},
			Container: &armstorageactions.StorageTaskPreviewContainerProperties{
				Name: to.Ptr("firstContainer"),
				Metadata: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
					{
						Key:   to.Ptr("mContainerKey1"),
						Value: to.Ptr("mContainerValue1"),
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StorageTaskPreviewAction = armstorageactions.StorageTaskPreviewAction{
	// 	Properties: &armstorageactions.StorageTaskPreviewActionProperties{
	// 		Action: &armstorageactions.StorageTaskPreviewActionCondition{
	// 			ElseBlockExists: to.Ptr(true),
	// 			If: &armstorageactions.StorageTaskPreviewActionIfCondition{
	// 				Condition: to.Ptr("[[equals(AccessTier, 'Hot')]]"),
	// 			},
	// 		},
	// 		Blobs: []*armstorageactions.StorageTaskPreviewBlobProperties{
	// 			{
	// 				Name: to.Ptr("folder1/file1.txt"),
	// 				MatchedBlock: to.Ptr(armstorageactions.MatchedBlockNameIf),
	// 				Metadata: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
	// 					{
	// 						Key: to.Ptr("mKey1"),
	// 						Value: to.Ptr("mValue1"),
	// 				}},
	// 				Properties: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
	// 					{
	// 						Key: to.Ptr("Creation-Time"),
	// 						Value: to.Ptr("Wed, 07 Jun 2023 05:23:29 GMT"),
	// 					},
	// 					{
	// 						Key: to.Ptr("Last-Modified"),
	// 						Value: to.Ptr("Wed, 07 Jun 2023 05:23:29 GMT"),
	// 					},
	// 					{
	// 						Key: to.Ptr("Etag"),
	// 						Value: to.Ptr("0x8DB67175454D36D"),
	// 					},
	// 					{
	// 						Key: to.Ptr("Content-Length"),
	// 						Value: to.Ptr("38619"),
	// 					},
	// 					{
	// 						Key: to.Ptr("Content-Type"),
	// 						Value: to.Ptr("text/xml"),
	// 					},
	// 					{
	// 						Key: to.Ptr("Content-Encoding"),
	// 						Value: to.Ptr(""),
	// 					},
	// 					{
	// 						Key: to.Ptr("Content-Language"),
	// 						Value: to.Ptr(""),
	// 					},
	// 					{
	// 						Key: to.Ptr("Content-CRC64"),
	// 						Value: to.Ptr(""),
	// 					},
	// 					{
	// 						Key: to.Ptr("Content-MD5"),
	// 						Value: to.Ptr("njr6iDrmU9+FC89WMK22EA=="),
	// 					},
	// 					{
	// 						Key: to.Ptr("Cache-Control"),
	// 						Value: to.Ptr(""),
	// 					},
	// 					{
	// 						Key: to.Ptr("Content-Disposition"),
	// 						Value: to.Ptr(""),
	// 					},
	// 					{
	// 						Key: to.Ptr("BlobType"),
	// 						Value: to.Ptr("BlockBlob"),
	// 					},
	// 					{
	// 						Key: to.Ptr("AccessTier"),
	// 						Value: to.Ptr("Hot"),
	// 					},
	// 					{
	// 						Key: to.Ptr("AccessTierInferred"),
	// 						Value: to.Ptr("true"),
	// 					},
	// 					{
	// 						Key: to.Ptr("LeaseStatus"),
	// 						Value: to.Ptr("unlocked"),
	// 					},
	// 					{
	// 						Key: to.Ptr("LeaseState"),
	// 						Value: to.Ptr("available"),
	// 					},
	// 					{
	// 						Key: to.Ptr("ServerEncrypted"),
	// 						Value: to.Ptr("true"),
	// 					},
	// 					{
	// 						Key: to.Ptr("TagCount"),
	// 						Value: to.Ptr("1"),
	// 				}},
	// 				Tags: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
	// 					{
	// 						Key: to.Ptr("tKey1"),
	// 						Value: to.Ptr("tValue1"),
	// 				}},
	// 			},
	// 			{
	// 				Name: to.Ptr("folder2/file1.txt"),
	// 				MatchedBlock: to.Ptr(armstorageactions.MatchedBlockNameElse),
	// 				Metadata: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
	// 					{
	// 						Key: to.Ptr("mKey2"),
	// 						Value: to.Ptr("mValue2"),
	// 				}},
	// 				Properties: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
	// 					{
	// 						Key: to.Ptr("Creation-Time"),
	// 						Value: to.Ptr("Wed, 06 Jun 2023 05:23:29 GMT"),
	// 					},
	// 					{
	// 						Key: to.Ptr("Last-Modified"),
	// 						Value: to.Ptr("Wed, 06 Jun 2023 05:23:29 GMT"),
	// 					},
	// 					{
	// 						Key: to.Ptr("Etag"),
	// 						Value: to.Ptr("0x6FB67175454D36D"),
	// 				}},
	// 				Tags: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
	// 					{
	// 						Key: to.Ptr("tKey2"),
	// 						Value: to.Ptr("tValue2"),
	// 				}},
	// 		}},
	// 		Container: &armstorageactions.StorageTaskPreviewContainerProperties{
	// 			Name: to.Ptr("firstContainer"),
	// 			Metadata: []*armstorageactions.StorageTaskPreviewKeyValueProperties{
	// 				{
	// 					Key: to.Ptr("mContainerKey1"),
	// 					Value: to.Ptr("mContainerValue1"),
	// 			}},
	// 		},
	// 	},
	// }
}
