//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragecache

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewAmlFilesystemsClient creates a new instance of AmlFilesystemsClient.
func (c *ClientFactory) NewAmlFilesystemsClient() *AmlFilesystemsClient {
	return &AmlFilesystemsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewAscOperationsClient creates a new instance of AscOperationsClient.
func (c *ClientFactory) NewAscOperationsClient() *AscOperationsClient {
	return &AscOperationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewAscUsagesClient creates a new instance of AscUsagesClient.
func (c *ClientFactory) NewAscUsagesClient() *AscUsagesClient {
	return &AscUsagesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCachesClient creates a new instance of CachesClient.
func (c *ClientFactory) NewCachesClient() *CachesClient {
	return &CachesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewManagementClient creates a new instance of ManagementClient.
func (c *ClientFactory) NewManagementClient() *ManagementClient {
	return &ManagementClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewSKUsClient creates a new instance of SKUsClient.
func (c *ClientFactory) NewSKUsClient() *SKUsClient {
	return &SKUsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewStorageTargetClient creates a new instance of StorageTargetClient.
func (c *ClientFactory) NewStorageTargetClient() *StorageTargetClient {
	return &StorageTargetClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewStorageTargetsClient creates a new instance of StorageTargetsClient.
func (c *ClientFactory) NewStorageTargetsClient() *StorageTargetsClient {
	return &StorageTargetsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewUsageModelsClient creates a new instance of UsageModelsClient.
func (c *ClientFactory) NewUsageModelsClient() *UsageModelsClient {
	return &UsageModelsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
