//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragemover

import "time"

// Agent - The Agent resource.
type Agent struct {
	// REQUIRED
	Properties *AgentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AgentList - List of Agents.
type AgentList struct {
	// READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers
	// exceed maximum page size.
	NextLink *string

	// READ-ONLY
	Value []*Agent
}

type AgentProperties struct {
	// REQUIRED; The fully qualified resource ID of the Hybrid Compute resource for the Agent.
	ArcResourceID *string

	// REQUIRED; The VM UUID of the Hybrid Compute resource for the Agent.
	ArcVMUUID *string

	// A description for the Agent.
	Description *string

	// READ-ONLY; The Agent status.
	AgentStatus *AgentStatus

	// READ-ONLY; The Agent version.
	AgentVersion *string

	// READ-ONLY
	ErrorDetails *AgentPropertiesErrorDetails

	// READ-ONLY; The last updated time of the Agent status.
	LastStatusUpdate *time.Time

	// READ-ONLY; Local IP address reported by the Agent.
	LocalIPAddress *string

	// READ-ONLY; Available memory reported by the Agent, in MB.
	MemoryInMB *int64

	// READ-ONLY; Available compute cores reported by the Agent.
	NumberOfCores *int64

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Uptime of the Agent in seconds.
	UptimeInSeconds *int64
}

type AgentPropertiesErrorDetails struct {
	// Error code reported by Agent
	Code *string

	// Expanded description of reported error code
	Message *string
}

// AgentUpdateParameters - The Agent resource.
type AgentUpdateParameters struct {
	Properties *AgentUpdateProperties
}

type AgentUpdateProperties struct {
	// A description for the Agent.
	Description *string
}

// AzureKeyVaultSmbCredentials - The Azure Key Vault secret URIs which store the credentials.
type AzureKeyVaultSmbCredentials struct {
	// REQUIRED; The Credentials type.
	Type *CredentialType

	// The Azure Key Vault secret URI which stores the password. Use empty string to clean-up existing value.
	PasswordURI *string

	// The Azure Key Vault secret URI which stores the username. Use empty string to clean-up existing value.
	UsernameURI *string
}

// GetCredentials implements the CredentialsClassification interface for type AzureKeyVaultSmbCredentials.
func (a *AzureKeyVaultSmbCredentials) GetCredentials() *Credentials {
	return &Credentials{
		Type: a.Type,
	}
}

// AzureStorageBlobContainerEndpointProperties - The properties of Azure Storage blob container endpoint.
type AzureStorageBlobContainerEndpointProperties struct {
	// REQUIRED; The name of the Storage blob container that is the target destination.
	BlobContainerName *string

	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// REQUIRED; The Azure Resource ID of the storage account that is the target destination.
	StorageAccountResourceID *string

	// A description for the Endpoint.
	Description *string

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState
}

// GetEndpointBaseProperties implements the EndpointBasePropertiesClassification interface for type AzureStorageBlobContainerEndpointProperties.
func (a *AzureStorageBlobContainerEndpointProperties) GetEndpointBaseProperties() *EndpointBaseProperties {
	return &EndpointBaseProperties{
		Description:       a.Description,
		EndpointType:      a.EndpointType,
		ProvisioningState: a.ProvisioningState,
	}
}

type AzureStorageBlobContainerEndpointUpdateProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// A description for the Endpoint.
	Description *string
}

// GetEndpointBaseUpdateProperties implements the EndpointBaseUpdatePropertiesClassification interface for type AzureStorageBlobContainerEndpointUpdateProperties.
func (a *AzureStorageBlobContainerEndpointUpdateProperties) GetEndpointBaseUpdateProperties() *EndpointBaseUpdateProperties {
	return &EndpointBaseUpdateProperties{
		Description:  a.Description,
		EndpointType: a.EndpointType,
	}
}

// AzureStorageSmbFileShareEndpointProperties - The properties of Azure Storage SMB file share endpoint.
type AzureStorageSmbFileShareEndpointProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// REQUIRED; The name of the Azure Storage file share.
	FileShareName *string

	// REQUIRED; The Azure Resource ID of the storage account.
	StorageAccountResourceID *string

	// A description for the Endpoint.
	Description *string

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState
}

// GetEndpointBaseProperties implements the EndpointBasePropertiesClassification interface for type AzureStorageSmbFileShareEndpointProperties.
func (a *AzureStorageSmbFileShareEndpointProperties) GetEndpointBaseProperties() *EndpointBaseProperties {
	return &EndpointBaseProperties{
		Description:       a.Description,
		EndpointType:      a.EndpointType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AzureStorageSmbFileShareEndpointUpdateProperties - The properties of Azure Storage SMB file share endpoint to update.
type AzureStorageSmbFileShareEndpointUpdateProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// A description for the Endpoint.
	Description *string
}

// GetEndpointBaseUpdateProperties implements the EndpointBaseUpdatePropertiesClassification interface for type AzureStorageSmbFileShareEndpointUpdateProperties.
func (a *AzureStorageSmbFileShareEndpointUpdateProperties) GetEndpointBaseUpdateProperties() *EndpointBaseUpdateProperties {
	return &EndpointBaseUpdateProperties{
		Description:  a.Description,
		EndpointType: a.EndpointType,
	}
}

// Credentials - The Credentials.
type Credentials struct {
	// REQUIRED; The Credentials type.
	Type *CredentialType
}

// GetCredentials implements the CredentialsClassification interface for type Credentials.
func (c *Credentials) GetCredentials() *Credentials { return c }

// Endpoint - The Endpoint resource, which contains information about file sources and targets.
type Endpoint struct {
	// REQUIRED; The resource specific properties for the Storage Mover resource.
	Properties EndpointBasePropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EndpointBaseProperties - The resource specific properties for the Storage Mover resource.
type EndpointBaseProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// A description for the Endpoint.
	Description *string

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState
}

// GetEndpointBaseProperties implements the EndpointBasePropertiesClassification interface for type EndpointBaseProperties.
func (e *EndpointBaseProperties) GetEndpointBaseProperties() *EndpointBaseProperties { return e }

// EndpointBaseUpdateParameters - The Endpoint resource.
type EndpointBaseUpdateParameters struct {
	// The Endpoint resource, which contains information about file sources and targets.
	Properties EndpointBaseUpdatePropertiesClassification
}

// EndpointBaseUpdateProperties - The Endpoint resource, which contains information about file sources and targets.
type EndpointBaseUpdateProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// A description for the Endpoint.
	Description *string
}

// GetEndpointBaseUpdateProperties implements the EndpointBaseUpdatePropertiesClassification interface for type EndpointBaseUpdateProperties.
func (e *EndpointBaseUpdateProperties) GetEndpointBaseUpdateProperties() *EndpointBaseUpdateProperties {
	return e
}

// EndpointList - List of Endpoints.
type EndpointList struct {
	// READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers
	// exceed maximum page size.
	NextLink *string

	// READ-ONLY
	Value []*Endpoint
}

// JobDefinition - The Job Definition resource.
type JobDefinition struct {
	// REQUIRED; Job definition properties.
	Properties *JobDefinitionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// JobDefinitionList - List of Job Definitions.
type JobDefinitionList struct {
	// READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers
	// exceed maximum page size.
	NextLink *string

	// READ-ONLY
	Value []*JobDefinition
}

// JobDefinitionProperties - Job definition properties.
type JobDefinitionProperties struct {
	// REQUIRED; Strategy to use for copy.
	CopyMode *CopyMode

	// REQUIRED; The name of the source Endpoint.
	SourceName *string

	// REQUIRED; The name of the target Endpoint.
	TargetName *string

	// Name of the Agent to assign for new Job Runs of this Job Definition.
	AgentName *string

	// A description for the Job Definition.
	Description *string

	// The subpath to use when reading from the source Endpoint.
	SourceSubpath *string

	// The subpath to use when writing to the target Endpoint.
	TargetSubpath *string

	// READ-ONLY; Fully qualified resource id of the Agent to assign for new Job Runs of this Job Definition.
	AgentResourceID *string

	// READ-ONLY; The name of the Job Run in a non-terminal state, if exists.
	LatestJobRunName *string

	// READ-ONLY; The fully qualified resource ID of the Job Run in a non-terminal state, if exists.
	LatestJobRunResourceID *string

	// READ-ONLY; The current status of the Job Run in a non-terminal state, if exists.
	LatestJobRunStatus *JobRunStatus

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Fully qualified resource ID of the source Endpoint.
	SourceResourceID *string

	// READ-ONLY; Fully qualified resource ID of the target Endpoint.
	TargetResourceID *string
}

// JobDefinitionUpdateParameters - The Job Definition resource.
type JobDefinitionUpdateParameters struct {
	// Job definition properties.
	Properties *JobDefinitionUpdateProperties
}

// JobDefinitionUpdateProperties - Job definition properties.
type JobDefinitionUpdateProperties struct {
	// Name of the Agent to assign for new Job Runs of this Job Definition.
	AgentName *string

	// Strategy to use for copy.
	CopyMode *CopyMode

	// A description for the Job Definition.
	Description *string
}

// JobRun - The Job Run resource.
type JobRun struct {
	// Job run properties.
	Properties *JobRunProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// JobRunError - Error type
type JobRunError struct {
	// Error code of the given entry.
	Code *string

	// Error message of the given entry.
	Message *string

	// Target of the given error entry.
	Target *string
}

// JobRunList - List of Job Runs.
type JobRunList struct {
	// READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers
	// exceed maximum page size.
	NextLink *string

	// READ-ONLY
	Value []*JobRun
}

// JobRunProperties - Job run properties.
type JobRunProperties struct {
	// READ-ONLY; Name of the Agent assigned to this run.
	AgentName *string

	// READ-ONLY; Fully qualified resource id of the Agent assigned to this run.
	AgentResourceID *string

	// READ-ONLY; Bytes of data that will not be transferred, as they are excluded by user configuration.
	BytesExcluded *int64

	// READ-ONLY; Bytes of data that were attempted to transfer and failed.
	BytesFailed *int64

	// READ-ONLY; Bytes of data that will not be transferred, as they are already found on target (e.g. mirror mode).
	BytesNoTransferNeeded *int64

	// READ-ONLY; Bytes of data scanned so far in source.
	BytesScanned *int64

	// READ-ONLY; Bytes of data successfully transferred to target.
	BytesTransferred *int64

	// READ-ONLY; Bytes of data that will not be transferred, as they are unsupported on target.
	BytesUnsupported *int64

	// READ-ONLY; Error details.
	Error *JobRunError

	// READ-ONLY; End time of the run. Null if Agent has not reported that the job has ended.
	ExecutionEndTime *time.Time

	// READ-ONLY; Start time of the run. Null if no Agent reported that the job has started.
	ExecutionStartTime *time.Time

	// READ-ONLY; Number of items that will not be transferred, as they are excluded by user configuration.
	ItemsExcluded *int64

	// READ-ONLY; Number of items that were attempted to transfer and failed.
	ItemsFailed *int64

	// READ-ONLY; Number of items that will not be transferred, as they are already found on target (e.g. mirror mode).
	ItemsNoTransferNeeded *int64

	// READ-ONLY; Number of items scanned so far in source.
	ItemsScanned *int64

	// READ-ONLY; Number of items successfully transferred to target.
	ItemsTransferred *int64

	// READ-ONLY; Number of items that will not be transferred, as they are unsupported on target.
	ItemsUnsupported *int64

	// READ-ONLY; Copy of parent Job Definition's properties at time of Job Run creation.
	JobDefinitionProperties any

	// READ-ONLY; The last updated time of the Job Run.
	LastStatusUpdate *time.Time

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The status of Agent's scanning of source.
	ScanStatus *JobRunScanStatus

	// READ-ONLY; Name of source Endpoint resource. This resource may no longer exist.
	SourceName *string

	// READ-ONLY; Copy of source Endpoint resource's properties at time of Job Run creation.
	SourceProperties any

	// READ-ONLY; Fully qualified resource id of source Endpoint. This id may no longer exist.
	SourceResourceID *string

	// READ-ONLY; The state of the job execution.
	Status *JobRunStatus

	// READ-ONLY; Name of target Endpoint resource. This resource may no longer exist.
	TargetName *string

	// READ-ONLY; Copy of Endpoint resource's properties at time of Job Run creation.
	TargetProperties any

	// READ-ONLY; Fully qualified resource id of of Endpoint. This id may no longer exist.
	TargetResourceID *string
}

// JobRunResourceID - Response that identifies a Job Run.
type JobRunResourceID struct {
	// READ-ONLY; Fully qualified resource id of the Job Run.
	JobRunResourceID *string
}

// List of Storage Movers.
type List struct {
	// READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers
	// exceed maximum page size.
	NextLink *string

	// READ-ONLY
	Value []*StorageMover
}

// NfsMountEndpointProperties - The properties of NFS share endpoint.
type NfsMountEndpointProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// REQUIRED; The directory being exported from the server.
	Export *string

	// REQUIRED; The host name or IP address of the server exporting the file system.
	Host *string

	// A description for the Endpoint.
	Description *string

	// The NFS protocol version.
	NfsVersion *NfsVersion

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState
}

// GetEndpointBaseProperties implements the EndpointBasePropertiesClassification interface for type NfsMountEndpointProperties.
func (n *NfsMountEndpointProperties) GetEndpointBaseProperties() *EndpointBaseProperties {
	return &EndpointBaseProperties{
		Description:       n.Description,
		EndpointType:      n.EndpointType,
		ProvisioningState: n.ProvisioningState,
	}
}

type NfsMountEndpointUpdateProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// A description for the Endpoint.
	Description *string
}

// GetEndpointBaseUpdateProperties implements the EndpointBaseUpdatePropertiesClassification interface for type NfsMountEndpointUpdateProperties.
func (n *NfsMountEndpointUpdateProperties) GetEndpointBaseUpdateProperties() *EndpointBaseUpdateProperties {
	return &EndpointBaseUpdateProperties{
		Description:  n.Description,
		EndpointType: n.EndpointType,
	}
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// Project - The Project resource.
type Project struct {
	// Project properties.
	Properties *ProjectProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProjectList - List of Project resources.
type ProjectList struct {
	// READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers
	// exceed maximum page size.
	NextLink *string

	// READ-ONLY
	Value []*Project
}

// ProjectProperties - Project properties.
type ProjectProperties struct {
	// A description for the Project.
	Description *string

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState
}

// ProjectUpdateParameters - The Project resource.
type ProjectUpdateParameters struct {
	// Project properties.
	Properties *ProjectUpdateProperties
}

// ProjectUpdateProperties - Project properties.
type ProjectUpdateProperties struct {
	// A description for the Project.
	Description *string
}

// Properties - The resource specific properties for the Storage Mover resource.
type Properties struct {
	// A description for the Storage Mover.
	Description *string

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState
}

// SmbMountEndpointProperties - The properties of SMB share endpoint.
type SmbMountEndpointProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// REQUIRED; The host name or IP address of the server exporting the file system.
	Host *string

	// REQUIRED; The name of the SMB share being exported from the server.
	ShareName *string

	// The Azure Key Vault secret URIs which store the required credentials to access the SMB share.
	Credentials *AzureKeyVaultSmbCredentials

	// A description for the Endpoint.
	Description *string

	// READ-ONLY; The provisioning state of this resource.
	ProvisioningState *ProvisioningState
}

// GetEndpointBaseProperties implements the EndpointBasePropertiesClassification interface for type SmbMountEndpointProperties.
func (s *SmbMountEndpointProperties) GetEndpointBaseProperties() *EndpointBaseProperties {
	return &EndpointBaseProperties{
		Description:       s.Description,
		EndpointType:      s.EndpointType,
		ProvisioningState: s.ProvisioningState,
	}
}

// SmbMountEndpointUpdateProperties - The properties of SMB share endpoint to update.
type SmbMountEndpointUpdateProperties struct {
	// REQUIRED; The Endpoint resource type.
	EndpointType *EndpointType

	// The Azure Key Vault secret URIs which store the required credentials to access the SMB share.
	Credentials *AzureKeyVaultSmbCredentials

	// A description for the Endpoint.
	Description *string
}

// GetEndpointBaseUpdateProperties implements the EndpointBaseUpdatePropertiesClassification interface for type SmbMountEndpointUpdateProperties.
func (s *SmbMountEndpointUpdateProperties) GetEndpointBaseUpdateProperties() *EndpointBaseUpdateProperties {
	return &EndpointBaseUpdateProperties{
		Description:  s.Description,
		EndpointType: s.EndpointType,
	}
}

// StorageMover - The Storage Mover resource, which is a container for a group of Agents, Projects, and Endpoints.
type StorageMover struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The resource specific properties for the Storage Mover resource.
	Properties *Properties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UpdateParameters - The Storage Mover resource.
type UpdateParameters struct {
	// The resource specific properties for the Storage Mover resource.
	Properties *UpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// UpdateProperties - The resource specific properties for the Storage Mover resource.
type UpdateProperties struct {
	// A description for the Storage Mover.
	Description *string
}
