//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
	"net/http"
	"net/url"
	"regexp"
)

// AccessControlRecordsServer is a fake server for instances of the armstorsimple8000series.AccessControlRecordsClient type.
type AccessControlRecordsServer struct {
	// BeginCreateOrUpdate is the fake for method AccessControlRecordsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, accessControlRecordName string, resourceGroupName string, managerName string, parameters armstorsimple8000series.AccessControlRecord, options *armstorsimple8000series.AccessControlRecordsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armstorsimple8000series.AccessControlRecordsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method AccessControlRecordsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, accessControlRecordName string, resourceGroupName string, managerName string, options *armstorsimple8000series.AccessControlRecordsClientBeginDeleteOptions) (resp azfake.PollerResponder[armstorsimple8000series.AccessControlRecordsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AccessControlRecordsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, accessControlRecordName string, resourceGroupName string, managerName string, options *armstorsimple8000series.AccessControlRecordsClientGetOptions) (resp azfake.Responder[armstorsimple8000series.AccessControlRecordsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagerPager is the fake for method AccessControlRecordsClient.NewListByManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagerPager func(resourceGroupName string, managerName string, options *armstorsimple8000series.AccessControlRecordsClientListByManagerOptions) (resp azfake.PagerResponder[armstorsimple8000series.AccessControlRecordsClientListByManagerResponse])
}

// NewAccessControlRecordsServerTransport creates a new instance of AccessControlRecordsServerTransport with the provided implementation.
// The returned AccessControlRecordsServerTransport instance is connected to an instance of armstorsimple8000series.AccessControlRecordsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccessControlRecordsServerTransport(srv *AccessControlRecordsServer) *AccessControlRecordsServerTransport {
	return &AccessControlRecordsServerTransport{
		srv:                   srv,
		beginCreateOrUpdate:   newTracker[azfake.PollerResponder[armstorsimple8000series.AccessControlRecordsClientCreateOrUpdateResponse]](),
		beginDelete:           newTracker[azfake.PollerResponder[armstorsimple8000series.AccessControlRecordsClientDeleteResponse]](),
		newListByManagerPager: newTracker[azfake.PagerResponder[armstorsimple8000series.AccessControlRecordsClientListByManagerResponse]](),
	}
}

// AccessControlRecordsServerTransport connects instances of armstorsimple8000series.AccessControlRecordsClient to instances of AccessControlRecordsServer.
// Don't use this type directly, use NewAccessControlRecordsServerTransport instead.
type AccessControlRecordsServerTransport struct {
	srv                   *AccessControlRecordsServer
	beginCreateOrUpdate   *tracker[azfake.PollerResponder[armstorsimple8000series.AccessControlRecordsClientCreateOrUpdateResponse]]
	beginDelete           *tracker[azfake.PollerResponder[armstorsimple8000series.AccessControlRecordsClientDeleteResponse]]
	newListByManagerPager *tracker[azfake.PagerResponder[armstorsimple8000series.AccessControlRecordsClientListByManagerResponse]]
}

// Do implements the policy.Transporter interface for AccessControlRecordsServerTransport.
func (a *AccessControlRecordsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AccessControlRecordsClient.BeginCreateOrUpdate":
		resp, err = a.dispatchBeginCreateOrUpdate(req)
	case "AccessControlRecordsClient.BeginDelete":
		resp, err = a.dispatchBeginDelete(req)
	case "AccessControlRecordsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AccessControlRecordsClient.NewListByManagerPager":
		resp, err = a.dispatchNewListByManagerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AccessControlRecordsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := a.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accessControlRecords/(?P<accessControlRecordName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.AccessControlRecord](req)
		if err != nil {
			return nil, err
		}
		accessControlRecordNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accessControlRecordName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdate(req.Context(), accessControlRecordNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		a.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		a.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (a *AccessControlRecordsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := a.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accessControlRecords/(?P<accessControlRecordName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		accessControlRecordNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accessControlRecordName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDelete(req.Context(), accessControlRecordNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		a.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		a.beginDelete.remove(req)
	}

	return resp, nil
}

func (a *AccessControlRecordsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accessControlRecords/(?P<accessControlRecordName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	accessControlRecordNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accessControlRecordName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), accessControlRecordNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessControlRecord, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessControlRecordsServerTransport) dispatchNewListByManagerPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagerPager not implemented")}
	}
	newListByManagerPager := a.newListByManagerPager.get(req)
	if newListByManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accessControlRecords`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByManagerPager(resourceGroupNameParam, managerNameParam, nil)
		newListByManagerPager = &resp
		a.newListByManagerPager.add(req, newListByManagerPager)
	}
	resp, err := server.PagerResponderNext(newListByManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagerPager) {
		a.newListByManagerPager.remove(req)
	}
	return resp, nil
}
