//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
	"net/http"
	"net/url"
	"regexp"
)

// CloudAppliancesServer is a fake server for instances of the armstorsimple8000series.CloudAppliancesClient type.
type CloudAppliancesServer struct {
	// NewListSupportedConfigurationsPager is the fake for method CloudAppliancesClient.NewListSupportedConfigurationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSupportedConfigurationsPager func(resourceGroupName string, managerName string, options *armstorsimple8000series.CloudAppliancesClientListSupportedConfigurationsOptions) (resp azfake.PagerResponder[armstorsimple8000series.CloudAppliancesClientListSupportedConfigurationsResponse])

	// BeginProvision is the fake for method CloudAppliancesClient.BeginProvision
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginProvision func(ctx context.Context, resourceGroupName string, managerName string, parameters armstorsimple8000series.CloudAppliance, options *armstorsimple8000series.CloudAppliancesClientBeginProvisionOptions) (resp azfake.PollerResponder[armstorsimple8000series.CloudAppliancesClientProvisionResponse], errResp azfake.ErrorResponder)
}

// NewCloudAppliancesServerTransport creates a new instance of CloudAppliancesServerTransport with the provided implementation.
// The returned CloudAppliancesServerTransport instance is connected to an instance of armstorsimple8000series.CloudAppliancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCloudAppliancesServerTransport(srv *CloudAppliancesServer) *CloudAppliancesServerTransport {
	return &CloudAppliancesServerTransport{
		srv:                                 srv,
		newListSupportedConfigurationsPager: newTracker[azfake.PagerResponder[armstorsimple8000series.CloudAppliancesClientListSupportedConfigurationsResponse]](),
		beginProvision:                      newTracker[azfake.PollerResponder[armstorsimple8000series.CloudAppliancesClientProvisionResponse]](),
	}
}

// CloudAppliancesServerTransport connects instances of armstorsimple8000series.CloudAppliancesClient to instances of CloudAppliancesServer.
// Don't use this type directly, use NewCloudAppliancesServerTransport instead.
type CloudAppliancesServerTransport struct {
	srv                                 *CloudAppliancesServer
	newListSupportedConfigurationsPager *tracker[azfake.PagerResponder[armstorsimple8000series.CloudAppliancesClientListSupportedConfigurationsResponse]]
	beginProvision                      *tracker[azfake.PollerResponder[armstorsimple8000series.CloudAppliancesClientProvisionResponse]]
}

// Do implements the policy.Transporter interface for CloudAppliancesServerTransport.
func (c *CloudAppliancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CloudAppliancesClient.NewListSupportedConfigurationsPager":
		resp, err = c.dispatchNewListSupportedConfigurationsPager(req)
	case "CloudAppliancesClient.BeginProvision":
		resp, err = c.dispatchBeginProvision(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CloudAppliancesServerTransport) dispatchNewListSupportedConfigurationsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListSupportedConfigurationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSupportedConfigurationsPager not implemented")}
	}
	newListSupportedConfigurationsPager := c.newListSupportedConfigurationsPager.get(req)
	if newListSupportedConfigurationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cloudApplianceConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListSupportedConfigurationsPager(resourceGroupNameParam, managerNameParam, nil)
		newListSupportedConfigurationsPager = &resp
		c.newListSupportedConfigurationsPager.add(req, newListSupportedConfigurationsPager)
	}
	resp, err := server.PagerResponderNext(newListSupportedConfigurationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListSupportedConfigurationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSupportedConfigurationsPager) {
		c.newListSupportedConfigurationsPager.remove(req)
	}
	return resp, nil
}

func (c *CloudAppliancesServerTransport) dispatchBeginProvision(req *http.Request) (*http.Response, error) {
	if c.srv.BeginProvision == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginProvision not implemented")}
	}
	beginProvision := c.beginProvision.get(req)
	if beginProvision == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/provisionCloudAppliance`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.CloudAppliance](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginProvision(req.Context(), resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginProvision = &respr
		c.beginProvision.add(req, beginProvision)
	}

	resp, err := server.PollerResponderNext(beginProvision, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginProvision.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginProvision) {
		c.beginProvision.remove(req)
	}

	return resp, nil
}
