//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsupport_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/support/armsupport"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/CheckNameAvailabilityForNoSubscriptionSupportTicketCommunication.json
func ExampleCommunicationsNoSubscriptionClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCommunicationsNoSubscriptionClient().CheckNameAvailability(ctx, "testticket", armsupport.CheckNameAvailabilityInput{
		Name: to.Ptr("sampleName"),
		Type: to.Ptr(armsupport.TypeMicrosoftSupportCommunications),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityOutput = armsupport.CheckNameAvailabilityOutput{
	// 	Message: to.Ptr("Name not available"),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr("Name is already in use"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/ListCommunicationsForSupportTicket.json
func ExampleCommunicationsNoSubscriptionClient_NewListPager_listCommunicationsForANoSubscriptionSupportTicket() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCommunicationsNoSubscriptionClient().NewListPager("testticket", &armsupport.CommunicationsNoSubscriptionClientListOptions{Top: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CommunicationsListResult = armsupport.CommunicationsListResult{
		// 	Value: []*armsupport.CommunicationDetails{
		// 		{
		// 			Name: to.Ptr("testmessage1"),
		// 			Type: to.Ptr("Microsoft.Support/communications"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket/communications/testmessage1"),
		// 			Properties: &armsupport.CommunicationDetailsProperties{
		// 				Body: to.Ptr("this is a test message"),
		// 				CommunicationDirection: to.Ptr(armsupport.CommunicationDirectionOutbound),
		// 				CommunicationType: to.Ptr(armsupport.CommunicationTypeWeb),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-24T20:18:19.000Z"); return t}()),
		// 				Sender: to.Ptr("user@contoso.com"),
		// 				Subject: to.Ptr("this is a test message"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testmessage2"),
		// 			Type: to.Ptr("Microsoft.Support/communications"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket/communications/testmessage2"),
		// 			Properties: &armsupport.CommunicationDetailsProperties{
		// 				Body: to.Ptr("test"),
		// 				CommunicationDirection: to.Ptr(armsupport.CommunicationDirectionOutbound),
		// 				CommunicationType: to.Ptr(armsupport.CommunicationTypeWeb),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-29T10:53:19.000Z"); return t}()),
		// 				Sender: to.Ptr("user@contoso.com"),
		// 				Subject: to.Ptr("test"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/ListWebCommunicationsForSupportTicketCreatedOnOrAfter.json
func ExampleCommunicationsNoSubscriptionClient_NewListPager_listWebCommunicationCreatedOnOrAfterASpecificDateForANoSubscriptionSupportTicket() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCommunicationsNoSubscriptionClient().NewListPager("testticket", &armsupport.CommunicationsNoSubscriptionClientListOptions{Top: nil,
		Filter: to.Ptr("communicationType eq 'web' and createdDate ge 2020-03-10T22:08:51Z"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CommunicationsListResult = armsupport.CommunicationsListResult{
		// 	Value: []*armsupport.CommunicationDetails{
		// 		{
		// 			Name: to.Ptr("testmessage1"),
		// 			Type: to.Ptr("Microsoft.Support/communications"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket/communications/testmessage1"),
		// 			Properties: &armsupport.CommunicationDetailsProperties{
		// 				Body: to.Ptr("this is a test message"),
		// 				CommunicationDirection: to.Ptr(armsupport.CommunicationDirectionOutbound),
		// 				CommunicationType: to.Ptr(armsupport.CommunicationTypeWeb),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T20:18:19.000Z"); return t}()),
		// 				Sender: to.Ptr("user@contoso.com"),
		// 				Subject: to.Ptr("this is a test message"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testmessage2"),
		// 			Type: to.Ptr("Microsoft.Support/communications"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket/communications/testmessage2"),
		// 			Properties: &armsupport.CommunicationDetailsProperties{
		// 				Body: to.Ptr("test"),
		// 				CommunicationDirection: to.Ptr(armsupport.CommunicationDirectionOutbound),
		// 				CommunicationType: to.Ptr(armsupport.CommunicationTypeWeb),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T10:53:19.000Z"); return t}()),
		// 				Sender: to.Ptr("user@contoso.com"),
		// 				Subject: to.Ptr("test"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/ListWebCommunicationsForSupportTicket.json
func ExampleCommunicationsNoSubscriptionClient_NewListPager_listWebCommunicationsForANoSubscriptionSupportTicket() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCommunicationsNoSubscriptionClient().NewListPager("testticket", &armsupport.CommunicationsNoSubscriptionClientListOptions{Top: nil,
		Filter: to.Ptr("communicationType eq 'web'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CommunicationsListResult = armsupport.CommunicationsListResult{
		// 	Value: []*armsupport.CommunicationDetails{
		// 		{
		// 			Name: to.Ptr("testmessage1"),
		// 			Type: to.Ptr("Microsoft.Support/communications"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket/communications/testmessage1"),
		// 			Properties: &armsupport.CommunicationDetailsProperties{
		// 				Body: to.Ptr("this is a test message"),
		// 				CommunicationDirection: to.Ptr(armsupport.CommunicationDirectionOutbound),
		// 				CommunicationType: to.Ptr(armsupport.CommunicationTypeWeb),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-10T20:18:19.000Z"); return t}()),
		// 				Sender: to.Ptr("user@contoso.com"),
		// 				Subject: to.Ptr("this is a test message"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testmessage2"),
		// 			Type: to.Ptr("Microsoft.Support/communications"),
		// 			ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket/communications/testmessage2"),
		// 			Properties: &armsupport.CommunicationDetailsProperties{
		// 				Body: to.Ptr("test"),
		// 				CommunicationDirection: to.Ptr(armsupport.CommunicationDirectionOutbound),
		// 				CommunicationType: to.Ptr(armsupport.CommunicationTypeWeb),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-11T10:53:19.000Z"); return t}()),
		// 				Sender: to.Ptr("user@contoso.com"),
		// 				Subject: to.Ptr("test"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/GetCommunicationDetailsForSupportTicket.json
func ExampleCommunicationsNoSubscriptionClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCommunicationsNoSubscriptionClient().Get(ctx, "testticket", "testmessage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CommunicationDetails = armsupport.CommunicationDetails{
	// 	Name: to.Ptr("testmessage"),
	// 	Type: to.Ptr("Microsoft.Support/communications"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket/communications/testmessage"),
	// 	Properties: &armsupport.CommunicationDetailsProperties{
	// 		Body: to.Ptr("this is a test message"),
	// 		CommunicationDirection: to.Ptr(armsupport.CommunicationDirectionOutbound),
	// 		CommunicationType: to.Ptr(armsupport.CommunicationTypeWeb),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-08-24T20:18:19.000Z"); return t}()),
	// 		Sender: to.Ptr("user@contoso.com"),
	// 		Subject: to.Ptr("this is a test message"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/support/resource-manager/Microsoft.Support/stable/2024-04-01/examples/CreateNoSubscriptionSupportTicketCommunication.json
func ExampleCommunicationsNoSubscriptionClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsupport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCommunicationsNoSubscriptionClient().BeginCreate(ctx, "testticket", "testcommunication", armsupport.CommunicationDetails{
		Properties: &armsupport.CommunicationDetailsProperties{
			Body:    to.Ptr("This is a test message from a customer!"),
			Sender:  to.Ptr("user@contoso.com"),
			Subject: to.Ptr("This is a test message from a customer!"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CommunicationDetails = armsupport.CommunicationDetails{
	// 	Name: to.Ptr("testcommunication"),
	// 	Type: to.Ptr("Microsoft.Support/communications"),
	// 	ID: to.Ptr("/providers/Microsoft.Support/supportTickets/testticket/communications/testcommunication"),
	// 	Properties: &armsupport.CommunicationDetailsProperties{
	// 		Body: to.Ptr("This is a test message from a customer!"),
	// 		CommunicationDirection: to.Ptr(armsupport.CommunicationDirectionOutbound),
	// 		CommunicationType: to.Ptr(armsupport.CommunicationTypeWeb),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-10T20:18:19.000Z"); return t}()),
	// 		Sender: to.Ptr("user@contoso.com"),
	// 		Subject: to.Ptr("This is a test message from a customer!"),
	// 	},
	// }
}
