//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleCreateOrUpdateDefaultMax.json
func ExampleDataMaskingRulesClient_CreateOrUpdate_createUpdateDataMaskingRuleForDefaultMax() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataMaskingRulesClient().CreateOrUpdate(ctx, "sqlcrudtest-6852", "sqlcrudtest-2080", "sqlcrudtest-331", "rule1", armsynapse.DataMaskingRule{
		Properties: &armsynapse.DataMaskingRuleProperties{
			AliasName:       to.Ptr("nickname"),
			ColumnName:      to.Ptr("test1"),
			MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionDefault),
			RuleState:       to.Ptr(armsynapse.DataMaskingRuleStateEnabled),
			SchemaName:      to.Ptr("dbo"),
			TableName:       to.Ptr("Table_1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataMaskingRule = armsynapse.DataMaskingRule{
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataMaskingPolicies/rules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-6852/sqlPools/sqlcrudtest-331/dataMaskingPolicies/Default/rules/"),
	// 	Location: to.Ptr("Central US"),
	// 	Properties: &armsynapse.DataMaskingRuleProperties{
	// 		AliasName: to.Ptr("nickname"),
	// 		ColumnName: to.Ptr("test1"),
	// 		ID: to.Ptr("dbo_Table_1_test1"),
	// 		MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionDefault),
	// 		RuleState: to.Ptr(armsynapse.DataMaskingRuleStateEnabled),
	// 		SchemaName: to.Ptr("dbo"),
	// 		TableName: to.Ptr("Table_1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleCreateOrUpdateDefaultMin.json
func ExampleDataMaskingRulesClient_CreateOrUpdate_createUpdateDataMaskingRuleForDefaultMin() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataMaskingRulesClient().CreateOrUpdate(ctx, "sqlcrudtest-6852", "sqlcrudtest-2080", "sqlcrudtest-331", "rule1", armsynapse.DataMaskingRule{
		Properties: &armsynapse.DataMaskingRuleProperties{
			ColumnName:      to.Ptr("test1"),
			MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionDefault),
			SchemaName:      to.Ptr("dbo"),
			TableName:       to.Ptr("Table_1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataMaskingRule = armsynapse.DataMaskingRule{
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataMaskingPolicies/rules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-6852/sqlPools/sqlcrudtest-331/dataMaskingPolicies/Default/rules/"),
	// 	Location: to.Ptr("Central US"),
	// 	Properties: &armsynapse.DataMaskingRuleProperties{
	// 		ColumnName: to.Ptr("test1"),
	// 		ID: to.Ptr("dbo_Table_1_test1"),
	// 		MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionDefault),
	// 		RuleState: to.Ptr(armsynapse.DataMaskingRuleStateEnabled),
	// 		SchemaName: to.Ptr("dbo"),
	// 		TableName: to.Ptr("Table_1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleCreateOrUpdateNumber.json
func ExampleDataMaskingRulesClient_CreateOrUpdate_createUpdateDataMaskingRuleForNumbers() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataMaskingRulesClient().CreateOrUpdate(ctx, "sqlcrudtest-6852", "sqlcrudtest-2080", "sqlcrudtest-331", "rule1", armsynapse.DataMaskingRule{
		Properties: &armsynapse.DataMaskingRuleProperties{
			ColumnName:      to.Ptr("test1"),
			MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionNumber),
			NumberFrom:      to.Ptr("0"),
			NumberTo:        to.Ptr("2"),
			SchemaName:      to.Ptr("dbo"),
			TableName:       to.Ptr("Table_1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataMaskingRule = armsynapse.DataMaskingRule{
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataMaskingPolicies/rules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-6852/sqlPools/sqlcrudtest-331/dataMaskingPolicies/Default/rules/"),
	// 	Location: to.Ptr("Central US"),
	// 	Properties: &armsynapse.DataMaskingRuleProperties{
	// 		ColumnName: to.Ptr("test1"),
	// 		ID: to.Ptr("dbo_Table_1_test1"),
	// 		MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionNumber),
	// 		NumberFrom: to.Ptr("0"),
	// 		NumberTo: to.Ptr("2"),
	// 		RuleState: to.Ptr(armsynapse.DataMaskingRuleStateEnabled),
	// 		SchemaName: to.Ptr("dbo"),
	// 		TableName: to.Ptr("Table_1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleCreateOrUpdateText.json
func ExampleDataMaskingRulesClient_CreateOrUpdate_createUpdateDataMaskingRuleForText() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataMaskingRulesClient().CreateOrUpdate(ctx, "sqlcrudtest-6852", "sqlcrudtest-2080", "sqlcrudtest-331", "rule1", armsynapse.DataMaskingRule{
		Properties: &armsynapse.DataMaskingRuleProperties{
			ColumnName:        to.Ptr("test1"),
			MaskingFunction:   to.Ptr(armsynapse.DataMaskingFunctionText),
			PrefixSize:        to.Ptr("1"),
			ReplacementString: to.Ptr("asdf"),
			SchemaName:        to.Ptr("dbo"),
			SuffixSize:        to.Ptr("0"),
			TableName:         to.Ptr("Table_1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataMaskingRule = armsynapse.DataMaskingRule{
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataMaskingPolicies/rules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-6852/sqlPools/sqlcrudtest-331/dataMaskingPolicies/Default/rules/"),
	// 	Location: to.Ptr("Central US"),
	// 	Properties: &armsynapse.DataMaskingRuleProperties{
	// 		ColumnName: to.Ptr("test1"),
	// 		ID: to.Ptr("dbo_Table_1_test1"),
	// 		MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionText),
	// 		PrefixSize: to.Ptr("1"),
	// 		ReplacementString: to.Ptr("asdf"),
	// 		RuleState: to.Ptr(armsynapse.DataMaskingRuleStateEnabled),
	// 		SchemaName: to.Ptr("dbo"),
	// 		SuffixSize: to.Ptr("0"),
	// 		TableName: to.Ptr("Table_1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleGet.json
func ExampleDataMaskingRulesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataMaskingRulesClient().Get(ctx, "sqlcrudtest-6852", "sqlcrudtest-2080", "sqlcrudtest-331", "rule1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataMaskingRule = armsynapse.DataMaskingRule{
	// 	Name: to.Ptr("rule1"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataMaskingPolicies/rules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-6852/sqlPools/sqlcrudtest-331/dataMaskingPolicies/Default/rules/"),
	// 	Location: to.Ptr("Central US"),
	// 	Properties: &armsynapse.DataMaskingRuleProperties{
	// 		ColumnName: to.Ptr("test1"),
	// 		ID: to.Ptr("dbo_Table_1_test1"),
	// 		MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionText),
	// 		PrefixSize: to.Ptr("1"),
	// 		ReplacementString: to.Ptr("asdf"),
	// 		RuleState: to.Ptr(armsynapse.DataMaskingRuleStateEnabled),
	// 		SchemaName: to.Ptr("dbo"),
	// 		SuffixSize: to.Ptr("0"),
	// 		TableName: to.Ptr("Table_1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DataMaskingRuleList.json
func ExampleDataMaskingRulesClient_NewListBySQLPoolPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataMaskingRulesClient().NewListBySQLPoolPager("sqlcrudtest-6852", "sqlcrudtest-2080", "sqlcrudtest-331", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataMaskingRuleListResult = armsynapse.DataMaskingRuleListResult{
		// 	Value: []*armsynapse.DataMaskingRule{
		// 		{
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataMaskingPolicies/rules"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-6852/sqlPools/sqlcrudtest-331/dataMaskingPolicies/Default/rules/"),
		// 			Location: to.Ptr("Central US"),
		// 			Properties: &armsynapse.DataMaskingRuleProperties{
		// 				ColumnName: to.Ptr("test1"),
		// 				ID: to.Ptr("dbo_Table_1_test1"),
		// 				MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionText),
		// 				PrefixSize: to.Ptr("1"),
		// 				ReplacementString: to.Ptr("asdf"),
		// 				RuleState: to.Ptr(armsynapse.DataMaskingRuleStateEnabled),
		// 				SchemaName: to.Ptr("dbo"),
		// 				SuffixSize: to.Ptr("0"),
		// 				TableName: to.Ptr("Table_1"),
		// 			},
		// 		},
		// 		{
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataMaskingPolicies/rules"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-6852/sqlPools/sqlcrudtest-331/dataMaskingPolicies/Default/rules/"),
		// 			Location: to.Ptr("Central US"),
		// 			Properties: &armsynapse.DataMaskingRuleProperties{
		// 				ColumnName: to.Ptr("test1"),
		// 				ID: to.Ptr("dbo_Table_1_test1"),
		// 				MaskingFunction: to.Ptr(armsynapse.DataMaskingFunctionNumber),
		// 				NumberFrom: to.Ptr("0"),
		// 				NumberTo: to.Ptr("2"),
		// 				RuleState: to.Ptr(armsynapse.DataMaskingRuleStateEnabled),
		// 				SchemaName: to.Ptr("dbo"),
		// 				TableName: to.Ptr("Table_1"),
		// 			},
		// 	}},
		// }
	}
}
